/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.awt.image.BufferedImage;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.formplugin.sf.ProcessTraceUtil;
import kd.isc.iscb.formplugin.sf.Util;
import kd.isc.iscb.formplugin.sf.image.ServiceFlowImage;
import kd.isc.iscb.formplugin.trace.TraceUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.connector.self.ProxyUserUtil;
import kd.isc.iscb.platform.core.permission.ResourceControl;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.FlowStarter;
import kd.isc.iscb.platform.core.sf.ServiceFlowReleaser;
import kd.isc.iscb.platform.core.sf.runtime.ActivitySync;
import kd.isc.iscb.platform.core.sf.runtime.ProcessRuntime;
import kd.isc.iscb.platform.core.sf.runtime.ProcessState;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.platform.core.util.ExportAndImportFormUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.FlowRuntime;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;

public class ServiceFlowEditorFormPlugin
extends AbstractFormPlugin
implements Const {
    private static final String ENABLE = "enable";
    private static final String FLOW_INST_DETAIL = "flow_inst_detail";
    private static final String DEFINE_JSON_TAG2 = "define_json_tag";
    private static final Log LOG = LogFactory.getLog(ServiceFlowEditorFormPlugin.class);
    private static final Set<String> OPERATE_KEYS = new HashSet<String>(Arrays.asList("save", "retry", "terminate", "enable", "disable", "release", "jump", "edit_var", "ignore", "creator_retry"));

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map define = this.loadDefine();
        this.setFocusNodeInfo(define);
        boolean editable = this.isEditable();
        Util.setEditorData(this, define, editable);
        if (Util.saveDefineToCache(this, define)) {
            this.getView().setVisible(Boolean.valueOf(editable), new String[]{"btn_save", "showhelptips", "set_flow", "disable", ENABLE, "release"});
            this.getView().setVisible(Boolean.valueOf(!editable), new String[]{FLOW_INST_DETAIL});
            if (CommonUtil.isEmpty((Object)this.getProcInstId())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"retry", "show_log", "terminate", "refresh", "show_var", FLOW_INST_DETAIL, "btn_view_trace", "view_flow_r"});
            } else {
                long released_id = this.getReleasedId();
                this.getView().setVisible(Boolean.valueOf(released_id > 0L), new String[]{"view_flow_r"});
                this.getView().setVisible(Boolean.valueOf(TraceStack.isTraceEnabled()), new String[]{"btn_view_trace"});
            }
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u7531\u4e8e\u5206\u5e03\u5f0f\u7f13\u5b58\u5f02\u5e38\uff0c\u6d41\u7a0b\u56fe\u529f\u80fd\u6682\u65f6\u4e0d\u80fd\u4f7f\u7528\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ServiceFlowEditorFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            this.getView().close();
        }
    }

    public long getReleasedId() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        return D.l(params.get("released_id"));
    }

    private void setFocusNodeInfo(Map define) {
        String tag = (String)this.getView().getFormShowParameter().getCustomParam("$tag");
        define.put("$tag", tag);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        Util.removeDefineFromCache(this);
    }

    private boolean isEditable() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        return params.containsKey("ENTITY");
    }

    private Map loadDefine() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Map diagram = (Map)params.get("diagram");
        if (diagram != null) {
            return diagram;
        }
        DynamicObject flow = this.loadFlow();
        String define = D.s((Object)flow.getString(DEFINE_JSON_TAG2));
        if (define == null) {
            define = FlowStarter.Type.valueOf((String)flow.getString("init_mode")).defaultDiagram();
        }
        return (Map)Json.toObject((String)define);
    }

    private DynamicObject loadFlow() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object id = params.get("flow");
        String entity = (String)params.get("ENTITY");
        DynamicObject flow = BusinessDataServiceHelper.loadSingle(id, (String)entity);
        return flow;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        AbstractOperate operate = (AbstractOperate)evt.getSource();
        String operationKey = operate.getOperateKey();
        if ("save".equals(operationKey)) {
            this.checkEnable(evt);
        }
    }

    private void checkEnable(BeforeDoOperationEventArgs evt) {
        DynamicObject flow = this.loadFlow();
        if (D.x((Object)flow.get(ENABLE))) {
            evt.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("disable_proc", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u7981\u7528\u540e\u624d\u80fd\u4fdd\u5b58\uff0c\u662f\u5426\u7981\u7528\uff1f", (String)"ServiceFlowEditorFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        try {
            if (MessageBoxResult.Yes == evt.getResult() && "disable_proc".equals(evt.getCallBackId())) {
                Object flowId = this.getView().getFormShowParameter().getCustomParam("flow");
                DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)flowId, (String)"isc_service_flow");
                this.recodingLogs("disable");
                this.disableFlow(flow);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u5df2\u7981\u7528\uff0c\u8bf7\u518d\u6b21\u5c1d\u8bd5\u4fdd\u5b58\u3002", (String)"ServiceFlowEditorFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private void enableFlow(DynamicObject flow) {
        ServiceFlowReleaser.enableDefine((long)flow.getLong("id"));
        flow.set(ENABLE, (Object)"1");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{flow});
    }

    private void disableFlow(DynamicObject flow) {
        ServiceFlowReleaser.disableDefine((long)flow.getLong("id"));
        flow.set(ENABLE, (Object)"0");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{flow});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        try {
            super.afterDoOperation(args);
            String operateKey = args.getOperateKey();
            if (OPERATE_KEYS.contains(operateKey)) {
                this.recodingLogs(operateKey);
            }
            if ("save".equalsIgnoreCase(operateKey)) {
                this.saveFlow();
            } else if ("set_flow".equals(operateKey)) {
                this.editFlow();
            } else if (FLOW_INST_DETAIL.equals(operateKey)) {
                this.showInstDetail();
            } else if ("show_log".equals(operateKey)) {
                this.showLog();
            } else if ("retry".equals(operateKey)) {
                this.retry(false);
            } else if ("terminate".equals(operateKey)) {
                this.terminate();
            } else if ("refresh".equals(operateKey)) {
                this.refreshImage();
            } else if (ENABLE.equals(operateKey)) {
                this.enable();
            } else if ("disable".equals(operateKey)) {
                this.disable();
            } else if ("showhelptips".equals(operateKey)) {
                this.showTips();
            } else if ("show_var".equals(operateKey)) {
                this.showVariables();
            } else if ("view_trace".equals(operateKey)) {
                this.showTrace();
            } else if ("export_png".equals(operateKey)) {
                this.exportPng();
            } else if ("export_fullpng".equals(operateKey)) {
                this.exportFullPng();
            } else if ("release".equals(operateKey)) {
                this.releaseFlow();
            } else if ("jump".equals(operateKey)) {
                this.jump();
            } else if ("edit_var".equals(operateKey)) {
                this.editVar();
            } else if ("ignore".equals(operateKey)) {
                this.ignoreCurrentAct();
            } else if ("creator_retry".equals(operateKey)) {
                this.retry(true);
            } else if ("view_flow_r".equals(operateKey)) {
                this.showReleasedFlow();
            }
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
    }

    private void showReleasedFlow() {
        long releasedId = this.getReleasedId();
        Util.openFlowDiagram(this, releasedId, null);
    }

    private void recodingLogs(String operateKey) {
        try {
            if (this.isEditable()) {
                Object id = this.getView().getFormShowParameter().getCustomParam("flow");
                DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_service_flow");
                DynamicObject opLog = BusinessDataServiceHelper.newDynamicObject((String)"isc_operation_log");
                opLog.set("number", flow.get("number"));
                opLog.set("name", flow.get("name"));
                opLog.set("schemaid", flow.getPkValue());
                opLog.set("desc", (Object)this.isEditable());
                opLog.set("type", (Object)"isc_service_flow_editor");
                opLog.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
                opLog.set("created_time", (Object)new Timestamp(System.currentTimeMillis()));
                opLog.set("operation_code", (Object)operateKey);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{opLog});
            } else {
                long id = (Long)this.getView().getFormShowParameter().getCustomParam("proc_inst_id");
                DynamicObject proc_inst = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_sf_proc_inst");
                DynamicObject opLog = BusinessDataServiceHelper.newDynamicObject((String)"isc_operation_log");
                opLog.set("number", proc_inst.get("number"));
                opLog.set("name", proc_inst.getDynamicObject("flow").get("name"));
                opLog.set("schemaid", proc_inst.getPkValue());
                opLog.set("desc", (Object)this.isEditable());
                opLog.set("type", (Object)"isc_service_flow_editor");
                opLog.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
                opLog.set("created_time", (Object)new Timestamp(System.currentTimeMillis()));
                opLog.set("operation_code", (Object)operateKey);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{opLog});
            }
        }
        catch (Exception e) {
            LOG.warn("\u8bb0\u5f55\u64cd\u4f5c\u65e5\u5fd7\u5931\u8d25\uff0c\u64cd\u4f5c\uff1a" + operateKey + "\uff0c\u5b9e\u4f53\uff1aisc_service_flow_editor, \u539f\u56e0\uff1a" + StringUtil.getCascadeMessage((Throwable)e), (Throwable)e);
        }
    }

    private void ignoreCurrentAct() {
        try {
            long procInstId = D.l((Object)this.getView().getFormShowParameter().getCustomParam("proc_inst_id"));
            FlowRuntime flowRuntime = ProcessRuntime.loadRuntime((long)procInstId);
            if (flowRuntime.isClosed()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u5173\u95ed\u7684\u6d41\u7a0b\u4e0d\u652f\u6301\u5ffd\u7565\u5931\u8d25\u8282\u70b9", (String)"ServiceFlowEditorFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            List<Map<String, Object>> actList = this.getFailedActList(flowRuntime);
            if (actList.size() == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u53ea\u6709\u5931\u8d25\u7684\u8282\u70b9\u624d\u5141\u8bb8\u5ffd\u7565", (String)"ServiceFlowEditorFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            } else {
                this.openIgnoreForm(procInstId, actList);
            }
        }
        catch (Exception ex) {
            FormOpener.showErrorMessage(this.getView(), ex);
        }
    }

    private void editVar() {
        long procInstId = this.getProcInstId();
        if (procInstId != 0L) {
            FlowRuntime runtime = ProcessRuntime.loadRuntime((long)procInstId);
            DynamicObject flowInst = ProcessRuntime.getProcessObj((FlowRuntime)runtime);
            if ("Failed".equals(flowInst.get("state"))) {
                HashMap<String, Object> invokeParams = new HashMap<String, Object>();
                invokeParams.put("proc_inst_id", procInstId);
                FormOpener.showForm(this, "isc_sf_var_edit", ResManager.loadKDString((String)"\u4fee\u6539\u53d8\u91cf", (String)"ServiceFlowEditorFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), invokeParams, null);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5931\u8d25\u72b6\u6001\u7684\u6d41\u7a0b\u624d\u5141\u8bb8\u4fee\u6539\u53d8\u91cf", (String)"ServiceFlowEditorFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8bID\u4e3a\u7a7a", (String)"ServiceFlowEditorFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void jump() {
        try {
            long procInstId = D.l((Object)this.getView().getFormShowParameter().getCustomParam("proc_inst_id"));
            FlowRuntime flowRuntime = ProcessRuntime.loadRuntime((long)procInstId);
            if (flowRuntime.isClosed()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u5173\u95ed\u7684\u6d41\u7a0b\u4e0d\u652f\u6301\u8df3\u8f6c", (String)"ServiceFlowEditorFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            List<Map<String, Object>> actList = this.getFailedActList(flowRuntime);
            if (actList.size() == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u53ea\u6709\u5931\u8d25\u7684\u8282\u70b9\u624d\u652f\u6301\u8fdb\u884c\u8df3\u8f6c", (String)"ServiceFlowEditorFormPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            } else {
                this.openJumpForm(procInstId, actList);
            }
        }
        catch (Exception ex) {
            FormOpener.showErrorMessage(this.getView(), ex);
        }
    }

    private void openJumpForm(long procInstId, List<Map<String, Object>> actList) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("proc_inst_id", procInstId);
        params.put("act_list", actList);
        FormOpener.showForm(this, "isc_sf_jump", ResManager.loadKDString((String)"\u8df3\u8f6c", (String)"ServiceFlowEditorFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, "get_jump_target");
    }

    private void openIgnoreForm(long procInstId, List<Map<String, Object>> actList) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("proc_inst_id", procInstId);
        params.put("act_list", actList);
        FormOpener.showForm(this, "isc_sf_ignore_list", ResManager.loadKDString((String)"\u5ffd\u7565\u5931\u8d25\u8282\u70b9", (String)"ServiceFlowEditorFormPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, "get_jump_target");
    }

    private List<Map<String, Object>> getFailedActList(FlowRuntime flowRuntime) {
        List executions = flowRuntime.getRootExecution().getChildren();
        ArrayList<Map<String, Object>> actList = new ArrayList<Map<String, Object>>(executions.size());
        for (Execution execution : executions) {
            if (!execution.isStarted() || !execution.getChildren().isEmpty() || !"failed".equals(ActivitySync.getState((Execution)execution, (String)"state"))) continue;
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("id", execution.getId());
            item.put("title", execution.getDefine().getTitle());
            actList.add(item);
        }
        return actList;
    }

    private void releaseFlow() {
        try {
            ServiceFlowReleaser.releaseDefine((long)D.l((Object)this.loadFlow().getPkValue()));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u6210\u529f", (String)"ServiceFlowEditorFormPlugin_14", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    public void exportPng() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Pair<String, BufferedImage> pair = this.isEditable() ? new ServiceFlowImage().getImage(Collections.emptyMap(), this.loadFlow()) : new ServiceFlowImage().getImage(params, null);
        ExportAndImportFormUtil.exportPng((BufferedImage)((BufferedImage)pair.getB()), (IFormView)this.getView(), (String)((String)pair.getA()));
    }

    private void exportFullPng() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Pair<String, BufferedImage> pair = this.isEditable() ? new ServiceFlowImage().getFullImage(Collections.emptyMap(), this.loadFlow()) : new ServiceFlowImage().getFullImage(params, null);
        ExportAndImportFormUtil.exportPng((BufferedImage)((BufferedImage)pair.getB()), (IFormView)this.getView(), (String)((String)pair.getA()));
    }

    private void saveFlow() {
        DynamicObject flow = this.loadFlow();
        String define = Util.getDefineStringFromCache(this);
        flow.set(DEFINE_JSON_TAG2, (Object)define);
        flow.set("is_released", (Object)Boolean.FALSE);
        this.save(flow);
    }

    private void editFlow() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object id = params.get("flow");
        FormOpener.showTabEdit(this, "isc_service_flow", id);
    }

    private void showInstDetail() {
        long id = this.getProcInstId();
        FormOpener.showView(this, "isc_sf_proc_inst", id);
    }

    private void showLog() {
        long id = this.getProcInstId();
        FormOpener.showList((AbstractFormPlugin)this, "isc_sf_proc_log", "proc_inst", id);
    }

    private void showTrace() {
        long id = this.getProcInstId();
        TraceUtil.showTrace(this, id);
    }

    private void retry(boolean useCreatorCtx) {
        long id = this.getProcInstId();
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_sf_proc_inst", (String)"number,state,creator");
        String state = obj.getString("state");
        if (ProcessState.Ignored.name().equals(state) || ProcessState.Failed.name().equals(state)) {
            if (useCreatorCtx) {
                this.resumeByCreator(id, obj);
            } else {
                ProcessTraceUtil.resume(id);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6d41\u7a0b\u5df2\u7ecf\u63d0\u4ea4\u4efb\u52a1\u961f\u5217\uff0c\u8bf7\u7a0d\u5019\u5237\u65b0\u67e5\u770b\u6267\u884c\u7ed3\u679c\u3002", (String)"ServiceFlowEditorFormPlugin_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(2500));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u91cd\u65b0\u6267\u884c\u5931\u8d25\u6216\u5ffd\u7565\u7684\u6d41\u7a0b\uff01", (String)"ServiceFlowEditorFormPlugin_16", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(2500));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeByCreator(long id, DynamicObject obj) {
        RequestContext currentContext = RequestContext.get();
        try {
            RequestContextCreator.restoreForMQ((RequestContext)ProxyUserUtil.createRequestContext((RequestContext)currentContext, (String)obj.getDynamicObject("creator").getPkValue().toString()));
            ProcessTraceUtil.resume(id);
        }
        finally {
            RequestContextCreator.restoreForMQ((RequestContext)currentContext);
        }
    }

    private long getProcInstId() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        return D.l(params.get("proc_inst_id"));
    }

    private void terminate() throws SQLException {
        long id = this.getProcInstId();
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_sf_proc_inst", (String)"number,state");
        String state = obj.getString("state");
        if (!ProcessState.Terminated.name().equals(state) && !ProcessState.Complete.name().equals(state)) {
            ProcessTraceUtil.terminate(D.l((Object)id));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u4efb\u52a1\u5df2\u63d0\u4ea4\uff0c\u8bf7\u7a0d\u540e\u5237\u65b0\u67e5\u770b\u6d41\u7a0b\u72b6\u6001\u3002", (String)"ServiceFlowEditorFormPlugin_17", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(2500));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u64a4\u9500\u5df2\u7ed3\u675f\u548c\u5df2\u64a4\u9500\u7684\u6d41\u7a0b\u3002", (String)"ServiceFlowEditorFormPlugin_18", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(2500));
        }
    }

    private void enable() {
        Object id = this.getView().getFormShowParameter().getCustomParam("flow");
        DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_service_flow");
        if (D.x((Object)flow.get(ENABLE))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u5df2\u4e3a\u542f\u7528\u72b6\u6001", (String)"ServiceFlowEditorFormPlugin_19", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
        } else {
            this.enableFlow(flow);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f", (String)"ServiceFlowEditorFormPlugin_20", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
        }
    }

    private void disable() {
        Object id = this.getView().getFormShowParameter().getCustomParam("flow");
        DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_service_flow");
        if (!D.x((Object)flow.get(ENABLE))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u5df2\u4e3a\u7981\u7528\u72b6\u6001", (String)"ServiceFlowEditorFormPlugin_21", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
        } else {
            this.disableFlow(flow);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f", (String)"ServiceFlowEditorFormPlugin_22", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
        }
    }

    private void showTips() {
        HashMap<String, Object> tips = new HashMap<String, Object>();
        tips.put("content", ResManager.loadKDString((String)"1.\u70b9\u51fb\u5de6\u4fa7\u8282\u70b9\u56fe\u6807\u653e\u7f6e\u5728\u53f3\u4fa7\u753b\u677f\uff1b", (String)"ServiceFlowEditorFormPlugin_45", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"2.\u70b9\u51fb\u5de6\u4fa7\u8fde\u7ebf\u653e\u7f6e\u5728\u51fa\u53d1\u8282\u70b9\u540e\u62d6\u52a8\u7ebf\u81f3\u76ee\u7684\u8282\u70b9\uff1b", (String)"ServiceFlowEditorFormPlugin_46", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"3.\u901a\u8fc7\u952e\u76d8\u65b9\u5411\u952e\u53ef\u62d6\u52a8\u753b\u677f\uff1b", (String)"ServiceFlowEditorFormPlugin_47", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"4.\u901a\u8fc7ctrl+s\u53ef\u5feb\u901f\u4fdd\u5b58\u6d41\u7a0b\u56fe\uff1b", (String)"ServiceFlowEditorFormPlugin_48", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"5.\u901a\u8fc7\u952e\u76d8\u4e0a\u7684'delete'\u952e\u5220\u9664\u8282\u70b9\u6216\u8005\u8fde\u63a5\u7ebf\u3002", (String)"ServiceFlowEditorFormPlugin_49", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) + "\n");
        FormOpener.showForm(this, "isc_text_content_dialog", ResManager.loadKDString((String)"\u64cd\u4f5c\u63d0\u793a", (String)"ServiceFlowEditorFormPlugin_28", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), tips, null);
    }

    private void showVariables() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        FormOpener.showForm(this, "isc_sf_var_list", ResManager.loadKDString((String)"\u53d8\u91cf\u5217\u8868", (String)"ServiceFlowEditorFormPlugin_29", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
    }

    private void save(DynamicObject flow) {
        if (D.x((Object)flow.get(ENABLE))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7981\u7528\u670d\u52a1\u6d41\u7a0b!", (String)"ServiceFlowEditorFormPlugin_30", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1200));
        } else {
            ConnectorUtil.save((DynamicObject)flow);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"ServiceFlowEditorFormPlugin_31", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1200));
        }
    }

    private void refreshImage() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object id = params.get("proc_inst_id");
        DynamicObject proc = BusinessDataServiceHelper.loadSingle(id, (String)"isc_sf_proc_inst", (String)"flow,context_tag");
        Map diagram = ServiceFlowReleaser.getDiagramJson((long)D.l((Object)proc.get("flow_id")));
        params.put("diagram", diagram);
        Util.setStates(proc, params);
        FormShowParameter p = new FormShowParameter();
        p.setFormId("isc_service_flow_editor");
        p.setCustomParams(params);
        p.setCaption(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u76d1\u63a7", (String)"ServiceFlowEditorFormPlugin_32", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        p.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().close();
        this.getView().showForm(p);
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String event = e.getEventName();
        if ("open_editor".equals(event)) {
            this.openEditor(e, event);
        } else if ("Ctrl+S".equals(event)) {
            DynamicObject flow = this.loadFlow();
            String checkOpPermission = ResourceControl.checkOpPermission((String)"modify", (DynamicObject)flow);
            if (checkOpPermission != null) {
                this.getView().showTipNotification(checkOpPermission, Integer.valueOf(1500));
            } else {
                String define = Util.getDefineStringFromCache(this);
                flow.set(DEFINE_JSON_TAG2, (Object)define);
                this.save(flow);
            }
        } else if ("viewBlock".equals(event)) {
            Util.openBlock(this, (Map)Json.toObject((String)e.getEventArgs()), event, this.isEditable());
        } else {
            this.updateDiagram(event, e.getEventArgs());
        }
    }

    private void openEditor(CustomEventArgs e, String event) {
        Map map = (Map)Json.toObject((String)e.getEventArgs());
        String type = D.s(map.get("type"));
        if (!this.isEditable()) {
            if ("SubFlow".equals(type)) {
                this.openSubProcessDiagram(map);
            } else if ("RPA".equals(type)) {
                this.openRPAProcessDiagram(map);
            } else {
                Util.openEditor(this, event, map, this.isEditable());
            }
        } else {
            Util.openEditor(this, event, map, this.isEditable());
        }
    }

    private void openRPAProcessDiagram(Map<String, Object> map) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Map acts = (Map)params.get("acts");
        Map node = (Map)acts.get(map.get("id"));
        String taskId = D.s(node.get("rpa_task_id"));
        try {
            Map task = (Map)DispatchServiceHelper.invokeBizService((String)"rpac", (String)"rpacp", (String)"RpaService", (String)"getTaskInfo", (Object[])new Object[]{taskId});
            String status = D.s(task.get("status"));
            if ("success".equals(status) || "failed".equals(status)) {
                try {
                    String url = (String)DispatchServiceHelper.invokeBizService((String)"rpac", (String)"rpacp", (String)"RpaService", (String)"getTaskLogUrl", (Object[])new Object[]{taskId});
                    this.getView().openUrl(url);
                }
                catch (Exception e) {
                    LOG.warn("\u8c03\u7528RPA\u5fae\u670d\u52a1\u5931\u8d25, \u539f\u56e0\uff1a" + StringUtil.getCascadeMessage((Throwable)e), (Throwable)e);
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8c03\u7528RPA\u5fae\u670d\u52a1\u83b7\u53d6\u7ed3\u679curl\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a%s", (String)"ServiceFlowEditorFormPlugin_50", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), StringUtil.getCascadeMessage((Throwable)e)));
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5c1a\u672a\u6267\u884c\u5b8c\u6210\u65e0\u6cd5\u67e5\u770b\uff0c\u8bf7\u7b49\u5f85\u3002", (String)"ServiceFlowEditorFormPlugin_35", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception e1) {
            LOG.warn("\u8c03\u7528RPA\u5fae\u670d\u52a1\u5931\u8d25, \u539f\u56e0\uff1a" + StringUtil.getCascadeMessage((Throwable)e1), (Throwable)e1);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8c03\u7528RPA\u5fae\u670d\u52a1\u83b7\u53d6\u4efb\u52a1\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a%s", (String)"ServiceFlowEditorFormPlugin_51", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), StringUtil.getCascadeMessage((Throwable)e1)));
        }
    }

    private void openSubProcessDiagram(Map<String, Object> map) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Map acts = (Map)params.get("acts");
        if (acts == null) {
            Util.openEditor(this, "", map, this.isEditable());
            return;
        }
        Object node_id = map.get("id");
        Map node = (Map)acts.get(node_id);
        if (node == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b50\u6d41\u7a0b\u5c1a\u672a\u6267\u884c\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"ServiceFlowEditorFormPlugin_37", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        long subProcInstId = D.l(node.get("subProcInstId"));
        if (subProcInstId != 0L) {
            Util.openProcessDiagram(this, subProcInstId, null);
        } else {
            String parent_id = D.s(params.get("parent_id"));
            String full_key = parent_id != null ? "subflows." + parent_id : "subflows";
            Map value = (Map)params.get(full_key);
            if (value == null || D.l(value.get(node_id)) == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b50\u6d41\u7a0b\u5c1a\u672a\u5f00\u59cb\u6267\u884c\u5c31\u5df2\u7ecf\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u6d41\u7a0b\u65e5\u5fd7\u3002", (String)"ServiceFlowEditorFormPlugin_38", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            } else {
                Object parent = parent_id == null ? node_id : node_id + "." + parent_id;
                params.put("parent_id", parent);
                long released_id = D.l(value.get(node_id));
                Map diagram = ServiceFlowReleaser.getDiagramJson((long)released_id);
                params.put("diagram", diagram);
                params.put("released_id", released_id);
                params.put("acts", params.get("acts." + parent));
                params.put("trans", params.get("trans." + parent));
                FormOpener.showTabForm(this, "isc_service_flow_editor", ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u76d1\u63a7", (String)"Util_21", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (!this.isEditable()) {
            return;
        }
        Map data = (Map)e.getReturnData();
        if (data != null) {
            data.remove("flow");
            data.remove("editable");
            data.remove("released_id");
            Object id = data.remove("id");
            Map<String, Object> define = Util.getDefineFromCache(this);
            this.updateFlowDefine(define, data, id);
            Util.saveDefineToCache(this, define);
            this.updateClientView(data, id);
        }
    }

    private void updateDiagram(String event, String args) {
        try (DLock lock = DLock.create((String)("/isc/sf/" + this.getView().getPageId())).fastMode();){
            lock.tryLock(300000L);
            Map<String, Object> define = Util.getDefineFromCache(this);
            this.updateDefine(define, event, args);
            Util.saveDefineToCache(this, define);
        }
    }

    private void updateDefine(Map<String, Object> define, String event, String args) {
        if ("move_node".equals(event) || "node_resize".equals(event)) {
            this.updateNode(define, args);
        } else if ("path_change".equals(event) || "link_change".equals(event)) {
            this.updateLink(args, define);
        } else if ("add_node".equals(event)) {
            this.addNode(args, define);
        } else if ("drop_node".equals(event)) {
            this.dropNode(args, define);
        } else if ("add_link".equals(event)) {
            this.addLink(args, define);
        } else if ("drop_link".equals(event)) {
            this.dropLink(args, define);
        } else {
            throw new IllegalArgumentException("TODO - " + event);
        }
    }

    private void dropLink(String args, Map<String, Object> define) {
        Map links = (Map)define.get("links");
        links.remove(args);
    }

    private void addLink(String args, Map<String, Object> define) {
        Map data;
        String id;
        Map links = (Map)define.get("links");
        if (links.putIfAbsent(id = (String)(data = (Map)Json.toObject((String)args)).get("id"), data) != null) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8fde\u63a5\uff08%s\uff09\u5df2\u5b58\u5728\uff01", (String)"ServiceFlowEditorFormPlugin_52", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), id));
        }
        define.put("count", id);
    }

    private void dropNode(String args, Map<String, Object> define) {
        Map nodes = (Map)define.get("nodes");
        nodes.remove(args);
    }

    private void addNode(String args, Map<String, Object> define) {
        Map data;
        String id;
        Map nodes = (Map)define.get("nodes");
        if (nodes.putIfAbsent(id = (String)(data = (Map)Json.toObject((String)args)).get("id"), data) != null) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff08%s\uff09\u5df2\u5b58\u5728\uff01", (String)"ServiceFlowEditorFormPlugin_53", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), id));
        }
        define.put("count", id);
    }

    private void updateLink(String args, Map<String, Object> define) {
        Map data = (Map)Json.toObject((String)args);
        Object id = data.remove("id");
        Map<String, Object> link = Util.findLink(define, id);
        this.mergeElementDefine(link, data);
    }

    private void updateNode(Map<String, Object> define, String args) {
        Map data = (Map)Json.toObject((String)args);
        Object id = data.remove("id");
        Map<String, Object> node = Util.findNode(define, id);
        this.mergeElementDefine(node, data);
    }

    private void updateFlowDefine(Map<String, Object> define, Map<String, Object> data, Object id) {
        Map<String, Object> node = Util.findNode(define, id);
        if (node != null) {
            this.mergeElementDefine(node, data);
        } else {
            Map<String, Object> link = Util.findLink(define, id);
            if (link != null) {
                this.mergeElementDefine(link, data);
            } else {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u5143\u7d20(%s)\u4e0d\u5b58\u5728\uff01", (String)"ServiceFlowEditorFormPlugin_54", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), id));
            }
        }
    }

    private void mergeElementDefine(Map<String, Object> element, Map<String, Object> data) {
        for (Map.Entry<String, Object> e : data.entrySet()) {
            element.put(e.getKey(), e.getValue());
        }
    }

    private void updateClientView(Map<String, Object> params, Object id) {
        HashMap<String, Object> cmd = new HashMap<String, Object>();
        cmd.put("id", id);
        cmd.put("title", params.get("title"));
        ((CustomControl)this.getControl("editor")).setData(cmd);
    }
}

