/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.dc.e.SQLUtil;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.trigger.ServiceFlowGenerator;
import kd.isc.iscb.platform.core.trace.Caller;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.ConnectionUtil;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.trace.TraceTask;

public class ServiceFlowEventParamFormPlugin
extends AbstractFormPlugin
implements Const {
    private static final String FILTERS = "filters";
    private static final String[] NUMBERS = new String[]{"number", "billno", "fnumber", "fbillno", "FNumber", "FBillNo", "code", "fcode"};

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object pk = this.getView().getFormShowParameter().getCustomParam("meta");
        if (pk == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61ID\u4e3a\u7a7a", (String)"ServiceFlowEventParamFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            this.getModel().setValue("meta", pk);
            long flow_id = (Long)this.getView().getFormShowParameter().getCustomParam("flow_id");
            this.getModel().setValue("flow", (Object)flow_id);
            this.addDefaultFilters(pk);
        }
    }

    private void addDefaultFilters(Object pk) {
        DynamicObject p2;
        DynamicObjectCollection objects = this.getModel().getDataEntity(true).getDynamicObjectCollection(FILTERS);
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"isc_metadata_schema");
        DynamicObjectCollection properties = meta.getDynamicObjectCollection("prop_entryentity");
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(properties.size());
        for (DynamicObject p2 : properties) {
            map.put(p2.getString("prop_name"), p2);
        }
        boolean hasField = this.addNumberEntry(objects, map);
        p2 = (DynamicObject)map.get("id");
        if (!hasField && p2 != null) {
            this.addEntry(objects, p2, "id");
        }
        this.getView().updateView(FILTERS);
    }

    private boolean addNumberEntry(DynamicObjectCollection objects, Map<String, DynamicObject> properties) {
        for (String number : NUMBERS) {
            DynamicObject p = properties.get(number);
            if (p == null) continue;
            this.addEntry(objects, p, number);
            return true;
        }
        return false;
    }

    private void addEntry(DynamicObjectCollection entries, DynamicObject p, String field) {
        DynamicObject object = entries.addNew();
        object.set("field", (Object)field);
        object.set("description", (Object)p.getString("prop_label"));
        object.set("data_type", (Object)p.getString("data_type"));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"field"});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("field".equals(key)) {
            HashMap<String, Object> param = new HashMap<String, Object>(3);
            param.put("id", this.getView().getFormShowParameter().getCustomParam("meta"));
            param.put("$type", "field");
            FormOpener.showForm(this, "isc_meta_properties", ResManager.loadKDString((String)"\u9009\u62e9\u5143\u6570\u636e\u5c5e\u6027", (String)"ServiceFlowEventParamFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), param, "get_field");
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        super.closedCallBack(evt);
        if ("get_field".equals(evt.getActionId()) && (returnData = evt.getReturnData()) instanceof Map) {
            Map map = (Map)returnData;
            this.getModel().setValue("field", map.get("number"));
            this.getModel().setValue("data_type", map.get("data_type"));
            this.getModel().setValue("description", map.get("name"));
            this.getView().updateView(FILTERS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if (evt.getOperationResult() != null && evt.getOperationResult().isSuccess() && evt.getOperateKey().equals("start_flow")) {
            RequestContext current = RequestContext.get();
            RequestContext new_rc = null;
            try {
                long exe_job_user_id = D.l((Object)this.getModel().getValue("exe_job_user_id"));
                String proxyUser = exe_job_user_id == 0L ? null : D.s((Object)exe_job_user_id);
                new_rc = ContextUtil.restoreAndGetContext((RequestContext)current, (String)proxyUser);
                this.execute();
            }
            finally {
                if (new_rc != null) {
                    RequestContextCreator.restoreForMQ((RequestContext)current);
                }
            }
        }
    }

    private void execute() {
        try {
            FormShowParameter formParam = this.getView().getFormShowParameter();
            final Object flowId = formParam.getCustomParam("flow_id");
            final String debug = (String)formParam.getCustomParam("#DEBUG");
            TraceStack.trace((Caller)Caller.Front, (TraceTask)new TraceTask(){

                public void run() {
                    Map data = ServiceFlowEventParamFormPlugin.this.queryByFilters();
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("#DEBUG", debug);
                    ServiceFlowGenerator.generate((long)D.l((Object)flowId), (Object)data, properties);
                }
            });
            this.getView().returnDataToParent((Object)"success");
            this.getView().close();
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> queryByFilters() {
        Map<String, Object> map;
        List<Map<String, Object>> filters = this.prepareFilters();
        Map<String, Object> requires = this.prepareRequires();
        ConnectionWrapper cn = null;
        ObjectReader reader = null;
        long flowDefId = D.l((Object)this.getModel().getValue("flow_id"));
        ConnectionManager.pushResLicense((boolean)IscLicenseUtil.resHasLicense((String)"isc_service_flow", (long)flowDefId));
        try {
            Object metaId = this.getView().getFormShowParameter().getCustomParam("meta");
            DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)D.l((Object)metaId), (String)"isc_metadata_schema", (String)"full_name, group_id");
            cn = ConnectionUtil.getConnectionByMeta((DynamicObject)meta);
            String entity = meta.getString("full_name");
            reader = ConnectionManager.query((ConnectionWrapper)cn, (String)entity, requires, filters, null);
            map = this.getResult((ObjectReader<Map<String, Object>>)reader, filters, entity);
        }
        catch (Throwable throwable) {
            ConnectionManager.popResLicense();
            DbUtil.close(reader);
            this.closeConnection(cn);
            throw throwable;
        }
        ConnectionManager.popResLicense();
        DbUtil.close((ObjectReader)reader);
        this.closeConnection(cn);
        return map;
    }

    private Map<String, Object> prepareRequires() {
        Map node = (Map)this.getView().getFormShowParameter().getCustomParam("node");
        List selectorEntry = (List)node.get("selector_entry");
        List<Map<String, Object>> filterEntries = this.getFilterEntries();
        selectorEntry.addAll(filterEntries);
        LinkedHashMap<String, Object> requires = new LinkedHashMap<String, Object>(selectorEntry.size());
        for (Map selector : selectorEntry) {
            String field = D.s(selector.get("field"));
            if (field == null) continue;
            if (field.indexOf(46) < 0) {
                requires.put(field, 1);
                continue;
            }
            String[] path = field.split("\\.");
            SQLUtil.addEntryProperty(requires, (String[])path);
        }
        return requires;
    }

    private List<Map<String, Object>> getFilterEntries() {
        DynamicObjectCollection objects = this.getModel().getEntryEntity(FILTERS);
        ArrayList<Map<String, Object>> filters = new ArrayList<Map<String, Object>>(objects.size());
        for (DynamicObject item : objects) {
            HashMap<String, String> data = new HashMap<String, String>(4);
            data.put("field", item.getString("field"));
            data.put("description", item.getString("description"));
            data.put("data_type", item.getString("data_type"));
            filters.add(data);
        }
        return filters;
    }

    private Map<String, Object> getResult(ObjectReader<Map<String, Object>> reader, List<Map<String, Object>> filters, String entity) {
        HashMap<String, Object> result = new HashMap(2);
        if (reader.getTotalCount() > 1) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u6761\u4ef6:%1$s\u5728'%2$s'\u67e5\u5230\u591a\u6761\u8bb0\u5f55\uff0c\u8bf7\u4fee\u6539\u8fc7\u6ee4\u6761\u4ef6\uff0c\u786e\u4fdd\u53ea\u67091\u6761\u6570\u636e\u3002", (String)"ServiceFlowEventParamFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), this.buildErrorInfo(filters).toString(), entity));
        }
        Map data = (Map)reader.read();
        while (data != null) {
            result = data;
            data = (Map)reader.read();
            if (data == null) continue;
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u6761\u4ef6:%1$s\u5728'%2$s'\u67e5\u5230\u591a\u6761\u8bb0\u5f55\uff0c\u8bf7\u4fee\u6539\u8fc7\u6ee4\u6761\u4ef6\uff0c\u786e\u4fdd\u53ea\u67091\u6761\u6570\u636e\u3002", (String)"ServiceFlowEventParamFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), this.buildErrorInfo(filters).toString(), entity));
        }
        if (CollectionUtils.isEmpty(result)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u6761\u4ef6:%1$s\u5728'%2$s'\u6ca1\u6709\u627e\u5230\u8bb0\u5f55\uff0c\u8bf7\u4fee\u6539\u8fc7\u6ee4\u6761\u4ef6\uff0c\u786e\u4fdd\u67091\u6761\u6570\u636e\u3002", (String)"ServiceFlowEventParamFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), this.buildErrorInfo(filters).toString(), entity));
        }
        return result;
    }

    private StringBuilder buildErrorInfo(List<Map<String, Object>> filters) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < filters.size(); ++i) {
            if (i > 0) {
                sb.append(';');
            }
            Map<String, Object> filter = filters.get(i);
            sb.append(filter.get("filter_column"));
            sb.append('=');
            sb.append(filter.get("filter_value"));
        }
        return sb;
    }

    private List<Map<String, Object>> prepareFilters() {
        DynamicObjectCollection objects = this.getModel().getEntryEntity(FILTERS);
        if (objects.isEmpty()) {
            throw new IscBizException(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u5206\u5f55\u81f3\u5c11\u914d\u7f6e\u4e00\u884c\u3002", (String)"ServiceFlowEventParamFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        ArrayList<Map<String, Object>> filters = new ArrayList<Map<String, Object>>(objects.size());
        for (int i = 0; i < objects.size(); ++i) {
            DynamicObject item = (DynamicObject)objects.get(i);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("filter_left_bracket", Character.valueOf('('));
            map.put("filter_column", item.getString("field"));
            map.put("filter_compare", "=");
            map.put("filter_value", item.get("value"));
            map.put("filter_right_bracket", Character.valueOf(')'));
            if (i > 0) {
                map.put("filter_link", "AND");
            }
            filters.add(map);
        }
        return filters;
    }

    private void closeConnection(ConnectionWrapper cn) {
        if (cn != null) {
            cn.close();
        }
    }
}

