/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.cache.data.DataCopySchema;
import kd.isc.iscb.platform.core.cache.data.DataCopyTrigger;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.platform.core.cache.data.SimpleValueTypeConfig;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.dc.DataCopyTaskUtil;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.dt.DataTypes;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.g.Edge;
import kd.isc.iscb.util.g.Graph;
import kd.isc.iscb.util.g.Vertex;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.misc.Triple;
import kd.isc.iscb.util.script.feature.tool.date.TimeSpan;

public class ServiceFlowGuideByDCFormPlugin
extends AbstractFormPlugin
implements Const,
CellClickListener {
    private static final String[] SPECIAL_FIELDS = new String[]{"number", "fnumber", "name", "fname", "title", "ftitle", "label", "flabel", "description", "fdescription"};
    private static final String RESOURCE = "resource";
    private static final String MANUAL_STRING = "MANUAL";
    private static final String TIMER_STRING = "TIMER";
    private static final String EVENT_STRING = "EVENT";
    private static final String TAB3_T = "tab3_t";
    private static final String FLEX_DC = "flex_dc";
    private static final String FLEX_FILTER = "flex_filter";
    private static final String FLEX_T = "flex_t";
    private static final String FLEX_E = "flex_e";
    private static final String NEXT_STEP = "nextstep";
    private static final String LAST_STEP = "laststep";
    private static final int PAGE_ONE = 1;
    private static final int PAGE_TWO = 2;
    private static final int PAGE_THREE = 3;
    private static final String INDEX = "index";
    private static final String META_ID = "metaId";
    private static final String FILTER_ENTRIES = "filter_entries";
    private static final String FILTER_FIELD = "filter_column";
    private static final String FILTER_LABLE = "filter_label";
    private static final String GUIDE_ONE = "one";
    private static final String GUIDE_ONED = "oneed";
    private static final String GUIDE_TWO = "two";
    private static final String GUIDE_TWOED = "twoed";
    private static final String GUIDE_THREE = "three";
    private static final String GUIDE_THREEED = "threeed";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setVisiableBytype(MANUAL_STRING);
        this.setFlexVisiable(1);
        this.getPageCache().put(INDEX, D.s((Object)1));
    }

    public void click(EventObject evt) {
        super.click(evt);
        try {
            Object src = evt.getSource();
            String operationKey = ((Control)evt.getSource()).getKey();
            if (src instanceof Button) {
                int index = D.i((Object)this.getPageCache().get(INDEX));
                String key = ((Button)src).getKey();
                if (index == 1 && NEXT_STEP.equals(key)) {
                    this.clickNextStepOnPageOne();
                } else if (index == 2 && NEXT_STEP.equals(key)) {
                    this.setFlexVisiable(3);
                    this.getPageCache().put(INDEX, D.s((Object)3));
                } else if (LAST_STEP.equals(key)) {
                    this.clickLastStep(index);
                } else if ("btnok".equals(key)) {
                    this.generateFlow();
                }
            } else if ("cron_expr".equals(operationKey)) {
                this.showCronForm();
            }
        }
        catch (AbortException | IscBizException e) {
            this.getView().showTipNotification(e.getMessage(), Integer.valueOf(3000));
        }
    }

    private void showCronForm() {
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("cron_expr", this.getModel().getValue("cron_expr"));
        params.put("end_time", D.t((Object)this.getModel().getValue("end_time")));
        params.put("start_time", D.t((Object)this.getModel().getValue("start_time")));
        FormOpener.showForm(this, "isc_cron_expression", "", params, "cron_expr");
    }

    private void clickLastStep(int index) {
        this.setFlexVisiable(--index);
        this.getPageCache().put(INDEX, D.s((Object)index));
    }

    private void generateFlow() {
        Graph<DynamicObject> g = this.createGraph();
        this.checkMustInputByType();
        this.createServiceFlow(g);
        this.showMessage();
    }

    private void clickNextStepOnPageOne() {
        Graph<DynamicObject> g = this.createGraph();
        this.checkGraph(g);
        this.initMeta(g);
        this.setFlexVisiable(2);
        this.getPageCache().put(INDEX, D.s((Object)2));
    }

    private void checkMustInputByType() {
        if (this.isManualMode()) {
            this.checkFilter();
        } else if (this.isTimerMode()) {
            this.checkFilter();
            this.checkSchedul();
        } else if (this.isEventMode()) {
            this.checkEvent();
        }
    }

    private void checkEvent() {
        String event = D.s((Object)this.getModel().getValue("bill_events"));
        if (StringUtil.isEmpty((String)event)) {
            throw new AbortException(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u76d1\u542c\u4e8b\u4ef6\u3002", (String)"ServiceFlowGuideByDCFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkFilter() {
        DynamicObjectCollection properties = this.getModel().getEntryEntity(FILTER_ENTRIES);
        if (properties.isEmpty()) {
            throw new AbortException(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"ServiceFlowGuideByDCFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        for (DynamicObject p : properties) {
            if (StringUtil.isEmpty((String)p.getString(FILTER_FIELD))) {
                throw new AbortException(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u5b58\u5728\u7a7a\u884c\u3002", (String)"ServiceFlowGuideByDCFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
            if (Arrays.asList("IS_NULL", "IS_NOT_NULL").contains(p.getString("filter_compare")) || !StringUtil.isEmpty((String)p.getString("filter_value")) || !StringUtil.isEmpty((String)p.getString("filter_value_fixed"))) continue;
            throw new AbortException(String.format(ResManager.loadKDString((String)"\u6761\u4ef6\u5b57\u6bb5 %s \u8868\u8fbe\u5f0f\u548c\u5e38\u91cf\u4e0d\u80fd\u90fd\u4e3a\u7a7a\u3002", (String)"ServiceFlowGuideByDCFormPlugin_29", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), p.getString(FILTER_FIELD)));
        }
    }

    private void checkSchedul() {
        String startTime = D.s((Object)this.getModel().getValue("start_time"));
        String endTime = D.s((Object)this.getModel().getValue("end_time"));
        String cronExpt = D.s((Object)this.getModel().getValue("cron_expr"));
        String interval = D.s((Object)this.getModel().getValue("interval"));
        if (StringUtil.isEmpty((String)startTime) || StringUtil.isEmpty((String)endTime) || StringUtil.isEmpty((String)cronExpt) || StringUtil.isEmpty((String)interval)) {
            throw new AbortException(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u8c03\u5ea6\u8ba1\u5212\u3002", (String)"ServiceFlowGuideByDCFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void showMessage() {
        String message = ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u5df2\u751f\u6210\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u5e76\u53d1\u5e03\u670d\u52a1\u6d41\u7a0b", (String)"ServiceFlowGuideByDCFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        this.getView().showMessage(message, MessageTypes.Default, new ConfirmCallBackListener("btnok", (IFormPlugin)this));
    }

    private void createServiceFlow(Graph<DynamicObject> g) {
        Set starts = g.getStarts();
        Vertex first = starts.isEmpty() ? g.getFirst() : (Vertex)starts.iterator().next();
        Graph g2 = new Graph();
        this.createGraph2((Vertex<DynamicObject>)first, (Graph<DynamicObject>)g2);
        int maxLevel = this.visitGraph2((Graph<DynamicObject>)g2);
        DynamicObject flow = BusinessDataServiceHelper.newDynamicObject((String)"isc_service_flow");
        this.setBasics(flow);
        Map<Long, String> variables = this.createVariables(flow, (Vertex<DynamicObject>)first, g);
        Map<Long, String> resources = this.createResources(flow, (Vertex<DynamicObject>)first, g);
        Info info = new Info();
        flow.set("define_json_tag", (Object)this.generateFlowDiagram((Graph<DynamicObject>)g2, variables, maxLevel, resources, (Vertex<DynamicObject>)first, info));
        ConnectorUtil.save((DynamicObject)flow);
    }

    private void createGraph2(Vertex<DynamicObject> first, Graph<DynamicObject> g2) {
        HashSet<Object> visited = new HashSet<Object>(16);
        LinkedList<Vertex<DynamicObject>> queue = this.initQueue(first, visited);
        while (!queue.isEmpty()) {
            Vertex<DynamicObject> v = queue.pollFirst();
            if (!visited.add(v)) continue;
            this.enqueueNext(queue, v, visited);
            this.appendNodesAndEdges(g2, v, visited);
        }
    }

    private int visitGraph2(Graph<DynamicObject> g2) {
        HashSet<Vertex> visited = new HashSet<Vertex>(g2.getStarts());
        LinkedList<Vertex> queue = new LinkedList<Vertex>();
        int[] left = new int[g2.getNodeCount()];
        Arrays.fill(left, -150);
        for (Vertex v : g2.getStarts()) {
            int x = left[0] = left[0] + 250;
            int y = 0;
            v.setFlag((Object)new Triple((Object)x, (Object)y, (Object)0));
            queue.add(v);
        }
        int maxLevel = 0;
        while (!queue.isEmpty()) {
            Vertex v;
            v = (Vertex)queue.pollFirst();
            Triple t = (Triple)v.getFlag();
            int level = (Integer)t.getC() + 1;
            maxLevel = Math.max(maxLevel, level);
            for (Edge e : v.getOutGoing()) {
                Triple p = (Triple)e.getFrom().getFlag();
                int minLeft = (Integer)p.getA();
                Vertex to = e.getTo();
                if (!visited.add(to)) continue;
                int n = level;
                left[n] = left[n] + 250;
                int x = left[n];
                if (x < minLeft) {
                    left[level] = x = minLeft;
                }
                int y = level * 150;
                to.setFlag((Object)new Triple((Object)x, (Object)y, (Object)level));
                queue.addLast(to);
            }
        }
        return maxLevel;
    }

    private void setBasics(DynamicObject flow) {
        flow.set("id", (Object)ContextUtil.newId());
        flow.set("init_mode", (Object)this.getType());
        flow.set("name", this.getName());
        flow.set("number", this.getNumber());
        flow.set("loglevel", (Object)"warn");
        long uid = Long.parseLong(RequestContext.get().getUserId());
        flow.set("creator_id", (Object)uid);
        flow.set("modifier_id", (Object)uid);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        flow.set("createtime", (Object)now);
        flow.set("modifytime", (Object)now);
        flow.set("is_released", (Object)Boolean.FALSE);
        flow.set("status", (Object)"A");
        flow.set("enable", (Object)"0");
        Object nodeId = this.getView().getFormShowParameter().getCustomParam("classification_id");
        if (!ObjectUtils.isEmpty((Object)nodeId)) {
            flow.set("classification", nodeId);
        }
    }

    private Map<Long, String> createVariables(DynamicObject flow, Vertex<DynamicObject> first, Graph<DynamicObject> g) {
        DynamicObjectCollection entries = flow.getDynamicObjectCollection("variables");
        this.createSrcVariable(first, entries);
        if (this.isMultipleMode()) {
            this.createSeqVariable(entries);
        }
        return this.createStringTempVariables(g, entries);
    }

    private Map<Long, String> createResources(DynamicObject flow, Vertex<DynamicObject> first, Graph<DynamicObject> g) {
        DynamicObjectCollection entries = flow.getDynamicObjectCollection("resources");
        this.createSrcResource(first, entries);
        return this.createDataCopyResource(entries, g);
    }

    private String generateFlowDiagram(Graph<DynamicObject> g2, Map<Long, String> variables, int maxLevel, Map<Long, String> resources, Vertex<DynamicObject> first, Info info) {
        LinkedHashMap<String, Serializable> diagram = new LinkedHashMap<String, Serializable>(16);
        LinkedHashMap<String, Object> nodes = new LinkedHashMap<String, Object>(16);
        LinkedHashMap<String, Object> links = new LinkedHashMap<String, Object>(16);
        int count = this.createNodes(g2, first, nodes, links, info, variables, maxLevel, resources);
        String prior = (String)first.getFlag();
        String path = "bottom:" + (this.isMultipleMode() ? "-5" : "0") + "|top:0";
        for (Vertex v : g2.getStarts()) {
            String next = (String)v.getFlag();
            String id = String.valueOf(++count);
            LinkedHashMap<String, String> t = new LinkedHashMap<String, String>(8);
            t.put("id", id);
            t.put("type", "NormalTransition");
            t.put("source", prior);
            t.put("target", next);
            t.put("path", path);
            links.put(id, t);
        }
        for (Edge e : g2.getEdges().values()) {
            String from = (String)e.getFrom().getFlag();
            String to = (String)e.getTo().getFlag();
            String id = String.valueOf(++count);
            LinkedHashMap<String, String> t = new LinkedHashMap<String, String>(8);
            t.put("id", id);
            t.put("type", "NormalTransition");
            t.put("source", from);
            t.put("target", to);
            t.put("path", "bottom:0|top:0");
            links.put(id, t);
        }
        diagram.put("nodes", nodes);
        diagram.put("links", links);
        diagram.put("count", Integer.valueOf(count));
        return Json.toString(diagram);
    }

    private Object getNumber() {
        String s = D.s((Object)this.getModel().getValue("number"));
        if (s != null) {
            return s;
        }
        throw new AbortException(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a\uff01", (String)"ServiceFlowGuideByDCFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }

    private void createSrcVariable(Vertex<DynamicObject> first, DynamicObjectCollection entries) {
        DynamicObject src = entries.addNew();
        DynamicObject meta = (DynamicObject)first.value();
        src.set("var_category", (Object)"isc_metadata_schema");
        src.set("var_type", (Object)meta);
        src.set("var_name", (Object)"src");
        src.set("var_desc", meta.get("name"));
        Object dataSource = MetaDataSchema.get((long)meta.getLong("id")).get("group");
        src.set("var_source", dataSource);
        src.set("is_array", (Object)this.isMultipleMode());
        src.set("is_input_param", (Object)Boolean.FALSE);
        src.set("is_output_param", (Object)Boolean.FALSE);
    }

    private void createSeqVariable(DynamicObjectCollection entries) {
        DynamicObject seq = entries.addNew();
        DynamicObject integer = BusinessDataServiceHelper.loadSingle((String)"isc_type_simple_value", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"integer")});
        seq.set("var_category", (Object)"isc_type_simple_value");
        seq.set("var_type", (Object)integer);
        seq.set("var_name", (Object)"SRC_SEQ");
        seq.set("var_desc", (Object)ResManager.loadKDString((String)"\u6e90\u5355\u5e8f\u53f7", (String)"ServiceFlowGuideByDCFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        seq.set("default_value", (Object)"0");
        seq.set("is_array", (Object)Boolean.FALSE);
        seq.set("is_input_param", (Object)Boolean.FALSE);
        seq.set("is_output_param", (Object)Boolean.FALSE);
    }

    private LinkedList<Vertex<DynamicObject>> initQueue(Vertex<DynamicObject> first, Set<Object> visited) {
        visited.add(first);
        LinkedList<Vertex<DynamicObject>> queue = new LinkedList<Vertex<DynamicObject>>();
        this.enqueueNext(queue, first, visited);
        return queue;
    }

    private void enqueueNext(LinkedList<Vertex<DynamicObject>> queue, Vertex<DynamicObject> v, Set<Object> visited) {
        for (Edge next : v.getOutGoing()) {
            queue.addLast((Vertex<DynamicObject>)next.getTo());
            visited.add(next);
        }
    }

    private void appendNodesAndEdges(Graph<DynamicObject> g2, Vertex<DynamicObject> v, Set<Object> visited) {
        for (Edge prior : v.getInComing()) {
            if (!visited.contains(prior)) continue;
            DynamicObject priorRes = (DynamicObject)prior.getValue();
            String from = D.s((Object)priorRes.get("id"));
            g2.appendVertex(from, (Object)priorRes);
            for (Edge next : v.getOutGoing()) {
                DynamicObject nextRes = (DynamicObject)next.getValue();
                String to = D.s((Object)nextRes.get("id"));
                g2.appendVertex(to, (Object)nextRes);
                g2.appendEdge(from, to, v.value());
            }
        }
    }

    private Map<Long, String> createStringTempVariables(Graph<DynamicObject> g, DynamicObjectCollection entries) {
        HashMap<Long, String> variables = new HashMap<Long, String>(16);
        int count = 0;
        for (Vertex v : g.getNodes2().values()) {
            DynamicObject meta = (DynamicObject)v.value();
            String name = "ID_" + ++count;
            variables.put(meta.getLong("id"), name);
            DynamicObject item = entries.addNew();
            item.set("var_category", (Object)"isc_type_simple_value");
            item.set("var_type", (Object)this.getPrimaryKeyType(meta));
            item.set("var_name", (Object)name);
            Object dataSource = ((DynamicObject)MetaDataSchema.get((long)meta.getLong("id")).get("group")).get("name");
            String text = meta.get("name") + "_ID (" + dataSource + ")";
            item.set("var_desc", (Object)StringUtil.trim((String)text, (int)50));
            item.set("is_array", (Object)Boolean.FALSE);
            item.set("is_input_param", (Object)Boolean.FALSE);
            item.set("is_output_param", (Object)Boolean.FALSE);
        }
        return variables;
    }

    private void createSrcResource(Vertex<DynamicObject> first, DynamicObjectCollection entries) {
        DynamicObject meta = (DynamicObject)first.value();
        DynamicObject item = entries.addNew();
        item.set("res_category", (Object)meta.getDataEntityType().getName());
        item.set("res_ref", (Object)meta);
        DynamicObject dataSource = (DynamicObject)MetaDataSchema.get((long)meta.getLong("id")).get("group");
        item.set("res_source_text", (Object)dataSource.getString("name"));
        item.set("res_alias", (Object)"_src");
    }

    private Map<Long, String> createDataCopyResource(DynamicObjectCollection entries, Graph<DynamicObject> g) {
        HashMap<Long, String> resources = new HashMap<Long, String>(16);
        int count = 0;
        for (Edge e : g.getEdges().values()) {
            DynamicObject dc = (DynamicObject)e.getValue();
            String name = "res_" + ++count;
            DynamicObject item = entries.addNew();
            item.set("res_category", (Object)dc.getDataEntityType().getName());
            item.set("res_ref", (Object)dc);
            item.set("res_alias", (Object)name);
            item.set("res_source_text", (Object)this.getDataSource(dc));
            resources.put(dc.getLong("id"), name);
        }
        return resources;
    }

    private int createNodes(Graph<DynamicObject> g2, Vertex<DynamicObject> first, Map<String, Object> nodes, Map<String, Object> links, Info info, Map<Long, String> variables, int maxLevel, Map<Long, String> resources) {
        int count = this.createStartNodes(nodes, info, links, first, variables);
        count = this.createDataCopyNodes(g2, nodes, count, resources, variables);
        count = this.createJoinNode(nodes, count, maxLevel);
        count = this.createJoinLinks(g2, links, count, first);
        return count;
    }

    private DynamicObject getPrimaryKeyType(DynamicObject meta) {
        DataType type = MetaDataSchema.getSchema((long)meta.getLong("id")).getPrimaryKeyDataType();
        DynamicObject var_type = type == DataTypes.STRING ? SimpleValueTypeConfig.getByNumber((String)"string") : (type == DataTypes.LONG ? SimpleValueTypeConfig.getByNumber((String)"long") : (type == DataTypes.INTEGER ? SimpleValueTypeConfig.getByNumber((String)"integer") : (type == DataTypes.DECIMAL ? SimpleValueTypeConfig.getByNumber((String)"decimal") : SimpleValueTypeConfig.getByNumber((String)"string"))));
        return var_type;
    }

    private String getDataSource(DynamicObject dc) {
        long id = dc.getLong("id");
        if (dc.getDataEntityType().getName().endsWith("trigger")) {
            id = DataCopyTrigger.get((long)id).getLong("data_copy_id");
        }
        DynamicObject schema = DataCopySchema.get((long)id);
        return ((DynamicObject)schema.get("data_source")).get("name") + " -> " + ((DynamicObject)schema.get("data_target")).get("name");
    }

    private int createStartNodes(Map<String, Object> nodes, Info info, Map<String, Object> links, Vertex<DynamicObject> first, Map<Long, String> variables) {
        DynamicObject meta = MetaDataSchema.get((long)((DynamicObject)first.value()).getLong("id"));
        int count = this.createStartNode(nodes, meta, links, info);
        count = this.createScriptNode(nodes, count, variables, links, meta, first);
        if (this.isMultipleMode()) {
            count = this.createEndNode(nodes, count, first, links, variables);
        }
        return count;
    }

    private int createDataCopyNodes(Graph<DynamicObject> g2, Map<String, Object> nodes, int count, Map<Long, String> resources, Map<Long, String> variables) {
        for (Vertex v : g2.getNodes2().values()) {
            Triple p = (Triple)v.getFlag();
            String id = String.valueOf(++count);
            v.setFlag((Object)id);
            LinkedHashMap<String, Object> node = new LinkedHashMap<String, Object>(8);
            node.put("id", id);
            DynamicObject dc = (DynamicObject)v.value();
            node.put("title", D.s((Object)dc.get("name")));
            node.put("type", "DataCopy");
            LinkedHashMap<String, Object> co = new LinkedHashMap<String, Object>(8);
            co.put("x", p.getA());
            co.put("y", (Integer)p.getB() + 200);
            co.put("width", 200);
            co.put("height", 45);
            node.put("coordinate", co);
            DynamicObject schema = (DynamicObject)v.value();
            String schemaType = schema.getDataEntityType().getName();
            LinkedHashMap<String, Object> schemaInfo = new LinkedHashMap<String, Object>(8);
            schemaInfo.put("name", D.s((Object)schema.get("name")));
            schemaInfo.put("id", schema.getPkValue());
            schemaInfo.put("schema_type", schemaType);
            if (schemaType.endsWith("trigger")) {
                schemaInfo.put("var", resources.get(schema.getLong("id")));
                schema = DataCopySchema.get((long)schema.getLong("data_copy_id"));
                if (v.hasOutGoing()) {
                    throw new AbortException(String.format(ResManager.loadKDString((String)"%s \u662f\u542f\u52a8\u65b9\u6848\uff0c\u53ea\u80fd\u4f5c\u4e3a\u4e2d\u95f4\u73af\u8282\u3002", (String)"ServiceFlowGuideByDCFormPlugin_30", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ((DynamicObject)v.value()).getString("name")));
                }
            } else {
                schema = DataCopySchema.get((long)schema.getLong("id"));
                schemaInfo.put("var", resources.get(schema.getLong("id")));
            }
            node.put("schema", schemaInfo);
            node.put("schema_type", schemaType);
            node.put("tar_var", variables.get(schema.getLong("target_schema_id")));
            node.put("src_var", variables.get(schema.getLong("source_schema_id")));
            node.put("filter_type", "filters");
            LinkedHashMap<String, Object> filter = new LinkedHashMap<String, Object>(8);
            DynamicObject meta = MetaDataSchema.get((long)schema.getLong("source_schema_id"));
            if (this.isInvalidSource(meta)) {
                throw new AbortException(String.format(ResManager.loadKDString((String)"\u65b9\u6848\uff08%s\uff09\u7684\u6e90\u5bf9\u8c61\u4e0d\u662f\u201c\u5b9e\u4f53\u201d\u3001\u201c\u6570\u636e\u8868\u201d\u6216\u201c\u89c6\u56fe\u201d\u3002", (String)"ServiceFlowGuideByDCFormPlugin_31", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ((DynamicObject)v.value()).get("name")));
            }
            DynamicObject pk = this.findPkField(meta);
            filter.put(FILTER_FIELD, pk.get("prop_name"));
            filter.put(FILTER_LABLE, pk.get("prop_label"));
            filter.put("filter_compare", "=");
            filter.put("filter_value_var", variables.get(meta.getPkValue()));
            node.put(FILTER_ENTRIES, Collections.singletonList(filter));
            nodes.put(id, node);
        }
        return count;
    }

    private int createJoinNode(Map<String, Object> nodes, int count, int maxLevel) {
        String id = String.valueOf(++count);
        LinkedHashMap<String, Object> join = new LinkedHashMap<String, Object>(8);
        join.put("id", id);
        if (this.isMultipleMode()) {
            String text = "++ SRC_SEQ";
            join.put("title", text);
            join.put("type", "Script");
            join.put("script", text);
        } else {
            join.put("title", ResManager.loadKDString((String)"\u7ed3\u675f", (String)"ServiceFlowGuideByDCFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            join.put("type", "End");
        }
        LinkedHashMap<String, Integer> co = new LinkedHashMap<String, Integer>(8);
        co.put("x", 100);
        co.put("y", maxLevel * 150 + 200);
        co.put("width", 200);
        co.put("height", 45);
        join.put("coordinate", co);
        nodes.put(id, join);
        return count;
    }

    private int createJoinLinks(Graph<DynamicObject> g2, Map<String, Object> links, int count, Vertex<DynamicObject> first) {
        String join = String.valueOf(count);
        for (Vertex v : g2.getEnds()) {
            LinkedHashMap<String, Object> t = new LinkedHashMap<String, Object>(8);
            String tid = String.valueOf(++count);
            t.put("id", tid);
            t.put("type", "NormalTransition");
            t.put("source", v.getFlag());
            t.put("target", join);
            t.put("path", "bottom:0|top:0");
            links.put(tid, t);
        }
        if (this.isMultipleMode()) {
            LinkedHashMap<String, Object> t = new LinkedHashMap<String, Object>(8);
            String tid = String.valueOf(++count);
            t.put("id", tid);
            t.put("type", "NormalTransition");
            t.put("source", join);
            t.put("target", first.getFlag());
            t.put("path", "right:0|bottom:5");
            links.put(tid, t);
        }
        return count;
    }

    private int createStartNode(Map<String, Object> nodes, DynamicObject meta, Map<String, Object> links, Info info) {
        if (this.isEventMode()) {
            this.createEventStartNode(nodes, meta, info);
            return 1;
        }
        if (this.isManualMode()) {
            this.createStartNode(nodes, "ManualStarter", info);
        } else if (this.isTimerMode()) {
            this.createStartNode(nodes, "TimerStarter", info);
        } else {
            throw new AbortException(ResManager.loadKDString((String)"\u6b64\u542f\u52a8\u65b9\u5f0f\u4e0d\u652f\u6301\uff01", (String)"ServiceFlowGuideByDCFormPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        info.secondNode = String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u67e5\u8be2", (String)"ServiceFlowGuideByDCFormPlugin_32", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), meta.get("name"), ((DynamicObject)meta.get("group")).get("name"));
        String qid = "3";
        LinkedHashMap<String, Object> query = new LinkedHashMap<String, Object>(8);
        query.put("id", qid);
        query.put("title", info.secondNode);
        query.put("type", "DataRetriever");
        LinkedHashMap<String, Integer> co = new LinkedHashMap<String, Integer>(8);
        co.put("x", 350);
        co.put("y", 50);
        co.put("width", 200);
        co.put("height", 45);
        query.put("coordinate", co);
        ArrayList retriever_entries = new ArrayList();
        DynamicObjectCollection properties = meta.getDynamicObjectCollection("prop_entryentity");
        for (DynamicObject p : properties) {
            if (!this.isExpected(p)) continue;
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>(8);
            item.put("reader_field", p.get("prop_name"));
            item.put("reader_field_type", p.get("data_type"));
            item.put("reader_field_label", p.get("prop_label"));
            retriever_entries.add(item);
            if (retriever_entries.size() != 2) continue;
            break;
        }
        query.put("retriever_entries", retriever_entries);
        query.put(FILTER_ENTRIES, this.get_filter_entries());
        query.put("sort_entries", Collections.emptyList());
        query.put("param_entries", Collections.emptyList());
        LinkedHashMap<String, Object> data_schema = new LinkedHashMap<String, Object>(8);
        data_schema.put("name", D.s((Object)meta.get("name")));
        data_schema.put("var", "_src");
        data_schema.put("id", meta.getPkValue());
        query.put("data_schema", data_schema);
        LinkedHashMap<String, Object> assignment_var = new LinkedHashMap<String, Object>(8);
        assignment_var.put("id", meta.getPkValue());
        assignment_var.put("var", "src");
        assignment_var.put("name", D.s((Object)meta.get("name")));
        query.put("assignment_var", assignment_var);
        nodes.put(qid, query);
        String tid = "2";
        LinkedHashMap<String, String> t = new LinkedHashMap<String, String>(8);
        t.put("id", tid);
        t.put("type", "NormalTransition");
        t.put("source", "1");
        t.put("target", qid);
        t.put("path", "right:0|left:0");
        links.put(tid, t);
        return 3;
    }

    private List<Map<String, Object>> get_filter_entries() {
        ArrayList<Map<String, Object>> filter_entries = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection properties = this.getModel().getEntryEntity(FILTER_ENTRIES);
        for (DynamicObject p : properties) {
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>(8);
            item.put("filter_link", p.get("filter_link"));
            item.put(FILTER_LABLE, p.get(FILTER_LABLE));
            item.put("filter_value_fixed", p.get("filter_value_fixed"));
            item.put("filter_value", p.get("filter_value"));
            item.put(FILTER_FIELD, p.get(FILTER_FIELD));
            item.put("filter_compare", p.get("filter_compare"));
            item.put("filter_left_bracket", p.get("filter_left_bracket"));
            item.put("filter_right_bracket", p.get("filter_right_bracket"));
            filter_entries.add(item);
        }
        return filter_entries;
    }

    private int createScriptNode(Map<String, Object> nodes, int count, Map<Long, String> variables, Map<String, Object> links, DynamicObject meta, Vertex<DynamicObject> first) {
        String from = String.valueOf(count);
        DynamicObject pk = this.findPkField(meta);
        String id = String.valueOf(++count);
        String tempVar = variables.get(meta.getPkValue());
        String pkField = pk.getString("prop_name");
        String text = tempVar + " = src" + (this.isMultipleMode() ? "[SRC_SEQ] ?." : " . ") + pkField;
        LinkedHashMap<String, Object> script = new LinkedHashMap<String, Object>(8);
        script.put("id", id);
        script.put("title", text);
        script.put("type", "Script");
        LinkedHashMap<String, Integer> co = new LinkedHashMap<String, Integer>(8);
        co.put("x", this.isMultipleMode() ? 600 : 350);
        co.put("y", 50);
        co.put("width", 200);
        co.put("height", 45);
        script.put("coordinate", co);
        script.put("script", text);
        nodes.put(id, script);
        String tid = String.valueOf(++count);
        LinkedHashMap<String, String> t = new LinkedHashMap<String, String>(8);
        t.put("id", tid);
        t.put("type", "NormalTransition");
        t.put("source", from);
        t.put("target", id);
        t.put("path", "right:0|left:0");
        links.put(tid, t);
        first.setFlag((Object)id);
        return count;
    }

    private int createEndNode(Map<String, Object> nodes, int count, Vertex<DynamicObject> first, Map<String, Object> links, Map<Long, String> variables) {
        String from = (String)first.getFlag();
        String id = String.valueOf(++count);
        LinkedHashMap<String, Object> end = new LinkedHashMap<String, Object>(8);
        end.put("id", id);
        end.put("title", ResManager.loadKDString((String)"\u7ed3\u675f", (String)"ServiceFlowGuideByDCFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        end.put("type", "End");
        LinkedHashMap<String, Integer> co = new LinkedHashMap<String, Integer>(8);
        co.put("x", 1050);
        co.put("y", 50);
        co.put("width", 200);
        co.put("height", 45);
        end.put("coordinate", co);
        nodes.put(id, end);
        String tid = String.valueOf(++count);
        LinkedHashMap<String, String> t = new LinkedHashMap<String, String>(8);
        t.put("id", tid);
        t.put("type", "NormalTransition");
        t.put("source", from);
        t.put("target", id);
        t.put("path", "right:0|left:0");
        String tempVar = variables.get(((DynamicObject)first.value()).getPkValue());
        String text = tempVar + " == null";
        t.put("title", text);
        t.put("condition", text);
        links.put(tid, t);
        return count;
    }

    private boolean isInvalidSource(DynamicObject meta) {
        String type = meta.getString("type");
        return !"ENTITY".equals(type) && !"TABLE".equals(type) && !"VIEW".equals(type);
    }

    private DynamicObject findPkField(DynamicObject meta) {
        DynamicObject pk = null;
        DynamicObjectCollection properties = meta.getDynamicObjectCollection("prop_entryentity");
        for (DynamicObject p : properties) {
            if (!this.isPrimaryKey(p)) continue;
            if (pk == null) {
                pk = p;
                continue;
            }
            throw new AbortException(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61\uff08%s\uff09\u6709\u591a\u5b57\u6bb5\u4e3b\u952e\uff01", (String)"ServiceFlowGuideByDCFormPlugin_33", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), meta.get("name")));
        }
        if (pk == null) {
            throw new AbortException(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61\uff08%s\uff09\u6709\u6ca1\u6709\u4e3b\u952e\u5b57\u6bb5\uff01", (String)"ServiceFlowGuideByDCFormPlugin_34", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), meta.get("name")));
        }
        return pk;
    }

    private void createEventStartNode(Map<String, Object> nodes, DynamicObject meta, Info info) {
        LinkedHashMap<String, Object> start = new LinkedHashMap<String, Object>(8);
        start.put("id", "1");
        info.firstNode = String.format(ResManager.loadKDString((String)"\u4e8b\u4ef6\u89e6\u53d1\uff08%s\uff09", (String)"ServiceFlowGuideByDCFormPlugin_35", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), D.s((Object)meta.get("name")));
        start.put("title", info.firstNode);
        start.put("type", "EventStarter");
        LinkedHashMap<String, Integer> co = new LinkedHashMap<String, Integer>(8);
        co.put("x", 100);
        co.put("y", 50);
        co.put("width", 200);
        co.put("height", 45);
        start.put("coordinate", co);
        ArrayList selector_entry = new ArrayList(2);
        DynamicObjectCollection properties = meta.getDynamicObjectCollection("prop_entryentity");
        for (DynamicObject p : properties) {
            if (!this.isExpected(p)) continue;
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>(8);
            item.put("field", p.get("prop_name"));
            item.put("data_type", p.get("data_type"));
            item.put("description", p.get("prop_label"));
            selector_entry.add(item);
            if (selector_entry.size() != 2) continue;
            break;
        }
        start.put("data_schema", meta.getPkValue());
        start.put("variables_value", "src");
        start.put("selector_entry", selector_entry);
        start.put("bill_events", this.getBillEvents());
        nodes.put("1", start);
    }

    private Object getBillEvents() {
        return this.getModel().getValue("bill_events");
    }

    private void createStartNode(Map<String, Object> nodes, String type, Info info) {
        LinkedHashMap<String, Object> start = new LinkedHashMap<String, Object>(8);
        start.put("id", "1");
        info.firstNode = ResManager.loadKDString((String)"\u5f00\u59cb", (String)"ServiceFlowGuideByDCFormPlugin_19", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        start.put("title", info.firstNode);
        start.put("type", type);
        LinkedHashMap<String, Integer> co = new LinkedHashMap<String, Integer>(8);
        co.put("x", 100);
        co.put("y", 50);
        co.put("width", 200);
        co.put("height", 45);
        start.put("coordinate", co);
        start.put("end_time", this.getModel().getValue("end_time"));
        start.put("start_time", this.getModel().getValue("start_time"));
        start.put("cron_expr", this.getModel().getValue("cron_expr"));
        start.put("interval", this.getModel().getValue("interval"));
        nodes.put("1", start);
    }

    private boolean isExpected(DynamicObject p) {
        if (this.isPrimaryKey(p)) {
            return true;
        }
        String name = p.getString("prop_name");
        for (String s : SPECIAL_FIELDS) {
            if (!s.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private boolean isPrimaryKey(DynamicObject p) {
        return D.x((Object)p.get("is_primary_key"));
    }

    private boolean isMultipleMode() {
        String type = this.getType();
        return MANUAL_STRING.equals(type) || TIMER_STRING.equals(type);
    }

    private boolean isEventMode() {
        String type = this.getType();
        return EVENT_STRING.equals(type);
    }

    private boolean isManualMode() {
        String type = this.getType();
        return MANUAL_STRING.equals(type);
    }

    private boolean isTimerMode() {
        String type = this.getType();
        return TIMER_STRING.equals(type);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        this.getView().close();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{NEXT_STEP, LAST_STEP, "btnok", "cron_expr"});
        EntryGrid filterEntries = (EntryGrid)this.getView().getControl(FILTER_ENTRIES);
        filterEntries.addCellClickListener((CellClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        try {
            if ("type".equals(name)) {
                ChangeData[] changeSet = e.getChangeSet();
                String type = D.s((Object)changeSet[0].getNewValue());
                if (StringUtil.isEmpty((String)type)) {
                    this.getModel().setValue("type", changeSet[0].getOldValue());
                    throw new AbortException(ResManager.loadKDString((String)"\u542f\u52a8\u65b9\u5f0f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ServiceFlowGuideByDCFormPlugin_20", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                }
                this.setVisiableBytype(type);
                this.setFlexVisiable(1);
            } else if (RESOURCE.equals(name)) {
                this.setResourceRelatedSystem(e);
            } else if ("name".equals(name)) {
                this.generateFlowNumber();
            } else if ("interval".equals(name)) {
                String interval = (String)e.getChangeSet()[0].getNewValue();
                if (!"0".equals(interval)) {
                    this.getModel().setValue("cron_expr", (Object)this.getCorn(interval));
                }
                this.getView().setEnable(Boolean.valueOf("0".equals(interval)), new String[]{"cron_expr"});
            }
        }
        catch (AbortException | IscBizException ex) {
            this.getView().showTipNotification(ex.getMessage(), Integer.valueOf(3000));
        }
    }

    private String getCorn(String interval) {
        Date start = (Date)this.getModel().getValue("start_time");
        if (start == null) {
            start = new Timestamp(System.currentTimeMillis() - 86400000L);
        }
        TimeSpan timeSpan = DataCopyTaskUtil.getTimeSpan((long)start.getTime());
        return DataCopyTaskUtil.buildCron((String)interval, (TimeSpan)timeSpan);
    }

    private void generateFlowNumber() {
        if (D.s((Object)this.getModel().getValue("number")) == null) {
            String number = Hash.mur32((Object[])new Object[]{UUID.randomUUID().toString()});
            if (number.charAt(0) < 'A') {
                number = (char)(number.charAt(0) + 23) + number.substring(1);
            }
            this.getModel().setValue("number", (Object)number);
        }
    }

    private Object getName() {
        String s = D.s((Object)this.getModel().getValue("name"));
        if (s != null) {
            return s;
        }
        throw new AbortException(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u540d\u79f0\u201d\u3002", (String)"ServiceFlowGuideByDCFormPlugin_21", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }

    private String getType() {
        return D.s((Object)this.getModel().getValue("type"));
    }

    private void setResourceRelatedSystem(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        for (ChangeData item : changeSet = e.getChangeSet()) {
            DynamicObject obj = item.getDataEntity();
            DynamicObject res = (DynamicObject)obj.get(RESOURCE);
            if (res == null) {
                obj.set("data_source", null);
                obj.set("data_target", null);
                continue;
            }
            long id = res.getLong("id");
            if (res.getDataEntityType().getName().endsWith("trigger")) {
                id = DataCopyTrigger.get((long)id).getLong("data_copy_id");
            }
            DynamicObject schema = DataCopySchema.get((long)id);
            obj.set("data_source", schema.get("data_source"));
            obj.set("data_target", schema.get("data_target"));
            this.getView().updateView("schemas");
        }
    }

    private void setFlexVisiable(int index) {
        this.getView().setEnable(Boolean.valueOf(index == 1), new String[]{"type"});
        if (this.isManualMode()) {
            this.getView().setVisible(Boolean.valueOf(index != 1), new String[]{FLEX_FILTER, LAST_STEP, GUIDE_ONE, GUIDE_TWOED, "btnok"});
            this.getView().setVisible(Boolean.valueOf(index != 2), new String[]{FLEX_DC, NEXT_STEP, GUIDE_ONED, GUIDE_TWO});
            this.getView().setVisible(Boolean.FALSE, new String[]{GUIDE_THREE, GUIDE_THREEED});
        } else if (this.isTimerMode()) {
            if (index == 1) {
                this.getView().setVisible(Boolean.FALSE, new String[]{LAST_STEP, FLEX_FILTER, TAB3_T, GUIDE_ONE, GUIDE_TWOED, GUIDE_THREEED, "btnok"});
                this.getView().setVisible(Boolean.TRUE, new String[]{NEXT_STEP, FLEX_DC, GUIDE_ONED, GUIDE_TWO, GUIDE_THREE});
            } else if (index == 2) {
                this.getView().setVisible(Boolean.FALSE, new String[]{TAB3_T, FLEX_DC, GUIDE_ONED, GUIDE_TWO, GUIDE_THREEED, "btnok"});
                this.getView().setVisible(Boolean.TRUE, new String[]{LAST_STEP, NEXT_STEP, FLEX_FILTER, GUIDE_ONE, GUIDE_TWOED, GUIDE_THREE});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{NEXT_STEP, FLEX_DC, FLEX_FILTER, GUIDE_ONED, GUIDE_TWOED, GUIDE_THREE});
                this.getView().setVisible(Boolean.TRUE, new String[]{LAST_STEP, TAB3_T, GUIDE_ONE, GUIDE_TWO, GUIDE_THREEED, "btnok"});
            }
        } else if (this.isEventMode()) {
            this.getView().setVisible(Boolean.valueOf(index != 1), new String[]{FLEX_E, LAST_STEP, GUIDE_ONE, GUIDE_TWOED, "btnok"});
            this.getView().setVisible(Boolean.valueOf(index != 2), new String[]{FLEX_DC, NEXT_STEP, GUIDE_ONED, GUIDE_TWO});
            this.getView().setVisible(Boolean.FALSE, new String[]{GUIDE_THREE, GUIDE_THREEED});
        }
    }

    private void initMeta(Graph<DynamicObject> g) {
        Set starts = g.getStarts();
        Vertex first = starts.isEmpty() ? g.getFirst() : (Vertex)starts.iterator().next();
        String metaId = D.s((Object)((DynamicObject)first.value()).getLong("id"));
        this.getView().getPageCache().put(META_ID, metaId);
        if (this.isManualMode() || this.isTimerMode()) {
            this.getView().getModel().setValue("meta", (Object)metaId);
        } else if (this.isEventMode()) {
            this.getView().getModel().setValue("meta_e", (Object)metaId);
            this.initEventCombo(D.l((Object)metaId));
        }
    }

    private void initEventCombo(long metaSchemaId) {
        if (metaSchemaId != 0L && QueryServiceHelper.exists((String)"isc_metadata_schema", (Object)metaSchemaId)) {
            DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)metaSchemaId, (String)"isc_metadata_schema");
            ComboEdit eventCombo = (ComboEdit)this.getView().getControl("bill_events");
            eventCombo.setComboItems(this.getEventComboItems(meta));
        }
    }

    private List<ComboItem> getEventComboItems(DynamicObject meta) {
        DynamicObjectCollection events = meta.getDynamicObjectCollection("event_entryentity");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(events.size());
        for (DynamicObject event : events) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(event.getString("event_label")));
            item.setValue(event.getString("event_number"));
            items.add(item);
        }
        return items;
    }

    public void cellClick(CellClickEvent evt) {
    }

    private void openSelectMetaForm(CellClickEvent evt) {
        String fieldKey = evt.getFieldKey();
        if (FILTER_FIELD.equals(fieldKey)) {
            HashMap<String, Object> param = new HashMap<String, Object>(2);
            String metaId = this.getView().getPageCache().get(META_ID);
            param.put("id", metaId);
            param.put("$row", evt.getRow());
            FormOpener.showForm(this, "isc_meta_properties", ResManager.loadKDString((String)"\u9009\u62e9\u5143\u6570\u636e\u5c5e\u6027", (String)"ServiceFlowGuideByDCFormPlugin_22", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), param, FILTER_FIELD);
        }
    }

    public void cellDoubleClick(CellClickEvent evt) {
        this.openSelectMetaForm(evt);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        if (FILTER_FIELD.equals(action)) {
            this.setReturnValues(action, (Map)returnData);
        } else if ("cron_expr".equals(action)) {
            this.getModel().setValue("cron_expr", ((Map)returnData).get("cron_expr"));
        }
    }

    private void setReturnValues(String action, Map<String, Object> map) {
        Object row = map.get("$row");
        if (row != null) {
            int index = D.i((Object)row);
            if (action.contains(FILTER_FIELD)) {
                String field = D.s((Object)map.get("number"));
                DynamicObject entry = this.getModel().getEntryRowEntity(FILTER_ENTRIES, index);
                entry.set(FILTER_FIELD, (Object)field);
                entry.set(FILTER_LABLE, map.get("name"));
                this.getView().updateView(FILTER_ENTRIES);
            }
        }
    }

    private Graph<DynamicObject> createGraph() {
        Graph g = new Graph();
        DynamicObjectCollection c = this.getModel().getEntryEntity("schemas");
        for (DynamicObject entry : c) {
            DynamicObject schema;
            DynamicObject resource = (DynamicObject)entry.get(RESOURCE);
            if (resource == null) continue;
            if (resource.getDataEntityType().getName().endsWith("trigger")) {
                resource = DataCopyTrigger.get((long)resource.getLong("id"));
                schema = DataCopySchema.get((long)resource.getLong("data_copy_id"));
            } else {
                schema = resource = DataCopySchema.get((long)resource.getLong("id"));
            }
            DynamicObject src = (DynamicObject)schema.get("source_schema");
            DynamicObject tar = (DynamicObject)schema.get("target_schema");
            String from = src.get("id").toString();
            String to = tar.get("id").toString();
            if (from.equals(to)) {
                String message = String.format(ResManager.loadKDString((String)"\u65b9\u6848\uff08%s\uff09\u7684\u6e90\u5bf9\u8c61\u548c\u76ee\u6807\u5bf9\u8c61\u662f\u540c\u4e00\u4e2a\uff0c\u4e0d\u80fd\u7528\u4e8e\u6570\u636e\u96c6\u6210\u7f16\u6392\u5411\u5bfc\uff01", (String)"ServiceFlowGuideByDCFormPlugin_36", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), resource.get("name"));
                throw new AbortException(message);
            }
            g.appendVertex(from, (Object)src);
            g.appendVertex(to, (Object)tar);
            if (g.appendEdge(from, to, (Object)resource)) continue;
            String message = String.format(ResManager.loadKDString((String)"\u201c%1$s\uff3b%2$s\uff3d\u201d\u5230\u201c%3$s\uff3b%4$s\uff3d\u201d\u6307\u5b9a\u4e86\u591a\u4e2a\u96c6\u6210\u65b9\u6848\uff01", (String)"ServiceFlowGuideByDCFormPlugin_37", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), src.get("name"), src.get("number"), tar.get("name"), tar.get("number"));
            throw new AbortException(message);
        }
        if (g.getNodeCount() == 0) {
            throw new AbortException(ResManager.loadKDString((String)"\u9700\u8981\u9009\u62e9\u81f3\u5c111\u4e2a\u96c6\u6210\u65b9\u6848\u6216\u542f\u52a8\u65b9\u6848\uff01", (String)"ServiceFlowGuideByDCFormPlugin_26", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        return g;
    }

    private void checkGraph(Graph<DynamicObject> g) {
        Set set = g.getStarts();
        if (set.size() > 1) {
            Vertex[] starts = set.toArray(new Vertex[set.size()]);
            DynamicObject src = (DynamicObject)starts[0].value();
            DynamicObject tar = (DynamicObject)starts[1].value();
            String message = String.format(ResManager.loadKDString((String)"\u201c%1$s\uff3b%2$s\uff3d\u201d\u4e0e\u201c%3$s\uff3b%4$s\uff3d\u201d\u95f4\u6ca1\u6709\u96c6\u6210\u65b9\u6848\u5173\u8054\uff01", (String)"ServiceFlowGuideByDCFormPlugin_38", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), src.get("name"), src.get("number"), tar.get("name"), tar.get("number"));
            throw new AbortException(message);
        }
    }

    private void setVisiableBytype(String type) {
        for (TypeEnum typeEnum : TypeEnum.values()) {
            if (!typeEnum.getProperty().equals(type)) continue;
            List<String> list = typeEnum.getUnVisiableString();
            String[] strings = list.toArray(new String[0]);
            this.getView().setVisible(Boolean.FALSE, strings);
            List<String> vlist = typeEnum.getVisiableString();
            String[] vstrings = vlist.toArray(new String[0]);
            this.getView().setVisible(Boolean.TRUE, vstrings);
        }
    }

    public static enum TypeEnum {
        MANUAL{

            @Override
            public String getProperty() {
                return ServiceFlowGuideByDCFormPlugin.MANUAL_STRING;
            }

            @Override
            public List<String> getUnVisiableString() {
                return Arrays.asList(ServiceFlowGuideByDCFormPlugin.FLEX_T, ServiceFlowGuideByDCFormPlugin.FLEX_E, "line2", "tag_text_21", "tag_text_3");
            }

            @Override
            public List<String> getVisiableString() {
                return Arrays.asList("tag_text_2", ServiceFlowGuideByDCFormPlugin.FLEX_FILTER);
            }
        }
        ,
        TIMER{

            @Override
            public String getProperty() {
                return ServiceFlowGuideByDCFormPlugin.TIMER_STRING;
            }

            @Override
            public List<String> getUnVisiableString() {
                return Arrays.asList(ServiceFlowGuideByDCFormPlugin.FLEX_FILTER, ServiceFlowGuideByDCFormPlugin.FLEX_E, "tag_text_21");
            }

            @Override
            public List<String> getVisiableString() {
                return Arrays.asList("line2", ServiceFlowGuideByDCFormPlugin.FLEX_T, "tag_text_2", "tag_text_3");
            }
        }
        ,
        EVENT{

            @Override
            public String getProperty() {
                return ServiceFlowGuideByDCFormPlugin.EVENT_STRING;
            }

            @Override
            public List<String> getUnVisiableString() {
                return Arrays.asList(ServiceFlowGuideByDCFormPlugin.FLEX_FILTER, ServiceFlowGuideByDCFormPlugin.FLEX_T, "line2", "tag_text_2", "tag_text_3");
            }

            @Override
            public List<String> getVisiableString() {
                return Arrays.asList(ServiceFlowGuideByDCFormPlugin.FLEX_E, "tag_text_21");
            }
        };


        public abstract String getProperty();

        public abstract List<String> getUnVisiableString();

        public abstract List<String> getVisiableString();
    }

    private static class Info {
        private String firstNode;
        private String secondNode;

        private Info() {
        }
    }

    private static class AbortException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public AbortException(String message) {
            super(message);
        }
    }
}

