/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Button;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.cache.data.DataCopySchema;
import kd.isc.iscb.platform.core.cache.data.DataCopyTrigger;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.platform.core.cache.data.SimpleValueTypeConfig;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.dt.DataTypes;
import kd.isc.iscb.util.g.Edge;
import kd.isc.iscb.util.g.Graph;
import kd.isc.iscb.util.g.Vertex;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.misc.Triple;

public class ServiceFlowGuideForDCFormPlugin
extends AbstractFormPlugin
implements Const {
    private static final String IS_OUTPUT_PARAM = "is_output_param";
    private static final String IS_INPUT_PARAM = "is_input_param";
    private static final String IS_ARRAY2 = "is_array";
    private static final String DEFAULT_VALUE2 = "default_value";
    private static final String VAR_DESC = "var_desc";
    private static final String VAR_NAME = "var_name";
    private static final String VAR_TYPE = "var_type";
    private static final String VAR_CATEGORY = "var_category";
    private static final String ISC_TYPE_SIMPLE_VALUE2 = "isc_type_simple_value";
    private static final String DATA_TYPE2 = "data_type";
    private static final String GROUP = "group";
    private static final String PROP_ENTRYENTITY = "prop_entryentity";
    private static final String PROP_LABEL = "prop_label";
    private static final String PROP_NAME = "prop_name";
    private static final String COORDINATE = "coordinate";
    private static final String HEIGHT = "height";
    private static final String WIDTH = "width";
    private static final String TYPE2 = "type";
    private static final String TARGET = "target";
    private static final String SOURCE = "source";
    private static final String NORMAL_TRANSITION = "NormalTransition";
    private static final String DATA_COPY_ID = "data_copy_id";
    private static final String TRIGGER = "trigger";
    private static final String DATA_TARGET = "data_target";
    private static final String DATA_SOURCE2 = "data_source";
    private static final String NUMBER2 = "number";
    private static final String NAME2 = "name";
    private static final String RESOURCE = "resource";
    private static final String TITLE2 = "title";
    private static final String[] SPECIAL_FIELDS = new String[]{"number", "fnumber", "name", "fname", "title", "ftitle", "label", "flabel", "description", "fdescription"};

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (RESOURCE.equals(name)) {
            this.setResourceRelatedSystem(e);
        } else if (NAME2.equals(name)) {
            this.generateFlowNumber();
        }
    }

    private void generateFlowNumber() {
        Object value;
        if (D.s((Object)this.getModel().getValue(NUMBER2)) == null && (value = this.getName()) != null) {
            String number = Hash.mur32((Object[])new Object[]{UUID.randomUUID().toString()});
            if (number.charAt(0) < 'A') {
                number = (char)(number.charAt(0) + 23) + number.substring(1);
            }
            this.getModel().setValue(NUMBER2, (Object)number);
        }
    }

    private void setResourceRelatedSystem(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        for (ChangeData item : changeSet = e.getChangeSet()) {
            DynamicObject obj = item.getDataEntity();
            DynamicObject res = (DynamicObject)obj.get(RESOURCE);
            if (res == null) {
                obj.set(DATA_SOURCE2, null);
                obj.set(DATA_TARGET, null);
                continue;
            }
            long id = res.getLong("id");
            if (res.getDataEntityType().getName().endsWith(TRIGGER)) {
                id = DataCopyTrigger.get((long)id).getLong(DATA_COPY_ID);
            }
            DynamicObject schema = DataCopySchema.get((long)id);
            obj.set(DATA_SOURCE2, schema.get(DATA_SOURCE2));
            obj.set(DATA_TARGET, schema.get(DATA_TARGET));
            this.getView().updateView("schemas");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        if (src instanceof Button && "btnok".equals(((Button)src).getKey())) {
            try {
                Graph<DynamicObject> g = this.createGraph();
                this.checkGraph(g);
                Info info = this.createServiceFlow(g);
                this.showMessage(info);
            }
            catch (AbortException e) {
                this.getView().showErrorNotification(e.getMessage());
            }
        }
    }

    private void showMessage(Info info) {
        String message = this.isEventMode() ? String.format(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u5df2\u751f\u6210\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u5e76\u6253\u5f00\u6d41\u7a0b\u56fe\u7684\u201c%s\u201d\u8282\u70b9\u8bbe\u7f6e\u76d1\u542c\u4e8b\u4ef6\uff01", (String)"ServiceFlowGuideForDCFormPlugin_26", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), info.firstNode) : (this.isManualMode() ? String.format(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u5df2\u751f\u6210\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u5e76\u6253\u5f00\u6d41\u7a0b\u56fe\u7684\u201c%s\u201d\u8282\u70b9\u8bbe\u7f6e\u8fc7\u6ee4\u6761\u4ef6\uff01", (String)"ServiceFlowGuideForDCFormPlugin_27", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), info.secondNode) : String.format(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u5df2\u751f\u6210\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u5e76\u6253\u5f00\u6d41\u7a0b\u56fe\u7684\u201c%1$s\u201d\u548c\u201c%2$s\u201d\u8282\u70b9\u5206\u522b\u8bbe\u7f6e\u8c03\u5ea6\u8ba1\u5212\u548c\u8fc7\u6ee4\u6761\u4ef6\uff01", (String)"ServiceFlowGuideForDCFormPlugin_28", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), info.firstNode, info.secondNode));
        this.getView().showConfirm(message, MessageBoxOptions.OK, new ConfirmCallBackListener(String.valueOf(info.id), (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        this.getView().close();
    }

    private void checkGraph(Graph<DynamicObject> g) {
        Set set = g.getStarts();
        if (set.size() > 1) {
            Vertex[] starts = set.toArray(new Vertex[set.size()]);
            DynamicObject src = (DynamicObject)starts[0].value();
            DynamicObject tar = (DynamicObject)starts[1].value();
            String message = String.format(ResManager.loadKDString((String)"\u201c%1$s\uff3b%2$s\uff3d\u201d\u4e0e\u201c%3$s\uff3b%4$s\uff3d\u201d\u95f4\u6ca1\u6709\u96c6\u6210\u65b9\u6848\u5173\u8054\uff01", (String)"ServiceFlowGuideForDCFormPlugin_29", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), src.get(NAME2), src.get(NUMBER2), tar.get(NAME2), tar.get(NUMBER2));
            throw new AbortException(message);
        }
    }

    private Graph<DynamicObject> createGraph() {
        Graph g = new Graph();
        DynamicObjectCollection c = this.getModel().getEntryEntity("schemas");
        for (DynamicObject entry : c) {
            DynamicObject schema;
            DynamicObject resource = (DynamicObject)entry.get(RESOURCE);
            if (resource == null) continue;
            if (resource.getDataEntityType().getName().endsWith(TRIGGER)) {
                resource = DataCopyTrigger.get((long)resource.getLong("id"));
                schema = DataCopySchema.get((long)resource.getLong(DATA_COPY_ID));
            } else {
                schema = resource = DataCopySchema.get((long)resource.getLong("id"));
            }
            DynamicObject src = (DynamicObject)schema.get("source_schema");
            DynamicObject tar = (DynamicObject)schema.get("target_schema");
            String from = src.get("id").toString();
            String to = tar.get("id").toString();
            if (from.equals(to)) {
                String message = String.format(ResManager.loadKDString((String)"\u65b9\u6848\uff08%s\uff09\u7684\u6e90\u5bf9\u8c61\u548c\u76ee\u6807\u5bf9\u8c61\u662f\u540c\u4e00\u4e2a\uff0c\u4e0d\u80fd\u7528\u4e8e\u6570\u636e\u96c6\u6210\u7f16\u6392\u5411\u5bfc\uff01", (String)"ServiceFlowGuideForDCFormPlugin_30", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), resource.get(NAME2));
                throw new AbortException(message);
            }
            g.appendVertex(from, (Object)src);
            g.appendVertex(to, (Object)tar);
            if (g.appendEdge(from, to, (Object)resource)) continue;
            String message = String.format(ResManager.loadKDString((String)"\u201c%1$s\uff3b%2$s\uff3d\u201d\u5230\u201c%3$s\uff3b%4$s\uff3d\u201d\u6307\u5b9a\u4e86\u591a\u4e2a\u96c6\u6210\u65b9\u6848\uff01", (String)"ServiceFlowGuideForDCFormPlugin_31", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), src.get(NAME2), src.get(NUMBER2), tar.get(NAME2), tar.get(NUMBER2));
            throw new AbortException(message);
        }
        if (g.getNodeCount() == 0) {
            throw new AbortException(ResManager.loadKDString((String)"\u9700\u8981\u9009\u62e9\u81f3\u5c111\u4e2a\u96c6\u6210\u65b9\u6848\u6216\u542f\u52a8\u65b9\u6848\uff01", (String)"ServiceFlowGuideForDCFormPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        return g;
    }

    private Info createServiceFlow(Graph<DynamicObject> g) {
        Set starts = g.getStarts();
        Vertex first = starts.size() == 0 ? g.getFirst() : (Vertex)starts.iterator().next();
        Graph g2 = new Graph();
        this.createGraph2((Vertex<DynamicObject>)first, (Graph<DynamicObject>)g2);
        int maxLevel = this.visitGraph2((Graph<DynamicObject>)g2);
        DynamicObject flow = BusinessDataServiceHelper.newDynamicObject((String)"isc_service_flow");
        this.setBasics(flow);
        Map<Long, String> variables = this.createVariables(flow, (Vertex<DynamicObject>)first, g);
        Map<Long, String> resources = this.createResources(flow, (Vertex<DynamicObject>)first, g);
        Info info = new Info();
        flow.set("define_json_tag", (Object)this.generateFlowDiagram((Graph<DynamicObject>)g2, variables, maxLevel, resources, (Vertex<DynamicObject>)first, info));
        ConnectorUtil.save((DynamicObject)flow);
        info.id = flow.getLong("id");
        return info;
    }

    private String generateFlowDiagram(Graph<DynamicObject> g2, Map<Long, String> variables, int maxLevel, Map<Long, String> resources, Vertex<DynamicObject> first, Info info) {
        LinkedHashMap<String, Object> diagram = new LinkedHashMap<String, Object>(16);
        LinkedHashMap<String, Object> nodes = new LinkedHashMap<String, Object>(16);
        LinkedHashMap<String, Object> links = new LinkedHashMap<String, Object>(16);
        int count = this.createNodes(diagram, g2, first, nodes, links, info, variables, maxLevel, resources);
        String prior = (String)first.getFlag();
        String path = "bottom:" + (this.isMultipleMode() ? "-5" : "0") + "|top:0";
        for (Vertex v : g2.getStarts()) {
            String next = (String)v.getFlag();
            String id = String.valueOf(++count);
            LinkedHashMap<String, String> t = new LinkedHashMap<String, String>(8);
            t.put("id", id);
            t.put(TYPE2, NORMAL_TRANSITION);
            t.put(SOURCE, prior);
            t.put(TARGET, next);
            t.put("path", path);
            links.put(id, t);
        }
        for (Edge e : g2.getEdges().values()) {
            String from = (String)e.getFrom().getFlag();
            String to = (String)e.getTo().getFlag();
            String id = String.valueOf(++count);
            LinkedHashMap<String, String> t = new LinkedHashMap<String, String>(8);
            t.put("id", id);
            t.put(TYPE2, NORMAL_TRANSITION);
            t.put(SOURCE, from);
            t.put(TARGET, to);
            t.put("path", "bottom:0|top:0");
            links.put(id, t);
        }
        diagram.put("nodes", nodes);
        diagram.put("links", links);
        diagram.put("count", count);
        return Json.toString(diagram);
    }

    private int createNodes(Map<String, Object> diagram, Graph<DynamicObject> g2, Vertex<DynamicObject> first, Map<String, Object> nodes, Map<String, Object> links, Info info, Map<Long, String> variables, int maxLevel, Map<Long, String> resources) {
        int count = this.createStartNodes(nodes, info, links, first, variables);
        count = this.createDataCopyNodes(g2, nodes, count, resources, variables);
        count = this.createJoinNode(nodes, count, maxLevel);
        count = this.createJoinLinks(g2, links, count, first);
        return count;
    }

    private int createJoinLinks(Graph<DynamicObject> g2, Map<String, Object> links, int count, Vertex<DynamicObject> first) {
        String join = String.valueOf(count);
        for (Vertex v : g2.getEnds()) {
            LinkedHashMap<String, Object> t = new LinkedHashMap<String, Object>(8);
            String tid = String.valueOf(++count);
            t.put("id", tid);
            t.put(TYPE2, NORMAL_TRANSITION);
            t.put(SOURCE, v.getFlag());
            t.put(TARGET, join);
            t.put("path", "bottom:0|top:0");
            links.put(tid, t);
        }
        if (this.isMultipleMode()) {
            LinkedHashMap<String, Object> t = new LinkedHashMap<String, Object>(8);
            String tid = String.valueOf(++count);
            t.put("id", tid);
            t.put(TYPE2, NORMAL_TRANSITION);
            t.put(SOURCE, join);
            t.put(TARGET, first.getFlag());
            t.put("path", "right:0|bottom:5");
            links.put(tid, t);
        }
        return count;
    }

    private int createJoinNode(Map<String, Object> nodes, int count, int maxLevel) {
        String id = String.valueOf(++count);
        LinkedHashMap<String, Object> join = new LinkedHashMap<String, Object>(8);
        join.put("id", id);
        if (this.isMultipleMode()) {
            String text = "++ SRC_SEQ";
            join.put(TITLE2, text);
            join.put(TYPE2, "Script");
            join.put("script", text);
        } else {
            join.put(TITLE2, ResManager.loadKDString((String)"\u7ed3\u675f", (String)"ServiceFlowGuideForDCFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            join.put(TYPE2, "End");
        }
        LinkedHashMap<String, Integer> co = new LinkedHashMap<String, Integer>(8);
        co.put("x", 100);
        co.put("y", maxLevel * 150 + 200);
        co.put(WIDTH, 200);
        co.put(HEIGHT, 45);
        join.put(COORDINATE, co);
        nodes.put(id, join);
        return count;
    }

    private int createDataCopyNodes(Graph<DynamicObject> g2, Map<String, Object> nodes, int count, Map<Long, String> resources, Map<Long, String> variables) {
        for (Vertex v : g2.getNodes2().values()) {
            Triple p = (Triple)v.getFlag();
            String id = String.valueOf(++count);
            v.setFlag((Object)id);
            LinkedHashMap<String, Object> node = new LinkedHashMap<String, Object>(8);
            node.put("id", id);
            DynamicObject dc = (DynamicObject)v.value();
            node.put(TITLE2, D.s((Object)dc.get(NAME2)));
            node.put(TYPE2, "DataCopy");
            LinkedHashMap<String, Object> co = new LinkedHashMap<String, Object>(8);
            co.put("x", p.getA());
            co.put("y", (Integer)p.getB() + 200);
            co.put(WIDTH, 200);
            co.put(HEIGHT, 45);
            node.put(COORDINATE, co);
            DynamicObject schema = (DynamicObject)v.value();
            String schemaType = schema.getDataEntityType().getName();
            LinkedHashMap<String, Object> schemaInfo = new LinkedHashMap<String, Object>(8);
            schemaInfo.put(NAME2, D.s((Object)schema.get(NAME2)));
            schemaInfo.put("id", schema.getPkValue());
            schemaInfo.put("schema_type", schemaType);
            if (schemaType.endsWith(TRIGGER)) {
                schema = DataCopySchema.get((long)schema.getLong(DATA_COPY_ID));
                if (v.hasOutGoing()) {
                    throw new AbortException(String.format(ResManager.loadKDString((String)"%s \u662f\u542f\u52a8\u65b9\u6848\uff0c\u53ea\u80fd\u4f5c\u4e3a\u4e2d\u95f4\u73af\u8282\u3002", (String)"ServiceFlowGuideForDCFormPlugin_32", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ((DynamicObject)v.value()).getString(NAME2)));
                }
            } else {
                schema = DataCopySchema.get((long)schema.getLong("id"));
            }
            schemaInfo.put("var", resources.get(schema.getLong("id")));
            node.put("schema", schemaInfo);
            node.put("schema_type", schemaType);
            node.put("tar_var", variables.get(schema.getLong("target_schema_id")));
            node.put("src_var", variables.get(schema.getLong("source_schema_id")));
            node.put("filter_type", "filters");
            LinkedHashMap<String, Object> filter = new LinkedHashMap<String, Object>(8);
            DynamicObject meta = MetaDataSchema.get((long)schema.getLong("source_schema_id"));
            if (this.isInvalidSource(meta)) {
                throw new AbortException(String.format(ResManager.loadKDString((String)"\u65b9\u6848\uff08%s\uff09\u7684\u6e90\u5bf9\u8c61\u4e0d\u662f\u201c\u5b9e\u4f53\u201d\u3001\u201c\u6570\u636e\u8868\u201d\u6216\u201c\u89c6\u56fe\u201d\u3002", (String)"ServiceFlowGuideForDCFormPlugin_33", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ((DynamicObject)v.value()).get(NAME2)));
            }
            DynamicObject pk = this.findPkField(meta);
            filter.put("filter_column", pk.get(PROP_NAME));
            filter.put("filter_label", pk.get(PROP_LABEL));
            filter.put("filter_compare", "=");
            filter.put("filter_value_var", variables.get(meta.getPkValue()));
            node.put("filter_entries", Collections.singletonList(filter));
            nodes.put(id, node);
        }
        return count;
    }

    private boolean isInvalidSource(DynamicObject meta) {
        String type = meta.getString(TYPE2);
        return !"ENTITY".equals(type) && !"TABLE".equals(type) && !"VIEW".equals(type);
    }

    private int createStartNodes(Map<String, Object> nodes, Info info, Map<String, Object> links, Vertex<DynamicObject> first, Map<Long, String> variables) {
        DynamicObject meta = MetaDataSchema.get((long)((DynamicObject)first.value()).getLong("id"));
        int count = this.createStartNode(nodes, meta, links, info);
        count = this.createScriptNode(nodes, count, variables, links, meta, first);
        if (this.isMultipleMode()) {
            count = this.createEndNode(nodes, count, first, links, variables);
        }
        return count;
    }

    private int createEndNode(Map<String, Object> nodes, int count, Vertex<DynamicObject> first, Map<String, Object> links, Map<Long, String> variables) {
        String from = (String)first.getFlag();
        String id = String.valueOf(++count);
        LinkedHashMap<String, Object> end = new LinkedHashMap<String, Object>(8);
        end.put("id", id);
        end.put(TITLE2, ResManager.loadKDString((String)"\u7ed3\u675f", (String)"ServiceFlowGuideForDCFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        end.put(TYPE2, "End");
        LinkedHashMap<String, Integer> co = new LinkedHashMap<String, Integer>(8);
        co.put("x", 1050);
        co.put("y", 50);
        co.put(WIDTH, 200);
        co.put(HEIGHT, 45);
        end.put(COORDINATE, co);
        nodes.put(id, end);
        String tid = String.valueOf(++count);
        LinkedHashMap<String, String> t = new LinkedHashMap<String, String>(8);
        t.put("id", tid);
        t.put(TYPE2, NORMAL_TRANSITION);
        t.put(SOURCE, from);
        t.put(TARGET, id);
        t.put("path", "right:0|left:0");
        String tempVar = variables.get(((DynamicObject)first.value()).getPkValue());
        String text = tempVar + " == null";
        t.put(TITLE2, text);
        t.put("condition", text);
        links.put(tid, t);
        return count;
    }

    private int createScriptNode(Map<String, Object> nodes, int count, Map<Long, String> variables, Map<String, Object> links, DynamicObject meta, Vertex<DynamicObject> first) {
        String from = String.valueOf(count);
        DynamicObject pk = this.findPkField(meta);
        String id = String.valueOf(++count);
        String tempVar = variables.get(meta.getPkValue());
        String pkField = pk.getString(PROP_NAME);
        String text = tempVar + " = src" + (this.isMultipleMode() ? "[SRC_SEQ] ?." : " . ") + pkField;
        LinkedHashMap<String, Object> script = new LinkedHashMap<String, Object>(8);
        script.put("id", id);
        script.put(TITLE2, text);
        script.put(TYPE2, "Script");
        LinkedHashMap<String, Integer> co = new LinkedHashMap<String, Integer>(8);
        co.put("x", this.isMultipleMode() ? 600 : 350);
        co.put("y", 50);
        co.put(WIDTH, 200);
        co.put(HEIGHT, 45);
        script.put(COORDINATE, co);
        script.put("script", text);
        nodes.put(id, script);
        String tid = String.valueOf(++count);
        LinkedHashMap<String, String> t = new LinkedHashMap<String, String>(8);
        t.put("id", tid);
        t.put(TYPE2, NORMAL_TRANSITION);
        t.put(SOURCE, from);
        t.put(TARGET, id);
        t.put("path", "right:0|left:0");
        links.put(tid, t);
        first.setFlag((Object)id);
        return count;
    }

    private DynamicObject findPkField(DynamicObject meta) {
        DynamicObject pk = null;
        DynamicObjectCollection properties = meta.getDynamicObjectCollection(PROP_ENTRYENTITY);
        for (DynamicObject p : properties) {
            if (!this.isPrimaryKey(p)) continue;
            if (pk == null) {
                pk = p;
                continue;
            }
            throw new AbortException(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61\uff08%s\uff09\u6709\u591a\u5b57\u6bb5\u4e3b\u952e\uff01", (String)"ServiceFlowGuideForDCFormPlugin_34", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), meta.get(NAME2)));
        }
        if (pk == null) {
            throw new AbortException(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61\uff08%s\uff09\u6709\u6ca1\u6709\u4e3b\u952e\u5b57\u6bb5\uff01", (String)"ServiceFlowGuideForDCFormPlugin_35", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), meta.get(NAME2)));
        }
        return pk;
    }

    private int createStartNode(Map<String, Object> nodes, DynamicObject meta, Map<String, Object> links, Info info) {
        if (this.isEventMode()) {
            this.createEventStartNode(nodes, meta, info);
            return 1;
        }
        if (this.isManualMode()) {
            this.createStartNode(nodes, "ManualStarter", info);
        } else if (this.isTimerMode()) {
            this.createStartNode(nodes, "TimerStarter", info);
        } else {
            throw new AbortException(ResManager.loadKDString((String)"\u6b64\u542f\u52a8\u65b9\u5f0f\u4e0d\u652f\u6301\uff01", (String)"ServiceFlowGuideForDCFormPlugin_18", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        info.secondNode = String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u67e5\u8be2", (String)"ServiceFlowGuideForDCFormPlugin_36", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), meta.get(NAME2), ((DynamicObject)meta.get(GROUP)).get(NAME2));
        String qid = "3";
        LinkedHashMap<String, Object> query = new LinkedHashMap<String, Object>(8);
        query.put("id", qid);
        query.put(TITLE2, info.secondNode);
        query.put(TYPE2, "DataRetriever");
        LinkedHashMap<String, Integer> co = new LinkedHashMap<String, Integer>(8);
        co.put("x", 350);
        co.put("y", 50);
        co.put(WIDTH, 200);
        co.put(HEIGHT, 45);
        query.put(COORDINATE, co);
        ArrayList retriever_entries = new ArrayList();
        DynamicObjectCollection properties = meta.getDynamicObjectCollection(PROP_ENTRYENTITY);
        for (DynamicObject p : properties) {
            if (!this.isExpected(p)) continue;
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>(8);
            item.put("reader_field", p.get(PROP_NAME));
            item.put("reader_field_type", p.get(DATA_TYPE2));
            item.put("reader_field_label", p.get(PROP_LABEL));
            retriever_entries.add(item);
            if (retriever_entries.size() != 2) continue;
            break;
        }
        query.put("retriever_entries", retriever_entries);
        query.put("filter_entries", Collections.emptyList());
        query.put("sort_entries", Collections.emptyList());
        query.put("param_entries", Collections.emptyList());
        LinkedHashMap<String, Object> data_schema = new LinkedHashMap<String, Object>(8);
        data_schema.put(NAME2, D.s((Object)meta.get(NAME2)));
        data_schema.put("var", "_src");
        data_schema.put("id", meta.getPkValue());
        query.put("data_schema", data_schema);
        LinkedHashMap<String, Object> assignment_var = new LinkedHashMap<String, Object>(8);
        assignment_var.put("id", meta.getPkValue());
        assignment_var.put("var", "src");
        assignment_var.put(NAME2, D.s((Object)meta.get(NAME2)));
        query.put("assignment_var", assignment_var);
        nodes.put(qid, query);
        String tid = "2";
        LinkedHashMap<String, String> t = new LinkedHashMap<String, String>(8);
        t.put("id", tid);
        t.put(TYPE2, NORMAL_TRANSITION);
        t.put(SOURCE, "1");
        t.put(TARGET, qid);
        t.put("path", "right:0|left:0");
        links.put(tid, t);
        return 3;
    }

    private void createStartNode(Map<String, Object> nodes, String type, Info info) {
        LinkedHashMap<String, Object> start = new LinkedHashMap<String, Object>(8);
        start.put("id", "1");
        info.firstNode = ResManager.loadKDString((String)"\u5f00\u59cb", (String)"ServiceFlowGuideForDCFormPlugin_20", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        start.put(TITLE2, info.firstNode);
        start.put(TYPE2, type);
        LinkedHashMap<String, Integer> co = new LinkedHashMap<String, Integer>(8);
        co.put("x", 100);
        co.put("y", 50);
        co.put(WIDTH, 200);
        co.put(HEIGHT, 45);
        start.put(COORDINATE, co);
        nodes.put("1", start);
    }

    private void createEventStartNode(Map<String, Object> nodes, DynamicObject meta, Info info) {
        LinkedHashMap<String, Object> start = new LinkedHashMap<String, Object>(8);
        start.put("id", "1");
        info.firstNode = String.format(ResManager.loadKDString((String)"\u4e8b\u4ef6\u89e6\u53d1\uff08%s\uff09", (String)"ServiceFlowGuideForDCFormPlugin_37", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), D.s((Object)meta.get(NAME2)));
        start.put(TITLE2, info.firstNode);
        start.put(TYPE2, "EventStarter");
        LinkedHashMap<String, Integer> co = new LinkedHashMap<String, Integer>(8);
        co.put("x", 100);
        co.put("y", 50);
        co.put(WIDTH, 200);
        co.put(HEIGHT, 45);
        start.put(COORDINATE, co);
        ArrayList selector_entry = new ArrayList(2);
        DynamicObjectCollection properties = meta.getDynamicObjectCollection(PROP_ENTRYENTITY);
        for (DynamicObject p : properties) {
            if (!this.isExpected(p)) continue;
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>(8);
            item.put("field", p.get(PROP_NAME));
            item.put(DATA_TYPE2, p.get(DATA_TYPE2));
            item.put("description", p.get(PROP_LABEL));
            selector_entry.add(item);
            if (selector_entry.size() != 2) continue;
            break;
        }
        start.put("data_schema", meta.getPkValue());
        start.put("variables_value", "src");
        start.put("selector_entry", selector_entry);
        nodes.put("1", start);
    }

    private boolean isExpected(DynamicObject p) {
        if (this.isPrimaryKey(p)) {
            return true;
        }
        String name = p.getString(PROP_NAME);
        for (String s : SPECIAL_FIELDS) {
            if (!s.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private boolean isPrimaryKey(DynamicObject p) {
        return D.x((Object)p.get("is_primary_key"));
    }

    private Map<Long, String> createResources(DynamicObject flow, Vertex<DynamicObject> first, Graph<DynamicObject> g) {
        DynamicObjectCollection entries = flow.getDynamicObjectCollection("resources");
        this.createSrcResource(first, entries);
        return this.createDataCopyResource(entries, g);
    }

    private Map<Long, String> createDataCopyResource(DynamicObjectCollection entries, Graph<DynamicObject> g) {
        HashMap<Long, String> resources = new HashMap<Long, String>(16);
        int count = 0;
        for (Edge e : g.getEdges().values()) {
            DynamicObject dc = (DynamicObject)e.getValue();
            String name = "res_" + ++count;
            DynamicObject item = entries.addNew();
            item.set("res_category", (Object)dc.getDataEntityType().getName());
            item.set("res_ref", (Object)dc);
            item.set("res_alias", (Object)name);
            item.set("res_source_text", (Object)this.getDataSource(dc));
            resources.put(dc.getLong("id"), name);
        }
        return resources;
    }

    private String getDataSource(DynamicObject dc) {
        long id = dc.getLong("id");
        if (dc.getDataEntityType().getName().endsWith(TRIGGER)) {
            id = DataCopyTrigger.get((long)id).getLong(DATA_COPY_ID);
        }
        DynamicObject schema = DataCopySchema.get((long)id);
        return ((DynamicObject)schema.get(DATA_SOURCE2)).get(NAME2) + " -> " + ((DynamicObject)schema.get(DATA_TARGET)).get(NAME2);
    }

    private void createSrcResource(Vertex<DynamicObject> first, DynamicObjectCollection entries) {
        DynamicObject meta = (DynamicObject)first.value();
        DynamicObject item = entries.addNew();
        item.set("res_category", (Object)meta.getDataEntityType().getName());
        item.set("res_ref", (Object)meta);
        DynamicObject dataSource = (DynamicObject)MetaDataSchema.get((long)meta.getLong("id")).get(GROUP);
        item.set("res_source_text", (Object)dataSource.getString(NAME2));
        item.set("res_alias", (Object)"_src");
    }

    private Map<Long, String> createVariables(DynamicObject flow, Vertex<DynamicObject> first, Graph<DynamicObject> g) {
        DynamicObjectCollection entries = flow.getDynamicObjectCollection("variables");
        this.createSrcVariable(first, entries);
        if (this.isMultipleMode()) {
            this.createSeqVariable(entries);
        }
        return this.createStringTempVariables(g, entries);
    }

    private void createSeqVariable(DynamicObjectCollection entries) {
        DynamicObject seq = entries.addNew();
        DynamicObject integer = BusinessDataServiceHelper.loadSingle((String)ISC_TYPE_SIMPLE_VALUE2, (String)"id,number", (QFilter[])new QFilter[]{new QFilter(NUMBER2, "=", (Object)"integer")});
        seq.set(VAR_CATEGORY, (Object)ISC_TYPE_SIMPLE_VALUE2);
        seq.set(VAR_TYPE, (Object)integer);
        seq.set(VAR_NAME, (Object)"SRC_SEQ");
        seq.set(VAR_DESC, (Object)ResManager.loadKDString((String)"\u6e90\u5355\u5e8f\u53f7", (String)"ServiceFlowGuideForDCFormPlugin_22", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        seq.set(DEFAULT_VALUE2, (Object)"0");
        seq.set(IS_ARRAY2, (Object)Boolean.FALSE);
        seq.set(IS_INPUT_PARAM, (Object)Boolean.FALSE);
        seq.set(IS_OUTPUT_PARAM, (Object)Boolean.FALSE);
    }

    private void createSrcVariable(Vertex<DynamicObject> first, DynamicObjectCollection entries) {
        DynamicObject src = entries.addNew();
        DynamicObject meta = (DynamicObject)first.value();
        src.set(VAR_CATEGORY, (Object)"isc_metadata_schema");
        src.set(VAR_TYPE, (Object)meta);
        src.set(VAR_NAME, (Object)"src");
        src.set(VAR_DESC, meta.get(NAME2));
        DynamicObject dataSource = (DynamicObject)MetaDataSchema.get((long)meta.getLong("id")).get(GROUP);
        src.set("var_source", (Object)dataSource);
        src.set(IS_ARRAY2, (Object)this.isMultipleMode());
        src.set(IS_INPUT_PARAM, (Object)Boolean.FALSE);
        src.set(IS_OUTPUT_PARAM, (Object)Boolean.FALSE);
    }

    private Map<Long, String> createStringTempVariables(Graph<DynamicObject> g, DynamicObjectCollection entries) {
        HashMap<Long, String> variables = new HashMap<Long, String>(16);
        int count = 0;
        for (Vertex v : g.getNodes2().values()) {
            DynamicObject meta = (DynamicObject)v.value();
            String name = "ID_" + ++count;
            variables.put(meta.getLong("id"), name);
            DynamicObject item = entries.addNew();
            item.set(VAR_CATEGORY, (Object)ISC_TYPE_SIMPLE_VALUE2);
            item.set(VAR_TYPE, (Object)this.getPrimaryKeyType(meta));
            item.set(VAR_NAME, (Object)name);
            Object dataSource = ((DynamicObject)MetaDataSchema.get((long)meta.getLong("id")).get(GROUP)).get(NAME2);
            String text = meta.get(NAME2) + "_ID (" + dataSource + ")";
            item.set(VAR_DESC, (Object)StringUtil.trim((String)text, (int)50));
            item.set(IS_ARRAY2, (Object)Boolean.FALSE);
            item.set(IS_INPUT_PARAM, (Object)Boolean.FALSE);
            item.set(IS_OUTPUT_PARAM, (Object)Boolean.FALSE);
        }
        return variables;
    }

    private DynamicObject getPrimaryKeyType(DynamicObject meta) {
        DataType type = MetaDataSchema.getSchema((long)meta.getLong("id")).getPrimaryKeyDataType();
        DynamicObject var_type = type == DataTypes.STRING ? SimpleValueTypeConfig.getByNumber((String)"string") : (type == DataTypes.LONG ? SimpleValueTypeConfig.getByNumber((String)"long") : (type == DataTypes.INTEGER ? SimpleValueTypeConfig.getByNumber((String)"integer") : (type == DataTypes.DECIMAL ? SimpleValueTypeConfig.getByNumber((String)"decimal") : SimpleValueTypeConfig.getByNumber((String)"string"))));
        return var_type;
    }

    private void setBasics(DynamicObject flow) {
        flow.set("id", (Object)ContextUtil.newId());
        flow.set("init_mode", this.getType());
        flow.set(NAME2, this.getName());
        flow.set(NUMBER2, this.getNumber());
        flow.set("loglevel", (Object)"warn");
        long uid = Long.parseLong(RequestContext.get().getUserId());
        flow.set("creator_id", (Object)uid);
        flow.set("modifier_id", (Object)uid);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        flow.set("createtime", (Object)now);
        flow.set("modifytime", (Object)now);
        flow.set("is_released", (Object)Boolean.FALSE);
        flow.set("status", (Object)"A");
        flow.set("enable", (Object)"0");
        Object nodeId = this.getView().getFormShowParameter().getCustomParam("classification_id");
        if (!ObjectUtils.isEmpty((Object)nodeId)) {
            flow.set("classification", nodeId);
        }
    }

    private Object getNumber() {
        String s = D.s((Object)this.getModel().getValue(NUMBER2));
        if (s != null) {
            return s;
        }
        throw new AbortException(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a\uff01", (String)"ServiceFlowGuideForDCFormPlugin_23", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }

    private Object getName() {
        String s = D.s((Object)this.getModel().getValue(NAME2));
        if (s != null) {
            return s;
        }
        throw new AbortException(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u540d\u79f0\u201d\u3002", (String)"ServiceFlowGuideForDCFormPlugin_24", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }

    private Object getType() {
        String s = D.s((Object)this.getModel().getValue(TYPE2));
        if (s != null) {
            return s;
        }
        throw new AbortException(ResManager.loadKDString((String)"\u542f\u52a8\u65b9\u5f0f\u4e0d\u53ef\u4e3a\u7a7a\uff01", (String)"ServiceFlowGuideForDCFormPlugin_25", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }

    private boolean isMultipleMode() {
        Object type = this.getType();
        return "MANUAL".equals(type) || "TIMER".equals(type);
    }

    private boolean isEventMode() {
        Object type = this.getType();
        return "EVENT".equals(type);
    }

    private boolean isManualMode() {
        Object type = this.getType();
        return "MANUAL".equals(type);
    }

    private boolean isTimerMode() {
        Object type = this.getType();
        return "TIMER".equals(type);
    }

    private int visitGraph2(Graph<DynamicObject> g2) {
        HashSet<Vertex> visited = new HashSet<Vertex>(g2.getStarts());
        LinkedList<Vertex> queue = new LinkedList<Vertex>();
        int[] left = new int[g2.getNodeCount()];
        Arrays.fill(left, -150);
        for (Vertex v : g2.getStarts()) {
            int x = left[0] = left[0] + 250;
            int y = 0;
            v.setFlag((Object)new Triple((Object)x, (Object)y, (Object)0));
            queue.add(v);
        }
        int maxLevel = 0;
        while (!queue.isEmpty()) {
            Vertex v;
            v = (Vertex)queue.pollFirst();
            Triple t = (Triple)v.getFlag();
            int level = (Integer)t.getC() + 1;
            maxLevel = Math.max(maxLevel, level);
            for (Edge e : v.getOutGoing()) {
                Triple p = (Triple)e.getFrom().getFlag();
                int minLeft = (Integer)p.getA();
                Vertex to = e.getTo();
                if (!visited.add(to)) continue;
                int n = level;
                left[n] = left[n] + 250;
                int x = left[n];
                if (x < minLeft) {
                    left[level] = x = minLeft;
                }
                int y = level * 150;
                to.setFlag((Object)new Triple((Object)x, (Object)y, (Object)level));
                queue.addLast(to);
            }
        }
        return maxLevel;
    }

    private void createGraph2(Vertex<DynamicObject> first, Graph<DynamicObject> g2) {
        HashSet<Object> visited = new HashSet<Object>(16);
        LinkedList<Vertex<DynamicObject>> queue = this.initQueue(first, visited);
        while (!queue.isEmpty()) {
            Vertex<DynamicObject> v = queue.pollFirst();
            if (!visited.add(v)) continue;
            this.enqueueNext(queue, v, visited);
            this.appendNodesAndEdges(g2, v, visited);
        }
    }

    private void appendNodesAndEdges(Graph<DynamicObject> g2, Vertex<DynamicObject> v, Set<Object> visited) {
        for (Edge prior : v.getInComing()) {
            if (!visited.contains(prior)) continue;
            DynamicObject priorRes = (DynamicObject)prior.getValue();
            String from = D.s((Object)priorRes.get("id"));
            g2.appendVertex(from, (Object)priorRes);
            for (Edge next : v.getOutGoing()) {
                DynamicObject nextRes = (DynamicObject)next.getValue();
                String to = D.s((Object)nextRes.get("id"));
                g2.appendVertex(to, (Object)nextRes);
                g2.appendEdge(from, to, v.value());
            }
        }
    }

    private void enqueueNext(LinkedList<Vertex<DynamicObject>> queue, Vertex<DynamicObject> v, Set<Object> visited) {
        for (Edge next : v.getOutGoing()) {
            queue.addLast((Vertex<DynamicObject>)next.getTo());
            visited.add(next);
        }
    }

    private LinkedList<Vertex<DynamicObject>> initQueue(Vertex<DynamicObject> first, Set<Object> visited) {
        visited.add(first);
        LinkedList<Vertex<DynamicObject>> queue = new LinkedList<Vertex<DynamicObject>>();
        this.enqueueNext(queue, first, visited);
        return queue;
    }

    private static class Info {
        private long id;
        private String firstNode;
        private String secondNode;

        private Info() {
        }
    }

    private static class AbortException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public AbortException(String message) {
            super(message);
        }
    }
}

