/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.sf.VariableType;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.platform.core.sf.runtime.ProcessRuntime;
import kd.isc.iscb.platform.core.util.SfRuntimeUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.FlowRuntime;
import kd.isc.iscb.util.flow.core.Variable;
import kd.isc.iscb.util.misc.Json;

public class SfEditVarFormPlugin
extends AbstractFormPlugin {
    private static final String VAR = "var";
    private static final String VAR_NAME = "var_name";
    private static final String VAR_DESC = "var_desc";
    private static final String TYPE = "type";
    private static final String CATEGORY = "category";
    private static final String IS_ARRAY = "is_array";
    private static final String VAR_TYPE = "var_type";
    private static final String VAR_CATEGORY = "var_category";
    private static final String LAST_UPDATE_TIME = "last_update_time";
    private static final String MODIFIED_TIME = "modified_time";
    private static final String VAR_VALUE = "var_value";
    private static final String UPDATE = "update";
    private static final String SET_VAL = "setVal";

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (UPDATE.equals(args.getOperateKey())) {
            try {
                this.update();
            }
            catch (Throwable e) {
                FormOpener.showErrorMessage(this.getView(), e);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{VAR_VALUE});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control src = (Control)evt.getSource();
        String key = src.getKey();
        if (VAR_VALUE.equals(key)) {
            try {
                HashMap<String, Object> params = new HashMap<String, Object>(2);
                params.put("largeTextValue", this.getModel().getValue(VAR_VALUE));
                FormOpener.showForm(this, "ide_largertextedit", ResManager.loadKDString((String)"\u53d8\u91cf\u503c", (String)"SfEditVarFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, SET_VAL);
            }
            catch (Throwable e) {
                FormOpener.showErrorMessage(this.getView(), e);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (SET_VAL.equals(evt.getActionId()) && evt.getReturnData() != null) {
            this.getModel().setValue(VAR_VALUE, evt.getReturnData());
        }
    }

    private void update() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        long procInstId = D.l(params.get("proc_inst_id"));
        FlowRuntime runtime = ProcessRuntime.loadRuntime((long)procInstId);
        if (!runtime.isSuspended()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5931\u8d25\u72b6\u6001\u7684\u6d41\u7a0b\u624d\u5141\u8bb8\u4fee\u6539\u53d8\u91cf", (String)"SfEditVarFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            String varName = D.s((Object)this.getModel().getValue(VAR_NAME));
            Object newVal = this.getModel().getValue(VAR_VALUE);
            Timestamp lastUpdateTime = D.t((Object)this.getModel().getValue(LAST_UPDATE_TIME));
            SfRuntimeUtil.updateVar((long)procInstId, (String)varName, (Object)newVal, (RequestContext)RequestContext.get(), (Timestamp)lastUpdateTime);
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)procInstId, (String)"isc_sf_proc_inst", (String)MODIFIED_TIME);
            this.getModel().setValue(LAST_UPDATE_TIME, obj.get(MODIFIED_TIME));
            this.getModel().setValue(VAR_VALUE, newVal);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d8\u91cf\u503c\u4fee\u6539\u6210\u529f", (String)"SfEditVarFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ComboEdit varCombo = (ComboEdit)this.getView().getControl(VAR);
        FlowRuntime runtime = SfRuntimeUtil.getFlowRuntime((IFormView)this.getView());
        List<ComboItem> items = this.constructComboItems(runtime);
        varCombo.setComboItems(items);
    }

    private List<ComboItem> constructComboItems(FlowRuntime runtime) {
        Map variables = runtime.getFlow().getVariables();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(variables.size());
        for (Map.Entry varEntry : variables.entrySet()) {
            this.addItem(items, varEntry);
        }
        return items;
    }

    private void addItem(List<ComboItem> items, Map.Entry<String, ? extends Variable> varEntry) {
        ComboItem comboItem = new ComboItem();
        comboItem.setValue(varEntry.getKey());
        Variable var = varEntry.getValue();
        comboItem.setCaption(new LocaleString(var.getTitle() + "(" + varEntry.getKey() + ")"));
        items.add(comboItem);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (name.equals(VAR)) {
            FlowRuntime runtime = SfRuntimeUtil.getFlowRuntime((IFormView)this.getView());
            String varNumber = D.s((Object)this.getModel().getValue(VAR));
            Variable variable = runtime.getFlow().getVariable(varNumber);
            this.setModelVal(runtime, variable);
        }
    }

    private void setModelVal(FlowRuntime runtime, Variable variable) {
        Map varDefine = (Map)variable.getAttribute("define");
        this.getModel().setValue(VAR_NAME, (Object)variable.getName());
        this.getModel().setValue(VAR_DESC, (Object)variable.getTitle());
        String varCategory = D.s(varDefine.get(CATEGORY));
        this.getModel().setValue(VAR_CATEGORY, (Object)varCategory.toLowerCase());
        this.getModel().setValue(VAR_TYPE, (Object)this.getVarTypeMeta(varDefine, varCategory));
        this.getModel().setValue(IS_ARRAY, varDefine.get(IS_ARRAY));
        Object varValue = runtime.get(variable.getName());
        if (varValue instanceof String) {
            this.getModel().setValue(VAR_VALUE, varValue);
        } else {
            this.getModel().setValue(VAR_VALUE, (Object)Json.toString((Object)varValue, (boolean)true));
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)runtime.getId(), (String)"isc_sf_proc_inst", (String)MODIFIED_TIME);
        this.getModel().setValue(LAST_UPDATE_TIME, obj.get(MODIFIED_TIME));
    }

    private DynamicObject getVarTypeMeta(Map<String, Object> varDefine, String varCategory) {
        DynamicObject meta = null;
        if (VariableType.isc_metadata_schema.name().equalsIgnoreCase(varCategory)) {
            meta = MetaDataSchema.get((long)D.l((Object)varDefine.get(TYPE)));
        } else if (VariableType.isc_type_simple_value.name().equalsIgnoreCase(varCategory)) {
            String type = D.s((Object)varDefine.get(TYPE));
            QFilter qFilter = new QFilter("number", "=", (Object)type.toLowerCase());
            meta = BusinessDataServiceHelper.loadSingleFromCache((String)VariableType.isc_type_simple_value.name(), (QFilter[])new QFilter[]{qFilter});
        }
        return meta;
    }
}

