/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.isc.iscb.formplugin.sf.ProcessTraceUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.util.dt.D;

public class SfIgnoreFormPlugin
extends AbstractFormPlugin {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String ACT_ID = "actid";
    private static final String ACT_TITLE = "act_title";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        List actList = (List)params.get("act_list");
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        for (Map act : actList) {
            DynamicObject obj = entries.addNew();
            obj.set(ACT_ID, act.get("id"));
            obj.set(ACT_TITLE, act.get("title"));
        }
        this.getView().updateView(ENTRY_ENTITY);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("select".equals(operateKey)) {
            int[] rowNum = ((EntryGrid)this.getView().getControl(ENTRY_ENTITY)).getSelectRows();
            if (rowNum.length >= 1) {
                this.showConfirm(ResManager.loadKDString((String)"\u82e5\u6240\u9009\u5931\u8d25\u8282\u70b9\u4e2d\u5b58\u5728\u53d8\u91cf\u8d4b\u503c\u64cd\u4f5c\uff0c\u5728\u5ffd\u7565\u524d\u8bf7\u5148\u7ed9\u53d8\u91cf\u8d4b\u4e0a\u6b63\u786e\u7684\u503c\u4f9b\u540e\u7eed\u8282\u70b9\u4f7f\u7528\uff0c\u4ee5\u514d\u4ea7\u751f\u4e0d\u826f\u5f71\u54cd\u3002", (String)"SfIgnoreFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5ffd\u7565\u7684\u8282\u70b9", (String)"SfIgnoreFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (evt.getResult() != MessageBoxResult.Yes) {
            return;
        }
        try {
            String callback = evt.getCallBackId();
            if ("ignoreActs".equals(callback)) {
                this.ignoreActs();
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private void ignoreActs() {
        int[] rowNum = ((EntryGrid)this.getView().getControl(ENTRY_ENTITY)).getSelectRows();
        ArrayList<String> actList = new ArrayList<String>(rowNum.length);
        for (int row : rowNum) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, row);
            actList.add(D.s((Object)rowEntity.get(ACT_ID)));
        }
        Map params = this.getView().getFormShowParameter().getCustomParams();
        long procInstId = D.l(params.get("proc_inst_id"));
        ProcessTraceUtil.ignore(procInstId, actList);
        this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u5ffd\u7565\u6210\u529f,\u8bf7\u7a0d\u540e\u5237\u65b0\u6d41\u7a0b\u56fe", (String)"SfIgnoreFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        this.getView().close();
    }

    private void showConfirm(String tips) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("ignoreActs", (IFormPlugin)this);
        this.getView().showConfirm(tips, MessageBoxOptions.OKCancel, confirmCallBacks);
    }
}

