/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.sf.EditorUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.Flow;
import kd.isc.iscb.util.flow.core.Variable;
import kd.isc.iscb.util.misc.StringUtil;

public class SubflowNodeEditorFormPlugin
extends AbstractFormPlugin
implements Const {
    private static final String PARAM_INPUT_NAME = "param_input_name";
    private static final String ENTRYENTITY_INPUT = "entryentity_input";
    private static final String PARAM_INPUT_TYPE = "param_input_type";
    private static final String PARAM_INPUT_TITLE = "param_input_title";
    private static final String PARAM_INPUT_VALUE = "param_input_value";
    private static final String PARAM_INPUT_FIXED = "param_input_fixed";
    private static final String PARAM_INPUT_CATEGORY = "param_input_category";
    private static final String PARAM_OUTPUT_CATEGORY = "param_output_category";
    private static final String ENTRYENTITY_OUTPUT = "entryentity_output";
    private static final String PARAM_OUTPUT_NAME = "param_output_name";
    private static final String PARAM_OUTPUT_TYPE = "param_output_type";
    private static final String PARAM_OUTPUT_TITLE = "param_output_title";
    private static final String PARAM_OUTPUT_VALUE = "param_output_value";
    private static final String INPUT = "input";
    private static final String OUTPUT = "output";
    private static final String VALUE = "value";
    private static final String VIEW = "view";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue("title", params.get("title"));
        String alias = D.s(params.get("sub_flow"));
        this.getModel().setValue("sub_flow", (Object)alias);
        Object is_independent_mode = params.get("is_independent_mode");
        if (is_independent_mode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ece\u661f\u701aV6.0\u7248\u672c\u540e\uff0c\u5b50\u6d41\u7a0b\u6a21\u5f0f\u63a8\u8350\u4f7f\u7528\u5d4c\u5165\u5f0f\u5b50\u6d41\u7a0b\u6a21\u5f0f,\u5982\u679c\u9700\u8981\u66f4\u6539\u56de\u539f\u6a21\u5f0f\uff0c\u8bf7\u6253\u5f00\u72ec\u7acb\u5b50\u6d41\u7a0b\u6a21\u5f0f\u5f00\u5173\u3002", (String)"SubflowNodeEditorFormPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        this.getModel().setValue("is_independent_mode", (Object)D.x(is_independent_mode));
        this.setCombo();
        long releasedSubFlowId = this.getReleasedSubFlowId(alias);
        this.setInputEntryEntity(releasedSubFlowId);
        this.setOutputEntryEntity(releasedSubFlowId);
        if (!this.isEditable()) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
    }

    private long getReleasedSubFlowId(String alias) {
        if (StringUtil.isEmpty((String)alias)) {
            return 0L;
        }
        long id = EditorUtil.getIdByAlias(this, alias);
        long releasedId = ServiceFlowParser.findReleasedFlowId((long)id);
        if (releasedId == 0L) {
            String number = QueryServiceHelper.queryOne((String)"isc_service_flow", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)}).getString("number");
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u53d1\u5e03\u7f16\u7801\u662f[%s]\u7684\u5b50\u6d41\u7a0b", (String)"SubflowNodeEditorFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), number));
        }
        return releasedId;
    }

    void setCombo() {
        List<ComboItem> items = EditorUtil.getComboItems(this, "isc_service_flow");
        ComboEdit combo = (ComboEdit)this.getView().getControl("sub_flow");
        combo.setComboItems(items);
    }

    private void setInputEntryEntity(long releasedSubFlowId) {
        List<? extends Variable> vars = this.getSubFlowInputVariables(releasedSubFlowId);
        this.getModel().getDataEntity(true);
        DynamicObjectCollection param_entryentity = this.getModel().getEntryEntity(ENTRYENTITY_INPUT);
        param_entryentity.clear();
        for (Variable variable : vars) {
            Map varDefine = (Map)variable.getAttribute("define");
            DynamicObject item = param_entryentity.addNew();
            String category = D.s(varDefine.get("category")).toLowerCase(Locale.ENGLISH);
            item.set(PARAM_INPUT_CATEGORY, (Object)category);
            item.set(PARAM_INPUT_NAME, (Object)variable.getName());
            item.set(PARAM_INPUT_TYPE, (Object)EditorUtil.getDynamicType(category, D.s(varDefine.get("type"))));
            item.set(PARAM_INPUT_TITLE, (Object)variable.getTitle());
            this.setInputItem(variable, item);
        }
        this.getView().updateView(ENTRYENTITY_INPUT);
    }

    private void setInputItem(Variable v, DynamicObject item) {
        Map in;
        Map inputMap = (Map)this.getView().getFormShowParameter().getCustomParam(INPUT);
        if (inputMap != null && (in = (Map)inputMap.get(v.getName())) != null) {
            item.set(PARAM_INPUT_VALUE, in.get(VALUE));
            item.set(PARAM_INPUT_FIXED, in.get("fixed"));
        }
    }

    private List<? extends Variable> getSubFlowInputVariables(long releasedSubFlowId) {
        if (releasedSubFlowId == 0L) {
            return Collections.emptyList();
        }
        Flow releasedSubFlow = ServiceFlowParser.getFlow((long)releasedSubFlowId);
        return releasedSubFlow.getInputVariables();
    }

    private void setOutputEntryEntity(long releasedSubFlowId) {
        List<? extends Variable> vars = this.getSubFlowOutputVariables(releasedSubFlowId);
        this.getModel().getDataEntity(true);
        DynamicObjectCollection param_entryentity = this.getModel().getEntryEntity(ENTRYENTITY_OUTPUT);
        param_entryentity.clear();
        for (Variable variable : vars) {
            Map varDefine = (Map)variable.getAttribute("define");
            DynamicObject item = param_entryentity.addNew();
            String category = D.s(varDefine.get("category")).toLowerCase(Locale.ENGLISH);
            item.set(PARAM_OUTPUT_CATEGORY, (Object)category);
            item.set(PARAM_OUTPUT_NAME, (Object)variable.getName());
            item.set(PARAM_OUTPUT_TYPE, (Object)EditorUtil.getDynamicType(category, D.s(varDefine.get("type"))));
            item.set(PARAM_OUTPUT_TITLE, (Object)variable.getTitle());
            this.setOutputItem(variable, item);
        }
        this.getView().updateView(ENTRYENTITY_OUTPUT);
    }

    private void setOutputItem(Variable v, DynamicObject item) {
        Map out;
        Map output = (Map)this.getView().getFormShowParameter().getCustomParam(OUTPUT);
        if (output != null && (out = (Map)output.get(v.getName())) != null) {
            item.set(PARAM_OUTPUT_VALUE, out.get(VALUE));
        }
    }

    private List<? extends Variable> getSubFlowOutputVariables(long releasedSubFlowId) {
        if (releasedSubFlowId == 0L) {
            return Collections.emptyList();
        }
        Flow releasedSubFlow = ServiceFlowParser.getFlow((long)releasedSubFlowId);
        return releasedSubFlow.getOutputVariables();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if ("sub_flow".equals(name)) {
            ChangeData[] changeSet = args.getChangeSet();
            String alias = D.s((Object)changeSet[0].getNewValue());
            long releasedSubFlowId = this.getReleasedSubFlowId(alias);
            this.setInputEntryEntity(releasedSubFlowId);
            this.setOutputEntryEntity(releasedSubFlowId);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{PARAM_INPUT_VALUE, PARAM_OUTPUT_VALUE});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        String key = ((Control)src).getKey();
        if (Arrays.asList(PARAM_INPUT_VALUE, PARAM_OUTPUT_VALUE).contains(key)) {
            EditorUtil.selectVariableProperty(this, key);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String op = args.getOperateKey();
        try {
            if ("btnok".equals(op)) {
                this.clickOK();
            } else if (VIEW.equals(op)) {
                this.openSubFlowEditor();
            }
        }
        catch (Exception e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private String getModelAlias() {
        String alias = D.s((Object)this.getModel().getValue("sub_flow"));
        if (StringUtil.isEmpty((String)alias)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5b50\u6d41\u7a0b\u3002", (String)"SubflowNodeEditorFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        return alias;
    }

    private void clickOK() {
        if (this.isEditable()) {
            EditorUtil.checkTitle(this.getModel());
            String alias = this.getModelAlias();
            long releasedSubFlowId = this.getReleasedSubFlowId(alias);
            if (releasedSubFlowId > 0L) {
                this.checkInputParams();
                this.checkReturnValues();
                this.setReturnData();
                this.getView().close();
            }
        } else {
            this.getView().close();
        }
    }

    private boolean isEditable() {
        return D.x((Object)this.getView().getFormShowParameter().getCustomParam("editable"));
    }

    private void openSubFlowEditor() {
        String alias = this.getModelAlias();
        long flowId = EditorUtil.getIdByAlias(this, alias);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("flow", flowId);
        params.put("ENTITY", "isc_service_flow");
        params.put("editable", Boolean.TRUE);
        FormOpener.showForm(this, "isc_service_flow_editor", ResManager.loadKDString((String)"\u6d41\u7a0b\u56fe", (String)"SubflowNodeEditorFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, "sub_flow");
    }

    private void setReturnData() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        params.put("title", this.getModel().getValue("title"));
        String alias = D.s((Object)this.getModel().getValue("sub_flow"));
        params.put("description", EditorUtil.getDescByAlias(this, alias));
        params.put("sub_flow", alias);
        params.put("is_independent_mode", D.x((Object)this.getModel().getValue("is_independent_mode")));
        this.setInputParamsReturnData(params);
        this.setOutputParamsReturnData(params);
        this.getView().returnDataToParent((Object)params);
    }

    private void setInputParamsReturnData(Map<String, Object> params) {
        DynamicObjectCollection param_entryentity = this.getModel().getEntryEntity(ENTRYENTITY_INPUT);
        LinkedHashMap input = new LinkedHashMap(param_entryentity.size());
        for (DynamicObject entry : param_entryentity) {
            HashMap<String, Object> line = new HashMap<String, Object>(5);
            String category = entry.getString(PARAM_INPUT_CATEGORY);
            line.put("category", category);
            if ("isc_metadata_schema".equals(category)) {
                line.put("type", entry.getDynamicObject(PARAM_INPUT_TYPE).getPkValue());
            } else {
                line.put("type", entry.getDynamicObject(PARAM_INPUT_TYPE).get("number"));
            }
            line.put("title", entry.getString(PARAM_INPUT_TITLE));
            line.put(VALUE, entry.getString(PARAM_INPUT_VALUE));
            line.put("fixed", entry.getString(PARAM_INPUT_FIXED));
            input.put(entry.getString(PARAM_INPUT_NAME), line);
        }
        params.put(INPUT, input);
    }

    private void setOutputParamsReturnData(Map<String, Object> params) {
        DynamicObjectCollection param_entryentity = this.getModel().getEntryEntity(ENTRYENTITY_OUTPUT);
        LinkedHashMap output = new LinkedHashMap(param_entryentity.size());
        for (DynamicObject entry : param_entryentity) {
            HashMap<String, Object> line = new HashMap<String, Object>(4);
            String category = entry.getString(PARAM_OUTPUT_CATEGORY);
            line.put("category", category);
            if ("isc_metadata_schema".equals(category)) {
                line.put("type", entry.getDynamicObject(PARAM_OUTPUT_TYPE).getPkValue());
            } else {
                line.put("type", entry.getDynamicObject(PARAM_OUTPUT_TYPE).get("number"));
            }
            line.put("title", entry.getString(PARAM_OUTPUT_TITLE));
            line.put(VALUE, entry.getString(PARAM_OUTPUT_VALUE));
            output.put(entry.getString(PARAM_OUTPUT_NAME), line);
        }
        params.put(OUTPUT, output);
    }

    private void checkInputParams() {
        DynamicObjectCollection paramEntries = this.getModel().getEntryEntity(ENTRYENTITY_INPUT);
        for (DynamicObject entry : paramEntries) {
            if (!StringUtil.isEmpty((String)entry.getString(PARAM_INPUT_VALUE)) || !StringUtil.isEmpty((String)entry.getString(PARAM_INPUT_FIXED))) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u53d8\u91cf %s\u7684\u8f93\u5165\u5e38\u91cf\u548c\u8f93\u5165\u53d8\u91cf\u4e0d\u80fd\u90fd\u4e3a\u7a7a\u3002", (String)"SubflowNodeEditorFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), entry.getString(PARAM_INPUT_NAME)));
        }
    }

    private void checkReturnValues() {
        DynamicObjectCollection paramEntries = this.getModel().getEntryEntity(ENTRYENTITY_OUTPUT);
        for (DynamicObject entry : paramEntries) {
            if (!StringUtil.isEmpty((String)entry.getString(PARAM_OUTPUT_VALUE))) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8f93\u51fa\u53d8\u91cf %s\u7684\u53c2\u6570\u8d4b\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SubflowNodeEditorFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), entry.getString(PARAM_OUTPUT_NAME)));
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        if ("get_property".equals(action)) {
            EditorUtil.setReturnDataAfterChosedVar(this.getModel(), evt);
        } else if ("sub_flow".equals(action) && this.isEditable()) {
            String alias = D.s((Object)this.getModel().getValue("sub_flow"));
            long releasedSubFlowId = this.getReleasedSubFlowId(alias);
            this.setInputEntryEntity(releasedSubFlowId);
            this.setOutputEntryEntity(releasedSubFlowId);
        }
    }
}

