/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.sf.ScriptTextUtil;
import kd.isc.iscb.formplugin.sf.Util;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.util.DynamicObjectUtil;
import kd.isc.iscb.util.dt.D;

public class ValueConversionEditorFormPlugin
extends AbstractFormPlugin
implements Const,
RowClickEventListener {
    private static final String RES_ALIAS = "res_alias";
    private static final String RES_CATEGORY = "res_category";
    private static final String ENTRYENTITY2 = "entryentity";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        boolean editable = D.x(params.get("editable"));
        if (editable) {
            String workFlowId = D.s(params.get("flow"));
            DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)workFlowId, (String)"isc_service_flow");
            this.initValueConversionList(flow);
            this.setEntryEntityValue(params, true);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"new"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"delete"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"viewrule"});
            this.getView().setStatus(OperationStatus.VIEW);
            this.setEntryEntityValue(params, false);
        }
        this.getModel().setValue("title", params.get("title"));
        this.getModel().setValue("save_state_on_success", (Object)D.x(params.get("save_state_on_success")));
        this.getModel().setValue("wait_for_on_failed", (Object)D.s(params.get("wait_for_on_failed")));
        this.getModel().setValue("wait_for_premise", (Object)D.s(params.get("wait_for_premise")));
    }

    private void setEntryEntityValue(Map<String, Object> params, boolean isEdit) {
        List entryentity = (List)params.get(ENTRYENTITY2);
        if (entryentity == null) {
            return;
        }
        IDataModel dataModel = this.getModel();
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("src_var", new Object[0]);
        vs.addField("tar_var", new Object[0]);
        vs.addField("value_conver_rule", new Object[0]);
        for (Map entity : entryentity) {
            Object srcVar = entity.get("src_var");
            Object tarVar = entity.get("tar_var");
            Object rule = entity.get("value_conver_rule");
            if (isEdit) {
                vs.addRow(new Object[]{srcVar, tarVar, entity.get("value_conver_rule")});
                continue;
            }
            Map resourceInfo = (Map)params.get("resourceInfo");
            Map ruleInfoMap = (Map)resourceInfo.get(rule);
            Map ruleName = ObjectUtils.isEmpty((Object)ruleInfoMap) ? ruleInfoMap : ruleInfoMap.get("res_ref_name");
            vs.addRow(new Object[]{srcVar, tarVar, rule + (ObjectUtils.isEmpty((Object)ruleName) ? "" : "(" + ruleName + ")")});
        }
        model.deleteEntryData(ENTRYENTITY2);
        model.batchCreateNewEntryRow(ENTRYENTITY2, vs);
        model.endInit();
    }

    private void initValueConversionList(DynamicObject flow) {
        DynamicObjectCollection resources = flow.getDynamicObjectCollection("resources");
        int size = resources.size();
        ArrayList<ComboItem> field = new ArrayList<ComboItem>(size);
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("value_conver_rule");
        for (DynamicObject resource : resources) {
            if (!"isc_value_conver_rule".equals(D.s((Object)resource.get(RES_CATEGORY)))) continue;
            String resAlias = D.s((Object)resource.get(RES_ALIAS));
            String name = D.s((Object)resource.get("res_ref.name.zh_CN"));
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(resAlias);
            comboItem.setCaption(new LocaleString(Util.getVarOrResName(name, resAlias)));
            field.add(comboItem);
        }
        comboEdit.setComboItems(field);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "src_var", "tar_var", "wait_for_premise", "wait_for_on_failed"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        if (operateKey.equals("btnok")) {
            this.operationIsBtnok(evt);
        } else if (operateKey.equals("viewrule")) {
            this.operationIsViewRule();
        }
    }

    private void operationIsViewRule() {
        int rowCount = this.getModel().getEntryRowCount(ENTRYENTITY2);
        if (rowCount < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u3010\u6e90\u503c/\u76ee\u6807\u503c\u6620\u5c04\u3011\u5173\u7cfb\u5217\u8868\uff01", (String)"ValueConversionEditorFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY2);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u67e5\u770b\u503c\u8f6c\u6362\u89c4\u5219\u7684\u6240\u5728\u884c\uff01", (String)"ValueConversionEditorFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject entryentity = this.getModel().getEntryRowEntity(ENTRYENTITY2, selectRows[0]);
        if (null != entryentity) {
            Object value_conver_rule = entryentity.get("value_conver_rule");
            if (value_conver_rule == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u503c\u8f6c\u6362\u89c4\u5219\uff01", (String)"ValueConversionEditorFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            FormOpener.showView(this, "isc_value_conver_rule", this.getRuleId(value_conver_rule));
        }
    }

    private Object getRuleId(Object value_conver_rule) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DynamicObject flow = BusinessDataServiceHelper.loadSingle(customParams.get("flow"), (String)"isc_service_flow");
        Object ruleId = 0;
        if (null == flow) {
            return ruleId;
        }
        DynamicObjectCollection resources = flow.getDynamicObjectCollection("resources");
        for (DynamicObject resource : resources) {
            if (!resource.getString(RES_CATEGORY).equals("isc_value_conver_rule")) continue;
            String resAlias = D.s((Object)resource.get(RES_ALIAS));
            Object refId = resource.get("res_ref.id");
            if (!value_conver_rule.equals(resAlias)) continue;
            ruleId = refId;
            break;
        }
        return ruleId;
    }

    private void operationIsBtnok(AfterDoOperationEventArgs evt) {
        OperationResult operationResult = evt.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            if (!D.x((Object)this.getView().getFormShowParameter().getCustomParam("editable"))) {
                this.getView().close();
                return;
            }
            Map params = this.getView().getFormShowParameter().getCustomParams();
            params.put("title", this.getModel().getValue("title"));
            params.put("value_conver_rule", this.getModel().getValue("value_conver_rule"));
            params.put("save_state_on_success", this.getModel().getValue("save_state_on_success"));
            params.put("wait_for_on_failed", this.getModel().getValue("wait_for_on_failed"));
            params.put("wait_for_premise", this.getModel().getValue("wait_for_premise"));
            DynamicObject flow = BusinessDataServiceHelper.loadSingle(params.get("flow"), (String)"isc_service_flow");
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY2);
            params.put(ENTRYENTITY2, DynamicObjectUtil.objectCollection2List((DynamicObjectCollection)entryEntity));
            params.put("resourceInfo", this.getResourceInfo(flow));
            params.put("variableInfo", this.getVariableInfo(flow));
            this.getView().returnDataToParent((Object)params);
            this.getView().close();
        }
    }

    private Map<String, Object> getVariableInfo(DynamicObject flow) {
        DynamicObjectCollection variables = flow.getDynamicObjectCollection("variables");
        HashMap<String, Object> variableInfoMap = new HashMap<String, Object>(variables.size());
        for (DynamicObject variable : variables) {
            HashMap<String, String> variableInfo = new HashMap<String, String>(1);
            String var_name = variable.getString("var_name");
            String res_category = variable.getString("var_category");
            variableInfo.put("var_category", res_category);
            variableInfoMap.put(var_name, variableInfo);
        }
        return variableInfoMap;
    }

    private Map<String, Object> getResourceInfo(DynamicObject flow) {
        DynamicObjectCollection resources = flow.getDynamicObjectCollection("resources");
        HashMap<String, Object> resourceInfoMap = new HashMap<String, Object>(resources.size());
        for (DynamicObject resource : resources) {
            if (!"isc_value_conver_rule".equals(D.s((Object)resource.get(RES_CATEGORY)))) continue;
            String resAlias = D.s((Object)resource.get(RES_ALIAS));
            String name = D.s((Object)resource.get("res_ref.name.zh_CN"));
            HashMap<String, String> resourceInfo = new HashMap<String, String>(1);
            resourceInfo.put("res_ref_name", name);
            resourceInfoMap.put(resAlias, resourceInfo);
        }
        return resourceInfoMap;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        boolean editable = D.x((Object)this.getView().getFormShowParameter().getCustomParam("editable"));
        if ("src_var".equals(key) || "tar_var".equals(key)) {
            HashMap<String, Object> param = new HashMap<String, Object>(3);
            param.put("flow_id", this.getView().getFormShowParameter().getCustomParams().get("flow"));
            param.put("key", key);
            FormOpener.showForm(this, "isc_sf_var_selector", ResManager.loadKDString((String)"\u9009\u62e9\u53d8\u91cf", (String)"ValueConversionEditorFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), param, "get_simple_value");
        } else if (editable && ("wait_for_premise".equals(key) || "wait_for_on_failed".equals(key))) {
            ScriptTextUtil.openRetryScriptForm(this.getModel().getValue(key), this, key, key);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        if (action.equals("get_simple_value")) {
            Object returnData = evt.getReturnData();
            if (returnData instanceof Map) {
                String key = D.s(((Map)returnData).get("key"));
                String value = D.s(((Map)returnData).get("full_number"));
                this.getModel().setValue(key, (Object)value);
            }
        } else if ("wait_for_premise".equals(action) || "wait_for_on_failed".equals(action)) {
            ScriptTextUtil.retryScriptFormCallBack(evt, this, this.getModel(), action);
        }
    }
}

