/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf;

import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ClientActions;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.formplugin.sf.EditorUtil;
import kd.isc.iscb.formplugin.sf.ScriptTextUtil;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;

public class WebApiEditorFormPlugin
extends AbstractFormPlugin
implements Const,
ClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"view", "param_var", "header_var", "body_var", "resp_body_var", "wait_for_premise", "wait_for_on_failed"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Map<String, Object> webapiConfig = (Map<String, Object>)params.get("webapi_config");
        if (webapiConfig == null) {
            webapiConfig = Collections.emptyMap();
            this.getModel().setValue("title", params.get("title"));
        } else {
            this.getModel().setValue("title", webapiConfig.get("title"));
        }
        String alias = D.s(webapiConfig.get("webapi"));
        this.getModel().setValue("webapi", (Object)alias);
        this.getModel().setValue("save_state_on_success", (Object)D.x(params.get("save_state_on_success")));
        this.getModel().setValue("wait_for_on_failed", (Object)D.s(params.get("wait_for_on_failed")));
        this.getModel().setValue("wait_for_premise", (Object)D.s(params.get("wait_for_premise")));
        if (this.getModel().getValue("title") == null) {
            this.getModel().setValue("title", (Object)ResManager.loadKDString((String)"\u51fd\u6570", (String)"WebApiEditorFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        this.setCombo();
        this.setEntries(webapiConfig, alias);
    }

    private void setEntries(Map<String, Object> params, String alias) {
        if (this.isEditable() && !StringUtil.isEmpty((String)alias)) {
            DynamicObject obj = EditorUtil.getObjByAlias(this, "isc_apic_webapi", alias);
            this.setEditableInputEntry(obj);
            this.setEditableOutputEntry(obj);
        } else if (!this.isEditable()) {
            this.setInstInputEntry(params);
            this.setInstOutputEntry(params);
            this.getView().setStatus(OperationStatus.VIEW);
        }
    }

    private void setInstInputEntry(Map<String, Object> params) {
        Map urlParams = (Map)params.get("urlParams");
        DynamicObjectCollection urlParamsEntry = this.getModel().getEntryEntity("url_params");
        urlParamsEntry.clear();
        for (Map.Entry param : urlParams.entrySet()) {
            DynamicObject item = urlParamsEntry.addNew();
            item.set("param_name", param.getKey());
            item.set("param_desc", ((Map)param.getValue()).get("param_desc"));
            item.set("param_fixed_value", ((Map)param.getValue()).get("param_fixed_value"));
            item.set("param_var", ((Map)param.getValue()).get("param_var"));
            item.set("param_need", ((Map)param.getValue()).get("param_need"));
        }
        Map reqHeader = (Map)params.get("reqHeader");
        DynamicObjectCollection reqHeaderEntry = this.getModel().getEntryEntity("req_header");
        reqHeaderEntry.clear();
        for (Map.Entry entry : reqHeader.entrySet()) {
            DynamicObject item = reqHeaderEntry.addNew();
            item.set("header_name", entry.getKey());
            item.set("header_desc", ((Map)entry.getValue()).get("header_desc"));
            item.set("header_fixed_value", ((Map)entry.getValue()).get("header_fixed_value"));
            item.set("header_var", ((Map)entry.getValue()).get("header_var"));
            item.set("header_need", ((Map)entry.getValue()).get("header_need"));
        }
        Map reqBody = (Map)params.get("reqBody");
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("req_body");
        dynamicObjectCollection.clear();
        for (Map.Entry param : reqBody.entrySet()) {
            DynamicObject item = dynamicObjectCollection.addNew();
            item.set("body_name", param.getKey());
            item.set("body_data_type", ((Map)param.getValue()).get("body_data_type"));
            item.set("body_desc", ((Map)param.getValue()).get("body_desc"));
            item.set("body_fixed_value", ((Map)param.getValue()).get("body_fixed_value"));
            item.set("body_var", ((Map)param.getValue()).get("body_var"));
            item.set("body_is_array", ((Map)param.getValue()).get("body_is_array"));
            item.set("body_required", ((Map)param.getValue()).get("body_required"));
        }
    }

    private void setInstOutputEntry(Map<String, Object> params) {
        Map respBody = (Map)params.get("respBody");
        DynamicObjectCollection respBodyEntry = this.getModel().getEntryEntity("resp_body");
        respBodyEntry.clear();
        for (Map.Entry param : respBody.entrySet()) {
            DynamicObject item = respBodyEntry.addNew();
            item.set("resp_body_name", param.getKey());
            item.set("resp_body_data_type", ((Map)param.getValue()).get("resp_body_data_type"));
            item.set("resp_body_desc", ((Map)param.getValue()).get("resp_body_desc"));
            item.set("resp_body_var", ((Map)param.getValue()).get("resp_body_var"));
        }
    }

    private void setCombo() {
        List<ComboItem> items = EditorUtil.getComboItems(this, "isc_apic_webapi");
        ComboEdit combo = (ComboEdit)this.getView().getControl("webapi");
        combo.setComboItems(items);
    }

    private boolean isEditable() {
        return D.x((Object)this.getView().getFormShowParameter().getCustomParam("editable"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        String newValue = D.s((Object)e.getChangeSet()[0].getNewValue());
        if ("webapi".equals(name)) {
            if (newValue != null) {
                DynamicObject obj = EditorUtil.getObjByAlias(this, "isc_apic_webapi", newValue);
                this.setEditableInputEntry(obj);
                this.setEditableOutputEntry(obj);
            } else {
                DynamicObjectCollection urlParams = this.getModel().getDataEntity(true).getDynamicObjectCollection("url_params");
                DynamicObjectCollection reqHeader = this.getModel().getDataEntity(true).getDynamicObjectCollection("req_header");
                DynamicObjectCollection reqBody = this.getModel().getDataEntity(true).getDynamicObjectCollection("req_body");
                DynamicObjectCollection respBody = this.getModel().getDataEntity(true).getDynamicObjectCollection("resp_body");
                urlParams.clear();
                reqHeader.clear();
                reqBody.clear();
                respBody.clear();
                this.getView().updateView();
            }
        }
    }

    private void setEditableInputEntry(DynamicObject obj) {
        DynamicObjectCollection urlParams = this.getModel().getDataEntity(true).getDynamicObjectCollection("url_params");
        DynamicObjectCollection reqHeader = this.getModel().getDataEntity(true).getDynamicObjectCollection("req_header");
        DynamicObjectCollection reqBody = this.getModel().getDataEntity(true).getDynamicObjectCollection("req_body");
        urlParams.clear();
        reqHeader.clear();
        reqBody.clear();
        DynamicObjectCollection webUrlParams = obj.getDynamicObjectCollection("web_url_params");
        DynamicObjectCollection webReqHeader = obj.getDynamicObjectCollection("web_req_header");
        DynamicObjectCollection webReqBody = obj.getDynamicObjectCollection("web_req_body");
        this.setUrlParams(urlParams, webUrlParams);
        this.setReqHeader(reqHeader, webReqHeader);
        this.setReqBody(reqBody, webReqBody);
        this.getView().updateView("url_params");
        this.getView().updateView("req_header");
        this.getView().updateView("req_body");
    }

    private void setUrlParams(DynamicObjectCollection urlParams, DynamicObjectCollection webUrlParams) {
        Map webapiConfig = (Map)this.getView().getFormShowParameter().getCustomParam("webapi_config");
        Map editedData = null;
        if (webapiConfig != null) {
            editedData = (Map)webapiConfig.get("urlParams");
        }
        int i = 0;
        for (DynamicObject src : webUrlParams) {
            Map paramMap;
            DynamicObject tar = urlParams.addNew();
            String name = D.s((Object)src.get("url_param_name"));
            tar.set("param_name", (Object)name);
            tar.set("param_desc", src.get("url_param_desc"));
            String srcUrlParamValue = D.s((Object)src.get("url_param_value"));
            tar.set("param_need", (Object)(srcUrlParamValue == null ? 1 : 0));
            if (srcUrlParamValue != null) {
                if (srcUrlParamValue.startsWith("$")) {
                    tar.set("param_var", (Object)srcUrlParamValue);
                } else {
                    tar.set("param_fixed_value", (Object)srcUrlParamValue);
                }
                this.setEntryRowDisabled("url_params", i, new String[]{"param_var", "param_fixed_value"});
            } else if (editedData != null && (paramMap = (Map)editedData.get(name)) != null) {
                tar.set("param_var", paramMap.get("param_var"));
                tar.set("param_fixed_value", paramMap.get("param_fixed_value"));
            }
            ++i;
        }
    }

    private void setEntryRowDisabled(String entryName, int i, String[] fields) {
        for (String f : fields) {
            this.getView().setEnable(Boolean.FALSE, i, new String[]{f});
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        ClientActions.createRowStyleBuilder().setRows(new int[]{i}).setBackColor("#F5F5F5").buildStyle().build().invokeControlMethod(proxy, entryName);
    }

    private void setReqHeader(DynamicObjectCollection reqHeader, DynamicObjectCollection webReqHeader) {
        Map webapiConfig = (Map)this.getView().getFormShowParameter().getCustomParam("webapi_config");
        Map editedData = null;
        if (webapiConfig != null) {
            editedData = (Map)webapiConfig.get("reqHeader");
        }
        int i = 0;
        for (DynamicObject src : webReqHeader) {
            Map paramMap;
            DynamicObject tar = reqHeader.addNew();
            String name = D.s((Object)src.get("req_h_param_name"));
            tar.set("header_name", (Object)name);
            tar.set("header_desc", src.get("req_h_param_desc"));
            String srcHeadParamValue = D.s((Object)src.get("req_h_param_value"));
            tar.set("header_need", (Object)(srcHeadParamValue == null ? 1 : 0));
            if (srcHeadParamValue != null) {
                if (srcHeadParamValue.startsWith("$")) {
                    tar.set("header_var", (Object)srcHeadParamValue);
                } else {
                    tar.set("header_fixed_value", (Object)srcHeadParamValue);
                }
                this.setEntryRowDisabled("req_header", i, new String[]{"header_var", "header_fixed_value"});
            } else if (editedData != null && (paramMap = (Map)editedData.get(name)) != null) {
                tar.set("header_var", paramMap.get("header_var"));
                tar.set("header_fixed_value", paramMap.get("header_fixed_value"));
            }
            ++i;
        }
    }

    private void setReqBody(DynamicObjectCollection reqBody, DynamicObjectCollection webReqBody) {
        Map webapiConfig = (Map)this.getView().getFormShowParameter().getCustomParam("webapi_config");
        Map editedData = null;
        if (webapiConfig != null) {
            editedData = (Map)webapiConfig.get("reqBody");
        }
        int i = 0;
        for (DynamicObject src : webReqBody) {
            Map paramMap;
            if (D.l((Object)src.get("pid")) != 0L) continue;
            DynamicObject tar = reqBody.addNew();
            String name = D.s((Object)src.get("req_b_param_name"));
            tar.set("body_name", (Object)name);
            tar.set("body_desc", src.get("req_b_param_desc"));
            tar.set("body_data_type", src.get("req_b_param_type"));
            tar.set("body_is_array", src.get("req_b_param_is_array"));
            tar.set("body_required", src.get("req_b_param_required"));
            String srcValue = D.s((Object)src.get("req_b_param_value"));
            if (srcValue != null) {
                if (srcValue.startsWith("$")) {
                    tar.set("body_var", (Object)srcValue);
                } else {
                    tar.set("body_fixed_value", (Object)srcValue);
                }
                this.setEntryRowDisabled("req_body", i, new String[]{"body_var", "body_fixed_value"});
            } else if (editedData != null && (paramMap = (Map)editedData.get(name)) != null) {
                tar.set("body_var", paramMap.get("body_var"));
                tar.set("body_fixed_value", paramMap.get("body_fixed_value"));
            }
            ++i;
        }
    }

    private void setEditableOutputEntry(DynamicObject obj) {
        Map webapiConfig = (Map)this.getView().getFormShowParameter().getCustomParam("webapi_config");
        Map editedData = null;
        if (webapiConfig != null) {
            editedData = (Map)webapiConfig.get("respBody");
        }
        DynamicObjectCollection respBody = this.getModel().getDataEntity(true).getDynamicObjectCollection("resp_body");
        respBody.clear();
        if (D.x((Object)obj.get("need_format_result"))) {
            DynamicObjectCollection webRespBody = obj.getDynamicObjectCollection("web_resp_body");
            for (DynamicObject src : webRespBody) {
                Map paramMap;
                if (D.l((Object)src.get("pid")) != 0L) continue;
                DynamicObject tar = respBody.addNew();
                String name = D.s((Object)src.get("resp_b_param_name"));
                tar.set("resp_body_name", (Object)name);
                tar.set("resp_body_data_type", src.get("resp_b_param_type"));
                tar.set("resp_body_desc", src.get("resp_b_param_desc"));
                if (editedData == null || (paramMap = (Map)editedData.get(name)) == null) continue;
                tar.set("resp_body_var", paramMap.get("resp_body_var"));
            }
        } else {
            Map paramMap;
            DynamicObject tar = respBody.addNew();
            tar.set("resp_body_name", (Object)"$result");
            tar.set("resp_body_data_type", (Object)"string");
            tar.set("resp_body_desc", (Object)ResManager.loadKDString((String)"api\u63a5\u53e3\u8fd4\u56de\u7684\u539f\u59cb\u7ed3\u679c", (String)"WebApiEditorFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            if (editedData != null && (paramMap = (Map)editedData.get("$result")) != null) {
                tar.set("resp_body_var", paramMap.get("resp_body_var"));
            }
        }
        this.getView().updateView("resp_body");
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        String key = ((Control)src).getKey();
        try {
            if ("view".equals(key)) {
                this.openWebapiForm();
            } else if (Arrays.asList("param_var", "header_var", "body_var", "resp_body_var").contains(key)) {
                EditorUtil.selectVariableProperty(this, key);
            } else if ("wait_for_premise".equals(key) || "wait_for_on_failed".equals(key)) {
                ScriptTextUtil.openRetryScriptForm(this.getModel().getValue(key), this, key, key);
            }
        }
        catch (Exception e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private void openWebapiForm() {
        String alias = D.s((Object)this.getModel().getValue("webapi"));
        if (StringUtil.isEmpty((String)alias)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2awebapi", (String)"WebApiEditorFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        long id = EditorUtil.getIdByAlias(this, alias);
        EditorUtil.showView(this, "isc_apic_webapi", id, null);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        if ("get_property".equals(action)) {
            EditorUtil.setReturnDataAfterChosedVar(this.getModel(), evt);
        } else if ("wait_for_premise".equals(action) || "wait_for_on_failed".equals(action)) {
            ScriptTextUtil.retryScriptFormCallBack(evt, this, this.getModel(), action);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        try {
            if (!this.isEditable()) {
                this.getView().close();
                return;
            }
            if ("returndata".equals(evt.getOperateKey()) && evt.getOperationResult() != null && evt.getOperationResult().isSuccess()) {
                this.setReturnData();
                this.getView().close();
            }
        }
        catch (Exception e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private void setReturnData() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("title", this.getModel().getValue("title"));
        String alias = D.s((Object)this.getModel().getValue("webapi"));
        params.put("webapi", alias);
        params.put("description", EditorUtil.getDescByAlias(this, alias));
        params.put("webapiId", EditorUtil.getIdByAlias(this, alias));
        this.collectInputParamsReturnData(params);
        this.collectOutputParamsReturnData(params);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("webapi_config", params);
        customParams.put("title", this.getModel().getValue("title"));
        customParams.put("save_state_on_success", this.getModel().getValue("save_state_on_success"));
        customParams.put("wait_for_on_failed", this.getModel().getValue("wait_for_on_failed"));
        customParams.put("wait_for_premise", this.getModel().getValue("wait_for_premise"));
        this.getView().returnDataToParent((Object)customParams);
    }

    private void collectInputParamsReturnData(Map<String, Object> params) {
        DynamicObjectCollection urlParams = this.getModel().getDataEntity(true).getDynamicObjectCollection("url_params");
        DynamicObjectCollection reqHeader = this.getModel().getDataEntity(true).getDynamicObjectCollection("req_header");
        DynamicObjectCollection reqBody = this.getModel().getDataEntity(true).getDynamicObjectCollection("req_body");
        LinkedHashMap urlParamsMap = new LinkedHashMap(urlParams.size());
        for (Object i : urlParams) {
            HashMap<String, Object> line = new HashMap<String, Object>(4);
            line.put("param_desc", i.get("param_desc"));
            line.put("param_fixed_value", i.get("param_fixed_value"));
            line.put("param_var", i.get("param_var"));
            line.put("param_need", i.get("param_need"));
            urlParamsMap.put(i.getString("param_name"), line);
        }
        LinkedHashMap reqHeaderMap = new LinkedHashMap(reqHeader.size());
        for (DynamicObject i : reqHeader) {
            HashMap<String, Object> line = new HashMap<String, Object>(4);
            line.put("header_desc", i.get("header_desc"));
            line.put("header_fixed_value", i.get("header_fixed_value"));
            line.put("header_var", i.get("header_var"));
            line.put("header_need", i.get("header_need"));
            reqHeaderMap.put(i.getString("header_name"), line);
        }
        LinkedHashMap reqBodyMap = new LinkedHashMap(reqBody.size());
        for (DynamicObject i : reqBody) {
            HashMap<String, Object> line = new HashMap<String, Object>(7);
            line.put("body_data_type", i.get("body_data_type"));
            line.put("body_desc", i.get("body_desc"));
            line.put("body_fixed_value", i.get("body_fixed_value"));
            line.put("body_var", i.get("body_var"));
            line.put("body_is_array", i.get("body_is_array"));
            line.put("body_required", i.get("body_required"));
            reqBodyMap.put(i.getString("body_name"), line);
        }
        params.put("urlParams", urlParamsMap);
        params.put("reqHeader", reqHeaderMap);
        params.put("reqBody", reqBodyMap);
    }

    private void collectOutputParamsReturnData(Map<String, Object> params) {
        DynamicObjectCollection respBody = this.getModel().getDataEntity(true).getDynamicObjectCollection("resp_body");
        LinkedHashMap respBodyMap = new LinkedHashMap(respBody.size());
        for (DynamicObject i : respBody) {
            HashMap<String, Object> line = new HashMap<String, Object>(3);
            line.put("resp_body_data_type", i.get("resp_body_data_type"));
            line.put("resp_body_desc", i.get("resp_body_desc"));
            line.put("resp_body_var", i.get("resp_body_var"));
            respBodyMap.put(i.getString("resp_body_name"), line);
        }
        params.put("respBody", respBodyMap);
    }
}

