/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf.image;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.ImageIcon;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.sf.FlowStarter;
import kd.isc.iscb.platform.core.sf.runtime.ProcessState;
import kd.isc.iscb.platform.core.util.ApiToXmlUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;

public class ServiceFlowImage {
    private static final int ARROW_SIZE = 8;
    private static final int ARROW_SHORT_SIZE = 4;
    private static final int FONT_SIZE = 12;
    private static final int ICON_SIZE = 24;
    private static final int OFFSET_TITLE = 30;
    private static final int ICON_OFFSET = 5;
    private static final int UP = 8;
    private static final int DOWN = 2;
    private static final int LEFT = 4;
    private static final int RIGHT = 6;
    private static final int OVAL_SIZE = 6;
    private static final int DETAIL_OFFSETX = 45;
    private static final int SPACE = 100;
    private static final int LINE_TITLE_OFFSET = 15;
    private static final Color NORMALTRANSITION_COLOR = new Color(168, 168, 168);
    private static final Color ERRORTRANSITION_COLOR = new Color(251, 35, 35);
    private static final Color COMPENSATION_COLOR = new Color(231, 156, 81);
    private static final float DESIGNING_SIZE = 2.0f;
    private static final Color KINGDEE_BULE = new Color(85, 130, 243);
    private static final Color ERROR_PASSED_COLOR = new Color(255, 0, 0);
    private static final Color COMPENSATION_PASSED_COLOR = new Color(231, 156, 81);
    private static final float PASSED_SIZE = 2.0f;
    private static final Color UNEXECUTED_COLOR = Color.lightGray;
    private static final float UNEXECUTED_SIZE = 2.0f;
    private static final int STATE_ICON_SIZE = 37;
    private static final int ROUND_RECT_SIZE = 10;
    private static final int WATER_SIZE = 12;
    private static final int WATER_SPACE = 120;
    private static final Color WATER_COLOR = new Color(221, 221, 221);
    private BufferedImage img;
    private Graphics2D g;
    private int minX = Integer.MAX_VALUE;
    private int minY = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int maxY = Integer.MIN_VALUE;
    private int offsetY = 30;
    private int offsetX = 50;

    public Pair<String, BufferedImage> getImage(Map<String, Object> params, DynamicObject flow) {
        Map<String, Object> define = this.initDefine(params, flow);
        this.drawPanel(define);
        this.setFont();
        this.drawLinks(params, define);
        this.drawNodes(params, define);
        this.drawDetails(params, flow);
        this.g.dispose();
        String fileName = this.getFileName(params, flow);
        return new Pair((Object)fileName, (Object)this.img);
    }

    public Pair<String, BufferedImage> getFullImage(Map<String, Object> params, DynamicObject flow) {
        Map<String, Object> define = this.initDefine(params, flow);
        this.sortNodes(define, "y");
        this.resetDefineByY(define);
        this.sortNodes(define, "x");
        Map<String, Object> subDefines = this.resetDefineByX(define);
        this.drawPanel(define);
        this.setFont();
        this.drawLinks(params, define);
        this.drawNodes(params, define);
        for (Map.Entry<String, Object> entry : subDefines.entrySet()) {
            Map subDefine = (Map)entry.getValue();
            this.drawLinks(params, subDefine);
            this.drawNodes(params, subDefine);
        }
        this.drawDetails(params, flow);
        this.g.dispose();
        String fileName = this.getFileName(params, flow);
        return new Pair((Object)fileName, (Object)this.img);
    }

    private void sortNodes(Map<String, Object> define, String s) {
        LinkedList<Map> listNodes = new LinkedList<Map>();
        Map nodes = (Map)define.get("nodes");
        for (Map.Entry node : nodes.entrySet()) {
            Map map = (Map)node.getValue();
            listNodes.add(map);
        }
        listNodes.sort((o1, o2) -> {
            Map coordinate1 = (Map)o1.get("coordinate");
            int y1 = (Integer)coordinate1.get(s);
            Map coordinate2 = (Map)o2.get("coordinate");
            int y2 = (Integer)coordinate2.get(s);
            return y1 - y2;
        });
        LinkedHashMap<String, Map> newNodes = new LinkedHashMap<String, Map>(listNodes.size());
        for (Map node : listNodes) {
            newNodes.put(D.s(node.get("id")), node);
        }
        define.put("nodes", newNodes);
    }

    private void resetDefineByY(Map<String, Object> define) {
        Map nodes = (Map)define.get("nodes");
        int subOffsetY = 0;
        for (Map.Entry node : nodes.entrySet()) {
            Map map = (Map)node.getValue();
            if ("Block".equals(map.get("type"))) {
                Map subDefine = (Map)map.get("subNode");
                if (subDefine == null) {
                    subDefine = (Map)Json.toObject((String)ServiceFlowImage.getDefaultDiagram());
                }
                Map subNodes = (Map)subDefine.get("nodes");
                int subMaxY = Integer.MIN_VALUE;
                int subMinY = Integer.MAX_VALUE;
                for (Map.Entry subNode : subNodes.entrySet()) {
                    Map subMap = (Map)subNode.getValue();
                    Map subCoordinate = (Map)subMap.get("coordinate");
                    int y1 = D.i(subCoordinate.get("y"));
                    int height = D.i(subCoordinate.get("height"));
                    int y2 = y1 + height;
                    subMaxY = Math.max(y2, subMaxY);
                    subMinY = Math.min(y1, subMinY);
                }
                Map coordinate = (Map)map.get("coordinate");
                this.resetCoordinateY(coordinate, subOffsetY);
                subOffsetY -= D.i(coordinate.get("height"));
                coordinate.put("height", subMaxY - subMinY + 150);
                subOffsetY += D.i(coordinate.get("height"));
                continue;
            }
            Map coordinate = (Map)map.get("coordinate");
            this.resetCoordinateY(coordinate, subOffsetY);
        }
    }

    private Map<String, Object> resetDefineByX(Map<String, Object> define) {
        HashMap<String, Object> subDefines = new HashMap<String, Object>();
        Map nodes = (Map)define.get("nodes");
        int subOffsetX = 0;
        for (Map.Entry node : nodes.entrySet()) {
            Map map = (Map)node.getValue();
            if ("Block".equals(map.get("type"))) {
                Map subDefine = (Map)map.get("subNode");
                if (subDefine == null) {
                    subDefine = (Map)Json.toObject((String)ServiceFlowImage.getDefaultDiagram());
                }
                Map subNodes = (Map)subDefine.get("nodes");
                int subMaxX = Integer.MIN_VALUE;
                int subMinX = Integer.MAX_VALUE;
                int subMaxY = Integer.MIN_VALUE;
                int subMinY = Integer.MAX_VALUE;
                for (Map.Entry subNode : subNodes.entrySet()) {
                    Map subMap = (Map)subNode.getValue();
                    Map subCoordinate = (Map)subMap.get("coordinate");
                    int x1 = D.i(subCoordinate.get("x"));
                    int width = D.i(subCoordinate.get("width"));
                    int x2 = x1 + width;
                    int y1 = D.i(subCoordinate.get("y"));
                    int height = D.i(subCoordinate.get("height"));
                    int y2 = y1 + height;
                    subMaxY = Math.max(y2, subMaxY);
                    subMinY = Math.min(y1, subMinY);
                    subMaxX = Math.max(x2, subMaxX);
                    subMinX = Math.min(x1, subMinX);
                }
                Map coordinate = (Map)map.get("coordinate");
                this.resetCoordinateX(coordinate, subOffsetX);
                subOffsetX -= D.i(coordinate.get("width"));
                coordinate.put("width", subMaxX - subMinX + 150);
                subOffsetX += D.i(coordinate.get("width"));
                this.resetSubDefine(subDefines, D.s(map.get("id")), subDefine, D.i(coordinate.get("x")) - subMinX + 45, D.i(coordinate.get("y")) - subMinY + 45);
                continue;
            }
            Map coordinate = (Map)map.get("coordinate");
            this.resetCoordinateX(coordinate, subOffsetX);
        }
        return subDefines;
    }

    private void resetCoordinateY(Map<String, Object> coordinate, int subOffsetY) {
        int y = D.i((Object)coordinate.get("y"));
        coordinate.put("y", y + subOffsetY);
    }

    private void resetCoordinateX(Map<String, Object> coordinate, int subOffsetX) {
        int x = D.i((Object)coordinate.get("x"));
        coordinate.put("x", x + subOffsetX);
    }

    private void resetSubDefine(Map<String, Object> subDefines, String id, Map<String, Object> subDefine, int x, int y) {
        Map subNodes = (Map)subDefine.get("nodes");
        for (Map.Entry subNode : subNodes.entrySet()) {
            Map subMap = (Map)subNode.getValue();
            Map subCoordinate = (Map)subMap.get("coordinate");
            int x1 = D.i(subCoordinate.get("x"));
            int y1 = D.i(subCoordinate.get("y"));
            subCoordinate.put("x", x1 + x);
            subCoordinate.put("y", y1 + y);
        }
        subDefines.put(id, subDefine);
    }

    private void drawDetails(Map<String, Object> params, DynamicObject flow) {
        Font font = ApiToXmlUtil.getFont((int)12);
        this.g.setFont(font);
        this.g.setColor(Color.lightGray);
        int x = this.minX - 45;
        if (params.isEmpty()) {
            this.drawString(ResManager.loadKDString((String)"\u8bbe\u8ba1\u671f", (String)"ServiceFlowImage_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), x, this.maxY + 30);
            if (flow.getString("number") != null) {
                this.drawString(flow.getString("number"), x, this.maxY + 45);
            }
            if (flow.getString("name") != null) {
                this.drawString(flow.getString("name"), x, this.maxY + 60);
            }
        } else {
            if (params.get("version") != null) {
                this.drawString(String.format(ResManager.loadKDString((String)"\u7248\u672c\u53f7\uff1a%s", (String)"ServiceFlowImage_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params.get("version")), x, this.maxY + 30);
            }
            if (params.get("number") != null) {
                this.drawString(D.s((Object)params.get("number")), x, this.maxY + 45);
            }
            if (params.get("name") != null) {
                this.drawString(D.s((Object)params.get("name")), x, this.maxY + 60);
            }
        }
    }

    private Map<String, Object> initDefine(Map<String, Object> params, DynamicObject flow) {
        if (params.isEmpty()) {
            String defineStr = D.s((Object)flow.getString("define_json_tag"));
            if (defineStr == null) {
                defineStr = FlowStarter.Type.valueOf((String)flow.getString("init_mode")).defaultDiagram();
            }
            return (Map)Json.toObject((String)defineStr);
        }
        return (Map)params.get("diagram");
    }

    private void drawPanel(Map<String, Object> define) {
        this.initDiagram(define);
        int width = this.maxX - this.minX + 100;
        int height = this.maxY - this.minY + 100;
        this.offsetY = 30 - this.minY;
        this.offsetX = 50 - this.minX;
        this.img = new BufferedImage(width, height, 1);
        this.g = this.img.createGraphics();
        this.g.fillRect(0, 0, width, height);
        this.drawWaterMark(width, height);
    }

    private void drawWaterMark(int width, int height) {
        this.drawWaterText(width, height);
    }

    public void drawWaterText(int width, int height) {
        this.g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        this.g.rotate(Math.toRadians(-30.0), (double)width / 2.0, (double)height / 2.0);
        this.g.setColor(WATER_COLOR);
        Font font = ApiToXmlUtil.getFont((int)12);
        this.g.setFont(font);
        this.g.setComposite(AlphaComposite.getInstance(10, 0.5f));
        int markWidth = 12 * ServiceFlowImage.getWaterText().length();
        for (int x = -width / 2; x < width * 2; x += markWidth + 120) {
            for (int y = -height / 2; y < width * 2; y += 72) {
                this.g.drawString(ServiceFlowImage.getWaterText(), x, y);
            }
        }
        this.g.rotate(Math.toRadians(30.0), (double)width / 2.0, (double)height / 2.0);
        this.g.setComposite(AlphaComposite.getInstance(10, 1.0f));
    }

    private void initDiagram(Map<String, Object> define) {
        Map nodes = (Map)define.get("nodes");
        for (Map.Entry node : nodes.entrySet()) {
            Map map = (Map)node.getValue();
            Map coordinate = (Map)map.get("coordinate");
            int x1 = D.i(coordinate.get("x"));
            int y1 = D.i(coordinate.get("y"));
            int height = D.i(coordinate.get("height"));
            int width = D.i(coordinate.get("width"));
            int x2 = x1 + width;
            int y2 = y1 + height;
            this.maxX = Math.max(x2, this.maxX);
            this.minX = Math.min(x1, this.minX);
            this.maxY = Math.max(y2, this.maxY);
            this.minY = Math.min(y1, this.minY);
        }
    }

    private void setFont() {
        Font font = ApiToXmlUtil.getFont((int)12);
        this.g.setFont(font);
    }

    private void drawNodes(Map<String, Object> params, Map<String, Object> define) {
        Map nodes = (Map)define.get("nodes");
        for (Map.Entry node : nodes.entrySet()) {
            this.drawEveryNode(node.getKey(), (Map)node.getValue(), params);
        }
    }

    private void drawEveryNode(Object key, Map<String, Object> node, Map<String, Object> params) {
        String state;
        Map coordinate = (Map)node.get("coordinate");
        int x = (Integer)coordinate.get("x");
        int y = (Integer)coordinate.get("y");
        int height = (Integer)coordinate.get("height");
        int width = (Integer)coordinate.get("width");
        int titleX = x + 30;
        this.g.setColor(Color.white);
        this.g.setStroke(new BasicStroke(1.0f));
        this.drawRoundRect(x, y, width, height, 10, 10);
        this.g.fillRoundRect(x + this.offsetX, y + this.offsetY, width, height, 10, 10);
        this.setNodeColor(key, params);
        this.g.setStroke(new BasicStroke(1.0f));
        this.drawRoundRect(x, y, width, height, 10, 10);
        this.drawNodeString(node, height, width, titleX, y);
        ImageIcon icon = this.getIcon(D.s((Object)node.get("type")));
        this.drawImage(icon, x + 5, y + (height - 24) / 2);
        if (this.isProc_inst_id(params) && !"unexecuted".equals(state = this.getNodeState(key, params))) {
            ImageIcon stateIcon = this.getIcon(state);
            this.drawImage(stateIcon, x + width - 37, y);
        }
    }

    private boolean isProc_inst_id(Map<String, Object> params) {
        return params.get("proc_inst_id") != null;
    }

    private void setNodeColor(Object key, Map<String, Object> params) {
        if (!this.isProc_inst_id(params)) {
            this.g.setColor(KINGDEE_BULE);
        } else {
            String state = this.getNodeState(key, params);
            if (ProcessState.Failed.toString().equals(state)) {
                this.g.setColor(Color.RED);
            } else if ("unexecuted".equals(state)) {
                this.g.setColor(Color.black);
            } else if ("started".equals(state) || "running".equals(state) || "ready".equals(state)) {
                this.g.setColor(Color.BLUE);
            } else if ("arrived".equals(state)) {
                this.g.setColor(new Color(61, 198, 91));
            } else if ("complete".equals(state)) {
                this.g.setColor(new Color(36, 123, 36));
            } else if ("suspended ".equals(state)) {
                this.g.setColor(Color.ORANGE);
            } else {
                this.g.setColor(Color.lightGray);
            }
        }
    }

    private void drawRoundRect(int x, int y, int width, int height, int r, int t) {
        this.g.drawRoundRect(x + this.offsetX, y + this.offsetY, width, height, r, t);
    }

    private void drawNodeString(Map<String, Object> node, int height, int width, int titleX, int titleY) {
        String title = D.s((Object)node.get("title"));
        int index = (width - 30) / 12;
        int k = title.length() / index + 1;
        titleY += (height - k * 12) / 2;
        for (int i = 0; i < k; ++i) {
            this.drawString(title.substring(index * i, Math.min(index * (i + 1), title.length())), titleX, titleY += 12);
        }
    }

    private ImageIcon getIcon(String type) {
        URL url = ServiceFlowImage.class.getClassLoader().getResource("png/" + type + ".png");
        if (url == null) {
            url = ServiceFlowImage.class.getClassLoader().getResource("png/backup.png");
        }
        return new ImageIcon(url);
    }

    private void drawImage(ImageIcon icon, int x, int y) {
        this.g.drawImage(icon.getImage(), x + this.offsetX, y + this.offsetY, null);
    }

    private String getNodeState(Object key, Map<String, Object> params) {
        Map acts = (Map)params.get("acts");
        if (acts == null) {
            return "unexecuted";
        }
        Map nodeAct = (Map)acts.get(key);
        if (nodeAct == null) {
            return "unexecuted";
        }
        return D.s(nodeAct.get("state"));
    }

    private String getLineState(Object key, Map<String, Object> params) {
        Map trans = (Map)params.get("trans");
        if (trans == null) {
            return "false";
        }
        return D.s(trans.get(key));
    }

    private void drawString(String title, int x, int y) {
        this.g.drawString(title, x + this.offsetX, y + this.offsetY);
    }

    private void drawLinks(Map<String, Object> params, Map<String, Object> define) {
        Map nodes = (Map)define.get("nodes");
        Map links = (Map)define.get("links");
        if (!this.isProc_inst_id(params)) {
            this.g.setStroke(new BasicStroke(2.0f));
            for (Map.Entry linkline : links.entrySet()) {
                Map line = (Map)linkline.getValue();
                String type = D.s(line.get("type"));
                Color color = this.setDesigningLineColor(type);
                Map nodeStart = (Map)nodes.get(line.get("source"));
                Map nodeEnd = (Map)nodes.get(line.get("target"));
                String[] pos = D.s(line.get("path")).split("\\|");
                Map<String, Object> p1 = this.port((Map)nodeStart.get("coordinate"), pos[0]);
                Map<String, Object> p2 = this.port((Map)nodeEnd.get("coordinate"), pos[1]);
                int p2sgn = D.i((Object)p2.get("sgn"));
                ArrayList<int[]> lines = this.getLines(p1, p2, p2sgn);
                this.setArrowDirection(p2, p2sgn, lines);
                this.drawLines(lines, type, color);
                this.drawLineString(line, lines);
            }
        } else {
            for (Map.Entry linkline : links.entrySet()) {
                Map line = (Map)linkline.getValue();
                Map nodeStart = (Map)nodes.get(line.get("source"));
                Map nodeEnd = (Map)nodes.get(line.get("target"));
                String[] pos = D.s(line.get("path")).split("\\|");
                Map<String, Object> p1 = this.port((Map)nodeStart.get("coordinate"), pos[0]);
                Map<String, Object> p2 = this.port((Map)nodeEnd.get("coordinate"), pos[1]);
                int p2sgn = D.i((Object)p2.get("sgn"));
                ArrayList<int[]> lines = this.getLines(p1, p2, p2sgn);
                this.setArrowDirection(p2, p2sgn, lines);
                String state = this.getLineState(linkline.getKey(), params);
                String type = D.s(line.get("type"));
                Color color = this.setRunningLineColor(type, state);
                this.drawLines(lines, type, color);
                this.drawLineString(line, lines);
            }
        }
    }

    private Color setDesigningLineColor(String type) {
        if ("NormalTransition".equals(type)) {
            this.g.setColor(NORMALTRANSITION_COLOR);
            return NORMALTRANSITION_COLOR;
        }
        if ("CompensationTransition".equals(type)) {
            this.g.setColor(COMPENSATION_COLOR);
            return COMPENSATION_COLOR;
        }
        if ("ErrorTransition".equals(type)) {
            this.g.setColor(ERRORTRANSITION_COLOR);
            return ERRORTRANSITION_COLOR;
        }
        return NORMALTRANSITION_COLOR;
    }

    private Color setRunningLineColor(String type, String state) {
        if ("NormalTransition".equals(type) && D.x((Object)state)) {
            this.g.setColor(KINGDEE_BULE);
            this.g.setStroke(new BasicStroke(2.0f));
            return KINGDEE_BULE;
        }
        if ("NormalTransition".equals(type) && !D.x((Object)state)) {
            this.g.setColor(UNEXECUTED_COLOR);
            this.g.setStroke(new BasicStroke(2.0f));
        } else {
            if ("ErrorTransition".equals(type) && D.x((Object)state)) {
                this.g.setColor(ERROR_PASSED_COLOR);
                this.g.setStroke(new BasicStroke(2.0f));
                return ERROR_PASSED_COLOR;
            }
            if ("ErrorTransition".equals(type) && !D.x((Object)state)) {
                this.g.setColor(UNEXECUTED_COLOR);
                this.g.setStroke(new BasicStroke(2.0f));
            } else {
                if ("CompensationTransition".equals(type) && D.x((Object)state)) {
                    this.g.setColor(COMPENSATION_PASSED_COLOR);
                    this.g.setStroke(new BasicStroke(2.0f));
                    return COMPENSATION_PASSED_COLOR;
                }
                if ("CompensationTransition".equals(type) && !D.x((Object)state)) {
                    this.g.setColor(UNEXECUTED_COLOR);
                    this.g.setStroke(new BasicStroke(2.0f));
                }
            }
        }
        return UNEXECUTED_COLOR;
    }

    private void setArrowDirection(Map<String, Object> p2, int p2sgn, ArrayList<int[]> lines) {
        int[] li = lines.get(lines.size() - 1);
        int[] tem = new int[5];
        tem[0] = li[0];
        tem[1] = li[1];
        tem[2] = li[2];
        tem[3] = li[3];
        tem[4] = p2.get("direction") == "vertical" ? (p2sgn < 0 ? 2 : 8) : (p2sgn < 0 ? 6 : 4);
        lines.remove(lines.size() - 1);
        lines.add(tem);
    }

    private void drawLines(ArrayList<int[]> lines, String type, Color color) {
        for (int i = 0; i < lines.size(); ++i) {
            int[] l = lines.get(i);
            this.drawLine(l[0], l[1], l[2], l[3]);
        }
        this.drawStartPoint(lines, type);
        this.drawArrow(lines, color);
    }

    private void drawStartPoint(ArrayList<int[]> lines, String type) {
        int[] line = lines.get(0);
        if ("NormalTransition".equals(type)) {
            int x = line[0] - 3;
            int y = line[1] - 3;
            this.g.fillOval(x + this.offsetX, y + this.offsetY, 6, 6);
        } else if ("CompensationTransition".equals(type)) {
            int x = line[0];
            int y = line[1];
            this.drawStartPng(line, x, y, "compensation");
        } else if ("ErrorTransition".equals(type)) {
            int x = line[0];
            int y = line[1];
            this.drawStartPng(line, x, y, "error");
        }
        this.setDesigningLineColor(type);
    }

    private void drawStartPng(int[] line, int x, int y, String type) {
        if (line[0] == line[2] && line[1] > line[3]) {
            x -= 6;
            y -= 12;
        } else if (line[1] == line[3] && line[0] > line[2]) {
            y -= 6;
            x -= 12;
        } else if (line[0] == line[2] && line[1] < line[3]) {
            x -= 6;
        } else if (line[1] == line[3] && line[0] < line[2]) {
            y -= 6;
        }
        this.g.setColor(Color.white);
        ImageIcon icon = this.getIcon(type);
        this.g.fillOval(x + this.offsetX, y + this.offsetY, 12, 12);
        this.drawImage(icon, x, y);
    }

    private void drawArrow(ArrayList<int[]> lines, Color color) {
        int y2;
        int x2;
        int y1;
        int x1;
        this.g.setColor(color);
        int[] line = lines.get(lines.size() - 1);
        int direction = line[4];
        if (direction == 8) {
            x1 = line[2] - 4;
            y1 = line[3] + 8;
            x2 = line[2] + 4;
            y2 = y1;
        } else if (direction == 6) {
            x1 = line[2] - 8;
            y1 = line[3] - 4;
            x2 = x1;
            y2 = line[3] + 4;
        } else if (direction == 4) {
            x1 = line[2] + 8;
            y1 = line[3] + 4;
            x2 = x1;
            y2 = line[3] - 4;
        } else if (direction == 2) {
            x1 = line[2] + 4;
            y1 = line[3] - 8;
            x2 = line[2] - 4;
            y2 = y1;
        } else {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u659c\u89d2\u7bad\u5934", (String)"ServiceFlowImage_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        this.drawLine(x1, y1, line[2], line[3]);
        this.drawLine(x2, y2, line[2], line[3]);
        this.drawTriangle(line, x1, y1, x2, y2);
    }

    private void drawLineString(Map<String, Object> line, ArrayList<int[]> lines) {
        int[] annotation = lines.get(0);
        String annota = D.s((Object)line.get("title"));
        if (StringUtil.isEmpty((String)annota)) {
            return;
        }
        int length = ServiceFlowImage.getTextLength(annota) * 12;
        if (annotation[0] > annotation[2]) {
            this.drawString(annota, annotation[0] - length, annotation[1] - 3);
        } else if (annotation[0] < annotation[2]) {
            this.drawString(annota, annotation[0] + 15, annotation[1] - 3);
        } else if (annotation[1] > annotation[3]) {
            this.drawString(annota, annotation[0] - length / 2, annotation[1] - 15);
        } else if (annotation[1] < annotation[3]) {
            this.drawString(annota, annotation[0] - length / 2, annotation[1] + 15);
        }
    }

    public static int getTextLength(String text) {
        int length = text.length();
        for (int i = 0; i < text.length(); ++i) {
            String s = String.valueOf(text.charAt(i));
            if (s.getBytes(StandardCharsets.UTF_8).length <= 1) continue;
            ++length;
        }
        length = length % 2 == 0 ? length / 2 : length / 2 + 1;
        return length;
    }

    private void drawTriangle(int[] line, int x1, int y1, int x2, int y2) {
        GeneralPath triangle = new GeneralPath();
        triangle.moveTo((float)line[2] + (float)this.offsetX, (float)line[3] + (float)this.offsetY);
        triangle.lineTo((float)x1 + (float)this.offsetX, (float)y1 + (float)this.offsetY);
        triangle.lineTo((float)x2 + (float)this.offsetX, (float)y2 + (float)this.offsetY);
        triangle.closePath();
        this.g.fill(triangle);
    }

    private void drawLine(int x1, int y1, int x2, int y2) {
        this.g.drawLine(x1 + this.offsetX, y1 + this.offsetY, x2 + this.offsetX, y2 + this.offsetY);
    }

    private Map<String, Object> port(Map<String, Integer> co, String pos) {
        int sgn;
        String direction;
        double x;
        double y;
        String[] tmp = pos.split(":");
        String border = tmp[0];
        double offset = Double.parseDouble(tmp[1]);
        switch (border) {
            case "top": {
                y = co.get("y").intValue();
                x = (double)co.get("x").intValue() + (double)co.get("width").intValue() / 2.0 + offset;
                direction = "vertical";
                sgn = -1;
                break;
            }
            case "bottom": {
                y = (double)co.get("y").intValue() + (double)co.get("height").intValue();
                x = (double)co.get("x").intValue() + (double)co.get("width").intValue() / 2.0 + offset;
                direction = "vertical";
                sgn = 1;
                break;
            }
            case "left": {
                x = co.get("x").intValue();
                y = (double)co.get("y").intValue() + (double)co.get("height").intValue() / 2.0 + offset;
                direction = "horizontal";
                sgn = -1;
                break;
            }
            case "right": {
                x = (double)co.get("x").intValue() + (double)co.get("width").intValue();
                y = (double)co.get("y").intValue() + (double)co.get("height").intValue() / 2.0 + offset;
                direction = "horizontal";
                sgn = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8def\u5f84\u4f4d\u7f6e(%s)\u683c\u5f0f\u975e\u6cd5!", (String)"ServiceFlowImage_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), pos));
            }
        }
        HashMap<String, Object> port = new HashMap<String, Object>(5);
        port.put("x", x);
        port.put("y", y);
        port.put("direction", direction);
        port.put("sgn", sgn);
        port.put("offset", offset);
        return port;
    }

    private String getFileName(Map<String, Object> params, DynamicObject flow) {
        if (flow == null) {
            return String.format(ResManager.loadKDString((String)"%1$s-%2$s-\u7248\u672c\u53f7%3$s.png", (String)"ServiceFlowImage_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params.get("name"), params.get("number"), params.get("version"));
        }
        return String.format(ResManager.loadKDString((String)"%1$s-%2$s-\u8bbe\u8ba1\u671f.png", (String)"ServiceFlowImage_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), flow.getString("name"), flow.getString("number"));
    }

    private ArrayList<int[]> getLines(Map<String, Object> p1, Map<String, Object> p2, int p2sgn) {
        int p1x = D.i((Object)p1.get("x"));
        int p1y = D.i((Object)p1.get("y"));
        int p2x = D.i((Object)p2.get("x"));
        int p2y = D.i((Object)p2.get("y"));
        int p1sgn = D.i((Object)p1.get("sgn"));
        if (Math.abs(p1x - D.i((Object)p2x)) <= 3) {
            p1.put("x", (p1x + p2x) / 2);
            p2.put("x", (p1x + p2x) / 2);
        }
        if (Math.abs(p1y - p2y) <= 3) {
            p1.put("y", (p1y + p2y) / 2);
            p2.put("y", (p1y + p2y) / 2);
        }
        p1x = D.i((Object)p1.get("x"));
        p1y = D.i((Object)p1.get("y"));
        p2x = D.i((Object)p2.get("x"));
        p2y = D.i((Object)p2.get("y"));
        ArrayList<int[]> lines = new ArrayList<int[]>(5);
        if ("vertical".equals(p1.get("direction"))) {
            if ("vertical".equals(p2.get("direction"))) {
                int y = p1sgn == p2sgn ? (p1sgn < 0 ? Math.min(p1y, p2y) - 30 : Math.max(p1y, p2y) + 30) : (p1y + p2y) / 2;
                if (y >= p1y && p1sgn > 0 || y <= p1y && p1sgn < 0) {
                    if (p1x == p2x) {
                        int[] line0 = new int[]{p1x, p1y, p2x, p2y};
                        lines.add(line0);
                    } else {
                        int[] line0 = new int[]{p1x, p1y, p1x, y};
                        int[] line1 = new int[]{p1x, y, p2x, y};
                        int[] line2 = new int[]{p2x, y, p2x, p2y};
                        lines.add(line0);
                        lines.add(line1);
                        lines.add(line2);
                    }
                } else {
                    int x = (p1x + p2x) / 2;
                    int y1 = p1y + 40 * p1sgn;
                    int y2 = p2y + 40 * p2sgn;
                    int[] line0 = new int[]{p1x, p1y, p1x, y1};
                    int[] line1 = new int[]{p1x, y1, x, y1};
                    int[] line2 = new int[]{x, y1, x, y2};
                    int[] line3 = new int[]{x, y2, p2x, y2};
                    int[] line4 = new int[]{p2x, y2, p2x, p2y};
                    lines.add(line0);
                    lines.add(line1);
                    lines.add(line2);
                    lines.add(line3);
                    lines.add(line4);
                }
            } else {
                int x = p1x;
                if (x >= p2x && p2sgn > 0 || x <= p2x && p2sgn < 0) {
                    int y = p2y;
                    if (y > p1y && p1sgn > 0 || y < p1y && p1sgn < 0) {
                        int[] line0 = new int[]{p1x, p1y, x, y};
                        int[] line1 = new int[]{x, y, p2x, p2y};
                        lines.add(line0);
                        lines.add(line1);
                    } else {
                        y = p1y;
                        x = (p1x + p2x) / 2;
                        int[] line0 = new int[]{p1x, p1y, p1x, y};
                        int[] line1 = new int[]{p1x, y, x, y};
                        int[] line2 = new int[]{x, y, x, p2y};
                        int[] line3 = new int[]{x, p2y, p2x, p2y};
                        lines.add(line0);
                        lines.add(line1);
                        lines.add(line2);
                        lines.add(line3);
                    }
                } else {
                    x = p2x;
                    int y = (p1y + p2y) / 2;
                    if (y < p1y && p1sgn > 0 || y > p1y && p1sgn < 0) {
                        y = p1y;
                    }
                    int[] line0 = new int[]{p1x, p1y, p1x, y};
                    int[] line1 = new int[]{p1x, y, x, y};
                    int[] line2 = new int[]{x, y, x, p2y};
                    int[] line3 = new int[]{x, p2y, p2x, p2y};
                    lines.add(line0);
                    lines.add(line1);
                    lines.add(line2);
                    lines.add(line3);
                }
            }
        } else if ("vertical".equals(p2.get("direction"))) {
            int y = p1y;
            if (y >= p2y && p2sgn > 0 || y <= p2y && p2sgn < 0) {
                int x = p2x;
                if (x > p1x && p1sgn > 0 || x < p1x && p1sgn < 0) {
                    int[] line0 = new int[]{p1x, p1y, x, y};
                    int[] line1 = new int[]{x, y, p2x, p2y};
                    lines.add(line0);
                    lines.add(line1);
                } else {
                    x = p1x;
                    y = (p1y + p2y) / 2;
                    int[] line0 = new int[]{p1x, p1y, x, p1y};
                    int[] line1 = new int[]{x, p1y, x, y};
                    int[] line2 = new int[]{x, y, p2x, y};
                    int[] line3 = new int[]{p2x, y, p2x, p2y};
                    lines.add(line0);
                    lines.add(line1);
                    lines.add(line2);
                    lines.add(line3);
                }
            } else {
                y = p2y;
                int x = (p1x + p2x) / 2;
                if (x > p1x && p1sgn < 0 || x < p1x && p1sgn > 0) {
                    x = p1x;
                }
                int[] line0 = new int[]{p1x, p1y, x, p1y};
                int[] line1 = new int[]{x, p1y, x, y};
                int[] line2 = new int[]{x, y, p2x, y};
                int[] line3 = new int[]{p2x, y, p2x, p2y};
                lines.add(line0);
                lines.add(line1);
                lines.add(line2);
                lines.add(line3);
            }
        } else {
            int x = p1sgn == p2sgn ? (p1sgn < 0 ? Math.min(p1x, p2x) - 30 : Math.max(p1x, p2x) + 30) : (p1x + p2x) / 2;
            if (x >= p1x && p1sgn > 0 || x <= p1x && p1sgn < 0) {
                if (p1y == p2y) {
                    int[] line0 = new int[]{p1x, p1y, p2x, p2y};
                    lines.add(line0);
                } else {
                    int[] line0 = new int[]{p1x, p1y, x, p1y};
                    int[] line1 = new int[]{x, p1y, x, p2y};
                    int[] line2 = new int[]{x, p2y, p2x, p2y};
                    lines.add(line0);
                    lines.add(line1);
                    lines.add(line2);
                }
            } else {
                int y = (p1y + p2y) / 2;
                int x1 = p1x + 40 * p1sgn;
                int x2 = p2x + 40 * p2sgn;
                int[] line0 = new int[]{p1x, p1y, x1, p1y};
                int[] line1 = new int[]{x1, p1y, x1, y};
                int[] line2 = new int[]{x1, y, x2, y};
                int[] line3 = new int[]{x2, y, x2, p2y};
                int[] line4 = new int[]{x2, p2y, p2x, p2y};
                lines.add(line0);
                lines.add(line1);
                lines.add(line2);
                lines.add(line3);
                lines.add(line4);
            }
        }
        return lines;
    }

    private static String getWaterText() {
        return ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u00b7\u82cd\u7a79 \u96c6\u6210\u670d\u52a1\u4e91", (String)"ServiceFlowImage_16", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
    }

    private static String getDefaultDiagram() {
        return String.format("({\"count\":\"2\",\"nodes\":{\"1\":{\"id\":\"1\",\"title\":\"%1$s\",\"type\":\"SubFlowStarter\",\"coordinate\":{\"x\":120 ,\"y\":130 ,\"height\":45 ,\"width\":200 }},\"2\":{\"id\":\"2\",\"title\":\"%2$s\",\"type\":\"End\",\"coordinate\":{\"x\":120 ,\"y\":440 ,\"height\":45 ,\"width\":200 }}},\"links\":{}})", ResManager.loadKDString((String)"\u5f00\u59cb", (String)"ServiceFlowImage_17", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ed3\u675f", (String)"ServiceFlowImage_18", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }
}

