/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf.rpa;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.util.dt.D;

public class RPAFlowFormPlugin
extends AbstractFormPlugin
implements CellClickListener {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String RPA_FLOW_LIST = "rpa_flow_list";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entryGrid.addCellClickListener((CellClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initEntry();
    }

    private void initEntry() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        List dcList = (List)params.get(RPA_FLOW_LIST);
        this.initEntryByList(dcList);
    }

    private void initEntryByList(List<Map<String, Object>> dcList) {
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        for (Map<String, Object> rpa : dcList) {
            if (!"release".equals(D.s((Object)rpa.get("workStatus")))) continue;
            DynamicObject obj = entries.addNew();
            obj.set("id", rpa.get("id"));
            obj.set("number", rpa.get("procCode"));
            obj.set("org", rpa.get("curOrgName"));
            obj.set("label", rpa.get("procLabel"));
            obj.set("version", rpa.get("procVer"));
            obj.set("createdate", (Object)D.t((Object)rpa.get("publishTime")));
            obj.set("developer", rpa.get("developerUser"));
            obj.set("desc", rpa.get("procDesc"));
        }
        this.getView().updateView(ENTRY_ENTITY);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        int[] rowNum;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("select".equals(operateKey) && (rowNum = ((EntryGrid)this.getView().getControl(ENTRY_ENTITY)).getSelectRows()).length == 1) {
            Map<String, Object> selectedRowData = this.getSelectedRowData(rowNum[0]);
            this.getView().returnDataToParent(selectedRowData);
            this.getView().close();
        }
    }

    private Map<String, Object> getSelectedRowData(int row) {
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, row);
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        data.put("id", rowEntity.getString("id"));
        data.put("number", rowEntity.getString("number"));
        data.put("name", rowEntity.getString("name"));
        data.put("version", rowEntity.getString("version"));
        return data;
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void cellDoubleClick(CellClickEvent evt) {
        Map<String, Object> data = this.getSelectedRowData(evt.getRow());
        this.getView().returnDataToParent(data);
        this.getView().close();
    }
}

