/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.sf.select;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import org.apache.commons.collections.CollectionUtils;

public class SelectFieldList
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeCheckListener,
SearchEnterListener {
    public static final String FormId_SelectField = "isc_sf_selectfield";
    public static final String CustParamKey_TreeNodes = "treenodes";
    public static final String CustParamKey_IsMulti = "ismulti";
    public static final String CustParamKey_SelectedNodeIds = "nodeids";
    private static final String CacheKey_SelectedNodeIds = "nodeids";
    public static final String Key_btnOK = "btnok";
    public static final String Key_btnCancel = "btncancel";
    public static final String Key_TreeView = "tv_fields";
    public static final String Key_SearchField = "searchfield";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel});
        TreeView tv = (TreeView)this.getView().getControl(Key_TreeView);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        tv.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        Search search = (Search)this.getView().getControl(Key_SearchField);
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String json = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_TreeNodes);
        this.fillTreeNodes(json);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (Key_btnOK.equalsIgnoreCase(ctlSource.getKey())) {
            String currNodeId = this.getPageCache().get("nodeids");
            if (StringUtils.isNotBlank((CharSequence)currNodeId)) {
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                customParams.put("currNodeId", currNodeId);
                this.getView().returnDataToParent((Object)customParams);
            } else {
                this.getView().returnDataToParent((Object)"");
            }
            this.getView().close();
        } else if (Key_btnCancel.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        if (!this.isMultiSelected()) {
            ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>();
            Map focusNode = ((TreeView)e.getSource()).getTreeState().getFocusNode();
            this.buildOneNode(nodes, focusNode);
            this.getPageCache().put("nodeids", Json.toString(nodes, (boolean)true));
        }
    }

    public void buildOneNode(List<Map<String, Object>> nodes, Map<String, Object> focusNode) {
        HashMap<String, Object> node = new HashMap<String, Object>();
        String parentid = D.s((Object)focusNode.get("parentid"));
        if (!StringUtils.isEmpty((CharSequence)parentid)) {
            node.put("id", parentid + "." + focusNode.get("id"));
            node.put("text", focusNode.get("text"));
            nodes.add(node);
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
    }

    public void treeNodeCheck(TreeNodeCheckEvent e) {
        TreeView treeView = (TreeView)e.getSource();
        this.cacheCheckedNodes(treeView);
    }

    public void cacheCheckedNodes(TreeView treeView) {
        List checkedNodes = treeView.getTreeState().getCheckedNodes();
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>();
        for (Map checkedNode : checkedNodes) {
            this.buildOneNode(nodes, checkedNode);
        }
        this.getPageCache().put("nodeids", Json.toString(nodes, (boolean)true));
    }

    private void fillTreeNodes(String strJson) {
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)strJson, TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        tree.addNode(rootNode);
        if (this.isMultiSelected()) {
            this.multiSelect(tree, rootNode);
        }
    }

    private void multiSelect(TreeView tree, TreeNode rootNode) {
        tree.setMulti(true);
        String cacheNodeIds = (String)this.getView().getFormShowParameter().getCustomParam("nodeids");
        if (StringUtils.isNotBlank((CharSequence)cacheNodeIds)) {
            String[] arr = StringUtils.split((String)cacheNodeIds, (String)",");
            ArrayList<TreeNode> selectedNodes = new ArrayList<TreeNode>();
            for (String nodeId : arr) {
                TreeNode node = rootNode.getTreeNode(nodeId, 5);
                if (node == null) continue;
                selectedNodes.add(node);
            }
            if (selectedNodes.size() > 0) {
                tree.checkNodes(selectedNodes);
            }
            this.cacheCheckedNodes(tree);
        }
    }

    private boolean isMultiSelected() {
        String isMulti = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_IsMulti);
        if (StringUtils.isBlank((CharSequence)isMulti)) {
            return false;
        }
        return isMulti.equalsIgnoreCase("true") || isMulti.equalsIgnoreCase("1");
    }

    public void search(SearchEnterEvent evt) {
        Search search = (Search)evt.getSource();
        if (StringUtils.equals((CharSequence)Key_SearchField, (CharSequence)search.getKey())) {
            String searchText = evt.getText();
            this.doSearch(searchText);
        }
    }

    private void doSearch(String searchText) {
        String json = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_TreeNodes);
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        if (StringUtils.isNotBlank((CharSequence)searchText) && CollectionUtils.isNotEmpty((Collection)rootNode.getChildren())) {
            rootNode.setChildren(this.getContains(rootNode.getChildren(), searchText));
        }
        tree.updateNode(rootNode);
        if (this.isMultiSelected()) {
            this.multiSelect(tree, rootNode);
        }
    }

    private List<TreeNode> getContains(List<TreeNode> childrens, String searchText) {
        Iterator<TreeNode> iterator = childrens.iterator();
        while (iterator.hasNext()) {
            TreeNode treeNode = iterator.next();
            if (CollectionUtils.isNotEmpty((Collection)treeNode.getChildren())) {
                treeNode.setChildren(this.getContains(treeNode.getChildren(), searchText));
            }
            if (!CollectionUtils.isEmpty((Collection)treeNode.getChildren()) || treeNode.getText().contains(searchText)) continue;
            iterator.remove();
        }
        return childrens;
    }
}

