/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.solution;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.platform.core.solution.SolutionResourceCompareJob;
import kd.isc.iscb.platform.core.solution.SolutionResourceUpdateJob;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;

public class ResourceCompareFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operation = args.getOperateKey();
        if ("compare".equals(operation)) {
            this.startCompare();
        } else if ("update_res".equals(operation)) {
            this.startUpdate();
        } else if ("set_main_ignore".equals(operation)) {
            this.setMode("main_resources", "main_importing_operation", "IGNORE", ResManager.loadKDString((String)"\u5ffd\u7565", (String)"ResourceCompareFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"set_main_ignore"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"unset_main_ignore"});
        } else if ("unset_main_ignore".equals(operation)) {
            this.setMode("main_resources", "main_importing_operation", "UPDATE", ResManager.loadKDString((String)"\u66f4\u65b0", (String)"ResourceCompareFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.TRUE, new String[]{"set_main_ignore"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"unset_main_ignore"});
        } else if ("set_ref_ignore".equals(operation)) {
            this.setMode("ref_resources", "ref_importing_operation", "IGNORE", ResManager.loadKDString((String)"\u5ffd\u7565", (String)"ResourceCompareFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"set_ref_ignore"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"unset_ref_ignore"});
        } else if ("unset_ref_ignore".equals(operation)) {
            this.setMode("ref_resources", "ref_importing_operation", "UPDATE", ResManager.loadKDString((String)"\u66f4\u65b0", (String)"ResourceCompareFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.TRUE, new String[]{"set_ref_ignore"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"unset_ref_ignore"});
        } else if ("show_main_diff".equals(operation)) {
            this.showMainDiff();
        } else if ("show_ref_diff".equals(operation)) {
            this.showRefDiff();
        } else if ("refresh".equals(operation)) {
            this.setColor("main_resources", "main_importing_operation");
            this.setColor("ref_resources", "ref_importing_operation");
        }
    }

    private void setColor(String entryKey, String operationKey) {
        DynamicObjectCollection resources = this.getModel().getDataEntity(true).getDynamicObjectCollection(entryKey);
        ArrayList<CellStyle> styles = new ArrayList<CellStyle>(resources.size());
        for (int i = 0; i < resources.size(); ++i) {
            DynamicObject main = (DynamicObject)resources.get(i);
            String operation = main.getString(operationKey);
            CellStyle cellStyle = new CellStyle();
            cellStyle.setRow(i);
            cellStyle.setFieldKey(operationKey);
            if ("INSERT".equals(operation)) {
                cellStyle.setForeColor("green");
            } else if ("UPDATE".equals(operation)) {
                cellStyle.setForeColor("blue");
            } else if ("DELETE".equals(operation)) {
                cellStyle.setForeColor("red");
            }
            styles.add(cellStyle);
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl(entryKey);
        grid.setCellStyle(styles);
    }

    private void startUpdate() {
        String progress = D.s((Object)this.getModel().getValue("progress"));
        if (!"COMPARED".equals(progress)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5bf9\u6bd4\u5b8c\u6210\u72b6\u6001\u4e0b\u624d\u652f\u6301\u66f4\u65b0", (String)"ResourceCompareFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("id", this.getModel().getValue("id"));
            param.put("solution_id", D.l((Object)this.getModel().getValue("solution_id")));
            SolutionResourceUpdateJob job = new SolutionResourceUpdateJob(ResManager.loadKDString((String)"\u8d44\u6e90\u66f4\u65b0", (String)"ResourceCompareFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Json.toString(param));
            List jobs = JobEngine.getJobsWithOwnerId((long)job.getOwnerId());
            if (jobs.isEmpty()) {
                FormOpener.startJob(this, (Job)job, "solution_update");
            } else {
                FormOpener.reopenJob(this, ((JobInfo)jobs.get(0)).getId(), job.getTitle(), "solution_update");
            }
        }
    }

    private void startCompare() {
        String progress = D.s((Object)this.getModel().getValue("progress"));
        if (!"READY".equals(progress) && !"COMPARING".equals(progress)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u72b6\u6001\u4e0b\u624d\u652f\u6301\u5bf9\u6bd4", (String)"ResourceCompareFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("id", this.getModel().getValue("id"));
            SolutionResourceCompareJob job = new SolutionResourceCompareJob(ResManager.loadKDString((String)"\u8d44\u6e90\u5bf9\u6bd4", (String)"ResourceCompareFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Json.toString(param));
            List jobs = JobEngine.getJobsWithOwnerId((long)job.getOwnerId());
            if (jobs.isEmpty()) {
                FormOpener.startJob(this, (Job)job, "solution_compare");
            } else {
                FormOpener.reopenJob(this, ((JobInfo)jobs.get(0)).getId(), job.getTitle(), "solution_compare");
            }
        }
    }

    private void setMode(String entryEntity, String modeField, String mode, String title) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryEntity);
        int[] rows = entryGrid.getSelectRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u3002", (String)"ResourceCompareFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            ArrayList<CellStyle> styles = new ArrayList<CellStyle>(rows.length);
            for (int row : rows) {
                String oldMode = D.s((Object)this.getModel().getValue(modeField, row));
                if (oldMode.equals("INSERT") || oldMode.equals("DELETE")) continue;
                this.getModel().setValue(modeField, (Object)mode, row);
                CellStyle cellStyle = new CellStyle();
                cellStyle.setRow(row);
                cellStyle.setFieldKey(modeField);
                if ("UPDATE".equals(mode)) {
                    cellStyle.setForeColor("#5582f3");
                } else {
                    cellStyle.setForeColor("black");
                }
                styles.add(cellStyle);
            }
            entryGrid.setCellStyle(styles);
            if (styles.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u884c\u8bbe\u7f6e\u4e3a%s\u6a21\u5f0f", (String)"ResourceCompareFormPlugin_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), title));
            } else {
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6210\u529f\u8bbe\u7f6e%1$s\u884c\u4e3a%2$s\u6a21\u5f0f", (String)"ResourceCompareFormPlugin_16", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), styles.size(), title));
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((EntryGrid)this.getView().getControl("ref_resources")).addRowClickListener((RowClickEventListener)this);
        ((EntryGrid)this.getView().getControl("main_resources")).addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent e) {
        EntryGrid entryGrid = (EntryGrid)e.getSource();
        int row = e.getRow();
        String entryKey = entryGrid.getKey();
        this.getPageCache().put(entryKey, String.valueOf(row));
        if ("ref_resources".equals(entryKey)) {
            Object mode = this.getModel().getValue("ref_importing_operation", row);
            if ("UPDATE".equals(mode)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"set_ref_ignore", "show_ref_diff"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"unset_ref_ignore"});
            } else if ("IGNORE".equals(mode)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"set_ref_ignore"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"unset_ref_ignore", "show_ref_diff"});
            } else if ("INSERT".equals(mode)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"set_ref_ignore", "unset_ref_ignore", "show_ref_diff"});
            } else if ("DELETE".equals(mode)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"set_ref_ignore", "unset_ref_ignore"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"show_ref_diff", "set_ref_ignore", "unset_ref_ignore"});
            }
        } else if ("main_resources".equals(entryKey)) {
            Object mode = this.getModel().getValue("main_importing_operation", row);
            if ("UPDATE".equals(mode)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"set_main_ignore"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"unset_main_ignore"});
            } else if ("IGNORE".equals(mode)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"set_main_ignore"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"unset_main_ignore"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"set_main_ignore", "unset_main_ignore"});
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("solution_compare".equals(actionId)) {
            this.getView().invokeOperation("refresh");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8d44\u6e90\u5bf9\u6bd4\u5b8c\u6210\u3002", (String)"ResourceCompareFormPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else if ("solution_update".equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String progress = D.s((Object)this.getModel().getValue("progress"));
        this.getView().returnDataToParent((Object)progress);
        super.beforeClosed(e);
    }

    private void showMainDiff() {
        int row = this.getSelectedRow("main_resources");
        if (row == -1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u4f9d\u8d56\u8d44\u6e90\u4e0e\u5176\u5386\u53f2\u7248\u672c\u6bd4\u8f83\u3002", (String)"ResourceCompareFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            return;
        }
        DynamicObject entry = this.getModel().getEntryRowEntity("main_resources", row);
        HashMap<String, Object> local = new HashMap();
        if (!"DELETE".equals(this.getModel().getValue("main_importing_operation", row))) {
            local = (Map)Json.toObject((String)D.s((Object)entry.get("main_res_content_tag")));
        }
        DynamicObject type = entry.getDynamicObject("main_res_type");
        String entity = D.s((Object)type.getPkValue());
        String pk = (String)entry.get("main_res_pk");
        Map res = (Map)Json.toObject((String)this.getContent(entity, pk, "t_isc_solution_mr"));
        FormOpener.showDiffComp(this, entity, res, ResManager.loadKDString((String)"\u8d44\u6e90\u5185\u5bb9\uff08\u65e7\uff09", (String)"ResourceCompareFormPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), local, ResManager.loadKDString((String)"\u672c\u5730\u5185\u5bb9\uff08\u65b0\uff09", (String)"ResourceCompareFormPlugin_14", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }

    private void showRefDiff() {
        int row = this.getSelectedRow("ref_resources");
        if (row == -1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u4f9d\u8d56\u8d44\u6e90\u4e0e\u5176\u5386\u53f2\u7248\u672c\u6bd4\u8f83\u3002", (String)"ResourceCompareFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            return;
        }
        DynamicObject entry = this.getModel().getEntryRowEntity("ref_resources", row);
        HashMap<String, Object> local = new HashMap();
        if (!"DELETE".equals(this.getModel().getValue("ref_importing_operation", row))) {
            local = (Map)Json.toObject((String)D.s((Object)entry.get("ref_res_content_tag")));
        }
        DynamicObject type = entry.getDynamicObject("ref_res_type");
        String entity = D.s((Object)type.getPkValue());
        String pk = (String)entry.get("ref_res_pk");
        Map res = (Map)Json.toObject((String)this.getContent(entity, pk, "t_isc_solution_rr"));
        FormOpener.showDiffComp(this, entity, res, ResManager.loadKDString((String)"\u8d44\u6e90\u5185\u5bb9\uff08\u65e7\uff09", (String)"ResourceCompareFormPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), local, ResManager.loadKDString((String)"\u672c\u5730\u5185\u5bb9\uff08\u65b0\uff09", (String)"ResourceCompareFormPlugin_14", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getContent(String entity, String id, String table_name) {
        try (Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);){
            long solutionId = D.l((Object)this.getModel().getValue("solution_id"));
            String sql = "SELECT fcontent_tag as tag FROM " + table_name + " where fid =? and ftype = ? and fres_pk = ? ";
            List<Integer> types = Arrays.asList(-5, 12, 12);
            List<Object> values = Arrays.asList(solutionId, entity, id);
            DataRow row = DbUtil.executeRow((Connection)cn, (String)sql, values, types);
            String string = row != null ? D.s((Object)row.get((Object)"tag")) : "{}";
            return string;
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
    }

    private int getSelectedRow(String entry) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entry);
        int[] rows = entryGrid.getSelectRows();
        if (rows.length != 1) {
            return -1;
        }
        return rows[0];
    }
}

