/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.solution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.isc.iscb.util.dt.D;

public class ResourceF7FormPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
ListRowClickListener,
F7SelectedListRemoveListener,
SearchEnterListener {
    private static final String KEY_TREE = "treeviewap";
    private static final String KEY_LIST = "billlistap";
    private static final String KEY_SELECTED_LIST = "f7selectedlistap";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillList billList = (BillList)this.getControl(KEY_LIST);
        billList.setBillFormId("isc_data_copy");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        BillList list = (BillList)this.getControl(KEY_LIST);
        list.addListRowClickListener((ListRowClickListener)this);
        list.setSelectedAll(false);
        F7SelectedList f7 = (F7SelectedList)this.getControl(KEY_SELECTED_LIST);
        f7.addF7SelectedListRemoveAllListener((F7SelectedListRemoveListener)this);
        f7.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
        this.addClickListeners(new String[]{"btnok"});
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!D.x((Object)this.getPageCache().get("initialized"))) {
            this.initTree();
        }
    }

    private void initTree() {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE);
        treeView.deleteAllNodes();
        treeView.setMulti(false);
        TreeNode root = new TreeNode("", "ROOT", ResManager.loadKDString((String)"\u8d44\u6e90\u7c7b\u522b", (String)"ResourceF7FormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        root.setExpend(true);
        List<TreeNode> nodes = this.getChildrenNodes();
        root.setChildren(nodes);
        treeView.addNode(root);
        treeView.setRootVisible(false);
        treeView.expand("ROOT");
        treeView.focusNode(nodes.get(0));
        this.getPageCache().put("initialized", "true");
    }

    private List<TreeNode> getChildrenNodes() {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(24);
        List<String> list = Arrays.asList("isc_data_copy", "isc_data_copy_trigger", "isc_service_flow", "iscx_resource", "iscx_data_flow_trigger", "isc_connection_type", "isc_data_source", "isc_value_conver_rule", "isc_metadata_schema", "isc_custom_function", "isc_apic_by_meta_schema", "isc_apic_by_dc_schema", "isc_apic_by_dc_trigger", "isc_apic_by_vc", "isc_apic_by_sf", "isc_apic_webapi", "isc_apic_for_external_api", "isc_apic_script", "isc_apic_mservice", "isc_mq_subscriber", "isc_mq_publisher", "isc_mq_bill_data_pub", "isc_mq_bill_data_sub", "isc_call_api_by_evt", "isc_call_api_by_timer", "isc_call_api_by_mq", "isc_data_comp");
        for (String entity : list) {
            nodes.add(new TreeNode("ROOT", entity, EntityMetadataCache.getDataEntityType((String)entity).getDisplayName().getLocaleValue()));
        }
        return nodes;
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        BillList billList = (BillList)this.getControl(KEY_LIST);
        if (!"ROOT".equals(nodeId)) {
            billList.changeBillFormId(nodeId);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u6839\u8282\u70b9\uff0c\u5df2\u81ea\u52a8\u5207\u6362\u5230\u7b2c\u4e00\u4e2a\u5b50\u8282\u70b9", (String)"ResourceF7FormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            billList.changeBillFormId("isc_data_copy");
            TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE);
            TreeNode node = new TreeNode("ROOT", "isc_data_copy", ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b", (String)"ResourceF7FormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            node.setCheckable(false);
            treeView.focusNode(node);
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        BillList list = (BillList)this.getControl(KEY_LIST);
        ListSelectedRowCollection rows = list.getSelectedRows();
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE);
        String nodeId = treeView.getTreeState().getFocusNodeId();
        String entity = "ROOT".equals(nodeId) ? "isc_data_copy" : nodeId;
        for (ListSelectedRow row : rows) {
            String pk = D.s((Object)row.getPrimaryKeyValue());
            String type = this.getPageCache().get(pk);
            if (D.s((Object)type) != null) continue;
            this.getPageCache().put(pk, entity);
        }
    }

    public void RemoveClick(F7SelectedListRemoveEvent event) {
        Object param = event.getParam();
        BillList list = (BillList)this.getControl(KEY_LIST);
        if (D.s((Object)param) == null) {
            list.clearSelection();
        } else {
            list.restoreSelection(param.toString());
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            ListSelectedRowCollection rows;
            BillList list = (BillList)this.getControl(KEY_LIST);
            int limit = D.i((Object)this.getView().getFormShowParameter().getCustomParam("limit"));
            if (limit <= 0) {
                limit = 10000;
            }
            if ((rows = list.getSelectedRows()).size() > limit) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u884c\u6570\u4e0d\u80fd\u5927\u4e8e%s\u3002", (String)"ResourceF7FormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[]{limit}));
            } else {
                this.setReturnData(rows);
            }
        }
    }

    private void setReturnData(ListSelectedRowCollection rows) {
        for (ListSelectedRow row : rows) {
            String entity = this.getPageCache().get(D.s((Object)row.getPrimaryKeyValue()));
            row.setFormID(entity);
        }
        this.getView().returnDataToParent((Object)rows);
        this.getView().invokeOperation("close");
    }

    public void search(SearchEnterEvent evt) {
        String text = D.s((Object)evt.getText());
        BillList list = (BillList)this.getControl(KEY_LIST);
        if (text != null) {
            QFilter filter = new QFilter("number", "like", (Object)("%" + text + "%")).or(new QFilter("name", "like", (Object)("%" + text + "%")));
            list.addSetFilterListener(event -> event.getQFilters().add(filter));
            list.refresh();
        } else {
            list.refresh();
        }
    }
}

