/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.solution;

import java.io.Serializable;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.Donothing;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.Modify;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.isc.iscb.formplugin.solution.DeployUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.imp.FileResourceUtil;
import kd.isc.iscb.platform.core.imp.SolutionSyncCloudUtil;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.platform.core.solution.PublicResourceUtil;
import kd.isc.iscb.platform.core.solution.SolutionResourceImportJob;
import kd.isc.iscb.platform.core.solution.SolutionResourceUtil;
import kd.isc.iscb.platform.core.solution.SolutionUtil;
import kd.isc.iscb.platform.core.solution.UpdateCloudSolutionJob;
import kd.isc.iscb.platform.core.util.DynamicObjectUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.script.misc.SystemContext;

public class SolutionCenterListPlugin
extends AbstractListPlugin {
    private static final String UPDATE_SOLUTION_LIST = "update_solution_list";
    private static final String SHOW_HISTORY = "show_history";
    private static final Log LOGGER = LogFactory.getLog(SolutionCenterListPlugin.class);

    public void initialize() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String billFormId = ((ListView)this.getView()).getBillFormId();
        if ("isc_solution_center".equals(billFormId)) {
            this.checkAppApply();
        }
    }

    public boolean checkAppApply() {
        try {
            return PublicResourceUtil.checkAppInfo();
        }
        catch (Throwable t) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("jumpApplyApp", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u79df\u6237\u672a\u8fdb\u884c\u4e91\u8d44\u6e90\u4e2d\u5fc3\u5bc6\u94a5\u7533\u8bf7\u6216\u5bc6\u94a5\u7533\u8bf7\u5931\u6548\uff0c\u5c06\u5f71\u54cd\u65b9\u6848\u8d44\u6e90\u7684\u8ba2\u9605\u3001\u66f4\u65b0\u548c\u56fe\u7247\u7684\u6b63\u5e38\u663e\u793a\u7b49\u64cd\u4f5c\u3002\u70b9\u51fb\u786e\u5b9a\u540e\u4f1a\u81ea\u52a8\u8df3\u8f6c\u81f3\u3010\u5e94\u7528\u5bc6\u94a5\u7533\u8bf7\u3011\u754c\u9762\u3002", (String)"SolutionCenterListPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
            return false;
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        Object selectedId = ((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo().getPrimaryKeyValue();
        FormOpener.showTabViewIfNotExist((AbstractFormPlugin)this, "isc_solution_center", selectedId);
        SolutionSyncCloudUtil.uploadSolutionClickInfo((long)D.l((Object)selectedId));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Modify && (args.getListSelectedData() == null || args.getListSelectedData().size() > 1)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u884c", (String)"SolutionCenterListPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        try {
            String operationKey = evt.getOperateKey();
            if (evt.getSource() instanceof Donothing && "deploy".equals(operationKey)) {
                this.deploy(evt);
            } else if ("show_deploy_log".equals(operationKey)) {
                this.showDeployLog(evt);
            } else if ("rebuild".equals(operationKey)) {
                this.rebuildSolution();
            } else if (SHOW_HISTORY.equals(operationKey)) {
                this.showHistory(evt);
            } else if (UPDATE_SOLUTION_LIST.equals(operationKey) && this.checkAppApply()) {
                FormOpener.showModalForm((AbstractFormPlugin)this, "isc_cloud_solution", null, null, null);
            } else if ("diffcompare".equals(operationKey)) {
                this.showLocalResourceDiff(evt);
            } else if ("update".equals(operationKey)) {
                Object id = FormOpener.getSelectedId((AbstractFormPlugin)this, evt);
                if (id != null) {
                    this.getView().getPageCache().put("update_id", D.s((Object)id));
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("confirmUpdate", (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u540e\u5c06\u4f1a\u83b7\u53d6\u4e91\u7aef\u6700\u65b0\u7684\u65b9\u6848\u66f4\u65b0\u5e76\u8986\u76d6\u81f3\u201c\u6211\u7684\u65b9\u6848\u201d\u5217\u8868\uff0c\u53ef\u7528\u4f5c\u540e\u7eed\u90e8\u7f72\u7b49\u64cd\u4f5c\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SolutionCenterListPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
                }
            } else if ("import".equals(operationKey)) {
                this.importSolution();
            }
        }
        catch (KDBizException e) {
            throw e;
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private void importSolution() {
        FormShowParameter p = new FormShowParameter();
        p.setFormId("isc_import_solution");
        p.setCustomParam("entity", (Object)"isc_solution_center");
        p.getOpenStyle().setShowType(ShowType.Modal);
        p.setStatus(OperationStatus.ADDNEW);
        p.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "importschema"));
        p.setCaption(String.format(ResManager.loadKDString((String)"\u5bfc\u5165 - %s", (String)"SolutionCenterListPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), FileResourceUtil.getEntityTitle((String)"isc_solution_center")));
        this.getView().showForm(p);
    }

    public void submitUpdateCloudSolutionJob(String param, String api) {
        UpdateCloudSolutionJob updateJob = new UpdateCloudSolutionJob(param, api);
        List jobs = JobEngine.getJobsWithOwnerId((long)updateJob.getOwnerId());
        if (jobs.isEmpty()) {
            FormOpener.startJob((AbstractFormPlugin)this, (Job)updateJob, UPDATE_SOLUTION_LIST);
        } else {
            FormOpener.reopenJob((AbstractFormPlugin)this, ((JobInfo)jobs.get(0)).getId(), updateJob.getTitle(), UPDATE_SOLUTION_LIST);
        }
    }

    private void showLocalResourceDiff(AfterDoOperationEventArgs evt) {
        Object id = FormOpener.getSelectedId((AbstractFormPlugin)this, evt);
        if (id != null) {
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_solution_center");
            QFilter[] qFilters = new QFilter[]{new QFilter("resid", "=", id).and(new QFilter("operate_key", "=", (Object)"deploy"))};
            DynamicObject[] objs = BusinessDataServiceHelper.load((String)"isc_res_history", (String)"res_content_tag", (QFilter[])qFilters, (String)"created_time desc", (int)1);
            if (objs.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u5305\u4e0d\u5b58\u5728\u4e8e\u672c\u5730\u6216\u67e5\u8be2\u4e0d\u5230\u5386\u53f2\u8bb0\u5f55\uff0c\u8bf7\u91cd\u65b0\u90e8\u7f72\u65b9\u6848\u540e\u518d\u8fdb\u884c\u672c\u5730\u4e0e\u4e91\u7aef\u65b9\u6848\u7684\u5dee\u5f02\u6bd4\u8f83\u3002", (String)"SolutionCenterListPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            Map localSolution = SolutionUtil.buildSolutionResource((DynamicObject)object);
            String contentTag = objs[0].getString("res_content_tag");
            Map solutionMap = (Map)Json.toObject((String)contentTag);
            DynamicObject deploySolution = DynamicObjectUtil.map2Object((String)"isc_solution_center", (Map)solutionMap);
            Map lastDeploySolution = SolutionUtil.buildSolutionResource((DynamicObject)deploySolution);
            FormOpener.showDiffComp((AbstractFormPlugin)this, "isc_solution_center", lastDeploySolution, ResManager.loadKDString((String)"\u672c\u5730\u5df2\u90e8\u7f72\u8d44\u6e90", (String)"SolutionCenterListPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), localSolution, ResManager.loadKDString((String)"\u672c\u5730\u65b9\u6848\u5305\u8d44\u6e90", (String)"SolutionCenterListPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void showHistory(AfterDoOperationEventArgs evt) {
        Object id = FormOpener.getSelectedId((AbstractFormPlugin)this, evt);
        if (id != null) {
            FormOpener.showList((AbstractFormPlugin)this, "isc_res_history", "resid", id);
        }
    }

    private void deploy(AfterDoOperationEventArgs evt) {
        Object id = FormOpener.getSelectedId((AbstractFormPlugin)this, evt);
        if (id != null) {
            DynamicObject solution = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_solution_center");
            if (!solution.getBoolean("ispreset") && SystemContext.isProcEnv()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u4e0d\u662f\u9884\u7f6e\u65b9\u6848\uff0c\u6b63\u5f0f\u73af\u5883\u4e0d\u53ef\u90e8\u7f72\uff0c\u8bf7\u5148\u5c06\u8be5\u65b9\u6848\u4e8e\u6d4b\u8bd5\u73af\u5883\u9a8c\u8bc1\u901a\u8fc7\u540e\uff0c\u5bfc\u5165\u81f3\u6b63\u5f0f\u73af\u5883\u4f7f\u7528", (String)"SolutionCenterListPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            if ("Z".equals(solution.getString("status"))) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("warnDownSolution", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u5728\u4e91\u7aef\u7ba1\u7406\u5e73\u53f0\u5df2\u4e0b\u67b6\uff0c\u4e14\u4e0d\u518d\u66f4\u65b0\u7ef4\u62a4\uff0c\u5efa\u8bae\u5148\u54a8\u8be2\u65b9\u6848\u5f00\u53d1\u5546\u6216\u96c6\u6210\u4e91\u7ba1\u7406\u5458\u83b7\u53d6\u652f\u6301\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002\u662f\u5426\u7ee7\u7eed\u90e8\u7f72\uff1f", (String)"SolutionCenterListPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks, null, D.s((Object)id));
            } else {
                DeployUtil.deploy(this.getView(), (AbstractFormPlugin)this, D.l((Object)id));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (evt.getResult() == MessageBoxResult.Yes && "warnDownSolution".equals(evt.getCallBackId())) {
            DeployUtil.deploy(this.getView(), (AbstractFormPlugin)this, D.l((Object)evt.getCustomVaule()));
        }
        if (evt.getResult() == MessageBoxResult.Yes && "jumpApplyApp".equals(evt.getCallBackId())) {
            if (PublicResourceUtil.checkNewAppInfoExist()) {
                FormOpener.showMainEditIfNotExist((AbstractFormPlugin)this, "res_pub_thirdapp_apply", null);
            } else {
                FormOpener.showMainEditIfNotExist((AbstractFormPlugin)this, "iscr_app_apply", null);
            }
        }
        if (evt.getResult() == MessageBoxResult.Yes && "confirmUpdate".equals(evt.getCallBackId())) {
            String updateId = this.getView().getPageCache().get("update_id");
            String api = "kapi/v2/kdec/iscb/isc_solution_center/query_solution_by_id?id=" + updateId;
            this.getView().getPageCache().remove("update_id");
            this.submitUpdateCloudSolutionJob(ResManager.loadKDString((String)"\u4e0b\u8f7d\u4e91\u7aef\u65b9\u6848", (String)"SolutionCenterListPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), api);
        }
    }

    private void showDeployLog(AfterDoOperationEventArgs evt) {
        Object id = FormOpener.getSelectedId((AbstractFormPlugin)this, evt);
        if (id != null) {
            FormOpener.showList((AbstractFormPlugin)this, "isc_dts_solution_deploy", new QFilter("resid", "=", (Object)id.toString()));
        }
    }

    private void rebuildSolution() {
        SolutionResourceImportJob job = new SolutionResourceImportJob(ResManager.loadKDString((String)"\u6807\u51c6\u65b9\u6848\u66f4\u65b0", (String)"SolutionCenterListPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        List jobs = JobEngine.getJobsWithOwnerId((long)job.getOwnerId());
        if (jobs.isEmpty()) {
            FormOpener.startJob((AbstractFormPlugin)this, (Job)job);
        } else {
            FormOpener.reopenJob((AbstractFormPlugin)this, ((JobInfo)jobs.get(0)).getId(), job.getTitle());
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map params;
        super.closedCallBack(evt);
        String action = evt.getActionId();
        if (UPDATE_SOLUTION_LIST.equals(action)) {
            this.getView().invokeOperation("refresh");
        }
        if ("importschema".equals(action) && evt.getReturnData() instanceof Map && D.x((params = (Map)evt.getReturnData()).get("progress"))) {
            SolutionUtil.saveDeployHistory((DynamicObject)BusinessDataServiceHelper.loadSingle((Object)D.s(params.get("id")), (String)"isc_solution_center"));
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        final String billFormId = ((ListView)this.getView()).getBillFormId();
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                boolean appApply = SolutionCenterListPlugin.this.checkAppApply();
                List<Map<String, Object>> cloudVersionSolution = this.getCloudVersion(rows, limit);
                for (DynamicObject row : rows) {
                    String url;
                    String keyWords = row.getString("key_words");
                    if (keyWords != null && keyWords.contains("\u514d\u8d39")) {
                        url = UrlService.getDomainContextUrl().replace("localhost", NetUtil.getLocalAddress()) + "/kingdee/isc/solution_images/";
                        row.set("freemark", (Object)(url + "freemark.png"));
                    } else {
                        row.set("freemark", (Object)"");
                    }
                    url = UrlService.getDomainContextUrl().replace("localhost", NetUtil.getLocalAddress()) + "/kingdee/isc/solution_images/off_shelf.png";
                    row.set("off_shelf_img", (Object)url);
                    if (cloudVersionSolution.size() <= 0 || !appApply) continue;
                    this.setNeedUpdate(cloudVersionSolution, row);
                    if (!"isc_solution_center".equals(billFormId)) continue;
                    this.handleNotExistImg(cloudVersionSolution, row);
                }
                return rows;
            }

            public void setNeedUpdate(List<Map<String, Object>> cloudVersionSolution, DynamicObject row) {
                boolean needUpdate = this.isNeedUpdate(cloudVersionSolution, row);
                if (needUpdate) {
                    row.set("is_update", (Object)needUpdate);
                }
            }

            public boolean isNeedUpdate(List<Map<String, Object>> cloudVersionSolution, DynamicObject row) {
                return cloudVersionSolution.stream().anyMatch(v -> D.l(v.get("id")) == D.l((Object)row.get("id")) && this.compareVersion(v.get("version"), row.get("version")));
            }

            public void handleNotExistImg(List<Map<String, Object>> cloudVersionSolution, DynamicObject row) {
                String logo = row.getString("logo");
                try {
                    Map<String, String> cloudSolution = cloudVersionSolution.stream().filter(k -> D.l(k.get("id")) == D.l((Object)row.get("id"))).collect(Collectors.toMap(k -> "id", v -> D.s(v.get("logo"))));
                    if (StringUtils.isNotEmpty((String)logo) && cloudSolution.size() > 0 && !FileServiceFactory.getImageFileService().exists(logo)) {
                        String cloudLogo = cloudSolution.get("id");
                        String localLogo = SolutionResourceUtil.uploadLogoToFileServer((String)cloudLogo);
                        row.set("logo", (Object)localLogo);
                        DynamicObject localSolution = BusinessDataServiceHelper.loadSingle((Object)row.get("id"), (String)"isc_solution_center");
                        localSolution.set("logo", (Object)localLogo);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{localSolution});
                    }
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                }
            }

            private List<Map<String, Object>> getCloudVersion(DynamicObjectCollection rows, int limit) {
                try {
                    List ids = rows.stream().map(k -> k.get("id")).collect(Collectors.toList());
                    HashMap queryParam = new HashMap(1);
                    queryParam.put("id", ids);
                    LinkedHashMap<String, Serializable> params = new LinkedHashMap<String, Serializable>(1);
                    params.put("data", queryParam);
                    params.put("pageNo", Integer.valueOf(1));
                    params.put("pageSize", Integer.valueOf(limit));
                    return SolutionSyncCloudUtil.queryCloudSolutionList((String)"kapi/v2/kdec/iscb/isc_solution_center/query_cloud_solution", params);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                    return Collections.emptyList();
                }
            }

            private boolean compareVersion(Object cloudVersion, Object localVersion) {
                cloudVersion = D.s((Object)cloudVersion).replace("-", "");
                localVersion = D.s((Object)localVersion).replace("-", "");
                return D.i((Object)cloudVersion) > D.i((Object)localVersion);
            }
        });
    }
}

