/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.solution;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.Html;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.IDService;
import kd.bos.list.ListShowParameter;
import kd.bos.login.utils.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.imp.FileResourceUtil;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.platform.core.solution.SolutionUtil;
import kd.isc.iscb.platform.core.solution.UpdateRefResourceJob;
import kd.isc.iscb.platform.core.util.DynamicObjectUtil;
import kd.isc.iscb.platform.core.util.ExportAndImportFormUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.misc.SystemContext;

public class SolutionCenterManageFormPlugin
extends AbstractFormPlugin {
    private static final String RICHTEXT_DETAIL = "richtext_detail";
    private static final String KEY_WORDS = "key_words";
    private static final String SOURCE = "source";
    private static final String CONNECT_SYSTEM_NAME = "connect_system_name";
    private static final String ISPRESET = "ispreset";
    private static final String BRIEF_PANEL = "brief_panel";
    private static final String HTML_DETAIL = "html_detail";
    private static final String RES_CHANGED = "res_changed";
    private static final Set<String> PRESETCHECKSET = new HashSet<String>(Arrays.asList("isc_service_flow", "isc_metadata_schema", "isc_data_copy", "isc_apic_script"));

    public void initialize() {
        super.initialize();
        if ("admin".equals(System.getProperty("solution.user.type"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"delete", "bar_modify", "update_res", "export"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"delete", "bar_modify", "update_res", "export"});
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if ("admin".equals(System.getProperty("solution.user.type"))) {
            String keyWords = D.s((Object)this.getKeyWords());
            if (keyWords != null && keyWords.contains("\u514d\u8d39")) {
                String url = UrlService.getDomainContextUrl().replace("localhost", NetUtil.getLocalAddress()) + "/kingdee/isc/solution_images/";
                this.getModel().setValue("freemark1", (Object)(url + "freemark.png"));
                this.getView().setVisible(Boolean.FALSE, new String[]{"flex_freemark"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"flex_freemark1"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flex_freemark", "flex_freemark1"});
            }
        }
        this.getView().setEnable(this.controlIsPreset(), new String[]{ISPRESET});
    }

    private Object getKeyWords() {
        String[] split;
        String key_words = D.s((Object)this.getModel().getValue(KEY_WORDS));
        if (key_words == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String s : split = StringUtil.split((String)key_words, (char)',')) {
            if (D.s((Object)s) == null) continue;
            if (sb.length() > 0) {
                sb.append('\u3001');
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_WORDS, SOURCE, CONNECT_SYSTEM_NAME});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        String operateKey = ctrl.getKey();
        if (KEY_WORDS.equals(operateKey)) {
            FormOpener.showF7(this, "isc_solution_keywords", "select_keywords", true);
        } else if (SOURCE.equals(operateKey)) {
            FormOpener.showF7(this, "isc_solution_source", "select_source", false);
        } else if (CONNECT_SYSTEM_NAME.equals(operateKey)) {
            FormOpener.showF7(this, "isc_connection_type", "select_connection_type", true);
        }
    }

    private void showF7() {
        ListShowParameter p = new ListShowParameter();
        p.setFormId("isc_resource_f7");
        p.getOpenStyle().setShowType(ShowType.Modal);
        p.setF7Style(0);
        p.setMultiSelect(true);
        p.setShowTitle(true);
        p.setHasRight(true);
        StyleCss css = new StyleCss();
        css.setWidth("1200px");
        css.setHeight("700px");
        p.getOpenStyle().setInlineStyleCss(css);
        p.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "select_res"));
        p.setShowFilter(false);
        p.setShowQuickFilter(false);
        this.getView().showForm((FormShowParameter)p);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            boolean check = this.checkSave(args);
            if (!check) {
                args.setCancel(true);
                return;
            }
            this.getView().getPageCache().remove("confirmSave");
            this.getModel().setValue("freemark", (Object)"");
            RichTextEditor editor = (RichTextEditor)this.getView().getControl(RICHTEXT_DETAIL);
            String text = D.s((Object)editor.getText());
            if (text != null) {
                this.getModel().setValue("detail_tag", (Object)text);
            }
            DynamicObject obj = this.getModel().getDataEntity(true);
            int count = obj.getDynamicObjectCollection("main_resources").size() + obj.getDynamicObjectCollection("ref_resources").size();
            obj.set("res_count", (Object)count);
            SolutionUtil.evalPackageSize((DynamicObject)obj);
            this.getView().updateView("size");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("export".equals(operateKey)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("export", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u53d1\u5e03\u5e76\u5bfc\u51fa\uff1f", (String)"SolutionCenterManageFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
        } else if ("update_res".equals(operateKey)) {
            List pkIds = args.getOperationResult().getSuccessPkIds();
            this.updateResources(pkIds);
        } else if ("save".equals(operateKey) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            this.executeAfterSave(args);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9700\u8981\u786e\u8ba4\u5f53\u524d\u65b9\u6848\u662f\u5426\u5305\u542b100000\u6839\u7ec4\u7ec7\u7f16\u7801\u7684\u5185\u5bb9\uff0c\u8bf7\u4f7f\u7528\u5de5\u5177\uff08\u96c6\u6210\u7ba1\u7406-\u5176\u4ed6-\u96c6\u6210\u5185\u5bb9\u68c0\u7d22\uff09\u68c0\u7d22100000\u3002", (String)"SolutionCenterManageFormPlugin_14", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else if ("modify".equals(operateKey)) {
            this.executeAfterModify();
        } else if ("add_main_res".equals(operateKey)) {
            this.showF7();
        } else if ("delete_main_res".equals(operateKey)) {
            this.getView().setEnable(this.controlIsPreset(), new String[]{ISPRESET});
            this.getPageCache().put(RES_CHANGED, "true");
        } else if ("update_ref".equals(operateKey)) {
            if (D.l((Object)this.getModel().getValue("id")) == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u518d\u66f4\u65b0\u5f15\u7528\u8d44\u6e90\u5173\u7cfb", (String)"SolutionCenterManageFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            } else {
                this.updateRefResources(this.getModel().getValue("id"));
            }
        }
    }

    private void executeAfterModify() {
        this.getView().setStatus(OperationStatus.EDIT);
        this.getView().setVisible(Boolean.TRUE, new String[]{RICHTEXT_DETAIL});
        this.getView().setVisible(Boolean.FALSE, new String[]{BRIEF_PANEL, HTML_DETAIL});
        RichTextEditor editor = (RichTextEditor)this.getView().getControl(RICHTEXT_DETAIL);
        editor.setText(D.s((Object)this.getModel().getValue("detail_tag")));
        this.getView().updateView(RICHTEXT_DETAIL);
    }

    private Boolean controlIsPreset() {
        Boolean isAllowPreset = Boolean.FALSE;
        if (SystemContext.isProcEnv()) {
            DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection("main_resources");
            if (entries.isEmpty()) {
                this.getModel().setValue(ISPRESET, (Object)isAllowPreset);
                return isAllowPreset;
            }
            for (DynamicObject entry : entries) {
                String json = D.s((Object)entry.get("main_res_content_tag"));
                Map mainContent = (Map)Json.toObject((String)json);
                String protect_level = D.s(mainContent.get("protect_level"));
                String entityName = D.s(mainContent.get("$entityname"));
                if (PRESETCHECKSET.contains(entityName) && "READ_ONLY".equals(protect_level)) {
                    isAllowPreset = Boolean.TRUE;
                    continue;
                }
                isAllowPreset = Boolean.FALSE;
                this.getModel().setValue(ISPRESET, (Object)isAllowPreset);
                break;
            }
        } else {
            isAllowPreset = Boolean.TRUE;
        }
        return isAllowPreset;
    }

    private void executeAfterSave(AfterDoOperationEventArgs args) {
        this.getView().setStatus(OperationStatus.VIEW);
        this.getView().cacheFormShowParameter();
        this.getView().setVisible(Boolean.FALSE, new String[]{RICHTEXT_DETAIL});
        this.getView().setVisible(Boolean.TRUE, new String[]{BRIEF_PANEL, HTML_DETAIL});
        Html html = (Html)this.getView().getControl(HTML_DETAIL);
        html.setConent(D.s((Object)this.getModel().getValue("detail_tag")));
        this.getView().updateView(HTML_DETAIL);
        OperationResult result = args.getOperationResult();
        if (result == null || result.getSuccessPkIds().isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"SolutionCenterManageFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!D.x((Object)this.getPageCache().get(RES_CHANGED))) {
            return;
        }
        this.updateRefResources(result.getSuccessPkIds().get(0));
    }

    private void updateRefResources(Object pkId) {
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection("main_resources");
        ArrayList list = new ArrayList(entries.size());
        for (DynamicObject entry : entries) {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("main_res_pk", entry.get("main_res_pk"));
            String entity = D.s((Object)entry.getDynamicObject("main_res_type").getPkValue());
            map.put("main_res_type", entity);
            map.put("main_res_number", entry.get("main_res_number"));
            list.add(map);
        }
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        param.put("id", pkId);
        param.put("main_resources", list);
        param.put("size", this.getModel().getValue("size"));
        this.updateRef(param);
    }

    private void updateRef(Map<String, Object> param) {
        UpdateRefResourceJob job = new UpdateRefResourceJob(ResManager.loadKDString((String)"\u5f15\u7528\u8d44\u6e90\u66f4\u65b0", (String)"SolutionCenterManageFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Json.toString(param));
        List jobs = JobEngine.getJobsWithOwnerId((long)job.getOwnerId());
        if (jobs.isEmpty()) {
            FormOpener.startJob(this, (Job)job, "update_ref");
        } else {
            FormOpener.reopenJob(this, ((JobInfo)jobs.get(0)).getId(), job.getTitle(), "update_ref");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (MessageBoxResult.Yes == evt.getResult()) {
            if ("export".equals(evt.getCallBackId())) {
                File zipFile = SolutionUtil.export2((Object)this.getModel().getValue("id"));
                ExportAndImportFormUtil.download((IFormView)this.getView(), (String)zipFile.getAbsolutePath());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"SolutionCenterManageFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            }
            if ("presetSave".equals(evt.getCallBackId())) {
                this.getView().getPageCache().put("confirmSave", "true");
                this.getView().invokeOperation("save");
            }
        }
    }

    private void updateResources(List<Object> pkIds) {
        if (!pkIds.isEmpty()) {
            String info = this.getNotExistedResources();
            if (info.length() > 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u8bf7\u5148\u5c06\u5176\u79fb\u9664\u3002", (String)"SolutionCenterManageFormPlugin_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), info), Integer.valueOf(3000));
            } else {
                this.updateSource(pkIds.get(0));
            }
        }
    }

    private void updateSource(Object pk) {
        long id = SolutionCenterManageFormPlugin.saveResourceCompare(D.l((Object)pk));
        BillShowParameter param = new BillShowParameter();
        param.setFormId("isc_resource_compare");
        param.setPkId((Object)id);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("MUTEX_OBJ_ID", (Object)String.valueOf(id));
        param.setStatus(OperationStatus.EDIT);
        param.setCaption(ResManager.loadKDString((String)"\u65b9\u6848\u5bf9\u6bd4", (String)"SolutionCenterManageFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "solution_update"));
        this.getView().showForm((FormShowParameter)param);
    }

    private static long saveResourceCompare(long pkValue) {
        DynamicObject solution = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"isc_solution_center_m");
        DynamicObjectCollection mainEntries = solution.getDynamicObjectCollection("main_resources");
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"isc_resource_compare");
        DynamicObjectCollection main = object.getDynamicObjectCollection("main_resources");
        long billId = IDService.get().genLongId();
        object.set("id", (Object)billId);
        object.set("number", (Object)Hash.mur32((Object[])new Object[]{UUID.randomUUID().toString()}));
        object.set("solution", (Object)solution);
        object.set("progress", (Object)"READY");
        object.set("modifytime", (Object)D.t((Object)System.currentTimeMillis()));
        object.set("modifier", (Object)RequestContext.get().getUserId());
        for (DynamicObject e : mainEntries) {
            DynamicObject item = main.addNew();
            item.set("main_importing_operation", (Object)"UPDATE");
            item.set("main_res_number", e.get("main_res_number"));
            item.set("main_res_name", e.get("main_res_name"));
            String pk = D.s((Object)e.get("main_res_pk"));
            item.set("main_res_pk", (Object)pk);
            DynamicObject type = e.getDynamicObject("main_res_type");
            item.set("main_res_type", (Object)type);
            item.set("main_res_time", (Object)D.t((Object)e.get("main_res_time")));
            String content = e.getString("main_res_content_tag");
            item.set("main_res_content_tag", (Object)content);
            item.set("main_res_size", (Object)content.length());
            item.set("main_res_remark", e.get("main_res_remark"));
        }
        DynamicObjectCollection refEntries = solution.getDynamicObjectCollection("ref_resources");
        DynamicObjectCollection ref = object.getDynamicObjectCollection("ref_resources");
        for (DynamicObject e : refEntries) {
            DynamicObject item = ref.addNew();
            item.set("ref_importing_operation", (Object)"INSERT");
            item.set("ref_res_number", e.get("ref_res_number"));
            item.set("ref_res_name", e.get("ref_res_name"));
            String pk = D.s((Object)e.get("ref_res_pk"));
            DynamicObject type = e.getDynamicObject("ref_res_type");
            item.set("ref_res_type", (Object)type);
            item.set("ref_res_time", (Object)D.t((Object)e.get("ref_res_time")));
            item.set("ref_res_pk", (Object)pk);
            String content = e.getString("ref_res_content_tag");
            item.set("ref_res_content_tag", (Object)content);
            item.set("ref_res_size", (Object)content.length());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        return billId;
    }

    private String getNotExistedResources() {
        StringBuilder sb = new StringBuilder();
        DynamicObjectCollection mainResources = this.getModel().getEntryEntity("main_resources");
        for (DynamicObject o : mainResources) {
            Object id;
            DynamicObject type = o.getDynamicObject("main_res_type");
            String entity = D.s((Object)type.getPkValue());
            boolean exists = QueryServiceHelper.exists((String)entity, (Object)(id = FileResourceUtil.parseResPK((String)D.s((Object)o.get("main_res_pk")), (String)entity)));
            if (exists) continue;
            String entityName = EntityMetadataCache.getDataEntityType((String)entity).getDisplayName().getLocaleValue();
            sb.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\uff1a%1$s\u7684\u4e3b\u8d44\u6e90%2$s\u5df2\u4e0d\u5b58\u5728\uff1b", (String)"SolutionCenterManageFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), o.get("main_res_number"), entityName)).append("\r\n");
        }
        return sb.toString();
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("update_ref".equals(actionId)) {
            this.getPageCache().remove(RES_CHANGED);
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f15\u7528\u8d44\u6e90\u66f4\u65b0\u5b8c\u6210\u3002", (String)"SolutionCenterManageFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
        if ((returnData = e.getReturnData()) == null) {
            return;
        }
        if ("select_res".equals(actionId)) {
            this.addResources((ListSelectedRowCollection)returnData);
        } else if ("refresh_solution".equals(actionId) && D.x((Object)returnData)) {
            this.getView().invokeOperation("refresh");
        } else if ("select_keywords".equals(actionId) && returnData instanceof ListSelectedRowCollection) {
            String s = this.getSelectedName((ListSelectedRowCollection)returnData);
            this.getModel().setValue(KEY_WORDS, (Object)s);
        } else if ("select_source".equals(actionId) && returnData instanceof ListSelectedRowCollection) {
            String s = this.getSelectedName((ListSelectedRowCollection)returnData);
            this.getModel().setValue(SOURCE, (Object)s);
        } else if ("solution_update".equals(actionId)) {
            if ("UPDATED".equals(returnData)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8d44\u6e90\u66f4\u65b0\u5b8c\u6210\u3002", (String)"SolutionCenterManageFormPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            }
        } else if ("select_connection_type".equals(actionId) && returnData instanceof ListSelectedRowCollection) {
            String s = this.getSelectedName((ListSelectedRowCollection)returnData);
            this.getModel().setValue(CONNECT_SYSTEM_NAME, (Object)s);
        }
    }

    private String getSelectedName(ListSelectedRowCollection returnData) {
        StringBuilder sb = new StringBuilder();
        for (ListSelectedRow row : returnData) {
            if (sb.length() > 0) {
                sb.append('\u3001');
            }
            sb.append(row.getName());
        }
        return sb.toString();
    }

    private void addResources(ListSelectedRowCollection collection) {
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection("main_resources");
        Map<String, DynamicObject> objectMap = SolutionCenterManageFormPlugin.convertToMap(entries);
        for (ListSelectedRow row : collection) {
            Object resourcesId = row.getPrimaryKeyValue();
            String entity = row.getFormID();
            String key = SolutionUtil.getFullKey((String)entity, (Object)resourcesId);
            DynamicObject existedRes = objectMap.get(key);
            DynamicObject item = existedRes != null ? existedRes : entries.addNew();
            DynamicObject res = BusinessDataServiceHelper.loadSingle((Object)resourcesId, (String)entity);
            item.set("main_res_type", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)entity, (String)"bos_objecttype"));
            item.set("main_res_number", (Object)res.getString("number"));
            item.set("main_res_name", (Object)res.getString("name"));
            Object pkValue = res.getPkValue();
            item.set("main_res_pk", pkValue);
            item.set("main_res_time", res.get(SolutionUtil.getTimeField((String)entity)));
            item.set("main_res_remark", (Object)SolutionUtil.getRemark((DynamicObject)res));
            Map map = DynamicObjectUtil.object2Map((DynamicObject)res);
            map.put("$id", pkValue);
            map.put("$entityname", entity);
            map.put("$isref", Boolean.FALSE);
            String content = Json.toString((Object)map);
            item.set("main_res_content_tag", (Object)content);
            item.set("main_res_size", (Object)content.length());
        }
        this.getView().setEnable(this.controlIsPreset(), new String[]{ISPRESET});
        this.getPageCache().put(RES_CHANGED, "true");
        this.getView().updateView("main_resources");
    }

    private static Map<String, DynamicObject> convertToMap(DynamicObjectCollection entries) {
        LinkedHashMap<String, DynamicObject> map = new LinkedHashMap<String, DynamicObject>(entries.size());
        for (DynamicObject object : entries) {
            String entity = D.s((Object)((DynamicObject)object.get("main_res_type")).getPkValue());
            String pk = D.s((Object)object.get("main_res_pk"));
            map.put(SolutionUtil.getFullKey((String)entity, (Object)pk), object);
        }
        return map;
    }

    private boolean checkSave(BeforeDoOperationEventArgs args) {
        if (StringUtils.isEmpty((String)D.s((Object)this.getModel().getValue("group")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6240\u5c5e\u9886\u57df\u201d\u3002", (String)"SolutionCenterManageFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!D.x((Object)this.getModel().getValue(ISPRESET)) && !D.x((Object)this.getView().getPageCache().get("confirmSave"))) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("presetSave", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u9ed8\u8ba4\u4e3a\u975e\u9884\u7f6e\u65b9\u6848\uff0c\u7528\u6237\u6b63\u5f0f\u73af\u5883\u4e0d\u53ef\u4ee5\u8fdb\u884c\u90e8\u7f72\u64cd\u4f5c\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SolutionCenterManageFormPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
            return false;
        }
        return true;
    }
}

