/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.solution;

import java.io.File;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.solution.SolutionUtil;
import kd.isc.iscb.platform.core.util.ExportAndImportFormUtil;

public class SolutionCenterManageListPlugin
extends AbstractListPlugin {
    public void initialize() {
        if ("admin".equals(System.getProperty("solution.user.type"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"tblnew", "delete", "modify"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnnew", "btnedit", "btndel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"tblnew", "delete", "show_keywords", "show_sources", "show_history", "btn_export"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblnew", "delete", "modify"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblnew", "delete", "show_keywords", "show_sources", "show_history", "btn_export"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        try {
            String operationKey = evt.getOperateKey();
            if ("show_keywords".equals(operationKey)) {
                FormOpener.showList((AbstractFormPlugin)this, "isc_solution_keywords", new QFilter("id", ">", (Object)0));
            } else if ("show_sources".equals(operationKey)) {
                FormOpener.showList((AbstractFormPlugin)this, "isc_solution_source", new QFilter("id", ">", (Object)0));
            } else if ("export".equals(operationKey)) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("export", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u53d1\u5e03\u5e76\u5bfc\u51fa\uff1f", (String)"SolutionCenterManageListPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
            } else if ("batch_export".equals(operationKey)) {
                this.batchExportSolution();
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (MessageBoxResult.Yes == evt.getResult() && "export".equals(evt.getCallBackId())) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            Object[] pk = selectedRows.getPrimaryKeyValues();
            if (pk == null || pk.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u65b9\u6848\u3002", (String)"SolutionCenterManageListPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            } else if (pk.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u65b9\u6848\u5bfc\u51fa\u3002", (String)"SolutionCenterManageListPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            } else {
                File zipFile = SolutionUtil.export2((Object)pk[0]);
                ExportAndImportFormUtil.download((IFormView)this.getView(), (String)zipFile.getAbsolutePath());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"SolutionCenterManageListPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            }
        }
    }

    private void batchExportSolution() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Object[] pks = selectedRows.getPrimaryKeyValues();
        if (pks.length > 10) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6279\u91cf\u5bfc\u51fa\u9650\u5236\u4e3a10\u4e2a\u65b9\u6848\u5305\u3002", (String)"SolutionCenterManageListPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        List zipFiles = SolutionUtil.batchExport((Object[])pks);
        for (File zipFile : zipFiles) {
            ExportAndImportFormUtil.download((IFormView)this.getView(), (String)zipFile.getAbsolutePath());
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"SolutionCenterManageListPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }
}

