/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.solution;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.report.CellStyle;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.app.AppParameterServiceHelper;
import kd.isc.iscb.platform.core.imp.SolutionSyncCloudUtil;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.platform.core.solution.PublicResourceUtil;
import kd.isc.iscb.platform.core.solution.SolutionUtil;
import kd.isc.iscb.platform.core.solution.UpdateCloudSolutionJob;
import kd.isc.iscb.platform.core.util.DynamicObjectUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Pair;

public class SolutionCloudDownloadListPlugin
extends AbstractListPlugin
implements HyperLinkClickListener,
TreeNodeClickListener,
SearchEnterListener,
CreateListDataProviderListener,
PagerClickListener {
    public static final String KEY_GROUP = "group";
    public static final String KEY_TREEVIEW = "treeviewap";
    public static final String KEY_BILLLIST = "billlistap";
    public static final String KEY_SEARCH = "solution_search";
    public static final String SEARCH_CONDITION = "search_condition";
    public static final String FOCUS_ID = "focus_id";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
        BillList list = (BillList)this.getControl(KEY_BILLLIST);
        list.addHyperClickListener((HyperLinkClickListener)this);
        list.addPagerClickListener((PagerClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initTree();
        this.query();
    }

    protected void initTree() {
        TreeView tree = (TreeView)this.getControl(KEY_TREEVIEW);
        tree.deleteAllNodes();
        DynamicObject[] dataSources = BusinessDataServiceHelper.load((String)"isc_solution_domain", (String)"id, number, name", null);
        TreeNode rootNode = new TreeNode("", "root", ResManager.loadKDString((String)"\u5168\u90e8\u5206\u7c7b", (String)"SolutionCloudDownloadListPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        tree.addNode(rootNode);
        for (DynamicObject ds : dataSources) {
            TreeNode node = new TreeNode(rootNode.getId(), ds.getPkValue().toString(), ds.getString("name"));
            tree.addNode(node);
        }
        tree.expand(rootNode.getId());
        tree.focusNode(rootNode);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)KEY_TREEVIEW)) {
            String nodeId = D.s((Object)evt.getNodeId());
            if (!"root".equals(nodeId)) {
                this.getPageCache().put(FOCUS_ID, nodeId);
            } else {
                this.getPageCache().remove(FOCUS_ID);
            }
            this.getPageCache().put("resetPage", "1");
            this.query();
            this.getView().updateView(KEY_BILLLIST);
        }
    }

    public void search(SearchEnterEvent evt) {
        String text = D.s((Object)evt.getText());
        this.getView().getPageCache().put(SEARCH_CONDITION, text);
        this.getPageCache().put("resetPage", "1");
        this.query();
        this.getView().updateView(KEY_BILLLIST);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        AbstractOperate source = (AbstractOperate)evt.getSource();
        String operateKey = source.getOperateKey();
        if ("confirm".equals(operateKey)) {
            this.checkSelectRow(evt);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String key = evt.getOperateKey();
        if ("confirm".equals(key)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("confirmDownload", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u540e\u5c06\u4f1a\u83b7\u53d6\u4e91\u7aef\u6700\u65b0\u7684\u65b9\u6848\u66f4\u65b0\u5e76\u8986\u76d6\u81f3\u201c\u6211\u7684\u65b9\u6848\u201d\u5217\u8868\uff0c\u53ef\u7528\u4f5c\u540e\u7eed\u90e8\u7f72\u7b49\u64cd\u4f5c\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SolutionCloudDownloadListPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
            return;
        }
        if (!"local_cloud_compare".equals(key)) {
            if (!"refresh".equals(key)) return;
            this.query();
            this.getView().updateView(KEY_BILLLIST);
            return;
        }
        BillList billList = (BillList)this.getControl(KEY_BILLLIST);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.getPrimaryKeyValues().length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u65b9\u6848\u4e0e\u4e91\u7aef\u65b9\u6848\u8fdb\u884c\u5dee\u5f02\u6bd4\u8f83\u3002", (String)"SolutionCloudDownloadListPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(2500));
            return;
        }
        Object id = selectedRows.getPrimaryKeyValues()[0];
        boolean exists = QueryServiceHelper.exists((String)"isc_solution_center", (Object)id);
        if (!exists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u5730\u65b9\u6848\u8d44\u6e90\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8fdb\u884c\u5dee\u5f02\u6bd4\u8f83", (String)"SolutionCloudDownloadListPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(2500));
            return;
        }
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_solution_center");
        Map localSolution = SolutionUtil.buildSolutionResource((DynamicObject)object);
        String api = "kapi/v2/kdec/iscb/isc_solution_center/query_resources_by_id?id=" + id;
        Map cloudSolution = (Map)PublicResourceUtil.queryListByGet((String)api, null).get(0);
        cloudSolution = SolutionUtil.buildSolutionResource((DynamicObject)DynamicObjectUtil.map2Object((String)"isc_solution_center", (Map)cloudSolution));
        this.handleSolution(localSolution, cloudSolution);
        FormOpener.showDiffComp((AbstractFormPlugin)this, "isc_solution_center", localSolution, ResManager.loadKDString((String)"\u672c\u5730\u65b9\u6848\u5305\u8d44\u6e90", (String)"SolutionCloudDownloadListPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), cloudSolution, ResManager.loadKDString((String)"\u4e91\u7aef\u65b9\u6848\u5305\u8d44\u6e90", (String)"SolutionCloudDownloadListPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }

    private void handleSolution(Map<String, Object> localSolution, Map<String, Object> cloudSolution) {
        localSolution.remove("is_enjoy");
        localSolution.remove("is_store");
        localSolution.remove("off_shelf_img");
        localSolution.remove("res_count");
        cloudSolution.remove("res_count");
        cloudSolution.remove("is_enjoy");
        cloudSolution.remove("off_shelf_img");
    }

    private boolean checkSelectRow(BeforeDoOperationEventArgs evt) {
        BillList billList = (BillList)this.getControl(KEY_BILLLIST);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.isEmpty()) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e", (String)"SolutionCloudDownloadListPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            return false;
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (MessageBoxResult.Yes == evt.getResult() && StringUtils.equals((CharSequence)evt.getCallBackId(), (CharSequence)"confirmDownload")) {
            BillList billList = (BillList)this.getControl(KEY_BILLLIST);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            ArrayList<Long> ids = new ArrayList<Long>(selectedRows.size());
            for (ListSelectedRow selectedRow : selectedRows) {
                ids.add(D.l((Object)selectedRow.getPrimaryKeyValue()));
            }
            String querySolutionUrl = SolutionUtil.getApiUrl(ids);
            this.submitUpdateSolutionJob(querySolutionUrl);
        }
    }

    public void submitUpdateSolutionJob(String querySolutionUrl) {
        UpdateCloudSolutionJob updateJob = new UpdateCloudSolutionJob(ResManager.loadKDString((String)"\u4e0b\u8f7d\u4e91\u7aef\u65b9\u6848", (String)"SolutionCloudDownloadListPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), querySolutionUrl);
        List jobs = JobEngine.getJobsWithOwnerId((long)updateJob.getOwnerId());
        if (jobs.isEmpty()) {
            FormOpener.startJob((AbstractFormPlugin)this, (Job)updateJob, querySolutionUrl);
        } else {
            FormOpener.reopenJob((AbstractFormPlugin)this, ((JobInfo)jobs.get(0)).getId(), updateJob.getTitle(), querySolutionUrl);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        BillListHyperLinkClickEvent billListHyperLinkClickEvent = (BillListHyperLinkClickEvent)evt;
        ListSelectedRow currentRow = billListHyperLinkClickEvent.getCurrentRow();
        String entryId = D.s((Object)currentRow.getPrimaryKeyValue());
        String devPortalUrl = D.s((Object)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)AppParameterServiceHelper.getAppParam(), (String)"dev_portal_url"));
        if (kd.bos.util.StringUtils.isEmpty((String)devPortalUrl)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u53d1\u8005\u95e8\u6237url\u672a\u914d\u7f6e\u3002\u8bf7\u524d\u5f80\u7cfb\u7edf\u670d\u52a1\u4e91-\u914d\u7f6e\u5de5\u5177-\u53c2\u6570\u914d\u7f6e-\u3010\u96c6\u6210\u7ba1\u7406\u7cfb\u7edf\u53c2\u6570\u3011\u754c\u9762\u8fdb\u884c\u5f00\u53d1\u8005\u95e8\u6237url\u914d\u7f6e\u3002", (String)"SolutionCloudDownloadListPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        devPortalUrl = devPortalUrl.endsWith("/") ? devPortalUrl : devPortalUrl + "/";
        this.getView().openUrl(devPortalUrl + entryId);
    }

    private void query() {
        BillList list = (BillList)this.getView().getControl(KEY_BILLLIST);
        list.addCreateListDataProviderListener((CreateListDataProviderListener)this);
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs e) {
        ListDataProvider provider = new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                start = SolutionCloudDownloadListPlugin.this.resetPage(start);
                DynamicObjectCollection rows = super.getData(start, limit);
                rows.clear();
                SolutionCloudDownloadListPlugin.this.fillData(rows, this.getQueryResult(), start, limit);
                return rows;
            }
        };
        e.setListDataProvider((IListDataProvider)provider);
    }

    private void fillData(DynamicObjectCollection rows, QueryResult queryResult, int start, int limit) {
        BillList billList = (BillList)this.getControl(KEY_BILLLIST);
        ArrayList<CellStyle> cslist = new ArrayList<CellStyle>();
        String billFormId = billList.getBillFormId();
        try {
            Map<String, Object> result = this.buildData(billFormId, start, limit);
            int totalSize = D.i((Object)result.get("totalSize"));
            List data = (List)result.get("data");
            int index = 0;
            int styleIndex = start;
            for (Map item : data) {
                DynamicObject row = new DynamicObject(rows.getDynamicObjectType());
                row.set("number", item.get("number"));
                row.set("name", item.get("name"));
                QFilter filter = new QFilter("id", "=", (Object)D.l(item.get(KEY_GROUP)));
                DynamicObject group = BusinessDataServiceHelper.loadSingle((String)"isc_solution_domain", (QFilter[])new QFilter[]{filter});
                row.set(KEY_GROUP, (Object)group);
                row.set("deploytimes", item.get("solution_download"));
                row.set("clicktimes", item.get("solution_click"));
                row.set("key_words", item.get("key_words"));
                row.set("id", item.get("id"));
                row.set("connect_system_name", item.get("connect_system_name"));
                row.set("version", item.get("version"));
                row.set("introduction", item.get("localversion"));
                row.set("createtime", item.get("localtime"));
                row.set("modifytime", (Object)D.t(item.get("modifytime")));
                this.setStyle(item, cslist, styleIndex);
                rows.add(index, row);
                ++index;
                ++styleIndex;
            }
            queryResult.setDataCount(totalSize);
            queryResult.setCollection(rows);
            queryResult.setBillDataCount(0);
            billList.clearSelection();
            billList.setCellStyle(cslist);
        }
        catch (Throwable t) {
            FormOpener.showErrorMessage(this.getView(), t);
        }
    }

    private void setStyle(Map<String, Object> item, List<CellStyle> cslist, int index) {
        this.setVersionColor(item, cslist, index);
        this.setClickAndDownloadColor(item, cslist, index);
    }

    private void setVersionColor(Map<String, Object> item, List<CellStyle> cslist, int index) {
        boolean oldVersion;
        if (StringUtils.isNotEmpty((CharSequence)D.s((Object)item.get("localversion"))) && !(oldVersion = SolutionUtil.compareVersion((String)D.s((Object)item.get("version")), (String)D.s((Object)item.get("localversion"))))) {
            CellStyle cs = new CellStyle();
            cs.setFieldKey("version");
            cs.setForeColor("#ff991c");
            cs.setRow(index);
            cslist.add(cs);
        }
    }

    private void setClickAndDownloadColor(Map<String, Object> item, List<CellStyle> cslist, int index) {
        CellStyle clickCs = new CellStyle();
        clickCs.setFieldKey("clicktimes");
        clickCs.setForeColor("orange");
        clickCs.setRow(index);
        cslist.add(clickCs);
        CellStyle downloadCs = new CellStyle();
        downloadCs.setFieldKey("deploytimes");
        downloadCs.setForeColor("green");
        downloadCs.setRow(index);
        cslist.add(downloadCs);
    }

    private Map<String, Object> buildData(String billFormId, int start, int limit) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<Map<String, Object>> cloudSolutionList = this.getCloudSolution();
        result.put("totalSize", cloudSolutionList.size());
        List<Map<String, Object>> pagingSolution = this.handlePage(cloudSolutionList, start, limit);
        this.buildLocalSolution(pagingSolution);
        result.put("data", pagingSolution);
        return result;
    }

    private List<Map<String, Object>> handlePage(List<Map<String, Object>> cloudSolutionList, int start, int limit) {
        int size = cloudSolutionList.size();
        List<Map<String, Object>> pagingSolution = size - start < limit ? cloudSolutionList.subList(start, size) : cloudSolutionList.subList(start, start + limit);
        return pagingSolution;
    }

    private void buildLocalSolution(List<Map<String, Object>> cloudSolutionList) {
        List ids = cloudSolutionList.stream().map(k -> D.l(k.get("id"))).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObjectCollection localSolutionCollection = QueryServiceHelper.query((String)"isc_solution_center", (String)"id,version,modifytime", (QFilter[])new QFilter[]{qFilter});
        List localSolutionList = DynamicObjectUtil.objectCollection2List((DynamicObjectCollection)localSolutionCollection);
        Map<String, Pair> localSolution = localSolutionList.stream().collect(Collectors.toMap(k -> D.s(k.get("id")), v -> new Pair(v.get("version"), v.get("modifytime"))));
        for (Map<String, Object> cloudSolution : cloudSolutionList) {
            cloudSolution.put("localversion", localSolution.get(cloudSolution.get("id")) == null ? "" : localSolution.get(cloudSolution.get("id")).getA());
            cloudSolution.put("localtime", localSolution.get(cloudSolution.get("id")) == null ? "" : localSolution.get(cloudSolution.get("id")).getB());
        }
    }

    private List<Map<String, Object>> getCloudSolution() {
        HashMap<String, String> queryParam = new HashMap<String, String>();
        queryParam.put(SEARCH_CONDITION, this.getPageCache().get(SEARCH_CONDITION));
        queryParam.put(KEY_GROUP, this.getPageCache().get(FOCUS_ID));
        Map cloudSolutionMap = SolutionSyncCloudUtil.getCloudSolution(queryParam);
        return (List)cloudSolutionMap.get("data");
    }

    public void pagerClick(PagerClickEvent pagerClickEvent) {
        BillList billList = (BillList)pagerClickEvent.getSource();
        billList.setPageRow(pagerClickEvent.getPageRows());
        this.query();
    }

    private int resetPage(int start) {
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get("resetPage"))) {
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            AbstractGrid.GridState entryState = proxy.getEntryState(KEY_BILLLIST);
            entryState.setCurrentPageIndex(Integer.valueOf(1));
            this.getPageCache().remove("resetPage");
            return 0;
        }
        return start;
    }
}

