/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.solution;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipInputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.ShowStackTraceUtil;
import kd.isc.iscb.platform.core.solution.SolutionResourceImportJob;
import kd.isc.iscb.util.dt.D;

public class SolutionImportFormPlugin
extends AbstractFormPlugin {
    private static final String PANEL = "attachmentpanelap";

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operationKey = evt.getOperateKey();
        if ("import".equals(operationKey)) {
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(PANEL);
            List list = attachmentPanel.getAttachmentData();
            if (list == null || list.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6587\u4ef6\u3002", (String)"SolutionImportFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            } else {
                this.importSolution(attachmentPanel, list);
            }
        }
    }

    private void importSolution(AttachmentPanel panel, List<Map<String, Object>> list) {
        int total = list.size();
        int success = 0;
        int omitted = 0;
        for (Map<String, Object> attach : list) {
            String name = D.s((Object)attach.get("name"));
            String url = D.s((Object)attach.get("url"));
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            try {
                InputStream in = cache.getInputStream(url);
                Throwable throwable = null;
                try {
                    ZipInputStream input = new ZipInputStream(in);
                    Throwable throwable2 = null;
                    try {
                        SolutionResourceImportJob.UploadState state = SolutionResourceImportJob.uploadSolution((ZipInputStream)input);
                        if (SolutionResourceImportJob.UploadState.SUCCESS == state) {
                            ++success;
                        } else if (SolutionResourceImportJob.UploadState.OMITTED == state) {
                            ++omitted;
                        }
                        panel.remove(attach);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (input == null) continue;
                        if (throwable2 != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        input.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(this.getView(), String.format(ResManager.loadKDString((String)"\u5bfc\u5165zip\u5305[%1$s]\u5931\u8d25\uff0c\u539f\u56e0\uff1a%2$s", (String)"SolutionImportFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), name, e.getMessage()), ShowStackTraceUtil.getErrorMsg(e));
                return;
            }
        }
        if (omitted > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5171%1$s\u4e2a\uff0c\u5bfc\u5165\u6210\u529f%2$s\u4e2a, \u5ffd\u7565\uff1a%3$s\u4e2a\uff0c\u5ffd\u7565\u539f\u56e0\uff1a\u5f53\u524d\u7cfb\u7edf\u7248\u672c\u6bd4\u5bfc\u5165\u7248\u672c\u76f8\u540c\u6216\u66f4\u9ad8\u3002", (String)"SolutionImportFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), total, success, omitted), Integer.valueOf(2000));
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"SolutionImportFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }
}

