/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.tools;

import java.text.Collator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Html;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.formplugin.tools.model.ViewCondition;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.core.Feature;
import kd.isc.iscb.util.text.SourceComparator;

public class DiffCompFormPlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    private static final int MAX_TEXT_LENGTH_FOR_COMP = 8000;
    private static final int MAX_TEXT_LENGTH_FOR_SHOW = 255;
    private static final String SEARCHAP = "searchap";
    private static final String NEW = "new";
    private static final String UPDATE = "update";
    private static final String DELETE = "delete";
    private static final String ALL = "all";
    private static final String NEWCOUNT = "newcount";
    private static final String UPDATECOUNT = "updatecount";
    private static final String DELETECOUNT = "deletecount";
    private static final HashMap<String, Integer> priorities = new HashMap(16);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{NEW, UPDATE, DELETE, ALL});
        Search search = (Search)this.getControl(SEARCHAP);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void click(EventObject evt) {
    }

    private void showCount(ViewCondition vc) {
        IPageCache pageCache = this.getPageCache();
        String newC = pageCache.get(NEWCOUNT);
        String upC = pageCache.get(UPDATECOUNT);
        String delC = pageCache.get(DELETECOUNT);
        if (StringUtil.isEmpty((String)newC)) {
            newC = D.s((Object)vc.getNewCount());
            upC = D.s((Object)vc.getUpdateCount());
            delC = D.s((Object)vc.getDeleteCount());
            pageCache.put(NEWCOUNT, newC);
            pageCache.put(UPDATECOUNT, upC);
            pageCache.put(DELETECOUNT, delC);
        }
        this.getModel().setValue(NEWCOUNT, (Object)newC);
        this.getModel().setValue(UPDATECOUNT, (Object)upC);
        this.getModel().setValue(DELETECOUNT, (Object)delC);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String search = this.getPageCache().get("search");
        if ("1".equals(search)) {
            return;
        }
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Boolean newValue = D.x((Object)changeSet[0].getNewValue());
        boolean oldValue = D.x((Object)changeSet[0].getOldValue());
        boolean showUpdate = false;
        boolean showDelete = false;
        boolean showAppend = false;
        if (NEW.equals(name)) {
            showUpdate = D.x((Object)this.getModel().getValue(UPDATE));
            showDelete = D.x((Object)this.getModel().getValue(DELETE));
            showAppend = newValue;
        } else if (UPDATE.equals(name)) {
            showAppend = D.x((Object)this.getModel().getValue(NEW));
            showDelete = D.x((Object)this.getModel().getValue(DELETE));
            showUpdate = newValue;
        } else if (DELETE.equals(name)) {
            showUpdate = D.x((Object)this.getModel().getValue(UPDATE));
            showAppend = D.x((Object)this.getModel().getValue(NEW));
            showDelete = newValue;
        } else if (ALL.equals(name)) {
            this.getModel().setValue(NEW, (Object)newValue);
            this.getModel().setValue(UPDATE, (Object)newValue);
            this.getModel().setValue(DELETE, (Object)newValue);
        }
        if (showAppend && showDelete && showUpdate) {
            this.getModel().setValue(ALL, (Object)Boolean.TRUE);
        } else if (oldValue) {
            this.getPageCache().put("search", "1");
            this.getModel().setValue(ALL, (Object)Boolean.FALSE);
            this.getPageCache().put("search", "0");
        }
        if (!ALL.equals(name)) {
            this.showContent(showDelete, showUpdate, showAppend);
        }
    }

    private void showContent(boolean showDelete, boolean showUpdate, boolean showAppend) {
        boolean showSame = false;
        if (!(showAppend || showDelete || showUpdate)) {
            showSame = true;
            showAppend = true;
            showUpdate = true;
            showDelete = true;
        }
        String entityName = (String)this.getView().getFormShowParameter().getCustomParam("entity");
        MainEntityType entity = EntityMetadataCache.getDataEntityType((String)entityName);
        Map ma = (Map)this.getView().getFormShowParameter().getCustomParam("A");
        Map mb = (Map)this.getView().getFormShowParameter().getCustomParam("B");
        StringBuilder html = new StringBuilder();
        html.append("<table padding='5' border='1'>");
        this.appendHeader(ma, mb, html);
        ViewCondition vc = new ViewCondition(showSame, showUpdate, showDelete, showAppend);
        this.appendContent("", ma, mb, html, (IDataEntityType)entity, entityName, vc);
        html.append("</table>");
        ((Html)this.getControl("content")).setConent(html.toString());
        this.showCount(vc);
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        String entityName = (String)this.getView().getFormShowParameter().getCustomParam("entity");
        MainEntityType entity = EntityMetadataCache.getDataEntityType((String)entityName);
        Map ma = (Map)this.getView().getFormShowParameter().getCustomParam("A");
        Map mb = (Map)this.getView().getFormShowParameter().getCustomParam("B");
        StringBuilder html = new StringBuilder();
        html.append("<table padding='5' border='1'>");
        this.appendHeader(ma, mb, html);
        ViewCondition vc = new ViewCondition(true, true, true, true);
        if (StringUtils.isNotEmpty((CharSequence)searchText)) {
            vc.setKeyWord(searchText);
            vc.setSearch(true);
        }
        this.appendContent("", ma, mb, html, (IDataEntityType)entity, entityName, vc, true);
        html.append("</table>");
        ((Html)this.getControl("content")).setConent(html.toString());
        this.showCount(vc);
        this.getPageCache().put("search", "1");
        this.getModel().setValue(NEW, (Object)Boolean.FALSE);
        this.getModel().setValue(UPDATE, (Object)Boolean.FALSE);
        this.getModel().setValue(DELETE, (Object)Boolean.FALSE);
        this.getPageCache().put("search", "0");
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ViewCondition vc = new ViewCondition(true, true, true, true);
        this.showForm(vc);
    }

    private void showForm(ViewCondition vc) {
        String entityName = (String)this.getView().getFormShowParameter().getCustomParam("entity");
        MainEntityType entity = EntityMetadataCache.getDataEntityType((String)entityName);
        Map ma = (Map)this.getView().getFormShowParameter().getCustomParam("A");
        Map mb = (Map)this.getView().getFormShowParameter().getCustomParam("B");
        StringBuilder html = new StringBuilder();
        html.append("<table padding='5' border='1'>");
        this.appendHeader(ma, mb, html);
        this.appendContent("", ma, mb, html, (IDataEntityType)entity, entityName, vc);
        html.append("</table>");
        ((Html)this.getControl("content")).setConent(html.toString());
        this.showCount(vc);
    }

    private void appendHeader(Map<String, Object> ma, Map<String, Object> mb, StringBuilder html) {
        html.append("<tr height='25px'><th width='30%'>");
        html.append(ResManager.loadKDString((String)"\u5b57\u6bb5", (String)"DiffCompFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        html.append("</th>");
        html.append("<th width='336px'>").append(this.getTitle(ma, "A")).append("</th>");
        html.append("<th width='336px'>").append(this.getTitle(mb, "B")).append("</th>");
        html.append("</tr>");
    }

    private Object getTitle(Map<String, Object> ma, String defaultTitle) {
        Object ta = ma.get("$version");
        if (ta == null) {
            ta = ma.get("modifytime");
        }
        return ta == null ? defaultTitle : ta;
    }

    private void appendContent(String prefix, Map<String, Object> ma, Map<String, Object> mb, StringBuilder html, IDataEntityType entity, String path, ViewCondition vc, boolean searchField) {
        String[] array;
        if (entity == null) {
            entity = this.findEntity(ma, mb, path);
        }
        for (String key : array = this.collectKeys(ma, mb)) {
            if (key.startsWith("$")) continue;
            Object a = ma.get(key);
            Object b = mb.get(key);
            String label = this.getLabel(entity, key);
            if (searchField ? !(prefix + label).contains(vc.getKeyWord()) : !(a instanceof Map) && !(a instanceof List) && vc.isSearch() && !(prefix + label).contains(vc.getKeyWord())) continue;
            this.doCompare(prefix, html, entity, path, vc, key, a, b, label);
        }
    }

    private void appendContent(String prefix, Map<String, Object> ma, Map<String, Object> mb, StringBuilder html, IDataEntityType entity, String path, ViewCondition vc) {
        this.appendContent(prefix, ma, mb, html, entity, path, vc, false);
    }

    private void doCompare(String prefix, StringBuilder html, IDataEntityType entity, String path, ViewCondition vc, String key, Object a, Object b, String label) {
        if (a == null) {
            this.handleAIsNull(prefix, html, entity, path, vc, key, b, label);
        } else if (b == null) {
            this.handleBIsNull(prefix, html, entity, path, vc, key, a, label);
        } else if (a instanceof Map && b instanceof Map) {
            this.appendContent(prefix + label + ".", (Map)a, (Map)b, html, this.getSubEntity(entity, key), path + "." + key, vc);
        } else if (a instanceof List && b instanceof List) {
            this.appendContent(prefix + label + ".", (List)a, (List)b, html, this.getSubEntity(entity, key), path + "." + key, vc);
        } else if (a.equals(b) && vc.showSame()) {
            this.appendSameContent(prefix, html, entity, key, a, b);
        } else {
            this.appendDiffContent(prefix, html, entity, key, a, b, vc);
        }
    }

    private void handleBIsNull(String prefix, StringBuilder html, IDataEntityType entity, String path, ViewCondition vc, String key, Object a, String label) {
        if (a instanceof Map) {
            this.appendContent(prefix + label + ".", (Map)a, Collections.emptyMap(), html, this.getSubEntity(entity, key), path + "." + key, vc);
        } else if (a instanceof List) {
            this.appendContent(prefix + label + ".", (List)a, Collections.emptyList(), html, this.getSubEntity(entity, key), path + "." + key, vc);
        } else if (vc.showDelete()) {
            vc.incDeleteCount(1);
            this.appendColumnA(prefix, html, key, a, entity);
        }
    }

    private void handleAIsNull(String prefix, StringBuilder html, IDataEntityType entity, String path, ViewCondition vc, String key, Object b, String label) {
        if (b == null) {
            if (vc.showSame()) {
                this.appendEmptyRow(prefix, label, html, entity);
            }
        } else if (b instanceof Map) {
            this.appendContent(prefix + label + ".", Collections.emptyMap(), (Map)b, html, this.getSubEntity(entity, key), path + "." + key, vc);
        } else if (b instanceof List) {
            this.appendContent(prefix + label + ".", Collections.emptyList(), (List)b, html, this.getSubEntity(entity, key), path + "." + key, vc);
        } else if (vc.showAppend()) {
            vc.incNewCount(1);
            this.appendColumnB(prefix, html, key, b, entity);
        }
    }

    private String[] collectKeys(Map<String, Object> ma, Map<String, Object> mb) {
        HashSet<String> keys = new HashSet<String>(ma.size() + mb.size());
        keys.addAll(ma.keySet());
        keys.addAll(mb.keySet());
        String[] array = keys.toArray(new String[keys.size()]);
        Arrays.sort(array, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                int p2;
                int p1 = this.getPriorities(s1);
                int c = Integer.compare(p1, p2 = this.getPriorities(s2));
                if (c != 0) {
                    return c;
                }
                return ((Collator)Feature.COLLATOR.get()).compare(s1, s2);
            }

            private int getPriorities(String s1) {
                Integer p1 = (Integer)priorities.get(s1);
                return p1 == null ? priorities.size() : p1.intValue();
            }
        });
        return array;
    }

    private IDataEntityType findEntity(Map<String, Object> ma, Map<String, Object> mb, String path) {
        return null;
    }

    private void appendDiffContent(String prefix, StringBuilder html, IDataEntityType entity, String key, Object a, Object b, ViewCondition vc) {
        String sa = a.toString();
        String sb = b.toString();
        if (sa.length() > 8000 && sb.length() > 8000) {
            if (sa.equals(sb)) {
                if (vc.showSame()) {
                    this.appendSameContent(prefix, html, entity, key, sa, sb);
                }
            } else {
                vc.incUpdateCount(1);
                html.append("<tr><td class='updatedA'>").append(prefix).append(this.getLabel(entity, key)).append("</td>");
                html.append("<td class='updatedA'>");
                html.append(DiffCompFormPlugin.escape(sa));
                html.append("</td>");
                html.append("<td class='updatedA'>");
                html.append(DiffCompFormPlugin.escape(sb));
                html.append("</td>");
                html.append("</tr>");
            }
            return;
        }
        Pair result = SourceComparator.compare((String)sa, (String)sb);
        if (((List)result.getA()).size() == 1 && Objects.equals(((Pair)((List)result.getA()).get(0)).getValue(), ((Pair)((List)result.getB()).get(0)).getValue())) {
            if (vc.showSame()) {
                this.appendSameContent(prefix, html, entity, key, a, b);
            }
        } else if (vc.showUpdate()) {
            vc.incUpdateCount(1);
            html.append("<tr><td class='updatedA'>").append(prefix).append(this.getLabel(entity, key)).append("</td>");
            html.append("<td class='updatedA'>");
            this.generateHTML((List)result.getA(), html);
            html.append("</td>");
            html.append("<td class='updatedA'>");
            this.generateHTML((List)result.getB(), html);
            html.append("</td>");
            html.append("</tr>");
        }
    }

    private void appendSameContent(String prefix, StringBuilder html, IDataEntityType entity, String key, Object a, Object b) {
        html.append("<tr><td>").append(prefix).append(this.getLabel(entity, key)).append("</td>");
        html.append("<td>").append(DiffCompFormPlugin.escape(a.toString())).append("</td>");
        html.append("<td>").append(DiffCompFormPlugin.escape(b.toString())).append("</td>");
        html.append("</tr>");
    }

    private IDataEntityType getSubEntity(IDataEntityType entity, String key) {
        if (entity == null) {
            return null;
        }
        Object p = entity.getProperties().get((Object)key);
        if (p == null) {
            return null;
        }
        if (p instanceof BasedataProp) {
            String id = ((BasedataProp)p).getBaseEntityId();
            return EntityMetadataCache.getDataEntityType((String)id);
        }
        if (p instanceof EntryProp) {
            return ((EntryProp)p).getItemType();
        }
        return null;
    }

    private void generateHTML(List<Pair<SourceComparator.Flag, String>> list, StringBuilder html) {
        for (Pair<SourceComparator.Flag, String> e : list) {
            html.append("<span class='").append(e.getA()).append("'>");
            html.append(DiffCompFormPlugin.escape((String)e.getB()));
            html.append("</span>");
        }
    }

    private void appendColumnA(String prefix, StringBuilder html, String key, Object a, IDataEntityType entity) {
        html.append("<tr><td class='deletedA'>").append(prefix).append(this.getLabel(entity, key)).append("</td>");
        html.append("<td class='deletedA'><span class='deleted'><span class='").append(SourceComparator.Flag.deleted).append("'>").append(DiffCompFormPlugin.escape(a.toString())).append("</span></span></td>");
        html.append("<td class='deletedA'></td>");
        html.append("</tr>");
    }

    private void appendColumnB(String prefix, StringBuilder html, String key, Object b, IDataEntityType entity) {
        html.append("<tr><td class='appendedA'>").append(prefix).append(this.getLabel(entity, key)).append("</td>");
        html.append("<td class='appendedA'></td>");
        html.append("<td class='appendedA'><span class='").append(SourceComparator.Flag.appended).append("'>").append(DiffCompFormPlugin.escape(b.toString())).append("</span></td>");
        html.append("</tr>");
    }

    private static String escape(String s) {
        if (s == null) {
            return "";
        }
        if (s.length() > 255) {
            return String.format("<B>%s</B>", ResManager.loadKDString((String)"#\u5185\u5bb9\u592a\u957f\uff0c\u4e0d\u663e\u793a#", (String)"DiffCompFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        StringBuilder sb = new StringBuilder();
        boolean priorIsCr = false;
        boolean priorIsBlank = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\'': {
                    sb.append("&apos;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\r': {
                    sb.append("<br/>");
                    break;
                }
                case '\n': {
                    if (priorIsCr) break;
                    sb.append("<br/>");
                    break;
                }
                case '\t': {
                    sb.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                    break;
                }
                case ' ': {
                    if (priorIsBlank) {
                        sb.append("&nbsp;");
                        break;
                    }
                    sb.append(' ');
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            priorIsCr = c == '\r';
            priorIsBlank = c == ' ';
        }
        return sb.toString();
    }

    private void appendContent(String prefix, List<Map<String, Object>> la, List<Map<String, Object>> lb, StringBuilder html, IDataEntityType entity, String path, ViewCondition vc) {
        if (this.isNotMap(la) || this.isNotMap(lb)) {
            this.appendDiffContent(prefix, html, entity, path, D.s(la), D.s(lb), vc);
            return;
        }
        if (this.hasDuplicatedIds(la) || this.hasDuplicatedIds(lb)) {
            this.uniquefiedIds(la);
            this.uniquefiedIds(lb);
        }
        HashMap<String, Map<String, Object>> mapping = new HashMap<String, Map<String, Object>>(la.size());
        for (Map<String, Object> a : la) {
            String id = D.s((Object)a.get("id"));
            mapping.put(id, a);
        }
        int index = 0;
        for (Map<String, Object> b : lb) {
            ++index;
            String id = D.s((Object)b.get("id"));
            Map a = (Map)mapping.remove(id);
            if (a != null) {
                this.appendContent(this.generatePrefix(prefix, index), a, b, html, entity, path, vc);
                continue;
            }
            this.appendContent(this.generatePrefix(prefix, index), Collections.emptyMap(), b, html, entity, path, vc);
        }
        for (Map<String, Object> a : mapping.values()) {
            this.appendContent(this.generatePrefix(prefix, ++index), a, Collections.emptyMap(), html, entity, path, vc);
        }
    }

    private boolean isNotMap(List<Map<String, Object>> lb) {
        boolean flag = false;
        for (Map<String, Object> map : lb) {
            if (map instanceof Map) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private boolean hasDuplicatedIds(List<Map<String, Object>> list) {
        HashSet<Object> ids = new HashSet<Object>(list.size());
        for (Map<String, Object> m : list) {
            Object id = m.get("id");
            if (id == null) {
                return true;
            }
            ids.add(id);
        }
        return ids.size() != list.size();
    }

    private void uniquefiedIds(List<Map<String, Object>> list) {
        int index = 0;
        for (Map<String, Object> m : list) {
            Object id = m.get("id");
            if (id == null) {
                m.put("id", ++index);
                continue;
            }
            StringBuilder s = new StringBuilder();
            s.append(id).append('.').append(++index);
            m.put("id", s.toString());
        }
    }

    private String generatePrefix(String prefix, int index) {
        StringBuilder s = new StringBuilder();
        if (prefix.length() == 0) {
            s.append('[').append(index).append(']');
        } else {
            s.append(prefix.substring(0, prefix.length() - 1));
            s.append('[').append(index).append(']').append('.');
        }
        return s.toString();
    }

    private void appendEmptyRow(String prefix, String key, StringBuilder html, IDataEntityType entity) {
        html.append("<tr><td>").append(prefix).append(this.getLabel(entity, key)).append("</td>");
        html.append("<td></td>");
        html.append("<td></td>");
        html.append("</tr>");
    }

    private String getLabel(IDataEntityType entity, String key) {
        if (entity == null) {
            return key;
        }
        IDataEntityProperty p = (IDataEntityProperty)entity.getProperties().get((Object)key);
        if (p == null) {
            return key;
        }
        String s = D.s((Object)p.getDisplayName());
        return s == null ? key : "<span title='" + key + "'>" + s + "</span>";
    }

    static {
        priorities.put("name", priorities.size());
        priorities.put("title", priorities.size());
        priorities.put("number", priorities.size());
        priorities.put("full_name", priorities.size());
        priorities.put("type", priorities.size());
        priorities.put("version", priorities.size());
        priorities.put("modifytime", priorities.size());
        priorities.put("id", priorities.size());
        priorities.put("coordinate", 2147483547);
        priorities.put("$id", 0x7FFFFFF5);
        priorities.put("$pk", 0x7FFFFFF6);
    }
}

