/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.tools;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.report.CellStyle;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.util.ExportUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.license.IscWhiteListState;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Triple;

public class IscResourceLicenseFormPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
HyperLinkClickListener {
    private static final String KEY_TREE = "treeviewap";
    private static final String ROOT_ID = "ROOT";
    private static final String ENTRY_ENTITY = "entryentity";
    private static Log logger = LogFactory.getLog(IscResourceLicenseFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        grid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initTree();
        this.showListData();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        AbstractOperate source = (AbstractOperate)evt.getSource();
        if ("export".equals(source.getOperateKey())) {
            EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
            int[] selectIndex = grid.getSelectRows();
            if (selectIndex.length == 0) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e", (String)"IscResourceLicenseFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            } else if (selectIndex.length <= 100 && ROOT_ID.equals(this.getFocusNodeId())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u5de6\u4fa7\u9009\u4e2d\u5177\u4f53\u7684\u8d44\u6e90\u7c7b\u578b\u540e\u518d\u9009\u62e9\u8d44\u6e90\u5bfc\u51fa", (String)"IscResourceLicenseFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String key = evt.getOperateKey();
        if ("refresh".equals(key)) {
            this.showListData();
        } else if ("isc_white_list".equals(key)) {
            QFilter qFilter = new QFilter("hash", "is not null", (Object)"");
            FormOpener.openBillList(this, "isc_white_list", Collections.singletonList(qFilter));
        } else if ("export".equals(key)) {
            Triple<Integer, Integer, Integer> exportSize = this.getExportSize();
            if ((Integer)exportSize.getB() <= 0) {
                this.doExport();
            } else if ((Integer)exportSize.getC() <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u4e2d\u7684\u6570\u636e\u5728\u767d\u540d\u5355\u5185\uff0c\u4e0d\u80fd\u5bfc\u51fa", (String)"IscResourceLicenseFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            } else {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("exportConfirm", (IFormPlugin)this);
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u4e86%1$s\u6761\u6570\u636e\uff0c\u5176\u4e2d%2$s\u6761\u5728\u767d\u540d\u5355\uff0c\u4e0d\u4f1a\u5bfc\u51fa\uff0c\u662f\u5426\u6267\u884c\u5269\u4e0b%3$s\u6761\u6570\u636e\u7684\u5bfc\u51fa\u64cd\u4f5c\uff1f", (String)"IscResourceLicenseFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), exportSize.getA(), exportSize.getB(), exportSize.getC()), MessageBoxOptions.YesNo, confirmCallBacks);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if ("exportConfirm".equals(e.getCallBackId()) && e.getResult() == MessageBoxResult.Yes) {
            this.doExport();
        }
    }

    private Triple<Integer, Integer, Integer> getExportSize() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] selectIndex = grid.getSelectRows();
        DynamicObject[] objects = grid.getEntryData().getDataEntitys();
        int whiteList = 0;
        for (int i : selectIndex) {
            boolean isWhiteList = objects[i].getBoolean("white_list");
            if (!isWhiteList) continue;
            ++whiteList;
        }
        return new Triple((Object)selectIndex.length, (Object)whiteList, (Object)(selectIndex.length - whiteList));
    }

    private void doExport() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] selectIndex = grid.getSelectRows();
        DynamicObject[] objects = grid.getEntryData().getDataEntitys();
        ArrayList<Object> ids = new ArrayList<Object>();
        int whiteList = 0;
        for (int i : selectIndex) {
            boolean isWhiteList = objects[i].getBoolean("white_list");
            if (isWhiteList) {
                ++whiteList;
                continue;
            }
            ids.add(D.l((Object)objects[i].get("spk")));
        }
        try {
            if (!ids.isEmpty()) {
                ExportUtil.exportDts(this, ids, this.getFocusNodeId());
            }
        }
        catch (Throwable e) {
            throw new IscBizException(e);
        }
    }

    private void initTree() {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE);
        treeView.deleteAllNodes();
        treeView.setMulti(false);
        int totalNums = this.getTotalNums();
        TreeNode root = new TreeNode("", ROOT_ID, String.format(ResManager.loadKDString((String)"\u5168\u90e8\uff08\u5171%s\u6761\uff09", (String)"IscResourceLicenseFormPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), totalNums));
        root.setExpend(true);
        List<TreeNode> nodes = this.getChildrenNodes();
        root.setChildren(nodes);
        root.setDisabled(true);
        treeView.addNode(root);
        treeView.setRootVisible(true);
        treeView.expand(ROOT_ID);
        treeView.focusNode(new TreeNode(ROOT_ID, "isc_data_copy", this.getEntityName("isc_data_copy")));
    }

    private int getTotalNums() {
        String sql = "select\n    (select count(1) from t_iscb_data_copy) +\n    (select count(1) from t_isc_service_flow) +\n    (select count(1) from t_iscb_apic_script) +\n    (select count(1) from t_iscb_external_api) +\n    (select count(1) from t_isc_dataschema where ftype='SERVICE' or ftype='QUERY') +\n    (select count(1) from t_iscb_apic_webapi)\nas \"sum\"";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            DataRow row = DbUtil.executeRow((Connection)cn, (String)sql);
            int n = D.i(row.toMap().get("sum"));
            return n;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u8d44\u6e90\u660e\u7ec6\u603b\u6570\u65f6\u53d1\u751f\u4e86\u5f02\u5e38\uff0cSQL\u662f" + sql, (Throwable)e);
            throw D.e((Throwable)e);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private List<TreeNode> getChildrenNodes() {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        nodes.add(new TreeNode(ROOT_ID, "isc_data_copy", this.getEntityName("isc_data_copy")));
        nodes.add(new TreeNode(ROOT_ID, "isc_service_flow", this.getEntityName("isc_service_flow")));
        nodes.add(new TreeNode(ROOT_ID, "isc_apic_script", this.getEntityName("isc_apic_script")));
        nodes.add(new TreeNode(ROOT_ID, "isc_apic_for_external_api", this.getEntityName("isc_apic_for_external_api")));
        nodes.add(new TreeNode(ROOT_ID, "isc_metadata_schema", this.getEntityName("isc_metadata_schema")));
        nodes.add(new TreeNode(ROOT_ID, "isc_apic_webapi", this.getEntityName("isc_apic_webapi")));
        nodes.add(new TreeNode(ROOT_ID, "iscx_resource", this.getEntityName("iscx_resource")));
        return nodes;
    }

    private String getEntityName(String entity) {
        return EntityMetadataCache.getDataEntityType((String)entity).getDisplayName().getLocaleValue();
    }

    private String getFocusNodeId() {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE);
        return treeView.getTreeState().getFocusNodeId();
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        grid.setPageIndex(1);
        if (!ROOT_ID.equals(this.getFocusNodeId())) {
            this.showListData();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        DynamicObject[] objects = grid.getEntryData().getDataEntitys();
        DynamicObject obj = objects[e.getRowIndex()];
        if ("iscx_resource".equals(obj.getString("type"))) {
            FormOpener.showView(this, "iscx_resource", obj.get("spk"));
        } else {
            FormOpener.showTabViewIfNotExist(this, obj.getString("type"), obj.get("spk"));
        }
    }

    private void showListData() {
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        entries.clear();
        Map<Long, String> whiteIdSet = this.getAllWhiteId();
        ArrayList<Map<String, Object>> resultData = new ArrayList<Map<String, Object>>(128);
        HashSet<Object> userPks = new HashSet<Object>();
        String sql = this.getSql();
        Connection cn = TX.__getConnection((String)"ISCB", (boolean)true);
        try {
            List dataRows = DbUtil.executeList((Connection)cn, (String)sql, Collections.emptyList(), Collections.emptyList());
            this.convertToList(dataRows, whiteIdSet, resultData, userPks);
        }
        catch (Exception e) {
            logger.error("\u8d44\u6e90\u8bb8\u53ef\u660e\u7ec6\u67e5\u8be2\u65f6\u53d1\u751f\u4e86\u5f02\u5e38", (Throwable)e);
            throw D.e((Throwable)e);
        }
        finally {
            DbUtil.close((Connection)cn);
        }
        Map<String, String> userNameMap = this.getUserNameMap(userPks);
        for (Map map : resultData) {
            DynamicObject entry = entries.addNew();
            entry.set("type", this.getValueFromMapIgnoreCase(map, "type"));
            entry.set("number", this.getValueFromMapIgnoreCase(map, "fnumber"));
            entry.set("name", this.getValueFromMapIgnoreCase(map, "fname"));
            entry.set("spk", this.getValueFromMapIgnoreCase(map, "fid"));
            entry.set("white_list", this.getValueFromMapIgnoreCase(map, "fwhite_list"));
            entry.set("license_state", this.getValueFromMapIgnoreCase(map, "fstate"));
            String creator = userNameMap.get(D.s(this.getValueFromMapIgnoreCase(map, "fcreatorid")));
            String modifier = userNameMap.get(D.s(this.getValueFromMapIgnoreCase(map, "fmodifierid")));
            entry.set("creator", (Object)creator);
            entry.set("createtime", this.getValueFromMapIgnoreCase(map, "fcreatetime"));
            entry.set("modifier", (Object)modifier);
            entry.set("modifytime", this.getValueFromMapIgnoreCase(map, "fmodifytime"));
        }
        Label label = (Label)this.getControl("total_nums");
        label.setText(String.format(ResManager.loadKDString((String)"\u5171%s\u6761", (String)"IscResourceLicenseFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), entries.size()));
        this.setFontColor(entries);
        this.getView().updateView(ENTRY_ENTITY);
    }

    private <T> T getValueFromMapIgnoreCase(Map<String, T> data, String key) {
        T value = data.get(key);
        if (value != null) {
            return value;
        }
        value = data.get(key.toLowerCase());
        if (value != null) {
            return value;
        }
        return data.get(key.toUpperCase());
    }

    private void setFontColor(DynamicObjectCollection entries) {
        ArrayList<CellStyle> styles = new ArrayList<CellStyle>(entries.size());
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject entry = (DynamicObject)entries.get(i);
            CellStyle cellStyle = new CellStyle();
            cellStyle.setRow(i);
            cellStyle.setFieldKey("license_state");
            Object license_status = entry.get("license_state");
            if (IscWhiteListState.NORMAL.name().equals(license_status)) {
                cellStyle.setForeColor("rgb(5,183,127)");
            } else {
                cellStyle.setForeColor("rgb(255,0,0)");
            }
            styles.add(cellStyle);
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        grid.setCellStyle(styles);
    }

    private Map<String, String> getUserNameMap(Set<Object> userPks) {
        DynamicObjectCollection users = QueryServiceHelper.query((String)"bos_user", (String)"id, name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)userPks.toArray())});
        HashMap<String, String> userNameMap = new HashMap<String, String>(16);
        for (DynamicObject u : users) {
            userNameMap.put(u.getString("id"), u.getString("name"));
        }
        return userNameMap;
    }

    private void convertToList(List<DataRow> dataRows, Map<Long, String> whiteIdSet, List<Map<String, Object>> resultData, Set<Object> userPks) {
        for (DataRow row : dataRows) {
            Object fmodifierid;
            Map map = row.toMap();
            Object fcreatorid = map.get("fcreatorid");
            if (fcreatorid != null) {
                userPks.add(fcreatorid);
            }
            if ((fmodifierid = map.get("fmodifierid")) != null) {
                userPks.add(fmodifierid);
            }
            String state = whiteIdSet.get(D.l(map.get("fid")));
            map.put("fstate", state);
            map.put("fwhite_list", whiteIdSet.containsKey(D.l(map.get("fid"))));
            resultData.add(map);
        }
    }

    private Map<Long, String> getAllWhiteId() {
        String sql;
        HashMap<Long, String> whiteIdMap = new HashMap<Long, String>();
        String nodeId = this.getFocusNodeId();
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        if (ROOT_ID.equals(nodeId)) {
            sql = "select fspk, fstate from t_isc_white_list";
        } else {
            sql = "select fspk, fstate from t_isc_white_list where ftype in (?,?,?,?,?,?,?)";
            values.add("isc_data_copy");
            values.add("isc_service_flow");
            values.add("isc_apic_script");
            values.add("isc_apic_for_external_api");
            values.add("isc_metadata_schema");
            values.add("isc_apic_webapi");
            values.add("iscx_resource");
            types.add(12);
            types.add(12);
            types.add(12);
            types.add(12);
            types.add(12);
            types.add(12);
            types.add(12);
        }
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            List whiteList = DbUtil.executeList((Connection)cn, (String)sql, values, types);
            for (DataRow row : whiteList) {
                whiteIdMap.put(D.l((Object)row.get((Object)"fspk")), D.s((Object)row.get((Object)"fstate")));
            }
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
        finally {
            DbUtil.close((Connection)cn);
        }
        return whiteIdMap;
    }

    public static Set<String> getDataSetField(DataSet dataSet) {
        Field[] fields = dataSet.getRowMeta().getFields();
        LinkedHashSet<String> fieldSet = new LinkedHashSet<String>(fields.length);
        for (Field field : fields) {
            String fieldName = field.getName();
            fieldSet.add(fieldName);
        }
        return fieldSet;
    }

    private String getSql() {
        String nodeId = this.getFocusNodeId();
        StringBuilder sql = new StringBuilder();
        if (ROOT_ID.equals(nodeId)) {
            sql.append(this.getDataCopySQL());
            sql.append("\nunion all\n");
            sql.append(this.getServiceFlowSQL());
            sql.append("\nunion all\n");
            sql.append(this.getApicScriptSQL());
            sql.append("\nunion all\n");
            sql.append(this.getExternalApiSQL());
            sql.append("\nunion all\n");
            sql.append(this.getMetadataSchemaSQL());
            sql.append("\nunion all\n");
            sql.append(this.getIscxResMain());
        } else if ("isc_data_copy".equals(nodeId)) {
            sql.append(this.getDataCopySQL());
        } else if ("isc_service_flow".equals(nodeId)) {
            sql.append(this.getServiceFlowSQL());
        } else if ("isc_apic_script".equals(nodeId)) {
            sql.append(this.getApicScriptSQL());
        } else if ("isc_apic_for_external_api".equals(nodeId)) {
            sql.append(this.getExternalApiSQL());
        } else if ("isc_metadata_schema".equals(nodeId)) {
            sql.append(this.getMetadataSchemaSQL());
        } else if ("isc_apic_webapi".equals(nodeId)) {
            sql.append(this.getWebapiSQL());
        } else if ("iscx_resource".equals(nodeId)) {
            sql.append(this.getIscxResMain());
        } else {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8d44\u6e90\u7c7b\u578b\uff1a%s", (String)"IscResourceLicenseFormPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), nodeId));
        }
        sql.append("\nORDER BY fmodifytime DESC");
        return sql.toString();
    }

    private String getDataCopySQL() {
        return "select 'isc_data_copy' as type, a.fid, a.fnumber, b.fname, a.fcreatorid, a.fcreatetime, a.fmodifierid, a.fmodifytime\n      from t_iscb_data_copy a,\n           t_iscb_data_copy_l b\n      where a.fid = b.fid\n            and flocaleid = 'zh_CN'";
    }

    private String getServiceFlowSQL() {
        return "select 'isc_service_flow' as type, a.fid, a.fnumber, b.fname, a.fcreatorid, a.fcreatetime, a.fmodifierid, a.fmodifytime\n         from t_isc_service_flow a,\n              t_isc_service_flow_l b\n         where a.fid = b.fid\n           and flocaleid = 'zh_CN'";
    }

    private String getApicScriptSQL() {
        return "select 'isc_apic_script' as type, a.fid, a.fnumber, b.fname, a.fcreatorid, a.fcreatetime, a.fmodifierid, a.fmodifytime\n         from t_iscb_apic_script a,\n              t_iscb_apic_script_l b\n         where a.fid = b.fid\n           and flocaleid = 'zh_CN'";
    }

    private String getExternalApiSQL() {
        return "select 'isc_apic_for_external_api' as type, a.fid, a.fnumber, b.fname, a.fcreatorid, a.fcreatetime, a.fmodifierid, a.fmodifytime\n         from t_iscb_external_api a,\n              t_iscb_external_api_l b\n         where a.fid = b.fid\n           and flocaleid = 'zh_CN'";
    }

    private String getMetadataSchemaSQL() {
        return "select 'isc_metadata_schema' as \"type\", a.fid, a.fnumber, b.fname, a.fcreatorid, a.fcreatetime, a.fmodifierid, a.fmodifytime\n         from t_isc_dataschema a,\n              t_isc_dataschema_l b\n         where a.fid = b.fid\n            and b.flocaleid = 'zh_CN'\n            and (a.ftype='SERVICE' or a.ftype='QUERY')";
    }

    private String getWebapiSQL() {
        return "select 'isc_apic_webapi' as \"type\", a.fid, a.fnumber, b.fname, a.fcreatorid, a.fcreatetime, a.fmodifierid, a.fmodifytime\n         from t_iscb_apic_webapi a,\n              t_iscb_apic_webapi_l b\n         where a.fid = b.fid\n            and b.flocaleid = 'zh_CN'\n";
    }

    private String getIscxResMain() {
        return "select 'iscx_resource' as \"type\", a.fid, a.fnumber, a.fname, a.fcreator, a.fcreatetime, a.fmodifier, a.fmodifytime\n         from t_iscx_res_main a";
    }
}

