/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.tools;

import java.text.DecimalFormat;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobState;
import kd.isc.iscb.util.dt.D;

public class JobExecutorFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{"btn_show_stacktrace"});
        Label label = (Label)this.getView().getControl("job_state");
        label.setText("");
        ProgressBar progressBar = (ProgressBar)this.getControl("job_progress");
        progressBar.setPercent(0, ResManager.loadKDString((String)"\u7b49\u5f85\u4e2d\u2026", (String)"JobExecutorFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        progressBar.start();
    }

    private long getJobId() {
        Object id = this.getView().getFormShowParameter().getCustomParam("jobId");
        return D.l((Object)id);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getView().getControl("job_progress");
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs a) {
        super.afterDoOperation(a);
        long jobId = this.getJobId();
        if ("terminate".equals(a.getOperateKey())) {
            JobEngine.cancel((long)jobId);
        } else if ("show_job".equals(a.getOperateKey())) {
            FormOpener.showSpecificSizeView(this, "isc_job_inst", jobId, "1170", "689");
        } else if ("show_stacktrace".equals(a.getOperateKey())) {
            this.handleStackTrace(jobId);
        }
    }

    private void handleStackTrace(long jobId) {
        String stack_trace = D.s((Object)this.getPageCache().get("stack_trace"));
        String state = this.getPageCache().get("state");
        if (stack_trace != null) {
            FormOpener.showErrorMessage(this.getView(), ResManager.loadKDString((String)"\u8bf7\u70b9\u51fb\u201c\u5c55\u5f00\u8be6\u60c5\u201d\u67e5\u770b\u8c03\u7528\u5806\u6808", (String)"JobExecutorFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), stack_trace);
            if (JobState.RUNNING.name().equals(state)) {
                this.getPageCache().remove("stack_trace");
                this.getPageCache().remove("requiresStackTrace");
            }
        } else if (JobState.RUNNING.name().equals(state)) {
            JobEngine.dumpStackTrace((long)jobId);
            this.getPageCache().put("requiresStackTrace", "true");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8f93\u51fa\u8c03\u7528\u5806\u6808\u7684\u8bf7\u6c42\u5df2\u53d1\u9001\uff0c\u8bf7\u7a0d\u5019\u518d\u6b21\u70b9\u51fb\u201c\u8c03\u7528\u5806\u6808\u201d\u6309\u94ae\u67e5\u770b\u3002", (String)"JobExecutorFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5806\u6808\u4fe1\u606f\uff0c\u8bf7\u70b9\u51fb\u201c\u540e\u53f0\u4efb\u52a1\u201d\u6309\u94ae\u4e86\u89e3\u672c\u4efb\u52a1\u7684\u76f8\u5173\u4fe1\u606f\u3002", (String)"JobExecutorFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    public void onProgress(ProgressEvent e) {
        long jobId = this.getJobId();
        boolean requiresStackTrace = "true".equals(this.getPageCache().get("requiresStackTrace"));
        Job.Progress progress = JobEngine.getProgress((long)jobId, (boolean)requiresStackTrace);
        ProgressBar progressBar = (ProgressBar)this.getControl("job_progress");
        if (progress == null) {
            e.setText(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5220\u9664", (String)"JobExecutorFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            e.setProgress(0);
            progressBar.stop();
        } else {
            String stackTrace = progress.getStackTrace();
            if (stackTrace != null) {
                this.getPageCache().put("stack_trace", stackTrace);
            }
            this.getPageCache().put("state", progress.getState().name());
            this.showProgress(e, progress, progressBar);
        }
    }

    private void showProgress(ProgressEvent e, Job.Progress progress, ProgressBar progressBar) {
        this.showJobDescription(progress);
        this.showStackTrace(progress);
        this.refreshJobState(e, progress, progressBar);
    }

    private void refreshJobState(ProgressEvent e, Job.Progress progress, ProgressBar progressBar) {
        switch (progress.getState()) {
            case RUNNING: {
                double v = Math.min(99.99, (double)progress.getCompletedWork() * 100.0 / (double)progress.getTotalWork());
                e.setProgress(Math.min(99, (int)v));
                e.setText(new DecimalFormat("00.00").format(v) + "%");
                this.getView().setEnable(Boolean.TRUE, new String[]{"btn_show_stacktrace"});
                break;
            }
            case TERMINATED: {
                e.setText(ResManager.loadKDString((String)"\u5df2\u64a4\u9500", (String)"JobExecutorFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                progressBar.stop();
                this.getView().setEnable(Boolean.FALSE, new String[]{"btncancel", "btn_show_stacktrace"});
                break;
            }
            case COMPLETE: {
                e.setText(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"JobExecutorFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                e.setProgress(100);
                this.getView().setEnable(Boolean.FALSE, new String[]{"btncancel", "btn_show_stacktrace"});
                break;
            }
            case FAILED: {
                e.setText(ResManager.loadKDString((String)"\u5df2\u5931\u8d25", (String)"JobExecutorFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                progressBar.stop();
                this.getView().setEnable(Boolean.TRUE, new String[]{"btn_show_stacktrace"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"btncancel"});
                break;
            }
            default: {
                this.getView().setEnable(Boolean.FALSE, new String[]{"btn_show_stacktrace"});
            }
        }
    }

    private void showJobDescription(Job.Progress progress) {
        Label label = (Label)this.getView().getControl("job_state");
        label.setText(progress.getDescription());
    }

    private void showStackTrace(Job.Progress progress) {
        String stack_trace = D.s((Object)progress.getStackTrace());
        if (stack_trace != null) {
            switch (progress.getState()) {
                case RUNNING: {
                    this.getPageCache().remove("requiresStackTrace");
                    FormOpener.showErrorMessage(this.getView(), ResManager.loadKDString((String)"\u5806\u6808\u4fe1\u606f\u5df2\u83b7\u53d6\uff0c\u8bf7\u70b9\u51fb\u201c\u5c55\u5f00\u8be6\u60c5\u201d\u67e5\u770b\u8be6\u7ec6\u5185\u5bb9\u3002", (String)"JobExecutorFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), stack_trace);
                    return;
                }
                case FAILED: {
                    FormOpener.showErrorMessage(this.getView(), ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5df2\u5931\u8d25\uff0c\u8bf7\u70b9\u51fb\u201c\u5c55\u5f00\u8be6\u60c5\u201d\u67e5\u770b\u8be6\u7ec6\u5185\u5bb9\u3002", (String)"JobExecutorFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), stack_trace);
                    break;
                }
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getView().returnDataToParent((Object)customParams);
    }
}

