/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.tools;

import com.alibaba.fastjson.JSON;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.robot.SmartRobotChatFormPlugin;
import kd.isc.iscb.formplugin.robot.SmartRobotUtil;
import kd.isc.iscb.formplugin.robot.SmartScriptTypeEnum;
import kd.isc.iscb.formplugin.tools.AbstractScriptEditorFormPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.ShowStackTraceUtil;
import kd.isc.iscb.platform.core.debug.ScriptDebugCoordinator;
import kd.isc.iscb.platform.core.mapping.bean.PropertyModel;
import kd.isc.iscb.platform.core.mapping.util.PropertyUtil;
import kd.isc.iscb.platform.core.util.FileUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.encoding.PseudoBase64;
import kd.isc.iscb.util.script.feature.tool.string.IsQname;

public class NewSceneScriptExecuteFromPlugin
extends AbstractScriptEditorFormPlugin {
    private static final String CMD_QUERY_EXAMPLE_CODE = "query_example_code";
    private static final String CMD_INSERT_SCRIPT_EXAMPLE = "insert_script_example";
    private static final String CMD_SEND_COSMIC_MSG = "send_cosmic_msg";
    private static final String CMD_GET_COSMIC_MSG = "get_cosmic_msg";
    private static final String CMD_SEND_COSMIC_REPORT = "send_cosmic_report";
    private static final String CMD_GET_COSMIC_REPORT = "get_cosmic_report";
    private static final String CLEAN_SCRIPT = "clean_script";
    private static final String CMD_GET_SCRIPT_DATA = "get_script_data";
    private static final String CMD_RETURN_SCRIPT_DATA = "return_script_data";
    private static final String CMD_NEW_TAB_EDITOR = "new_tab_editor";
    private static final String CMD_TIPS_SHOW_HELPER = "tips_show_helper";
    private static final String CMD_VALIDATE_AI_AVAILABLE = "validate_ai_available";
    private static final Log LOG = LogFactory.getLog(SmartRobotChatFormPlugin.class);
    private static final Map<String, String> TIPS_MSG = new HashMap<String, String>();
    private static final Log LOGGER = LogFactory.getLog(NewSceneScriptExecuteFromPlugin.class);

    @Override
    public void beforeBindData(EventObject e) {
        String env = (String)this.getView().getFormShowParameter().getCustomParam("env");
        String remark = (String)this.getView().getFormShowParameter().getCustomParam("remark");
        CustomControl c = (CustomControl)this.getControl("common_script_editorv2");
        boolean enableRobot = false;
        if ("data_copy_mapping_script".equals(env)) {
            enableRobot = this.isSmartRobotEnabled();
        }
        boolean editable = this.getEditable();
        if (c != null) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("context", this.getContext());
            data.put("scene", env);
            data.put("remark", remark);
            data.put("helper", this.getCodeHelperTree());
            data.put("editable", editable);
            data.put("height", this.getHeight());
            data.put("width", this.getWidth());
            data.put("script", this.getScript());
            data.put("enableRobot", enableRobot);
            c.setData(data);
        }
        String operate = (String)this.getView().getFormShowParameter().getCustomParam("operate");
        this.getView().setVisible(Boolean.valueOf(!"new_tab".equals(operate)), new String[]{"goto_tab"});
        this.getView().setEnable(Boolean.valueOf(editable), new String[]{"btn_ok", "btn_clean"});
        if (!editable) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u811a\u672c\u4e3a\u67e5\u770b\u6001\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"ScriptEditorPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        if (enableRobot) {
            try {
                long source_schema = D.l((Object)this.getView().getFormShowParameter().getCustomParam("source_schema"));
                long target_schema = D.l((Object)this.getView().getFormShowParameter().getCustomParam("target_schema"));
                String srcMetaDesc = NewSceneScriptExecuteFromPlugin.buildMetaSmartDesc(source_schema);
                String tarMetaDesc = NewSceneScriptExecuteFromPlugin.buildMetaSmartDesc(target_schema);
                this.getPageCache().put("srcMetaDesc", srcMetaDesc);
                this.getPageCache().put("tarMetaDesc", tarMetaDesc);
                long gaiPromptId = SmartScriptTypeEnum.DataCopyTransScriptEX.getGaiPromptId();
                this.getPageCache().put("gaiPromptId", D.s((Object)gaiPromptId));
                this.getPageCache().put("chatSessionId", UUID.randomUUID().toString());
            }
            catch (Throwable e1) {
                LOGGER.warn("\u521d\u59cb\u5316\u673a\u5668\u4eba\u4fe1\u606f\u5931\u8d25,\u6682\u4e0d\u652f\u6301\u8c03\u7528AI\u5fae\u670d\u52a1\u3002");
            }
        }
    }

    @Override
    public void customEvent(CustomEventArgs e) {
        String event = e.getEventName();
        String eventArgs = e.getEventArgs();
        if (CMD_QUERY_EXAMPLE_CODE.equals(event)) {
            if (null != eventArgs && eventArgs.contains("leaf")) {
                this.queryExampleCode(eventArgs);
            }
        } else if (CMD_SEND_COSMIC_MSG.equals(event)) {
            Map<String, Object> resp = this.sendCosmicMsg(eventArgs, this.getGenSceneDesc());
            if (null != resp) {
                this.afterInvokeGpt(CMD_GET_COSMIC_MSG, resp);
            }
        } else if (CMD_SEND_COSMIC_REPORT.equals(event)) {
            Map<String, Object> resp = this.sendCosmicMsg(eventArgs, this.getParseSceneDesc());
            if (null != resp) {
                this.afterInvokeGpt(CMD_GET_COSMIC_REPORT, resp);
            }
        } else if (CMD_RETURN_SCRIPT_DATA.equals(event)) {
            Map map = (Map)Json.toObject((String)eventArgs);
            String script = PseudoBase64.decode((String)((String)map.get("script")));
            String remark = D.s(map.get("remark"));
            this.handleScript(script, remark);
        } else if (CMD_NEW_TAB_EDITOR.equals(event)) {
            Map map = (Map)Json.toObject((String)eventArgs);
            String script = PseudoBase64.decode((String)((String)map.get("script")));
            String remark = D.s(map.get("remark"));
            Map params = this.getView().getFormShowParameter().getCustomParams();
            HashMap<String, String> returns = new HashMap<String, String>(params);
            returns.put("script", script);
            returns.put("remark", remark);
            returns.put("operate", "new_tab");
            this.getView().returnDataToParent(returns);
            this.getView().close();
        } else if (CMD_TIPS_SHOW_HELPER.equals(event)) {
            Map params = this.getView().getFormShowParameter().getCustomParams();
            FormOpener.showForm(this, "isc_online_helper_view", params);
        } else if (CMD_VALIDATE_AI_AVAILABLE.equals(event)) {
            this.validateAiAvailable();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok", "btn_clean", "goto_tab"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btn_ok".equals(key)) {
            this.returnDataToCustomControl(CMD_GET_SCRIPT_DATA, null);
        } else if ("btn_clean".equals(key)) {
            this.returnDataToCustomControl(CLEAN_SCRIPT, null);
            this.clearScriptAndReturn();
        } else if ("goto_tab".equals(key)) {
            this.returnDataToCustomControl(CMD_NEW_TAB_EDITOR, null);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
    }

    private boolean checkScriptValid(String script) {
        try {
            Script.compile((String)script);
            return true;
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), String.format(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u5185\u5bb9\u4e0d\u5408\u6cd5\uff0c\u9519\u8bef\u539f\u56e0\uff1a%s", (String)"ScriptEditorPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), e.getMessage()), ShowStackTraceUtil.getErrorMsg(e));
            return false;
        }
    }

    private String checkMqScriptValid(String remark, String script) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String plugin_name = D.s(params.get("plugin_name"));
        String errorMsg = TIPS_MSG.get(plugin_name);
        if (errorMsg == null) {
            return errorMsg;
        }
        if (D.s((Object)script) != null) {
            return script.contains("return") ? null : errorMsg;
        }
        return remark.contains("return") ? null : errorMsg;
    }

    protected void handleScript(String script, String remark) {
        if (remark == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5907\u6ce8\u201d\u3002", (String)"ScriptEditorPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!this.checkScriptValid(script)) {
            return;
        }
        String checkMqScriptValid = this.checkMqScriptValid(remark, script);
        if (checkMqScriptValid != null) {
            this.getView().showTipNotification(checkMqScriptValid);
            return;
        }
        Map params = this.getView().getFormShowParameter().getCustomParams();
        HashMap<String, String> returns = new HashMap<String, String>(params);
        returns.put("script", script);
        returns.put("remark", remark);
        returns.remove("operate");
        this.getView().returnDataToParent(returns);
        this.getView().close();
    }

    private void clearScriptAndReturn() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        HashMap returns = new HashMap(params);
        returns.put("script", null);
        returns.put("remark", null);
        returns.remove("operate");
        this.getView().returnDataToParent(returns);
        this.getView().close();
    }

    private void returnDataToCustomControl(String cmd, Object info) {
        HashMap<String, Object> data = new HashMap<String, Object>(3);
        data.put("cmd", cmd);
        data.put("id", UUID.randomUUID().toString());
        data.put("info", info);
        ((CustomControl)this.getControl("common_script_editorv2")).setData(data);
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
    }

    @Override
    protected int getHeight() {
        return 670;
    }

    @Override
    protected int getWidth() {
        return 1350;
    }

    private String getGroup() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String group = this.getView().getEntityId();
        if (!"isc_sf_script_node_editor".equals(group)) {
            group = D.s(customParams.get("plugin_name"));
        }
        if ("isc_call_api_by_mq".equals(group) || "isc_call_api_by_evt".equals(group) || "isc_call_api_by_timer".equals(group)) {
            group = "api_task";
        }
        return group;
    }

    private void addNodeToLeaf(TreeNode root, Map<String, List<DynamicObject>> scriptMap, List<TreeNode> leafTreeNodes) {
        List<DynamicObject> script = scriptMap.get(root.getId());
        if (script != null) {
            ArrayList<TreeNode> childNodeList = new ArrayList<TreeNode>(script.size());
            for (DynamicObject object : script) {
                TreeNode node = new TreeNode();
                node.setText("</> " + D.s((Object)object.get("name")));
                node.setId("leaf_" + D.s((Object)object.get("id")));
                node.setParentid(root.getId());
                childNodeList.add(node);
            }
            leafTreeNodes.addAll(childNodeList);
            root.setChildren(childNodeList);
        }
    }

    public void addScriptIntoTree(TreeNode root, Map<String, List<DynamicObject>> scriptMap, List<TreeNode> leafTreeNodes) {
        if (scriptMap == null || scriptMap.size() == 0) {
            return;
        }
        if (root.getChildren() == null) {
            this.addNodeToLeaf(root, scriptMap, leafTreeNodes);
        } else {
            for (TreeNode node : root.getChildren()) {
                this.addScriptIntoTree(node, scriptMap, leafTreeNodes);
            }
        }
    }

    private List<Object> fillTree(TreeNode root, DynamicObjectCollection collection) {
        ArrayList<TreeNode> childNodeList = new ArrayList<TreeNode>(collection.size());
        ArrayList<Object> groupList = new ArrayList<Object>(collection.size());
        for (DynamicObject dynamicObject : collection) {
            String childId = D.s((Object)dynamicObject.get("number"));
            String childName = D.s((Object)dynamicObject.get("name"));
            groupList.add(dynamicObject.get("id"));
            TreeNode childNode = new TreeNode(root.getId(), childId, childName);
            childNodeList.add(childNode);
        }
        root.setChildren(childNodeList);
        return groupList;
    }

    public List<Object> buildScriptGroup(TreeNode root, String group) {
        root.setIsOpened(true);
        DynamicObjectCollection scriptSort = QueryServiceHelper.query((String)"isc_script_scene", (String)"name,number,id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)group).or(new QFilter("number", "=", (Object)"for_common")).or(new QFilter("number", "=", (Object)"common_function"))});
        if (scriptSort != null && !scriptSort.isEmpty()) {
            return this.fillTree(root, scriptSort);
        }
        return Collections.emptyList();
    }

    public Map<String, List<DynamicObject>> getAllScript(List<Object> groupList) {
        DynamicObjectCollection scriptSort = QueryServiceHelper.query((String)"isc_script_example", (String)"name,group.number,id,group.id", (QFilter[])new QFilter[]{new QFilter("group.id", "in", groupList)});
        HashMap<String, List<DynamicObject>> map = new HashMap<String, List<DynamicObject>>(10);
        if (scriptSort != null && !scriptSort.isEmpty()) {
            for (DynamicObject object : scriptSort) {
                String key = object.getString("group.number");
                ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)map.get(key);
                if (list == null) {
                    list = new ArrayList<DynamicObject>();
                    list.add(object);
                    map.put(key, list);
                    continue;
                }
                list.add(object);
            }
        }
        return map;
    }

    private TreeNode getCodeHelperTree() {
        String group = this.getGroup();
        TreeNode root = new TreeNode("", "ROOT", ResManager.loadKDString((String)"\u5168\u90e8", (String)"ScriptExampleTreeFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        root.setIsOpened(true);
        List<Object> groupList = this.buildScriptGroup(root, group);
        Map<String, List<DynamicObject>> allScript = this.getAllScript(groupList);
        ArrayList<TreeNode> leafTreeNodes = new ArrayList<TreeNode>(allScript.size());
        this.addScriptIntoTree(root, allScript, leafTreeNodes);
        return root;
    }

    private boolean getEditable() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params.get("view") != null && ((Boolean)params.get("view")).booleanValue()) {
            return false;
        }
        if ("VIEW".equals(D.s(params.get("billStatus")))) {
            return false;
        }
        Object editable = this.getView().getFormShowParameter().getCustomParam("editable");
        return editable == null ? true : D.x((Object)editable);
    }

    private String getScript() {
        String script = D.s((Object)this.getView().getFormShowParameter().getCustomParam("script"));
        return script == null ? "" : script;
    }

    private void queryExampleCode(String id) {
        QFilter qFilter = new QFilter("id", "=", (Object)D.l((Object)id.replace("leaf_", "")));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"isc_script_example", (String)"id,script_code_tag", (QFilter[])new QFilter[]{qFilter});
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("script", "\n//" + ResManager.loadKDString((String)"\u5f00\u59cb", (String)"ScriptExampleTreeFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) + "\n" + dynamicObject.getString("script_code_tag") + "\n//" + ResManager.loadKDString((String)"\u7ed3\u675f", (String)"ScriptExampleTreeFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) + "\n");
        data.put("time", System.currentTimeMillis());
        this.returnDataToCustomControl(CMD_INSERT_SCRIPT_EXAMPLE, data);
    }

    private List<Map<String, String>> readEnvTips() {
        String env = (String)this.getView().getFormShowParameter().getCustomParam("env");
        if (env == null) {
            env = "tool";
        }
        return NewSceneScriptExecuteFromPlugin.readResource("iscb/script/isc/context.js", Collections.emptyList(), env);
    }

    private boolean isSmartRobotEnabled() {
        QFilter qFilter = new QFilter("number", "=", (Object)SmartScriptTypeEnum.DataCopyTransScriptEX.getNumber());
        qFilter.and("enable", "=", (Object)"1");
        return QueryServiceHelper.exists((String)"isc_smart_robot", (QFilter[])new QFilter[]{qFilter});
    }

    private Collection<String> getContextVariables() {
        Set<String> vars = (Set<String>)this.getView().getFormShowParameter().getCustomParam("context_variables");
        return vars != null ? vars : Collections.emptySet();
    }

    private List<Map<String, Object>> getDynamicTips() {
        List<Map<String, Object>> tips = (List<Map<String, Object>>)this.getView().getFormShowParameter().getCustomParam("dynamic_tips");
        return tips != null ? tips : Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readStringResource(String path) {
        FileUtil.checkFilePath((String)path);
        InputStream in = ScriptDebugCoordinator.class.getClassLoader().getResourceAsStream(path);
        try {
            if (in == null) {
                String string = "";
                return string;
            }
            String string = NetUtil.readText((InputStream)in);
            return string;
        }
        finally {
            DbUtil.close((InputStream)in);
        }
    }

    private Map<String, Object> getContext() {
        Map ScriptContextMap = NewSceneScriptExecuteFromPlugin.readResource("iscb/script/isc/scriptv2_context.js", new HashMap(50));
        String libSource = this.readStringResource("iscb/script/isc/lifescript_api.d.ts");
        List commonSuggestions = NewSceneScriptExecuteFromPlugin.readResource("iscb/script/isc/suggestions.js", new ArrayList());
        Collection<String> allContextVariables = this.getContextVariables();
        List<Map<String, String>> tips = this.readEnvTips();
        List<Map<String, Object>> dynamicTips = this.getDynamicTips();
        ArrayList<Map> suggestions = new ArrayList<Map>();
        ArrayList<String> apis = new ArrayList<String>(20);
        HashMap<String, Object> context = new HashMap<String, Object>(4);
        for (String string : allContextVariables) {
            if (!IsQname.valid((Object)string).booleanValue()) continue;
            Map suggestion = (Map)ScriptContextMap.get(string);
            if (null != suggestion) {
                suggestions.add(suggestion);
                continue;
            }
            apis.add(string);
        }
        for (Map map : tips) {
            String mapKey = ((String)map.get("text")).replace(";", "");
            if (allContextVariables.contains(mapKey)) continue;
            Map suggestion = (Map)ScriptContextMap.get(mapKey);
            if (null != suggestion) {
                suggestions.add(suggestion);
                continue;
            }
            apis.add(mapKey);
        }
        suggestions.addAll(commonSuggestions);
        context.put("suggestions", suggestions);
        context.put("apis", apis);
        context.put("mapping", dynamicTips);
        context.put("libSource", libSource);
        return context;
    }

    private String getGenSceneDesc() {
        return ResManager.loadKDString((String)"\u4f60\u662f\u4e00\u4e2aDSL\u751f\u6210\u5de5\u5177\uff0c\u4e0d\u8981\u4f7f\u7528JavaScript\u8bed\u6cd5\uff0c\u8bf7\u4e25\u683c\u6839\u636e\u4ee5\u4e0b\u63d0\u4f9b\u7684\u8bed\u6cd5\u751f\u6210\u811a\u672c\uff0c\u53ea\u9700\u8981\u8fd4\u56de\u751f\u6210\u7684\u811a\u672c\u548c\u811a\u672c\u91cc\u7684\u6ce8\u91ca\uff0c\u5982\u679c\u65e0\u6cd5\u751f\u6210\u8bf7\u8bf4\u660e\u539f\u56e0", (String)"SmartRobotChatFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
    }

    private String getParseSceneDesc() {
        return ResManager.loadKDString((String)"\u4f60\u662f\u4e00\u4e2aDSL\u68c0\u67e5\u5de5\u5177\uff0c\u6839\u636e\u4ee5\u4e0b\u8bed\u6cd5\u68c0\u67e5\u7528\u6237\u7684\u811a\u672c\u662f\u5426\u5b58\u5728\u95ee\u9898\uff0c\u5e76\u7ed9\u51fa\u4fee\u6539\u610f\u89c1\uff1a", (String)"SmartRobotChatFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
    }

    private void validateAiAvailable() {
        if (D.x((Object)this.getPageCache().get("PolicyAgreeRecords"))) {
            HashMap<String, Boolean> data = new HashMap<String, Boolean>(3);
            data.put("policyAgree", true);
            this.returnDataToCustomControl(CMD_VALIDATE_AI_AVAILABLE, data);
        } else {
            Boolean result = (Boolean)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPrivacyService", (String)"isUserAgree", (Object[])new Object[0]);
            if (result.booleanValue()) {
                this.getPageCache().put("PolicyAgreeRecords", "true");
                HashMap<String, Boolean> data = new HashMap<String, Boolean>(3);
                data.put("policyAgree", true);
                this.returnDataToCustomControl(CMD_VALIDATE_AI_AVAILABLE, data);
            } else {
                this.getView().getPageCache().put("showAgreement", "true");
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("gai_privacy_agreement");
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                fsp.setCustomParam("agreementType", (Object)"userAgreement");
                this.getView().showForm(fsp);
                HashMap<String, Boolean> data = new HashMap<String, Boolean>(3);
                data.put("policyAgree", false);
                this.returnDataToCustomControl(CMD_VALIDATE_AI_AVAILABLE, data);
            }
        }
    }

    private Map<String, Object> sendCosmicMsg(String text, String sceneDesc) {
        String chatSessionId = this.getPageCache().get("chatSessionId");
        if (StringUtil.isEmpty((String)text)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u63cf\u8ff0\u60a8\u7684\u9700\u6c42", (String)"SmartRobotChatFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return null;
        }
        Map<String, String> promptInputMap = this.getPromptInputMap(sceneDesc);
        LOG.warn("AI\u8c03\u7528\u7684\u8f93\u5165\u662f\uff0cchatSessionId\uff1a" + chatSessionId + "\n" + Json.toString(promptInputMap, (boolean)true));
        Map resp = (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)"syncCallUseHistoryMsg", (Object[])new Object[]{chatSessionId, D.l((Object)this.getPageCache().get("gaiPromptId")), text, promptInputMap});
        LOG.warn("AI\u8fd4\u56de\u7684\u7ed3\u679c\u662f\uff1a" + Json.toString((Object)resp, (boolean)true));
        return resp;
    }

    public void afterInvokeGpt(String command, Map<String, Object> resp) {
        HashMap<String, Object> aiResultInfo = new HashMap<String, Object>(2);
        String aiResult = SmartRobotUtil.formatAiResp(resp);
        aiResultInfo.put("message", aiResult);
        aiResultInfo.put("time", System.currentTimeMillis());
        this.returnDataToCustomControl(command, aiResultInfo);
    }

    public Map<String, String> getPromptInputMap(String sceneDesc) {
        HashMap<String, String> promptInput = new HashMap<String, String>();
        promptInput.put("src", this.getPageCache().get("srcMetaDesc"));
        promptInput.put("tar", this.getPageCache().get("tarMetaDesc"));
        promptInput.put("scene", sceneDesc);
        return promptInput;
    }

    public static String buildMetaSmartDesc(long id) {
        if (id > 0L) {
            Map propModels = PropertyUtil.initPropertyMap((long)id, (String)"", (String)"");
            Collection values = propModels.values();
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(values.size());
            for (PropertyModel tarProp : values) {
                NewSceneScriptExecuteFromPlugin.buildOneProp(map, tarProp);
            }
            return JSON.toJSONString(map);
        }
        return "";
    }

    public static void buildOneProp(Map<String, Object> map, PropertyModel prop) {
        Map childProps = prop.getChildProps();
        if (!childProps.isEmpty()) {
            LinkedHashMap<String, Object> subMap = new LinkedHashMap<String, Object>();
            for (PropertyModel value : childProps.values()) {
                NewSceneScriptExecuteFromPlugin.buildOneProp(subMap, value);
            }
            map.put(prop.getName(), subMap);
        } else {
            map.put(prop.getName(), prop.getDetailedDesc());
        }
    }

    static {
        TIPS_MSG.put("isc_mq_subscriber_reader", ResManager.loadKDString((String)"\u6ce8\u610f\uff1a\u811a\u672c\u5fc5\u987b\u4ee5 \u201creturn result_var; \u201d\u8bed\u53e5\u5728\u811a\u672c\u7ed3\u675f\u6267\u884c\u65f6\u660e\u786e\u8fd4\u56de\u5904\u7406\u540e\u7684\u6d88\u606f\u6570\u636e\uff1b\u5982\u679c\u4ee5\u201creturn null;\u201d \u7ed3\u675f\u811a\u672c\u7684\u6267\u884c\u5219\u53ef\u4ee5\u5ffd\u7565\u5f53\u524d\u6d88\u606f\u7684\u8ba2\u9605\uff1b\u5982\u679c\u4e0d\u4ee5 return \u8bed\u53e5\u660e\u786e\u8fd4\u56de\u5904\u7406\u7ed3\u679c\uff0c\u6d88\u606f\u8ba2\u9605\u7684\u6700\u7ec8\u7ed3\u679c\u4e0d\u53ef\u9884\u6d4b\u3002", (String)"ScriptEditorPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        TIPS_MSG.put("isc_mq_bill_data_pub_reader", ResManager.loadKDString((String)"\u6ce8\u610f\uff1a\u811a\u672c\u5fc5\u987b\u4ee5 \u201creturn result_var; \u201d\u8bed\u53e5\u5728\u811a\u672c\u7ed3\u675f\u6267\u884c\u65f6\u660e\u786e\u8fd4\u56de\u9700\u8981\u53d1\u5e03\u7684\u6d88\u606f\u6570\u636e\uff1b\u5982\u679c\u4ee5\u201creturn null;\u201d \u7ed3\u675f\u811a\u672c\u7684\u6267\u884c\u5219\u53ef\u4ee5\u5ffd\u7565\u5f53\u524d\u6d88\u606f\u7684\u53d1\u5e03\uff1b\u5982\u679c\u4e0d\u4ee5 return \u8bed\u53e5\u660e\u786e\u8fd4\u56de\u5904\u7406\u7ed3\u679c\uff0c\u6d88\u606f\u53d1\u5e03\u7684\u6700\u7ec8\u7ed3\u679c\u4e0d\u53ef\u9884\u6d4b\u3002", (String)"ScriptEditorPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        TIPS_MSG.put("isc_mq_bill_data_sub_reader", ResManager.loadKDString((String)"\u6ce8\u610f\uff1a\u811a\u672c\u5fc5\u987b\u4ee5 \u201creturn result_var; \u201d\u8bed\u53e5\u5728\u811a\u672c\u7ed3\u675f\u6267\u884c\u65f6\u660e\u786e\u8fd4\u56de\u9884\u5904\u7406\u540e\u7684\u6d88\u606f\u6570\u636e\uff1b\u5982\u679c\u4ee5\u201creturn null;\u201d \u7ed3\u675f\u811a\u672c\u7684\u6267\u884c\u5219\u53ef\u4ee5\u5ffd\u7565\u5f53\u524d\u6d88\u606f\u7684\u8ba2\u9605\uff1b\u5982\u679c\u4e0d\u4ee5 return \u8bed\u53e5\u660e\u786e\u8fd4\u56de\u5904\u7406\u7ed3\u679c\uff0c\u6d88\u606f\u8ba2\u9605\u7684\u6700\u7ec8\u7ed3\u679c\u4e0d\u53ef\u9884\u6d4b\u3002", (String)"ScriptEditorPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }
}

