/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.tools;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.SystemProperties;
import kd.isc.iscb.formplugin.dc.InstanceInfo;
import kd.isc.iscb.formplugin.dc.LicenseInfo;
import kd.isc.iscb.formplugin.dc.RunningTasks;
import kd.isc.iscb.formplugin.dc.ScheduledTasks;
import kd.isc.iscb.formplugin.tools.AbstractScriptEditorFormPlugin;
import kd.isc.iscb.formplugin.tools.ScriptDebuggerFormPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.ShowStackTraceUtil;
import kd.isc.iscb.platform.core.IscScript;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.connector.self.BotpServiceInvoker;
import kd.isc.iscb.platform.core.connector.self.MicroServiceInvoker;
import kd.isc.iscb.platform.core.connector.self.MicroServiceInvoker2;
import kd.isc.iscb.platform.core.connector.self.SelfConnection;
import kd.isc.iscb.platform.core.connector.self.StartEventDataCopy;
import kd.isc.iscb.platform.core.connector.self.StartEventServiceFlow;
import kd.isc.iscb.platform.core.dc.e.FlatObjectToMapOrList;
import kd.isc.iscb.platform.core.dc.e.v.a.BizQueryFunction;
import kd.isc.iscb.platform.core.dc.e.v.a.CalcEasPwd;
import kd.isc.iscb.platform.core.dc.e.v.a.DecodeFunction;
import kd.isc.iscb.platform.core.dc.e.v.a.EncodeFunction;
import kd.isc.iscb.platform.core.debug.ScriptDebugCache;
import kd.isc.iscb.platform.core.fn.openapi.OpenAPIToolKit;
import kd.isc.iscb.platform.core.fn.orm.ORMToolKit;
import kd.isc.iscb.platform.core.sf.Resource;
import kd.isc.iscb.platform.core.sf.func.InvokeAction;
import kd.isc.iscb.platform.core.sf.func.InvokeActionWithParams;
import kd.isc.iscb.platform.core.sf.parser.ResourceCategory;
import kd.isc.iscb.platform.core.sf.res.DataSourceResource;
import kd.isc.iscb.platform.core.task.LightTask;
import kd.isc.iscb.platform.core.task.LightTaskManager;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.platform.core.trace.Caller;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.FileUtil;
import kd.isc.iscb.platform.core.util.TimeUtil;
import kd.isc.iscb.util.connector.s.ExecuteBatch;
import kd.isc.iscb.util.connector.s.ExecuteCall;
import kd.isc.iscb.util.connector.s.ExecuteUpdate;
import kd.isc.iscb.util.connector.s.QueryList;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.encoding.PseudoBase64;
import kd.isc.iscb.util.script.feature.control.loop.Throw;
import kd.isc.iscb.util.script.feature.sql.SqlRuntime;
import kd.isc.iscb.util.trace.TraceTask;

public class NewScriptExecuteFormPlugin
extends AbstractScriptEditorFormPlugin {
    private static final String OPER_EXECUTE_FOR_NEW = "execute_for_new";
    private static final String OPER_EXECUTE_AND_DOWNLOAD = "execute_and_download";
    private static final String OPER_SHOW_LOGS = "viewlog";
    private static final String OPER_DEBUG = "debug";
    private static final String CMD_GET_SELECT_LINK = "get_select_link";
    private static final String CMD_GET_SELECT_RESOURCE = "get_select_resource";
    private static final String CMD_PWD_ERROR = "pwd_error";
    private static final String CMD_PWD_SUCCESS = "pwd_success";
    private static final String CMD_DOWNLOAD_RESULT = "download_result";
    private static final String CMD_RETURN_SELECT_LINK = "return_select_link";
    private static final String CMD_RETURN_SELECT_RESOURCE = "return_select_resource";
    private static final String CMD_RETURN_EDITOR_RESULT = "return_editor_result";
    private static final String CMD_VALIDATE_PWD = "validate_pwd";
    private static final String CMD_DEBUG_RUNNING = "debug_running";

    @Override
    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String event = e.getEventName();
        String eventArgs = e.getEventArgs();
        if (CMD_GET_SELECT_LINK.equals(event)) {
            FormOpener.showF7(this, "isc_database_link", CMD_RETURN_SELECT_LINK, false);
        } else if (CMD_GET_SELECT_RESOURCE.equals(event) && eventArgs != null) {
            if ("isc_service_flow".equals(eventArgs)) {
                FormOpener.showF7(this, eventArgs, CMD_RETURN_SELECT_RESOURCE, false);
            } else if ("isc_apic_for_external_api".equals(eventArgs)) {
                NewScriptExecuteFormPlugin.showF7(this, eventArgs, null, CMD_RETURN_SELECT_RESOURCE, "isc_external_api_f7", false);
            } else {
                FormOpener.showF7((AbstractFormPlugin)this, eventArgs, CMD_RETURN_SELECT_RESOURCE, false, true);
            }
        } else if (CMD_DOWNLOAD_RESULT.equals(event)) {
            this.downloadResult(eventArgs, this.getView());
        } else if (CMD_VALIDATE_PWD.equals(event)) {
            if (!this.validatePWD(D.s((Object)eventArgs)).booleanValue()) {
                this.returnDataToCustomControl(CMD_PWD_ERROR, null);
            } else {
                this.returnDataToCustomControl(CMD_PWD_SUCCESS, null);
            }
        }
    }

    private Boolean validatePWD(String password) {
        if (password == null) {
            return false;
        }
        String pwd = PseudoBase64.decode((String)password);
        String required_password = D.s((Object)SystemProperties.getWithEnv((String)"ISC_TEST_PASSWORD"));
        if (required_password == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u96c6\u6210\u6d4b\u8bd5\u5bc6\u7801\u672a\u8bbe\u7f6e!", (String)"ScriptExecuteFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!required_password.equals(pwd)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bc6\u7801\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u586b\u5199", (String)"NewScriptExecuteFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        Object data = evt.getReturnData();
        if (action == null || data == null) {
            return;
        }
        ListSelectedRowCollection rows = (ListSelectedRowCollection)data;
        if (CollectionUtils.isEmpty((Collection)rows)) {
            return;
        }
        ListSelectedRow row = rows.get(0);
        String id = D.s((Object)row.getPrimaryKeyValue());
        String number = row.getNumber();
        String name = row.getName();
        if (CMD_RETURN_SELECT_LINK.equals(action)) {
            long dbLinkId = D.l((Object)row.getPrimaryKeyValue());
            String connName = this.getConnNameByID(dbLinkId);
            HashMap<String, String> dbLinkInfo = new HashMap<String, String>(4);
            dbLinkInfo.put("connection", id);
            dbLinkInfo.put("number", number);
            dbLinkInfo.put("type", connName);
            dbLinkInfo.put("name", name);
            this.returnDataToCustomControl(CMD_RETURN_SELECT_LINK, dbLinkInfo);
        } else if (CMD_RETURN_SELECT_RESOURCE.equals(action)) {
            HashMap<String, String> resourceInfo = new HashMap<String, String>(3);
            resourceInfo.put("res_ref", id);
            resourceInfo.put("number", number);
            resourceInfo.put("name", name);
            this.returnDataToCustomControl(CMD_RETURN_SELECT_RESOURCE, resourceInfo);
        }
    }

    private void returnDataToCustomControl(String cmd, Object info) {
        HashMap<String, Object> data = new HashMap<String, Object>(3);
        data.put("cmd", cmd);
        data.put("id", UUID.randomUUID().toString());
        data.put("info", info);
        ((CustomControl)this.getControl("editor")).setData(data);
    }

    private String getConnNameByID(long dbLinkId) {
        QFilter filter = new QFilter("id", "=", (Object)dbLinkId);
        DynamicObject dbLink = BusinessDataServiceHelper.loadSingle((String)"isc_database_link", (String)"database_type", (QFilter[])new QFilter[]{filter});
        String type = dbLink.getString("database_type");
        DynamicObject conn = BusinessDataServiceHelper.loadSingle((String)"isc_connection_type", (String)"name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)type)});
        return conn.getString("name");
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operationKey = evt.getOperateKey();
        if (StringUtils.equals((CharSequence)OPER_EXECUTE_FOR_NEW, (CharSequence)operationKey) || StringUtils.equals((CharSequence)OPER_EXECUTE_AND_DOWNLOAD, (CharSequence)operationKey)) {
            if (RequestContext.get().getUserId().equals(ScriptDebugCache.getDebugUserId())) {
                this.debugScript();
            } else {
                this.executeScriptByOperation(operationKey);
            }
        } else if (StringUtils.equals((CharSequence)OPER_SHOW_LOGS, (CharSequence)operationKey)) {
            FormOpener.openExistedBillList(this, "isc_sql_exe_log", null);
        } else if (OPER_DEBUG.equals(operationKey) && ScriptDebuggerFormPlugin.enableDebug(this)) {
            this.debugScript();
        }
    }

    private void executeScriptByOperation(String operationKey) {
        if (OPER_EXECUTE_FOR_NEW.equals(operationKey)) {
            this.getView().invokeOperation("get_script_data");
        } else if (OPER_EXECUTE_AND_DOWNLOAD.equals(operationKey)) {
            this.getView().invokeOperation("get_script_data_dl");
        }
    }

    private void debugScript() {
        FormOpener.showAppIdTabForm(this, "isc_script_debugger", ResManager.loadKDString((String)"\u811a\u672c\u8c03\u8bd5\u5668", (String)"ScriptExecuteFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), new HashMap<String, Object>());
        this.returnDataToCustomControl(CMD_DEBUG_RUNNING, null);
    }

    @Override
    protected int getHeight() {
        return 540;
    }

    @Override
    protected int getWidth() {
        return 900;
    }

    @Override
    protected void handleScript(String script) {
        this.executeScript(script);
    }

    private void executeScript(String data) {
        Map map = (Map)Json.toObject((String)data);
        String script = PseudoBase64.decode((String)((String)map.get("script")));
        String password = D.s(map.get("pwd"));
        List dblinks = (List)map.get("links");
        List resources = (List)map.get("source");
        boolean download = D.x(map.get("download"));
        if (password != null && !this.validatePWD(password).booleanValue()) {
            this.returnDataToCustomControl(CMD_PWD_ERROR, null);
            return;
        }
        this.execute(script, password, dblinks, resources, download);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String script, String password, List<Map<String, Object>> dblinks, List<Map<String, Object>> resources, boolean download) {
        long start = System.currentTimeMillis();
        ArrayList<ConnectionWrapper> cns = new ArrayList<ConnectionWrapper>();
        try {
            final Map<String, Object> ctx = this.prepareConnections(cns, password, dblinks, resources);
            final Script p = IscScript.compile((String)script, ctx);
            this.prepareBeforeEval(password, p);
            Object result = TraceStack.trace((Caller)Caller.Front, (TraceTask)new TraceTask(){

                public Object invoke() {
                    DataSourceResource.createConnectionPool();
                    try {
                        Object object;
                        SignalManager.registerTask((String)RequestContext.get().getUserId());
                        try {
                            object = p.eval(ctx);
                        }
                        catch (Throwable throwable) {
                            SignalManager.unregisterTask((String)RequestContext.get().getUserId());
                            throw throwable;
                        }
                        SignalManager.unregisterTask((String)RequestContext.get().getUserId());
                        return object;
                    }
                    finally {
                        DataSourceResource.disposeConnectionPool();
                    }
                }
            });
            this.handleResult(start, result, download);
        }
        catch (Throwable e) {
            long end = System.currentTimeMillis();
            String errorMsg = ShowStackTraceUtil.getErrorMsg(e);
            this.setResult(false, errorMsg, start, end);
        }
        finally {
            String links = this.closeConnections(cns);
            String res = StringUtil.trim((String)this.collectResources(resources), (int)1999);
            this.saveLog(script, links, res);
        }
    }

    private void handleResult(long start, Object result, boolean download) {
        long end = System.currentTimeMillis();
        String s = Throw.toMessage((Object)result);
        this.setResult(true, s, start, end);
        if (download) {
            this.downloadResult(s, this.getView());
        }
    }

    private void downloadResult(String s, IFormView view) {
        if (s == null) {
            return;
        }
        if (this.isResultOverSize(s)) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String format = sdf.format(new Date());
        try (ByteArrayInputStream input = new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8));){
            String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(String.format(ResManager.loadKDString((String)"\u811a\u672c\u6267\u884c\u5de5\u5177_%s.txt", (String)"ScriptExecuteFormPlugin_25", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), format), (InputStream)input, 300);
            FileUtil.addDownloadPermission((String)"isc_script_tool", (String)urls, (String)view.getFormShowParameter().getServiceAppId());
            view.openUrl(urls);
        }
        catch (Exception e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"ScriptExecuteFormPlugin_26", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    private boolean isResultOverSize(String s) {
        int maxSize;
        long objectSize = DbUtil.getObjectSize((Object)s);
        if (objectSize >= (long)(maxSize = QueryList.getResultSetMaxSize())) {
            FormOpener.showMessage(this, ResManager.loadKDString((String)"\u4e0b\u8f7d\u5185\u5bb9\u8d85\u51fa\u7cfb\u7edf\u5141\u8bb8\u4e0a\u9650", (String)"ScriptExecuteFormPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u811a\u672c\u6267\u884c\u7ed3\u679c\u7684\u603b\u5b57\u8282\u6570\u5df2\u7ecf\u8d85\u8fc7\u5141\u8bb8\u4e0b\u8f7d\u7684\u6700\u5927\u503c%s\u4e2a\u5b57\u8282\uff0c\u5efa\u8bae\u89e3\u51b3\u529e\u6cd5\uff1a\u4f18\u5316\u6267\u884c\u811a\u672c\uff1b\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8c03\u6574JVM\u7cfb\u7edf\u53c2\u6570 ISC_QUERY_MAX_SIZE \u589e\u52a0\u4e0a\u9650\u3002", (String)"ScriptExecuteFormPlugin_27", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), maxSize));
            return true;
        }
        return false;
    }

    private String collectResources(List<Map<String, Object>> resources) {
        ArrayList result = new ArrayList();
        if (resources != null) {
            for (Map<String, Object> resource : resources) {
                if (StringUtils.isEmpty((CharSequence)D.s((Object)resource.get("res_category")))) continue;
                HashMap<String, Object> res = new HashMap<String, Object>(3);
                res.put("type", resource.get("res_category"));
                res.put("number", resource.get("number"));
                res.put("alias", resource.get("res_alias"));
                result.add(res);
            }
        }
        return Json.toString(result);
    }

    private void prepareBeforeEval(String password, Script p) {
        if (password == null) {
            p.setTimeout(3000);
        } else {
            p.setTimeout(60000);
        }
        String debugUser = ScriptDebugCache.getDebugUserId();
        if (debugUser == null) {
            this.attachBreakpointAtAll(p);
        } else if (debugUser.equals(RequestContext.get().getUserId())) {
            this.attachBreakpointAtSome(p);
            p.setTimeout(1800000);
        }
    }

    private void attachBreakpointAtAll(Script p) {
        int lines = p.getProgram().getScriptReader().lineCount();
        for (int i = 1; i <= lines; ++i) {
            p.getProgram().attachBreakpoint(i);
        }
    }

    private void attachBreakpointAtSome(Script p) {
        int i;
        int lines = p.getProgram().getScriptReader().lineCount();
        for (i = 1; i <= lines && !p.getProgram().attachBreakpoint(i); ++i) {
        }
        for (i = 1; i <= 5; ++i) {
            p.getProgram().attachBreakpoint(i);
        }
    }

    private void setResult(boolean isSuccess, String result, long start, long end) {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");
        String tips = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u6267\u884c\u5f00\u59cb\u4e8e\uff1a%1$s\uff0c\u7ed3\u675f\u4e8e\uff1a%2$s\uff0c\r\n\u8017\u65f6\uff1a%3$s\u6beb\u79d2\uff0c\u7ed3\u679c\uff1a", (String)"ScriptExecuteFormPlugin_29", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), TimeUtil.getInteTime((Date)D.t((Object)start), (SimpleDateFormat)df), TimeUtil.getInteTime((Date)D.t((Object)end), (SimpleDateFormat)df), end - start);
        HashMap<String, Object> info = new HashMap<String, Object>(3);
        info.put("tips", tips);
        info.put("originalRes", this.trim(result, 100000));
        info.put("isSuccess", isSuccess);
        this.returnDataToCustomControl(CMD_RETURN_EDITOR_RESULT, info);
    }

    private Object trim(String s, int max) {
        if (s == null) {
            return "null";
        }
        if (s.length() > max) {
            return s.substring(0, max) + "...";
        }
        return s;
    }

    private void saveLog(final String script, final String links, final String resources) {
        LightTaskManager.submit((LightTask)new LightTask(){
            private String id = UUID.randomUUID().toString();

            public void run() {
                NewScriptExecuteFormPlugin.this.saveExecuteLog(links, script, resources);
            }

            public String getId() {
                return this.id;
            }
        });
    }

    private String closeConnections(List<ConnectionWrapper> cns) {
        DbUtil.close((Connection)SqlRuntime.getCurrent(), (boolean)false);
        SqlRuntime.setCurrent(null);
        StringBuilder links = new StringBuilder();
        for (ConnectionWrapper cn : cns) {
            links.append(cn.getConfig().get("number")).append(';');
            ConnectorUtil.close((AutoCloseable)cn);
        }
        return links.length() == 0 ? "$this" : (links.length() <= 50 ? links.toString() : links.toString().substring(1, 48) + "..");
    }

    private Map<String, Object> prepareConnections(List<ConnectionWrapper> cns, String password, List<Map<String, Object>> dblinks, List<Map<String, Object>> resources) {
        HashMap<String, Object> ctx = new HashMap<String, Object>(8);
        ctx.put("encode", new EncodeFunction());
        ctx.put("decode", new DecodeFunction());
        ctx.put("LicenseInfo", new LicenseInfo());
        ctx.put("InstanceInfo", new InstanceInfo());
        ctx.put("calc_eas_pwd", new CalcEasPwd());
        ctx.put("ScheduledTasks", new ScheduledTasks());
        ctx.put("RunningTasks", new RunningTasks());
        if (password == null) {
            return ctx;
        }
        HashSet<String> alias_set = new HashSet<String>();
        this.setConnections(cns, ctx, alias_set, dblinks);
        this.setResources(ctx, alias_set, resources);
        SelfConnection cn = new SelfConnection();
        SqlRuntime.setCurrent((Connection)cn);
        ctx.put("$this", cn);
        ctx.put("execute_update", new ExecuteUpdate(true));
        ctx.put("execute_call", new ExecuteCall());
        ctx.put("execute_batch", new ExecuteBatch());
        ctx.put("bizQuery", new BizQueryFunction());
        ctx.put("IERP_BOTP", new BotpServiceInvoker());
        ctx.put("invokeMicroService", new MicroServiceInvoker());
        ctx.put("invokeMicroService2", new MicroServiceInvoker2());
        ctx.put("flatObjectToMapOrList", new FlatObjectToMapOrList());
        ctx.put("StartEventServiceFlow", new StartEventServiceFlow());
        ctx.put("StartEventDataCopy", new StartEventDataCopy());
        ctx.put("ORM", new ORMToolKit());
        ctx.put("$action", new InvokeAction());
        ctx.put("$action2", new InvokeActionWithParams());
        ctx.put("OpenAPI", new OpenAPIToolKit());
        return ctx;
    }

    private void setResources(Map<String, Object> ctx, Set<String> alias_set, List<Map<String, Object>> resources) {
        if (resources != null) {
            for (Map<String, Object> resource : resources) {
                String s = ((String)resource.get("res_category")).toUpperCase();
                ResourceCategory category = ResourceCategory.valueOf((String)s);
                Resource res = NewScriptExecuteFormPlugin.create(resource, category);
                String alias = D.s((Object)resource.get("res_alias"));
                this.checkAndAddSet(alias_set, alias);
                ctx.put(alias, res);
            }
        }
    }

    private void setConnections(List<ConnectionWrapper> cns, Map<String, Object> ctx, Set<String> alias_set, List<Map<String, Object>> dblinks) {
        if (dblinks != null) {
            for (Map<String, Object> dblink : dblinks) {
                ConnectionWrapper cn = ConnectionManager.getConnection((long)D.l((Object)dblink.get("connection")));
                cns.add(cn);
                ctx.put(D.s((Object)dblink.get("number")), cn);
                String alias = D.s((Object)dblink.get("alias"));
                this.checkAndAddSet(alias_set, alias);
                ctx.put(alias, cn);
            }
        }
    }

    private void checkAndAddSet(Set<String> alias_set, String alias) {
        if (alias_set.contains(alias)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u3010\u7cfb\u7edf\u8fde\u63a5\u3011\u5206\u5f55\u548c\u3010\u4f9d\u8d56\u8d44\u6e90\u3011\u5206\u5f55\u4e2d\u522b\u540d\u3010%s\u3011\u5b58\u5728\u91cd\u590d\u503c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ScriptExecuteFormPlugin_31", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), alias));
        }
        alias_set.add(alias);
    }

    private static Resource create(Map<String, Object> resource, ResourceCategory category) {
        long id = D.l((Object)resource.get("res_ref"));
        String name = D.s((Object)resource.get("number"));
        String title = D.s((Object)resource.get("name"));
        return category.create(id, name, title);
    }

    private void saveExecuteLog(String dataSource, String script, String resources) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"isc_sql_exe_log");
        log.set("data_source", (Object)(dataSource == null ? "{none}" : dataSource));
        log.set("sql", (Object)script);
        log.set("creator", (Object)RequestContext.get().getUserId());
        log.set("createtime", (Object)Timestamp.valueOf(LocalDateTime.now()));
        log.set("resources", (Object)resources);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }

    public static void showF7(AbstractFormPlugin form, String entity, QFilter[] filters, String callback, String formId, boolean multiSelect) {
        ListShowParameter param = new ListShowParameter();
        param.setBillFormId(entity);
        param.setFormId(formId);
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        param.getOpenStyle().setInlineStyleCss(css);
        param.setLookUp(true);
        param.setShowTitle(false);
        param.setMultiSelect(multiSelect);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)form, callback));
        if (filters != null && filters.length > 0) {
            param.getListFilterParameter().setQFilters(Arrays.asList(filters));
        }
        form.getView().showForm((FormShowParameter)param);
    }
}

