/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.tools;

import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Html;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.formplugin.tools.AbstractScriptEditorFormPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.debug.ScriptDebugCache;
import kd.isc.iscb.platform.core.debug.ScriptDebugSignal;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.misc.Xml;

public class ScriptDebuggerFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (ScriptDebuggerFormPlugin.enableDebug(this)) {
            this.saveTimestamps();
            this.clearEntries();
            this.setButtonsEnabled();
            this.initScriptEditor();
        }
    }

    private void initScriptEditor() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        Map keywords = AbstractScriptEditorFormPlugin.readResource("iscb/script/global/keys.js", Collections.emptyMap());
        data.put("keywords", keywords);
        data.put("all_keys", Collections.emptyMap());
        data.put("tips", Collections.emptyList());
        data.put("editable", Boolean.FALSE);
        data.put("for_debugger", Boolean.TRUE);
        data.put("height", 300);
        data.put("width", 1000);
        data.put("script", "Debugger is ready.");
        ((CustomControl)this.getControl("editor")).setData(data);
    }

    private void clearEntries() {
        DynamicObjectCollection breakpoints = this.getView().getModel().getDataEntity().getDynamicObjectCollection("breakpoints");
        breakpoints.clear();
        this.getView().getModel().getDataEntity(true).set("breakpoints", (Object)breakpoints);
        DynamicObjectCollection logs = this.getView().getModel().getDataEntity().getDynamicObjectCollection("logs");
        logs.clear();
        this.getView().getModel().getDataEntity(true).set("logs", (Object)logs);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        Object op = e.getSource();
        if (op instanceof Donothing && "enable_debug".equals(((Donothing)op).getOperateKey())) {
            if (ScriptDebuggerFormPlugin.enableDebug(this)) {
                this.saveTimestamps();
                this.setButtonsEnabled();
            } else {
                e.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String op = e.getOperateKey();
        if ("disable_debug".equals(op)) {
            this.disableDebug();
        } else if ("close".equals(op)) {
            this.disableDebug();
            this.getView().close();
        } else if ("resume".equals(op)) {
            this.resume();
        } else if ("eval_expr".equals(op)) {
            this.evalExpr(null);
        } else if ("terminate".equals(op)) {
            this.evalExpr("shut down");
        } else if ("clear_logs".equals(op)) {
            ScriptDebugCache.clearLogs();
        } else if ("terminate_script_test".equals(op)) {
            SignalManager.sendCancelSignal((String)RequestContext.get().getUserId());
        }
    }

    private void resume() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("breakpoints");
        int[] rows = entryGrid.getSelectRows();
        if (rows.length != 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e14\u4ec5\u9009\u62e9\u4e00\u4e2a\u65ad\u70b9\u3002", (String)"ScriptDebuggerFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            String id = (String)this.getModel().getValue("breakpointid", rows[0]);
            ScriptDebugSignal.resume((String)id);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65ad\u70b9\u7ee7\u7eed\u6267\u884c\u547d\u4ee4\u5df2\u53d1\u9001\uff0c\u8bf7\u7a0d\u5019...", (String)"ScriptDebuggerFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1));
        }
    }

    private void evalExpr(String command) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("breakpoints");
        int[] rows = entryGrid.getSelectRows();
        if (rows.length != 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e14\u4ec5\u9009\u62e9\u4e00\u4e2a\u65ad\u70b9\u3002", (String)"ScriptDebuggerFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            String id = (String)this.getModel().getValue("breakpointid", rows[0]);
            String expr = command != null ? command : D.s((Object)this.getModel().getValue("expr"));
            ScriptDebugSignal.setExpr((String)id, (String)expr);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6c42\u503c\u547d\u4ee4\u5df2\u53d1\u9001\uff0c\u8bf7\u7a0d\u5019...", (String)"ScriptDebuggerFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        }
    }

    private void disableDebug() {
        ScriptDebugCache.disableDebug();
        this.clearEntries();
        this.clearHtmlControls();
        this.getView().updateView("tabap");
        ((ProgressBar)this.getControl("progressor")).stop();
        this.getView().setEnable(Boolean.TRUE, new String[]{"btn_enable_debug"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"btn_disable_debug"});
    }

    public static boolean enableDebug(AbstractFormPlugin form) {
        String debugUser = ScriptDebugCache.getDebugUserId();
        if (debugUser == null || debugUser.equals(RequestContext.get().getUserId())) {
            ScriptDebugCache.enableDebug();
            return true;
        }
        FormOpener.showMessage(form, ResManager.loadKDString((String)"\u811a\u672c\u8c03\u8bd5", (String)"ScriptDebuggerFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"%s \u6b63\u5728\u8c03\u8bd5\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ScriptDebuggerFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ScriptDebugCache.getDebugUser()));
        return false;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ScriptDebugCache.setLogsIgnored((boolean)D.x((Object)this.getModel().getValue("ignore_logs")));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((ProgressBar)this.getView().getControl("progressor")).addProgressListener((ProgresssListener)this);
        ((Tab)this.getView().getControl("tabap")).addTabSelectListener(new TabSelectListener(){

            public void tabSelected(TabSelectEvent e) {
                ScriptDebuggerFormPlugin.this.clearHtmlControls();
                if ("tab_log".equals(e.getTabKey())) {
                    ((EntryGrid)ScriptDebuggerFormPlugin.this.getView().getControl("logs")).selectRows(new int[0], 0);
                }
            }
        });
        ((EntryGrid)this.getView().getControl("logs")).addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent e) {
                int row = e.getRow();
                ScriptDebuggerFormPlugin form = ScriptDebuggerFormPlugin.this;
                String script = (String)form.getModel().getValue("log_script_tag", row);
                ((Html)form.getView().getControl("script")).setConent(String.format("<pre>%s", ResManager.loadKDString((String)"\u811a\u672c\uff1a", (String)"ScriptDebuggerFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])) + "\r\n\r\n" + String.format("%s</pre>", Xml.escape((String)script)));
                String data = (String)form.getModel().getValue("log_data_tag", row);
                ((Html)form.getView().getControl("content")).setConent(String.format("<pre>%s", ResManager.loadKDString((String)"\u6570\u636e\uff1a", (String)"ScriptDebuggerFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])) + "\r\n\r\n" + String.format("%s</pre>", Xml.escape((String)data)));
            }
        });
        ((EntryGrid)this.getView().getControl("breakpoints")).addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent e) {
                ScriptDebuggerFormPlugin form = ScriptDebuggerFormPlugin.this;
                ScriptDebuggerFormPlugin.this.clearHtmlControls();
                String breakpointid = (String)form.getModel().getValue("breakpointid", e.getRow());
                if (breakpointid != null) {
                    ScriptDebuggerFormPlugin.this.showBreakpointInfo(breakpointid);
                }
            }
        });
    }

    public void onProgress(ProgressEvent arg0) {
        ScriptDebugCache.enableDebug();
        this.refreshLogs();
        this.refreshBreakpoints();
    }

    private void refreshBreakpoints() {
        long newTs = System.currentTimeMillis();
        long oldTs = D.l((Object)this.getPageCache().get("bkpTs"));
        Collection breakpoints = ScriptDebugCache.getBreakpoints((long)oldTs);
        if (breakpoints != null) {
            this.getPageCache().put("bkpTs", String.valueOf(newTs));
            this.showBreakpoints(breakpoints);
            this.refreshExprResult();
        }
    }

    private void refreshLogs() {
        long newTs = System.currentTimeMillis();
        long oldTs = D.l((Object)this.getPageCache().get("logsTs"));
        Collection logs = ScriptDebugCache.getDebugLogs((long)oldTs);
        if (logs != null) {
            this.getPageCache().put("logsTs", String.valueOf(newTs));
            this.showLogs(logs);
            this.clearHtmlControls();
        }
    }

    private void saveTimestamps() {
        this.getPageCache().put("logsTs", "0");
        this.getPageCache().put("bkpTs", "0");
    }

    private void refreshExprResult() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("breakpoints");
        int[] rows = entryGrid.getSelectRows();
        if (rows.length == 1) {
            String id = (String)this.getModel().getValue("breakpointid", rows[0]);
            String expr = D.s((Object)this.getModel().getValue("expr"));
            if (expr != null) {
                String result = ScriptDebugCache.getExprResult((String)id, (String)expr);
                if (result != null) {
                    ((Html)this.getView().getControl("content")).setConent(String.format("<pre>%s", ResManager.loadKDString((String)"\u7ed3\u679c\uff1a", (String)"ScriptDebuggerFormPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])) + "\r\n\r\n" + String.format("%s</pre>", Xml.escape((String)result)));
                } else {
                    this.clearHtmlControls();
                }
            }
        }
    }

    private void clearScriptBreakpoints() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("cmd", "set_script_data");
        data.put("id", UUID.randomUUID().toString());
        data.put("script", "    ");
        data.put("breakpoints", Collections.emptyList());
        ((CustomControl)this.getControl("editor")).setData(data);
    }

    private void showBreakpoints(Collection<Map<String, Object>> breakpoints) {
        String breakpointId = this.getSelectedBreakpointId();
        String program = this.getSelectedProgram();
        String selectedBreakpointId = breakpointId;
        DynamicObjectCollection entries = this.getView().getModel().getDataEntity().getDynamicObjectCollection("breakpoints");
        entries.clear();
        int selected = -1;
        int index = 0;
        for (Map<String, Object> log : breakpoints) {
            DynamicObject item = entries.addNew();
            item.set("breakpoint_time", (Object)D.t((Object)log.get("time")));
            item.set("breakpoint_thread", log.get("thread"));
            item.set("breakpoint_script", (Object)D.s((Object)log.get("script_short")));
            item.set("breakpoint_script_tag", log.get("script_long"));
            item.set("breakpoint_line", log.get("line"));
            item.set("breakpointid", log.get("id"));
            item.set("program", log.get("program"));
            if (Objects.equals(log.get("id"), breakpointId)) {
                selected = index;
                selectedBreakpointId = breakpointId;
            } else if (selected < 0 && Objects.equals(log.get("program"), program)) {
                selectedBreakpointId = D.s((Object)log.get("id"));
                selected = index;
            }
            ++index;
        }
        this.getView().getModel().getDataEntity(true).set("breakpoints", (Object)entries);
        this.getView().updateView("breakpoints");
        if (selected > -1) {
            ((EntryGrid)this.getView().getControl("breakpoints")).selectRows(selected);
            this.showBreakpointInfo(selectedBreakpointId);
        } else {
            this.clearScriptBreakpoints();
        }
    }

    private void showLogs(Collection<Map<String, Object>> logs) {
        DynamicObjectCollection entries = this.getView().getModel().getDataEntity().getDynamicObjectCollection("logs");
        entries.clear();
        for (Map<String, Object> log : logs) {
            DynamicObject item = entries.addNew();
            item.set("log_time", (Object)D.t((Object)log.get("time")));
            item.set("log_thread", log.get("thread"));
            item.set("log_script", (Object)D.s((Object)log.get("script_short")));
            item.set("log_script_tag", log.get("script_long"));
            item.set("log_script_line", log.get("line"));
            String data = D.s((Object)log.get("data"));
            item.set("log_data_tag", (Object)data);
            item.set("log_data", (Object)StringUtil.trim((String)data, (int)50));
        }
        this.getView().getModel().getDataEntity(true).set("logs", (Object)entries);
        this.getView().updateView("logs");
    }

    private void clearHtmlControls() {
        ((Html)this.getView().getControl("script")).setConent("<pre></pre>");
        ((Html)this.getView().getControl("content")).setConent("<pre></pre>");
    }

    private void setButtonsEnabled() {
        boolean enabled = ScriptDebugCache.isDebugEnabled();
        this.getView().setEnable(Boolean.valueOf(!enabled), new String[]{"btn_enable_debug"});
        this.getView().setEnable(Boolean.valueOf(enabled), new String[]{"btn_disable_debug"});
        if (enabled) {
            ScriptDebugCache.setLogsIgnored((boolean)D.x((Object)this.getModel().getValue("ignore_logs")));
            ((ProgressBar)this.getControl("progressor")).start();
        }
    }

    private void setScriptBreakpoints(Map<String, Object> info) {
        List breakpoints = (List)info.get("breakpoints");
        List lines = (List)info.get("lines");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("cmd", "set_script_data");
        data.put("id", UUID.randomUUID().toString());
        data.put("script", StringUtil.join((Collection)lines, (String)"\r\n"));
        data.put("breakpoints", breakpoints);
        ((CustomControl)this.getControl("editor")).setData(data);
    }

    public void customEvent(CustomEventArgs e) {
        String breakpointId;
        super.customEvent(e);
        String event = e.getEventName();
        if (("attach_breakpoint".equals(event) || "detach_breakpoint".equals(event)) && (breakpointId = this.getSelectedBreakpointId()) != null) {
            int line = D.i((Object)e.getEventArgs());
            ScriptDebugSignal.setBreakpoint((String)breakpointId, (int)line, (boolean)"attach_breakpoint".equals(event));
        }
    }

    private String getSelectedBreakpointId() {
        int[] rows = ((EntryGrid)this.getView().getControl("breakpoints")).getSelectRows();
        if (rows.length == 1) {
            return (String)this.getModel().getValue("breakpointid", rows[0]);
        }
        return null;
    }

    private String getSelectedProgram() {
        int[] rows = ((EntryGrid)this.getView().getControl("breakpoints")).getSelectRows();
        if (rows.length == 1) {
            return (String)this.getModel().getValue("program", rows[0]);
        }
        return null;
    }

    private void showBreakpointInfo(String breakpointid) {
        Map info = ScriptDebugCache.getBreakpointInfo((String)breakpointid);
        if (info != null) {
            this.setScriptBreakpoints(info);
        } else {
            this.clearScriptBreakpoints();
        }
    }
}

