/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.tools;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.isc.iscb.formplugin.tools.model.Rule;
import kd.isc.iscb.formplugin.tools.model.TestCaseBase;
import kd.isc.iscb.formplugin.tools.model.TestGroup;
import kd.isc.iscb.formplugin.tools.model.TestUnit;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.ExportAndImportFormUtil;
import kd.isc.iscb.platform.core.util.FileUtil;
import kd.isc.iscb.util.except.IscBizException;

public class TestCaseMetaMakerPlugin
extends AbstractFormPlugin {
    private static final String TEST_METHOD = "testmethod";
    private static final String TEST_RULE = "testrule";
    private static final String VALUE = "value";
    private IDataModel model;
    private IFormView view;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.model = this.getModel();
        this.view = this.getView();
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        if ("fileexport".equals(operateKey)) {
            OperationResult result = evt.getOperationResult();
            if (!result.getAllErrorOrValidateInfo().isEmpty()) {
                return;
            }
            this.fileExport();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("import".equals(itemKey)) {
            this.importMeta();
            this.view.showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f", (String)"TestCaseMetaMakerPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void fileExport() {
        TestCaseBase testCaseBase = this.exportMeta();
        List<TestUnit> testUnitList = testCaseBase.getTestMethods().stream().map(TestGroup::getTestUnits).flatMap(Collection::stream).collect(Collectors.toList());
        ArrayList errorList = new ArrayList();
        testUnitList.forEach(it -> {
            if (CollectionUtils.isEmpty(it.getRules())) {
                return;
            }
            Rule rule = it.getRules().get(0);
            if (rule.getValidator().startsWith("propertyPath") && StringUtils.isBlank((String)rule.getParams().get(0))) {
                errorList.add(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199 \u6d4b\u8bd5\u5355\u5143 \u7b2c%s\u884c \u5c5e\u6027\u8def\u5f84", (String)"TestCaseMetaMakerPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), it.getIndex() + 1));
            }
        });
        if (!errorList.isEmpty()) {
            this.view.showMessage(String.join((CharSequence)"\r\n", errorList));
            return;
        }
        String content = JSON.toJSONString((Object)this.exportMeta());
        this.model.setValue("export_meta", (Object)content);
        String tempFilePath = this.getLocalPath(UUID.randomUUID().toString() + ".json");
        try (FileOutputStream out = new FileOutputStream(tempFilePath);){
            ((OutputStream)out).write(content.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            FileUtil.delete((String)tempFilePath);
            throw new IscBizException(ResManager.loadKDString((String)"\u5199\u5165\u6587\u4ef6\u5931\u8d25", (String)"TestCaseMetaMakerPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), (Throwable)e);
        }
        ExportAndImportFormUtil.download((IFormView)this.view, (String)tempFilePath, (String)(testCaseBase.getName() + "_meta.json"));
        this.view.showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\uff01", (String)"TestCaseMetaMakerPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }

    public String getLocalPath(String name) {
        String filePath = FileUtil.USER_HOME + File.separator + "downloads" + File.separator + "temp";
        String fileName = name + ".json";
        try {
            File file = new File(filePath, fileName);
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5728%s\u4e0b\u521b\u5efa\u76ee\u5f55\u5931\u8d25\uff01", (String)"TestCaseMetaMakerPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), filePath));
            }
            if (!file.exists() && !file.createNewFile()) {
                String tPath = filePath + File.separator + fileName;
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5728%s\u4e0b\u521b\u5efa\u6587\u4ef6\u5931\u8d25\uff01", (String)"TestCaseMetaMakerPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), tPath));
            }
        }
        catch (Exception e) {
            String ePath = filePath + File.separator + fileName;
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5728%s\u4e0b\u521b\u5efa\u6587\u4ef6\u6216\u76ee\u5f55\u5f02\u5e38\uff01", (String)"TestCaseMetaMakerPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ePath), (Throwable)e);
        }
        return filePath + File.separator + fileName;
    }

    private void importMeta() {
        int i;
        TestCaseBase meta = (TestCaseBase)JSON.parseObject((String)this.getModelValue("import_meta"), TestCaseBase.class);
        if (meta == null) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u89e3\u6790\u5143\u6570\u636e\u5bfc\u5165\u5185\u5bb9\u5931\u8d25", (String)"TestCaseMetaMakerPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        this.model.setValue("classname", (Object)meta.getName());
        List<TestGroup> methods = meta.getTestMethods();
        this.model.deleteEntryData(TEST_METHOD);
        this.model.batchCreateNewEntryRow(TEST_METHOD, methods.size());
        ArrayList<Rule> rulesAll = new ArrayList<Rule>();
        for (i = 0; i < methods.size(); ++i) {
            TestGroup method = methods.get(i);
            this.model.setValue("groupindex", (Object)method.getIndex(), i);
            this.model.setValue("displayname", (Object)method.getDisplayName(), i);
            this.model.setValue("methodname", (Object)method.getMethod(), i);
            List indexList = method.getTestUnits().stream().map(TestUnit::getIndex).map(it -> it + 1).collect(Collectors.toList());
            this.model.setValue("testunits", (Object)JSON.toJSONString(indexList), i);
            for (TestUnit ei : method.getTestUnits()) {
                Integer index = ei.getIndex() + 1;
                List<Rule> rules = ei.getRules();
                if (CollectionUtils.isEmpty(rules)) continue;
                for (Rule rulej : rules) {
                    rulej.setIndex(index);
                    rulesAll.add(rulej);
                }
            }
        }
        this.model.deleteEntryData(TEST_RULE);
        this.model.batchCreateNewEntryRow(TEST_RULE, rulesAll.size());
        for (i = 0; i < rulesAll.size(); ++i) {
            Rule rai = (Rule)rulesAll.get(i);
            this.model.setValue("index0", (Object)rai.getIndex(), i);
            this.model.setValue("rule_description", (Object)rai.getDescription(), i);
            this.model.setValue("rule_type", (Object)rai.getValidator(), i);
            List<String> params = rai.getParams();
            if (params.size() == 1) {
                this.model.setValue(VALUE, (Object)params.get(0), i);
                continue;
            }
            if (params.size() != 2) continue;
            this.model.setValue("propertypath", (Object)params.get(0), i);
            this.model.setValue(VALUE, (Object)params.get(1), i);
        }
    }

    private TestCaseBase exportMeta() {
        Map<Integer, List<Rule>> testUnits = this.getTestUnits();
        int count = this.model.getEntryRowCount(TEST_METHOD);
        ArrayList<TestGroup> testMethods = new ArrayList<TestGroup>(count);
        for (int i = 0; i < count; ++i) {
            TestGroup testMethod = new TestGroup();
            int index = Integer.parseInt(this.getModelValue("groupindex", i));
            testMethod.setIndex(index);
            testMethod.setDisplayName(this.getModelValue("displayName", i));
            testMethod.setMethod(this.getModelValue("methodname", i));
            List tuList = JSON.parseArray((String)this.getModelValue("testunits", i), Integer.class);
            Iterator iterator = tuList.iterator();
            while (iterator.hasNext()) {
                int tu = (Integer)iterator.next();
                testMethod.getTestUnits().add(new TestUnit(tu - 1, testUnits.get(tu - 1)));
            }
            testMethods.add(testMethod);
        }
        TestCaseBase testCase = new TestCaseBase();
        testCase.setName(this.getModelValue("classname"));
        testCase.setTestMethods(testMethods);
        return testCase;
    }

    private Map<Integer, List<Rule>> getTestUnits() {
        HashMap<Integer, List<Rule>> map = new HashMap<Integer, List<Rule>>();
        for (int i = 0; i < this.model.getEntryRowCount(TEST_RULE); ++i) {
            Integer index = Integer.parseInt(this.getModelValue("index0", i)) - 1;
            List rules = map.computeIfAbsent(index, k -> new ArrayList());
            Rule e = new Rule();
            e.setDescription(this.getModelValue("rule_description", i));
            e.setValidator(this.getModelValue("rule_type", i));
            if ("equals".equals(e.getValidator()) || "contains".equals(e.getValidator()) || "regex".equals(e.getValidator())) {
                e.getParams().add(this.getModelValue(VALUE, i));
            } else {
                e.getParams().add(this.getModelValue("propertypath", i));
                e.getParams().add(this.getModelValue(VALUE, i));
            }
            rules.add(e);
        }
        return map;
    }

    private String getModelValue(String property) {
        return this.getModelValue(property, null);
    }

    private String getModelValue(String property, Integer index) {
        Object value = index == null ? this.model.getValue(property) : this.model.getValue(property, index.intValue());
        return value == null ? "" : value.toString();
    }
}

