/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.tools.check;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.rc.RiskItem;
import kd.isc.iscb.platform.core.rc.Util;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;

public class CheckDetailFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String NAME = "name";
    private static final String RISK_DEC = "riskdec";
    private static final String SUGGESTIONS = "suggestions";
    private static final String NUMBER = "number";
    private static final String RISK_LIST = "risklist";
    private static final String RISK_NUMBER = "risknumber";
    private static final String LINK_MESSAGE = "LinkNoMessageCheck";
    private static final String DataCopyTriggerMsg = "DataCopyTriggerNoMsgCheck";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(RISK_LIST);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"newmessage"});
        Map params = this.getView().getFormShowParameter().getCustomParams();
        RiskItem riskItem = Util.getRiskItem((String)D.s(params.get(RISK_NUMBER)));
        if (riskItem.number.equals(LINK_MESSAGE) || riskItem.number.equals(DataCopyTriggerMsg)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"newmessage"});
        } else {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put("selchexkbox", Boolean.FALSE);
            this.getView().updateControlMetadata(RISK_LIST, map);
        }
        this.getModel().setValue(SUGGESTIONS, params.get("sug"));
        this.loadData(params);
    }

    private void loadData(Map<String, Object> params) {
        DynamicObjectCollection entry = this.getModel().getEntryEntity(RISK_LIST);
        entry.clear();
        this.loadEntityData(params, entry);
        this.getView().updateView(RISK_LIST);
        this.getModel().setValue(RISK_DEC, params.get("resultdesc"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadEntityData(Map<String, Object> params, DynamicObjectCollection entry) {
        Connection cn = null;
        try {
            cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
            List<DataRow> dataRows = this.getContents(cn, D.s((Object)params.get(RISK_NUMBER)));
            for (DataRow dataRow : dataRows) {
                DynamicObject obj = entry.addNew();
                obj.set(NAME, dataRow.get((Object)"fresource_name"));
                obj.set(NUMBER, dataRow.get((Object)"fresource_number"));
                obj.set("fid", dataRow.get((Object)"fresource_id"));
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(cn);
            throw throwable;
        }
        DbUtil.close((Connection)cn);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        EntryGrid entryGrid;
        int[] rows;
        super.afterDoOperation(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        RiskItem riskItem = Util.getRiskItem((String)D.s(params.get(RISK_NUMBER)));
        if ("newmessage".equals(e.getOperateKey()) && this.checkSelectedRows(riskItem, rows = (entryGrid = (EntryGrid)this.getControl(RISK_LIST)).getSelectRows())) {
            this.setMessageForm(rows, riskItem.number);
        }
    }

    private void setMessageForm(int[] rows, String type) {
        HashMap<String, Object> map;
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(RISK_LIST);
        ArrayList<Long> selectedID = new ArrayList<Long>(rows.length);
        for (int row : rows) {
            selectedID.add(D.l((Object)((DynamicObject)collection.get(row)).get("fid")));
        }
        if (LINK_MESSAGE.equals(type)) {
            map = new HashMap<String, Object>();
            map.put("link", selectedID.get(0));
            FormOpener.showTabBill(this, "isc_link_notification", null, map, null);
        } else if (DataCopyTriggerMsg.equals(type)) {
            map = new HashMap();
            map.put("triggers", selectedID);
            FormOpener.showModalForm(this, "isc_message_notification", null, map, null);
        }
    }

    private boolean checkSelectedRows(RiskItem riskItem, int[] rows) {
        String number = riskItem.number;
        if (LINK_MESSAGE.equals(number)) {
            if (rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u884c", (String)"CheckDetailFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (rows.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u884c", (String)"CheckDetailFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else if (rows.length == 0 && DataCopyTriggerMsg.equals(number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u9009\u62e9\u4e00\u884c", (String)"CheckDetailFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (evt.getRowIndex() >= 0 && NUMBER.equals(evt.getFieldName())) {
            Map params = this.getView().getFormShowParameter().getCustomParams();
            DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(RISK_LIST);
            RiskItem riskItem = Util.getRiskItem((String)D.s(params.get(RISK_NUMBER)));
            String id = D.s((Object)((DynamicObject)collection.get(evt.getRowIndex())).get("fid"));
            if (QueryServiceHelper.exists((String)riskItem.getEntity(), (Object)id)) {
                this.handleForm(collection, riskItem, id);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u62a5\u544a\u3002", (String)"CheckDetailFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void handleForm(DynamicObjectCollection collection, RiskItem riskItem, String id) {
        Map map = riskItem.getShowParams(id);
        String showType = D.s(map.get("showtype"));
        String entity = D.s(map.get("entity"));
        String caption = D.s(map.get("title"));
        Map showParams = (Map)map.get("params");
        switch (showType) {
            case "showView": {
                FormOpener.showView(this, entity, id);
                break;
            }
            case "showTabEdit": {
                FormOpener.showTabEdit(this, entity, id);
                break;
            }
            case "showTabBill": {
                FormOpener.showTabBill(this, entity, caption, showParams, null);
                break;
            }
            case "showModalForm": {
                FormOpener.showModalForm(this, entity, caption, showParams, null);
                break;
            }
            case "showList": {
                FormOpener.showList(this, entity, this.getFilter(collection));
                break;
            }
            default: {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u94fe\u63a5\u65e0\u6307\u5b9a\u8df3\u8f6c", (String)"CheckDetailFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private QFilter getFilter(DynamicObjectCollection collection) {
        ArrayList<Long> strings = new ArrayList<Long>();
        for (DynamicObject dynamicObject : collection) {
            strings.add(D.l((Object)dynamicObject.getString("fid")));
        }
        return new QFilter("id", "in", strings);
    }

    private List<DataRow> getContents(Connection cn, String number) {
        String sql = "SELECT fresource_number,fresource_name ,fresource_id FROM  T_ISC_RES_CHECK_RESULT WHERE frisk_number=?";
        return DbUtil.executeList((Connection)cn, (String)sql, Collections.singletonList(number), Collections.singletonList(12));
    }
}

