/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.tools.check;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AnchorItems;
import kd.bos.entity.report.CellStyle;
import kd.bos.ext.form.control.AnchorControl;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.formplugin.tools.check.HealthReportData;
import kd.isc.iscb.formplugin.tools.check.HealthReportUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.rc.CheckItem;
import kd.isc.iscb.platform.core.rc.EntityEnum;
import kd.isc.iscb.platform.core.rc.GroupEnum;
import kd.isc.iscb.platform.core.rc.RiskHandler;
import kd.isc.iscb.platform.core.rc.RiskHandlers;
import kd.isc.iscb.platform.core.rc.RiskInfo;
import kd.isc.iscb.platform.core.rc.RiskItem;
import kd.isc.iscb.platform.core.rc.RiskRank;
import kd.isc.iscb.platform.core.rc.Util;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class HealthReportFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
EntryGridBindDataListener {
    private static final String OPENVIEW = "openview";
    private static final String ENTITY = "entity";
    private static final String HIGH_RISK_TITLE = "high_risk_title";
    private static final String MEDIUM_RISK_TITLE = "medium_risk_title";
    private static final String LOW_RISK_TITLE = "low_risk_title";
    private static final String NO_RISK_TITLE = "no_risk_title";
    private static final String CRITICALCOLOR = "#ff0000";
    private static final String WARNCOLOR = "#ff991c";
    private static final String RECOMMENDCOLOR = "#999999";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        for (GroupEnum group : GroupEnum.values()) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(group.name().toLowerCase() + ENTITY);
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    private void drawChart(HealthReportData reportData) {
        PieChart pieChart = (PieChart)this.getControl("piechartap");
        PieSeries a = pieChart.createSeries("");
        ItemValue[] itemValues = new ItemValue[]{new ItemValue(ResManager.loadKDString((String)"\u9ad8\u98ce\u9669", (String)"HealthReportFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), (Number)reportData.higNum, CRITICALCOLOR), new ItemValue(ResManager.loadKDString((String)"\u4e2d\u98ce\u9669", (String)"HealthReportFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), (Number)reportData.medNum, WARNCOLOR), new ItemValue(ResManager.loadKDString((String)"\u4f4e\u98ce\u9669", (String)"HealthReportFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), (Number)reportData.lowNum, RECOMMENDCOLOR), new ItemValue(ResManager.loadKDString((String)"\u5065\u5eb7", (String)"HealthReportFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), (Number)reportData.normalNum, "#73D13D"), new ItemValue(ResManager.loadKDString((String)"\u5173\u6ce8", (String)"HealthReportFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), (Number)reportData.careNum, "#46B9ff")};
        if (reportData.higNum != 0) {
            a.addData(itemValues[0]);
        }
        if (reportData.medNum != 0) {
            a.addData(itemValues[1]);
        }
        if (reportData.lowNum != 0) {
            a.addData(itemValues[2]);
        }
        if (reportData.normalNum != 0) {
            a.addData(itemValues[3]);
        }
        if (reportData.careNum != 0) {
            a.addData(itemValues[4]);
        }
        Label label = new Label();
        label.setShow(false);
        label.setPosition(Position.inside);
        a.setLabel(label);
        this.setChartStyle(pieChart, a, reportData);
        pieChart.refresh();
    }

    private void setChartStyle(PieChart pieChart, PieSeries a, HealthReportData reportData) {
        pieChart.setShowTitle(true);
        pieChart.setName(new LocaleString(ResManager.loadKDString((String)"\u5171\u68c0\u6d4b", (String)"HealthReportFormPlugin_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) + "\n" + String.format(ResManager.loadKDString((String)"%s\u9879", (String)"HealthReportFormPlugin_16", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), reportData.getSum())));
        pieChart.setTitleAlign(XAlign.center, YAlign.center);
        HashMap<String, Object> label = new HashMap<String, Object>();
        label.put("show", Boolean.TRUE);
        label.put("fontSize", 40);
        label.put("fontWeight", "bold");
        a.setPropValue("emphasis", label);
        a.setPropValue("borderRadius", (Object)10);
        HashMap<String, Object> normal = new HashMap<String, Object>();
        normal.put("borderRadius", 20);
        normal.put("borderColor", "#fff");
        normal.put("borderWidth", 2);
        HashMap<String, Serializable> itemStyle = new HashMap<String, Serializable>();
        itemStyle.put("normal", normal);
        itemStyle.put("borderRadius", Integer.valueOf(10));
        a.setPropValue("itemStyle", itemStyle);
        a.setRadius("40%", "70%");
        pieChart.setShowTooltip(true);
        pieChart.setLegendAlign(XAlign.center, YAlign.top);
        pieChart.setShowLegend(false);
    }

    private void setRankTitle(HealthReportData reportData) {
        this.getView().setVisible(Boolean.FALSE, new String[]{HIGH_RISK_TITLE});
        this.getView().setVisible(Boolean.FALSE, new String[]{MEDIUM_RISK_TITLE});
        this.getView().setVisible(Boolean.FALSE, new String[]{LOW_RISK_TITLE});
        this.getView().setVisible(Boolean.FALSE, new String[]{NO_RISK_TITLE});
        if (reportData.higNum > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{HIGH_RISK_TITLE});
        } else if (reportData.medNum > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{MEDIUM_RISK_TITLE});
        } else if (reportData.lowNum > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{LOW_RISK_TITLE});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{NO_RISK_TITLE});
        }
    }

    private void setRankNumbers(HealthReportData reportData) {
        this.getModel().setValue("high_risk_num", (Object)reportData.higNum);
        this.getModel().setValue("medium_risk_num", (Object)reportData.medNum);
        this.getModel().setValue("low_risk_num", (Object)reportData.lowNum);
        this.getModel().setValue("no_risk_num", (Object)reportData.normalNum);
        this.getModel().setValue("point_num", (Object)reportData.careNum);
        this.setRankTitle(reportData);
    }

    private void loadCheckTime() {
        Timestamp time = D.t((Object)Util.getRecordValue((String)"checktime"));
        this.getModel().setValue("checktime", (Object)time);
    }

    private void clearReportData(HealthReportData reportData) {
        for (GroupEnum value : GroupEnum.values()) {
            reportData.setGroupNormalNum(value.name(), 0);
            reportData.setGroupNormalTxt(value.name(), "");
            DynamicObjectCollection entry_dc = this.getModel().getEntryEntity(value + ENTITY);
            entry_dc.clear();
        }
    }

    private void loadReportData(HealthReportData reportData) {
        Map<String, Integer> metaDataCountMap = HealthReportUtil.queryResourceTotalCount();
        Map<String, Integer> riskCountMap = HealthReportUtil.queryRiskCount();
        List<String> selectedCheckItems = HealthReportUtil.queryCheckItemNumBer();
        for (GroupEnum group : GroupEnum.values()) {
            this.handleGroup(group, metaDataCountMap, riskCountMap, selectedCheckItems, reportData);
            this.getView().updateView(group + ENTITY);
            if (reportData.getGroupNormalNum(group.name()) != 0) {
                this.getView().setVisible(Boolean.TRUE, new String[]{group + "normal"});
                this.getModel().setValue(group + "num", (Object)String.format(ResManager.loadKDString((String)"%s\u9879\u68c0\u6d4b\u72b6\u6001\u6b63\u5e38", (String)"HealthReportFormPlugin_18", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), reportData.getGroupNormalNum(group.name())));
                this.getModel().setValue(group + "txt", (Object)reportData.getGroupNormalTxt(group.name()));
                continue;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{group + "normal"});
        }
    }

    private void handleGroup(GroupEnum group, Map<String, Integer> metaDataCountMap, Map<String, Integer> riskCountMap, List<String> selectedCheckItems, HealthReportData reportData) {
        List entityEnums = Util.getEntityEnums((String)group.name());
        for (EntityEnum entityEnum : entityEnums) {
            this.handleEntity(entityEnum, metaDataCountMap, riskCountMap, selectedCheckItems, reportData);
        }
    }

    private void handleEntity(EntityEnum entity, Map<String, Integer> metaDataCountMap, Map<String, Integer> riskCountMap, List<String> selectedCheckItems, HealthReportData reportData) {
        List checkItemList = Util.getCheckItems((String)entity.name());
        for (CheckItem checkItem : checkItemList) {
            if (!selectedCheckItems.contains(checkItem.getNumber())) continue;
            this.handleCheckItem(metaDataCountMap, riskCountMap, checkItem, reportData);
        }
    }

    private void handleCheckItem(Map<String, Integer> metaDataCountMap, Map<String, Integer> riskCountMap, CheckItem checkItem, HealthReportData reportData) {
        for (RiskItem riskItem : checkItem.getRiskItemList()) {
            RiskHandler riskHandler = Util.getRiskHandler((String)riskItem.number);
            RiskInfo riskInfo = riskHandler.calcRiskInfo(D.i((Object)metaDataCountMap.get(checkItem.getEntityName().name())), D.i((Object)riskCountMap.get(riskItem.getNumber())));
            if (riskInfo.getRiskRank() == null) continue;
            this.recordRiskRankNum(riskInfo, reportData);
            if (RiskRank.Normal == riskInfo.getRiskRank()) {
                this.recordNormalContent(riskInfo, checkItem.getGroupName().name(), reportData);
                continue;
            }
            this.setEntityData(checkItem.getGroupName().name(), riskItem, riskInfo);
        }
    }

    private void setEntityData(String group, RiskItem riskItem, RiskInfo riskInfo) {
        DynamicObjectCollection entry_dc = this.getModel().getEntryEntity(group + ENTITY);
        DynamicObject obj = entry_dc.addNew();
        obj.set(group + "resultdesc", (Object)riskInfo.getResultDesc());
        obj.set(group + "type", (Object)riskInfo.getRiskRank().ordinal());
        obj.set(group + "suggestions", (Object)StringUtil.trim((String)riskInfo.getSuggestion(), (int)100));
        obj.set(group + OPENVIEW, (Object)ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"HealthReportFormPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        obj.set(group + "risknumber", (Object)riskItem.getNumber());
        obj.set(group + "sug", (Object)riskInfo.getSuggestion());
    }

    private void recordNormalContent(RiskInfo riskInfo, String group, HealthReportData reportData) {
        String txt = reportData.getGroupNormalTxt(group);
        if (!txt.contains(riskInfo.getResultDesc())) {
            ++reportData.normalNum;
            int num = reportData.getGroupNormalNum(group);
            reportData.setGroupNormalNum(group, ++num);
            txt = txt.concat("-");
            txt = txt.concat(riskInfo.getResultDesc());
            txt = txt.concat("\n");
            reportData.setGroupNormalTxt(group, txt);
        }
    }

    private void recordRiskRankNum(RiskInfo riskInfo, HealthReportData reportData) {
        switch (riskInfo.getRiskRank()) {
            case Critical: {
                ++reportData.higNum;
                break;
            }
            case Warn: {
                ++reportData.medNum;
                break;
            }
            case Recommend: {
                ++reportData.lowNum;
                break;
            }
            case NoSuggestion: {
                ++reportData.careNum;
            }
        }
    }

    private void setTableVisible(HealthReportData reportData) {
        ArrayList<AnchorItems> list = new ArrayList<AnchorItems>();
        list.add(new AnchorItems("return", ResManager.loadKDString((String)"\u8fd4\u56de", (String)"HealthReportFormPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), null));
        for (GroupEnum group : GroupEnum.values()) {
            DynamicObjectCollection entry_dc = this.getModel().getEntryEntity(group + ENTITY);
            if (!entry_dc.isEmpty()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{group + ENTITY});
                this.sortAndSetColor(group.name(), entry_dc);
                this.getView().updateView(group + ENTITY);
                list.add(new AnchorItems(group.name(), HealthReportData.anchorItemMap.get(group.name()), null));
                continue;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{group + ENTITY});
            if (reportData.getGroupNormalNum(group.name()) == 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{group.name()});
                continue;
            }
            list.add(new AnchorItems(group.name(), HealthReportData.anchorItemMap.get(group.name()), null));
        }
        AnchorControl anchorCtl1 = (AnchorControl)this.getView().getControl("anchorcontrolap");
        anchorCtl1.addItems(list);
    }

    private void sortAndSetColor(final String group, DynamicObjectCollection entry_dc) {
        entry_dc.sort((Comparator)new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                return D.s((Object)o1.get(group + "type")).compareTo(D.s((Object)o2.get(group + "type")));
            }
        });
        ArrayList<CellStyle> cellStyleList = new ArrayList<CellStyle>();
        for (int i = 0; i < entry_dc.getRowCount(); ++i) {
            this.setCellColor(i, ((DynamicObject)entry_dc.get(i)).getString(group + "type"), cellStyleList, group + "type");
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(group + ENTITY);
        entryGrid.setCellStyle(cellStyleList);
    }

    private void setCellColor(int index, String riskStr, List<CellStyle> cellStyleList, String field) {
        CellStyle cellStyle = new CellStyle();
        cellStyle.setRow(index);
        cellStyle.setFieldKey(field);
        if (D.s((Object)RiskRank.Critical.ordinal()).equals(riskStr)) {
            cellStyle.setForeColor(CRITICALCOLOR);
        } else if (D.s((Object)RiskRank.Warn.ordinal()).equals(riskStr)) {
            cellStyle.setForeColor(WARNCOLOR);
        } else if (D.s((Object)RiskRank.Recommend.ordinal()).equals(riskStr)) {
            cellStyle.setForeColor(RECOMMENDCOLOR);
        }
        cellStyleList.add(cellStyle);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
    }

    public void beforeBindData(EventObject e) {
        this.setDefaultValue();
        this.getModel().setValue("textfield1", (Object)ResManager.loadKDString((String)"\u7279\u522b\u58f0\u660e\uff1a\u5065\u5eb7\u5ea6\u68c0\u6d4b\u670d\u52a1\u7531\u96c6\u6210\u670d\u52a1\u4e91\u63d0\u4f9b\uff0c\u8be5\u62a5\u544a\u4ec5\u9488\u5bf9\u96c6\u6210\u7ba1\u7406\u6a21\u5757\u6240\u6db5\u76d6\u7684\u529f\u80fd\u8fdb\u884c\u5065\u5eb7\u5ea6\u68c0\u6d4b\u3002\u6240\u6709\u68c0\u6d4b\u5185\u5bb9\u5747\u6765\u81ea\u672c\u8d26\u5957\u9759\u6001\u7cfb\u7edf\u6570\u636e\uff0c\u672a\u5bf9\u654f\u611f\u6570\u636e\u8fdb\u884c\u8bfb\u53d6\u3001\u57cb\u70b9\u3001\u8bb0\u5f55\u3002", (String)"HealthReportFormPlugin_19", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        HealthReportData reportData = new HealthReportData();
        this.loadCheckTime();
        this.clearReportData(reportData);
        this.loadReportData(reportData);
        this.setTableVisible(reportData);
        this.drawChart(reportData);
        this.setRankNumbers(reportData);
    }

    private void setDefaultValue() {
        String defaultValue = ResManager.loadKDString((String)"0\u9879\u68c0\u6d4b\u72b6\u6001\u6b63\u5e38", (String)"HealthReportFormPlugin_20", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        this.getModel().setValue("connectionnum", (Object)defaultValue);
        this.getModel().setValue("metanum", (Object)defaultValue);
        this.getModel().setValue("datacopynum", (Object)defaultValue);
        this.getModel().setValue("apicnum", (Object)defaultValue);
        this.getModel().setValue("messagenum", (Object)defaultValue);
        this.getModel().setValue("serviceflownum", (Object)defaultValue);
        this.getModel().setValue("datacompnum", (Object)defaultValue);
        this.getModel().setValue("othernum", (Object)defaultValue);
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        if ("refresh".equals(eventArgs.getOperateKey())) {
            HealthReportData reportData = new HealthReportData();
            this.loadCheckTime();
            this.clearReportData(reportData);
            this.loadReportData(reportData);
            this.setTableVisible(reportData);
            this.drawChart(reportData);
            this.setRankNumbers(reportData);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f\u3002", (String)"HealthReportFormPlugin_14", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (evt.getRowIndex() >= 0) {
            for (GroupEnum group : GroupEnum.values()) {
                if (!(group + OPENVIEW).equals(evt.getFieldName())) continue;
                this.openCheckDetailForm(evt.getRowIndex(), group + ENTITY, group + "risknumber", group + "sug", group + "resultdesc");
            }
        }
    }

    private void openCheckDetailForm(int rowIndex, String entityName, String riskNumber, String sug, String resultdesc) {
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(entityName);
        String number = ((DynamicObject)collection.get(rowIndex)).getString(riskNumber);
        resultdesc = ((DynamicObject)collection.get(rowIndex)).getString(resultdesc);
        sug = ((DynamicObject)collection.get(rowIndex)).getString(sug);
        RiskItem riskItem = Util.getRiskItem((String)number);
        RiskHandler riskHandler = RiskHandlers.getHandler((String)number);
        switch (riskHandler.getDetailType()) {
            case "showDetail": {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("risknumber", number);
                params.put("resultdesc", resultdesc);
                params.put("sug", sug);
                FormOpener.showForm(this, "isc_check_detail", params);
                break;
            }
            case "showList": {
                FormOpener.showList(this, riskItem.getEntity(), null);
                break;
            }
            case "showForm": {
                FormOpener.showForm(this, riskItem.getEntity(), null);
            }
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        super.entryGridBindData(e);
        EntryGrid entryGrid = (EntryGrid)e.getSource();
        String entryKey = entryGrid.getEntryKey();
        String group = entryKey.replace(ENTITY, "");
        DynamicObjectCollection entry_dc = this.getModel().getEntryEntity(entryKey);
        this.sortAndSetColor(group, entry_dc);
    }
}

