/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.tools.scriptexample;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.util.dt.D;

public class ScriptExampleTreeFormPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    public void registerListener(EventObject e) {
        Search search;
        super.registerListener(e);
        TreeView preTree = (TreeView)this.getView().getControl("scripttree");
        if (preTree != null) {
            preTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        }
        if ((search = (Search)this.getView().getControl("searchap")) != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initTree();
    }

    private void initTree() {
        TreeView treeView = (TreeView)this.getView().getControl("scripttree");
        if (treeView == null) {
            return;
        }
        String group = this.getGroup();
        this.initTree(treeView, group);
    }

    private String getGroup() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String group = this.getView().getEntityId();
        if (!"isc_sf_script_node_editor".equals(group)) {
            group = D.s(customParams.get("plugin_name"));
        }
        if ("isc_call_api_by_mq".equals(group) || "isc_call_api_by_evt".equals(group) || "isc_call_api_by_timer".equals(group)) {
            group = "api_task";
        }
        return group;
    }

    private void initTree(TreeView treeView, String group) {
        treeView.deleteAllNodes();
        TreeNode root = new TreeNode("", "ROOT", ResManager.loadKDString((String)"\u5168\u90e8", (String)"ScriptExampleTreeFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        root.setIsOpened(true);
        List<Object> groupList = this.buildScriptGroup(root, group);
        Map<String, List<DynamicObject>> allScript = this.getAllScript(groupList);
        ArrayList<TreeNode> leafTreeNodes = new ArrayList<TreeNode>(allScript.size());
        this.addScriptIntoTree(root, allScript, leafTreeNodes);
        treeView.addNode(root);
        this.getView().getPageCache().put("leafTreeNodes", SerializationUtils.toJsonString(leafTreeNodes));
        treeView.setRootVisible(false);
        this.getView().updateView("scripttree");
    }

    public List<Object> buildScriptGroup(TreeNode root, String group) {
        root.setIsOpened(true);
        DynamicObjectCollection scriptSort = QueryServiceHelper.query((String)"isc_script_scene", (String)"name,number,id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)group).or(new QFilter("number", "=", (Object)"for_common")).or(new QFilter("number", "=", (Object)"common_function"))});
        if (scriptSort != null && !scriptSort.isEmpty()) {
            return this.fillTree(root, scriptSort);
        }
        return Collections.emptyList();
    }

    public Map<String, List<DynamicObject>> getAllScript(List<Object> groupList) {
        DynamicObjectCollection scriptSort = QueryServiceHelper.query((String)"isc_script_example", (String)"name,group.number,id,group.id", (QFilter[])new QFilter[]{new QFilter("group.id", "in", groupList)});
        HashMap<String, List<DynamicObject>> map = new HashMap<String, List<DynamicObject>>(10);
        if (scriptSort != null && !scriptSort.isEmpty()) {
            for (DynamicObject object : scriptSort) {
                String key = object.getString("group.number");
                ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)map.get(key);
                if (list == null) {
                    list = new ArrayList<DynamicObject>();
                    list.add(object);
                    map.put(key, list);
                    continue;
                }
                list.add(object);
            }
        }
        return map;
    }

    public void treeNodeClick(TreeNodeEvent e) {
        Control control = (Control)e.getSource();
        if (!control.getKey().equals("scripttree")) {
            return;
        }
        String nodeId = D.s((Object)e.getNodeId());
        if (nodeId != null && nodeId.contains("leaf")) {
            String id = nodeId.replace("leaf_", "");
            QFilter qFilter = new QFilter("id", "=", (Object)D.l((Object)id));
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"isc_script_example", (String)"id,script_code_tag", (QFilter[])new QFilter[]{qFilter});
            HashMap<String, Object> data = new HashMap<String, Object>(2);
            data.put("cmd", "insert_script_example");
            data.put("script", "\n//" + ResManager.loadKDString((String)"\u5f00\u59cb", (String)"ScriptExampleTreeFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) + "\n" + dynamicObject.getString("script_code_tag") + "\n//" + ResManager.loadKDString((String)"\u7ed3\u675f", (String)"ScriptExampleTreeFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) + "\n");
            data.put("time", System.currentTimeMillis());
            ((CustomControl)this.getControl("editor")).setData(data);
        }
    }

    private List<Object> fillTree(TreeNode root, DynamicObjectCollection collection) {
        ArrayList<TreeNode> childNodeList = new ArrayList<TreeNode>(collection.size());
        ArrayList<Object> groupList = new ArrayList<Object>(collection.size());
        for (DynamicObject dynamicObject : collection) {
            String childId = D.s((Object)dynamicObject.get("number"));
            String childName = D.s((Object)dynamicObject.get("name"));
            groupList.add(dynamicObject.get("id"));
            TreeNode childNode = new TreeNode(root.getId(), childId, childName);
            childNodeList.add(childNode);
        }
        root.setChildren(childNodeList);
        return groupList;
    }

    public void addScriptIntoTree(TreeNode root, Map<String, List<DynamicObject>> scriptMap, List<TreeNode> leafTreeNodes) {
        if (scriptMap == null || scriptMap.size() == 0) {
            return;
        }
        if (root.getChildren() == null) {
            this.addNodeToLeaf(root, scriptMap, leafTreeNodes);
        } else {
            for (TreeNode node : root.getChildren()) {
                this.addScriptIntoTree(node, scriptMap, leafTreeNodes);
            }
        }
    }

    private void addNodeToLeaf(TreeNode root, Map<String, List<DynamicObject>> scriptMap, List<TreeNode> leafTreeNodes) {
        List<DynamicObject> script = scriptMap.get(root.getId());
        if (script != null) {
            ArrayList<TreeNode> childNodeList = new ArrayList<TreeNode>(script.size());
            for (DynamicObject object : script) {
                TreeNode node = new TreeNode();
                node.setText("</> " + D.s((Object)object.get("name")));
                node.setId("leaf_" + D.s((Object)object.get("id")));
                node.setParentid(root.getId());
                childNodeList.add(node);
            }
            leafTreeNodes.addAll(childNodeList);
            root.setChildren(childNodeList);
        }
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
    }

    public void search(SearchEnterEvent evt) {
        String new_str = D.s((Object)evt.getText());
        if (new_str == null) {
            return;
        }
        String last_str = D.s((Object)this.getView().getPageCache().get("last_search_str"));
        int find_index = D.i((Object)this.getView().getPageCache().get("last_find_index"));
        String jsonStr = this.getView().getPageCache().get("leafTreeNodes");
        List leafTreeNodes = (List)SerializationUtils.fromJsonString((String)jsonStr, List.class);
        if (new_str.equals(last_str)) {
            this.search(leafTreeNodes, new_str, find_index + 1, find_index);
        } else {
            this.getView().getPageCache().put("last_search_str", new_str);
            this.search(leafTreeNodes, new_str, 0, -1);
        }
    }

    private void search(List<Map<String, Object>> leafTreeNodes, String str, int i, int last_index) {
        while (i < leafTreeNodes.size()) {
            TreeNode node = (TreeNode)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(leafTreeNodes.get(i)), TreeNode.class);
            if (node.getText().contains(str)) {
                TreeView treeView = (TreeView)this.getView().getControl("scripttree");
                treeView.expand(node.getParentid());
                treeView.focusNode(node);
                this.getView().getPageCache().put("last_find_index", D.s((Object)i));
                return;
            }
            ++i;
        }
        if (last_index >= 0 && last_index < leafTreeNodes.size()) {
            this.search(leafTreeNodes, str, 0, -1);
            return;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\u3002", (String)"ScriptExampleTreeFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().getPageCache().remove("last_find_index");
        this.getView().getPageCache().remove("last_search_str");
    }
}

