/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.trace;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.control.Html;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.AfterSearchClickListener;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.sf.Util;
import kd.isc.iscb.formplugin.trace.Forest;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.trace.TraceType;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.misc.Xml;
import kd.isc.iscb.util.trace.TraceState;

public class IscBizTraceTreePlugin
extends AbstractFormPlugin
implements FilterContainerInitListener,
AfterSearchClickListener,
TreeNodeClickListener {
    private static final String TREEVIEW = "topic_tree";
    private static Map<String, Forest> forestMap = new HashMap<String, Forest>();

    public void initialize() {
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        if (null != filterContainer) {
            filterContainer.setBillFormId("isc_biz_trace");
            filterContainer.addFilterContainerInitListener((FilterContainerInitListener)this);
        }
    }

    public void registerListener(EventObject e) {
        TreeView treeView = (TreeView)this.getControl(TREEVIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        if (null != filterContainer) {
            filterContainer.addAfterSearchClickListener((AfterSearchClickListener)this);
        }
    }

    public void filterContainerInit(FilterContainerInitEvent filterContainerInitEvent) {
        CommonFilterColumn commonFilterColumn = new CommonFilterColumn("state");
        filterContainerInitEvent.addFilterColumn((FilterColumn)commonFilterColumn);
        FilterColumn start_time = filterContainerInitEvent.getFilterColumn("start_time");
        filterContainerInitEvent.getCommonFilterColumns().remove(start_time);
        List schemeFilterColumns = filterContainerInitEvent.getSchemeFilterColumns();
        ArrayList schemeFilter = new ArrayList(schemeFilterColumns.size());
        schemeFilter.addAll(schemeFilterColumns);
        schemeFilterColumns.removeAll(schemeFilter);
    }

    public void click(SearchClickEvent searchClickEvent) {
        List selectFields = searchClickEvent.getFilterParameter().getSelectFields();
        QFilter filter = null;
        HashSet<String> fields = new HashSet<String>(selectFields.size());
        for (String selectField : selectFields) {
            if (fields.contains(selectField)) continue;
            fields.add(selectField);
            QFilter parsedQFilter = searchClickEvent.getQFilter(selectField);
            if (filter != null) {
                filter.and(parsedQFilter);
                continue;
            }
            filter = parsedQFilter;
        }
        this.refreshView(filter);
    }

    private void refreshView(QFilter filter) {
        ArrayList<TreeNode> nodes;
        Forest forest = forestMap.get(this.getView().getPageId());
        if (forest == null) {
            nodes = new ArrayList();
            nodes.add(new TreeNode("", "0", ResManager.loadKDString((String)"\u8ffd\u6eaf\u4fe1\u606f\u672a\u627e\u5230,\u8bf7\u91cd\u65b0\u6253\u5f00\u8be5\u754c\u9762\u3002", (String)"IscBizTraceTreePlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])));
        } else {
            nodes = forest.searchFilterItems(filter);
        }
        nodes = this.sort(nodes);
        this.appendTreeNodes(nodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TreeNode> getTreeNodes(List<Object> traceIds, StringBuilder sql, List<Integer> types) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            List rows = DbUtil.executeList((Connection)cn, (String)sql.toString(), traceIds, types);
            ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(rows.size());
            ArrayList<TreeNode> tagNodes = new ArrayList<TreeNode>(rows.size());
            String pageId = this.getView().getPageId();
            Forest forest = forestMap.get(pageId);
            if (forest == null) {
                forest = new Forest();
                forestMap.put(pageId, forest);
            }
            for (DataRow row : rows) {
                String id = String.valueOf(row.get((Object)"fid"));
                long prior = D.l((Object)row.get((Object)"fprior_id"));
                String parent = prior == 0L ? "" : String.valueOf(prior);
                String ftask_type = D.s((Object)row.get((Object)"ftask_type"));
                String ftask_number = D.s((Object)row.get((Object)"ftask_number"));
                String title = TraceType.getLabel((String)ftask_type) + "\uff1a" + ftask_number;
                TreeNode node = new TreeNode(parent, id, StringUtil.trim((String)title, (int)70));
                String fstate = D.s((Object)row.get((Object)"fstate"));
                String icon = "";
                if ("F".equals(fstate)) {
                    icon = "kdfont kdfont-jinggao-mian";
                    node.setIcon(icon);
                }
                String tag = D.s((Object)row.get((Object)"fprior_tag"));
                node.setData((Object)tag);
                if (tag != null) {
                    String cid = parent + "." + tag;
                    TreeNode treeNode = new TreeNode(parent, cid, Hash.mur32((Object[])new Object[]{tag}));
                    node.setParentid(cid);
                    tagNodes.add(treeNode);
                    nodes.add(treeNode);
                }
                this.addNode(forest, node, fstate, icon, title);
                nodes.add(node);
            }
            this.addTagNode(forest, tagNodes);
            ArrayList<TreeNode> arrayList = nodes;
            return arrayList;
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    private void addNode(Forest forest, TreeNode node, String state, String icon, String title) {
        forest.add(node.getId(), node.getParentid(), state, icon, title);
    }

    private void addTagNode(Forest forest, List<TreeNode> tagNodes) {
        for (TreeNode treeNode : tagNodes) {
            Forest.Node node = forest.search(treeNode.getParentid());
            treeNode.setIcon(node.getIcon());
            Forest.Node tagNode = new Forest.Node(treeNode.getId(), treeNode.getParentid(), node.getState(), node.getIcon(), node.getTitle());
            tagNode.setParent(node);
            node.getNodeList().add(tagNode);
        }
        forest.adjustNodes();
    }

    private List<TreeNode> loadItems(Map<String, Object> params) {
        List<Object> traceIds = this.findTraceIds(params);
        if (traceIds.isEmpty()) {
            return Collections.emptyList();
        }
        StringBuilder sql = new StringBuilder("SELECT TOP 500 fid,fstate,ftask_type,ftask_number,ftask_def_id,fprior_tag,fprior_id FROM t_iscb_biz_trace_tree WHERE ftrace_id in(");
        ArrayList<Integer> types = new ArrayList<Integer>(traceIds.size());
        for (int i = 0; i < traceIds.size(); ++i) {
            sql.append("?,");
            types.add(-5);
        }
        sql.setCharAt(sql.length() - 1, ')');
        sql.append(" ORDER BY fstart_time, fid");
        return this.getTreeNodes(traceIds, sql, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> findTraceIds(Map<String, Object> params) {
        long id;
        String sql = "SELECT distinct ftrace_id FROM t_iscb_biz_trace_tree WHERE ";
        Object fid = params.get("fid");
        if (fid != null) {
            sql = sql + " ftask_def_id IN(SELECT ftask_def_id FROM t_iscb_biz_trace_tree WHERE fid=?)";
            id = D.l((Object)fid);
        } else {
            sql = sql + " ftask_def_id=?";
            id = D.l((Object)params.get("ftask_def_id"));
        }
        if (id == 0L) {
            return Collections.emptyList();
        }
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            List list = DbUtil.executeList((Connection)cn, (String)sql, Collections.singletonList(id), Collections.singletonList(-5));
            ArrayList<Long> traceIds = new ArrayList<Long>(list.size());
            for (DataRow row : list) {
                traceIds.add(D.l((Object)row.get((Object)"ftrace_id")));
            }
            ArrayList<Long> arrayList = traceIds;
            return arrayList;
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        this.initTree(params);
        this.getView().setEnable(Boolean.FALSE, new String[]{"btn_view_details"});
    }

    private void initTree(Map<String, Object> params) {
        List<TreeNode> nodes = this.loadItems(params);
        nodes = this.sort(nodes);
        this.appendTreeNodes(nodes);
    }

    private List<TreeNode> sort(List<TreeNode> nodes) {
        ArrayList<TreeNode> sorted = new ArrayList<TreeNode>(nodes.size());
        HashSet<String> visited = new HashSet<String>(nodes.size());
        visited.add("");
        while (nodes.size() > 0) {
            Iterator<TreeNode> it = nodes.iterator();
            boolean changed = false;
            while (it.hasNext()) {
                TreeNode node = it.next();
                String parent = node.getParentid();
                if (!visited.contains(parent)) continue;
                changed = true;
                visited.add(node.getId());
                sorted.add(node);
                it.remove();
            }
            if (changed) continue;
            nodes.get(0).setParentid("");
        }
        if (sorted.isEmpty()) {
            sorted.add(new TreeNode("", "0", ResManager.loadKDString((String)"\u8ffd\u6eaf\u4fe1\u606f\u672a\u627e\u5230", (String)"IscBizTraceTreePlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])));
        }
        return sorted;
    }

    private void appendTreeNodes(List<TreeNode> nodes) {
        TreeView tree = (TreeView)this.getControl(TREEVIEW);
        tree.deleteAllNodes();
        for (TreeNode node : nodes) {
            tree.addNode(node);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("view_details".equals(e.getOperateKey())) {
            long id;
            String entity = this.getPageCache().get("TASK_FORM");
            if (QueryServiceHelper.exists((String)entity, (Object)(id = D.l((Object)this.getPageCache().get("TASK_ID"))))) {
                String tag = this.getPageCache().get("TASK_TAG");
                if (tag == null) {
                    FormOpener.showView((AbstractFormPlugin)this, entity, (Object)id, true);
                } else if (entity.equals("isc_service_flow_r")) {
                    Util.openFlowDiagram(this, id, tag);
                } else if (entity.equals("isc_sf_proc_inst")) {
                    Util.openProcessDiagram(this, id, tag);
                } else {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"TODO - \u5173\u8054\u6570\u636e\u7c7b\u578b\uff08%s\uff09\u4e0d\u652f\u6301tag\u67e5\u770b\u3002", (String)"IscBizTraceTreePlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), entity));
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u6570\u636e\u5df2\u5220\u9664\uff0c\u65e0\u6cd5\u67e5\u770b\u3002", (String)"IscBizTraceTreePlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        int i = nodeId.indexOf(46);
        long fid = D.l((Object)(i < 0 ? nodeId : nodeId.substring(0, i)));
        if (fid == 0L) {
            return;
        }
        DynamicObject item = BusinessDataServiceHelper.loadSingle((Object)fid, (String)"isc_biz_trace");
        String tag = i < 0 ? null : nodeId.substring(i + 1);
        String text = this.generateHTML(item, tag);
        Html html = (Html)this.getControl("content");
        html.setConent(text);
        String entity = TraceType.getEntity((String)item.getString("task_type"), (String)item.getString("task_number"));
        this.getView().setEnable(Boolean.valueOf(entity != null), new String[]{"btn_view_details"});
        this.getPageCache().put("TASK_ID", String.valueOf(item.get("task_def")));
        this.getPageCache().put("TASK_TAG", tag);
        this.getPageCache().put("TASK_FORM", entity == null ? "" : entity);
    }

    private String generateHTML(DynamicObject item, String tag) {
        StringBuilder html = new StringBuilder();
        String type = item.getString("task_type");
        String number = item.getString("task_number");
        String xType = ResManager.loadKDString((String)"\u7c7b\u578b", (String)"IscBizTraceTreePlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        String xNumber = ResManager.loadKDString((String)"\u7f16\u7801", (String)"IscBizTraceTreePlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        String xStartTime = ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4", (String)"IscBizTraceTreePlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        String xElapsedTime = ResManager.loadKDString((String)"\u8017\u65f6", (String)"IscBizTraceTreePlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        String xState = ResManager.loadKDString((String)"\u72b6\u6001", (String)"IscBizTraceTreePlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        html.append("<div style='word-break:break-all;word-wrap:break-word;line-height:2em;'>");
        html.append(String.format("<p><b>%s</b>: ", xType));
        html.append(TraceType.getLabel((String)type));
        html.append(String.format("<p><b>%s</b>: ", xNumber));
        html.append(Xml.escape((String)number));
        html.append(String.format("<p><b>%s</b>: ", xStartTime));
        html.append(D.s((Object)item.get("start_time")));
        html.append(String.format("<p><b>%s</b>: ", xElapsedTime));
        html.append(TraceType.getTime((int)item.getInt("elapsed_time")));
        html.append(String.format("<p><b>%s</b>: ", xState));
        html.append("<font color='").append(TraceState.getColor((String)item.getString("state"))).append("'>");
        html.append(TraceState.getLabel((String)item.getString("state")));
        html.append("</font>");
        long defId = item.getLong("task_def");
        Map extInfo = TraceType.getExtInfo((String)type, (String)number, (long)defId, (String)tag);
        if (!extInfo.isEmpty()) {
            html.append("<hr size='1' color='lightgray'/>");
            for (Map.Entry e : extInfo.entrySet()) {
                html.append("<p><b>").append((String)e.getKey()).append("</b>: ");
                html.append(Xml.escape((String)D.s(e.getValue())));
            }
        }
        html.append("</div>");
        return html.toString();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String pageId = this.getView().getPageId();
        forestMap.remove(pageId);
    }
}

