/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.trace;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.common.RecycleResourceListPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.util.MultiLangUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Pair;

public class ResourceHistoryListPlugin
extends AbstractListPlugin
implements Const {
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        try {
            String operateKey = args.getOperateKey();
            if ("diff_comp".equals(operateKey)) {
                Pair<Object, Object> twins = FormOpener.getSelectedTwins((AbstractFormPlugin)this, args);
                if (twins != null) {
                    DynamicObject ra = this.load(twins.getA());
                    DynamicObject rb = this.load(twins.getB());
                    if (!ra.get("resid").equals(rb.get("resid")) || !ra.get("res_type").equals(rb.get("res_type"))) {
                        throw new IscBizException(ResManager.loadKDString((String)"\u6240\u9009\u8d44\u6e90\u4e0d\u5c5e\u4e8e\u540c\u4e00\u4e2a\u5355\u636e\u3002", (String)"ResourceHistoryListPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                    }
                    if (D.i((Object)ra.get("version")) > D.i((Object)rb.get("version"))) {
                        DynamicObject tmp = ra;
                        ra = rb;
                        rb = tmp;
                    }
                    ResourceHistoryListPlugin.showDiff((AbstractFormPlugin)this, ra, rb);
                }
            } else if ("restore".equals(operateKey)) {
                this.restoreHistory(D.l((Object)FormOpener.getSelectedId((AbstractFormPlugin)this, args)));
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private void restoreHistory(long pkid) {
        if (pkid == 0L) {
            return;
        }
        DynamicObject obj = QueryServiceHelper.queryOne((String)"isc_res_history", (String)"res_type,res_content_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkid)});
        String resType = obj.getString("res_type");
        RecycleResourceListPlugin.restore(resType, obj.getString("res_content_tag"));
    }

    private static void showDiff(AbstractFormPlugin form, DynamicObject ra, DynamicObject rb) {
        Object detailsTag;
        Map a = (Map)Json.toObject((String)ra.getString("res_content_tag"));
        Map b = (Map)Json.toObject((String)rb.getString("res_content_tag"));
        Object raDefJsonTag = a.get("define_json_tag");
        if (raDefJsonTag != null) {
            a.put("define_json_tag", Json.toObject((String)D.s(raDefJsonTag)));
            b.put("define_json_tag", Json.toObject((String)D.s(b.get("define_json_tag"))));
        }
        if ("iscx_resource".equals(ra.get("res_type")) && (detailsTag = a.get("details_tag")) != null) {
            a.put("details_tag", Json.toObject((String)D.s(detailsTag)));
            b.put("details_tag", Json.toObject((String)D.s(b.get("details_tag"))));
        }
        if (!Objects.equals(ra.get("operate_key"), rb.get("operate_key"))) {
            ResourceHistoryListPlugin.removeKeys(a, b);
            ResourceHistoryListPlugin.removeKeys(b, a);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("A", a);
        params.put("B", b);
        params.put("entity", ra.get("res_type"));
        FormOpener.showForm(form, "isc_diff_comp", String.format(ResManager.loadKDString((String)"\u6570\u636e\u5dee\u5f02\u5bf9\u6bd4%s", (String)"ResourceHistoryListPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ResourceHistoryListPlugin.showName(a)), params, null);
    }

    private static String showName(Map<String, Object> mb) {
        Object name = mb.get("name");
        String zh_cn = "";
        if (name != null) {
            if (name instanceof Map) {
                zh_cn = MultiLangUtil.getMultiLangValue((Object)name);
                if (zh_cn != null) {
                    return "_" + zh_cn;
                }
            } else {
                return "_" + D.s((Object)name);
            }
        }
        return zh_cn;
    }

    private static void removeKeys(Map<String, Object> a, Map<String, Object> b) {
        Iterator<Map.Entry<String, Object>> it = a.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> e = it.next();
            if (b.containsKey(e.getKey())) continue;
            it.remove();
        }
    }

    private DynamicObject load(Object id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_res_history");
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if ("continue_restore".equals(evt.getCallBackId()) && evt.getResult() == MessageBoxResult.Yes) {
            String id = evt.getCustomVaule();
            if (this.isLatestVersion(id)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u662f\u5f53\u524d\u7248\u672c", (String)"ResourceHistoryListPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            this.restoreHistory(D.l((Object)id));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8fd8\u539f\u6210\u529f", (String)"ResourceHistoryListPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operationKey = operate.getOperateKey();
        if ("restore".equals(operationKey)) {
            if (args.getListSelectedData().size() != 1) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u884c", (String)"ResourceHistoryListPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject obj = QueryServiceHelper.queryOne((String)"isc_res_history", (String)"res_type,res_content_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", args.getListSelectedData().get(0).getPrimaryKeyValue())});
            if (obj != null && "isc_database_link".equals(obj.getString("res_type"))) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u914d\u7f6e\u4e0d\u652f\u6301\u8fd8\u539f\u3002", (String)"ResourceHistoryListPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            args.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_restore", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u5b58\u5728\u7684ID\u76f8\u540c\u7684\u8d44\u6e90\u5c06\u4f1a\u88ab\u8986\u76d6\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ResourceHistoryListPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks, null, D.s((Object)args.getListSelectedData().get(0).getPrimaryKeyValue()));
        }
    }

    private boolean isLatestVersion(Object id) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_res_history", (String)"resid,res_type,version");
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"isc_res_history", (String)"version", (QFilter[])new QFilter[]{new QFilter("resid", "=", obj.get("resid"))}, (String)"created_time desc", (int)1);
        return QueryServiceHelper.exists((String)obj.getString("res_type"), (Object)obj.get("resid")) && objs[0].getInt("version") == obj.getInt("version");
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (D.x(customParams.get("hidden_restore"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"restore"});
        }
    }
}

