/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.util;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.isc.iscb.platform.core.constant.MappingType;
import kd.isc.iscb.platform.core.meta.MetaSchemaUtil;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.syndata.MapDataUtil;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;

public class AutoMappingUtil
implements Const {
    private static final String RULE_TYPE = "rule_type";
    private static final String SOURCE_DATA_SOURCE = "source_data_source";
    private static final String TARGET_DATA_SOURCE = "target_data_source";
    private static final String ISC_VALUE_CONVER_RULE2 = "isc_value_conver_rule";
    private static final String TARGET_DATA_SCHEMA = "target_data_schema";
    private static final String SOURCE_DATA_SCHEMA = "source_data_schema";
    private static final String FULL_NUMBER2 = "full_number";
    private static final String PROP_LABEL = "prop_label";
    private static final String GROUP_ID = "group_id";
    private static final String NUMBER2 = "number";
    private static final String GROUP = "group";
    private static final String TYPE_ENTRIES = "ENTRIES";
    private static final String TYPE_ENUM = "ENUM";
    private static final String TYPE_REF = "REF";
    private static final String PROP_NAME = "prop_name";
    private static final String DATA_SCHEMA2 = "data_schema";
    private static final String DATA_TYPE2 = "data_type";
    private static final String PROP_ENTRYENTITY2 = "prop_entryentity";
    private static final String ISC_METADATA_SCHEMA2 = "isc_metadata_schema";
    private static final String MAPPING_ENTRIES2 = "mapping_entries";
    private static final String MAPPING_ENTRIES = "mapping_entries";
    private static final String MAPPING_TAR_COLUMN = "mapping_tar_column";
    private static final String TAR_DESC = "tar_desc";
    private static final String SRC_DESC = "src_desc";
    private static final String MAPPING_SRC_COLUMN = "mapping_src_column";
    private static final String CANDIDATE_KEY = "candidate_key";
    public static final String FILE_LIST = "$file_list.tarAttachId";

    public static void createMapping(long source_schema_id, long target_schema_id, IFormView view, boolean supportFile) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)ISC_METADATA_SCHEMA2);
        HashMap<String, String> src_columns = new HashMap<String, String>();
        HashMap<String, Map<String, String>> src_entry_columns = new HashMap<String, Map<String, String>>();
        HashMap<String, String> src_dt = new HashMap<String, String>();
        HashMap<String, Map<String, String>> src_entry_dt = new HashMap<String, Map<String, String>>();
        if (source_schema_id > 0L) {
            DynamicObject source_schema = BusinessDataServiceHelper.loadSingle((Object)source_schema_id, (DynamicObjectType)entityType);
            DynamicObjectCollection src_props = source_schema.getDynamicObjectCollection(PROP_ENTRYENTITY2);
            AutoMappingUtil.initSrcColumns(src_columns, src_entry_columns, source_schema, src_props, src_dt, src_entry_dt, supportFile);
        }
        if (target_schema_id > 0L) {
            DynamicObject target_schema = BusinessDataServiceHelper.loadSingle((Object)target_schema_id, (DynamicObjectType)entityType);
            DynamicObjectCollection mapping_entries = view.getModel().getDataEntity().getDynamicObjectCollection("mapping_entries");
            mapping_entries.clear();
            ArrayList<DynamicObject> entryList = new ArrayList<DynamicObject>();
            AutoMappingUtil.initMainProp(src_columns, target_schema, mapping_entries, entryList, src_dt, supportFile);
            AutoMappingUtil.initEntryProp(src_entry_columns, target_schema, mapping_entries, entryList, src_entry_dt);
            view.getModel().getDataEntity(true).set("mapping_entries", (Object)mapping_entries);
            view.updateView("mapping_entries");
        }
    }

    private static void initSrcColumns(Map<String, String> src_columns, Map<String, Map<String, String>> src_entry_columns, DynamicObject source_schema, DynamicObjectCollection src_props, Map<String, String> src_dt, Map<String, Map<String, String>> src_entry_dt, boolean supportFile) {
        for (DynamicObject src_prop : src_props) {
            String data_type = src_prop.getString(DATA_TYPE2);
            String data_schema = src_prop.getString(DATA_SCHEMA2);
            String prop_name = src_prop.getString(PROP_NAME);
            if (AutoMappingUtil.isAttachmentField(data_schema)) {
                if (!supportFile) continue;
                src_columns.put(FILE_LIST, ResManager.loadKDString((String)"\u76ee\u6807\u9644\u4ef6id - string", (String)"AutoMappingUtil_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                src_dt.put(FILE_LIST, "string");
                continue;
            }
            if (TYPE_ENTRIES.equals(data_type) || "SubHeadEntity".equals(data_type)) {
                DynamicObject entrySchema = AutoMappingUtil.getSchema(src_prop, source_schema.getLong(GROUP_ID));
                HashMap<String, String> entryPropMap = new HashMap<String, String>();
                HashMap<String, String> entry_dt_map = new HashMap<String, String>();
                DynamicObjectCollection entryProps = entrySchema.getDynamicObjectCollection(PROP_ENTRYENTITY2);
                for (DynamicObject entryProp : entryProps) {
                    entryPropMap.put(entryProp.getString(PROP_NAME), AutoMappingUtil.getDescription(entryProp, src_prop.getString(PROP_LABEL)));
                    entry_dt_map.put(entryProp.getString(PROP_NAME), entryProp.getString(DATA_TYPE2));
                }
                entryPropMap.put("main_entry_prefix", src_prop.getString(PROP_NAME) + ".");
                src_entry_columns.put(src_prop.getString(DATA_SCHEMA2), entryPropMap);
                src_entry_columns.put(prop_name, entryPropMap);
                src_entry_dt.put(src_prop.getString(DATA_SCHEMA2), entry_dt_map);
                src_entry_dt.put(prop_name, entry_dt_map);
                continue;
            }
            src_columns.put(prop_name, AutoMappingUtil.getDescription(src_prop));
            src_dt.put(prop_name, data_type);
        }
    }

    private static boolean isAttachmentField(String data_schema) {
        return "bd_attachment".equals(data_schema) || "bos_attachment".equals(data_schema);
    }

    private static void initMainProp(Map<String, String> src_columns, DynamicObject target_schema, DynamicObjectCollection mapping_entries, List<DynamicObject> entryList, Map<String, String> src_dt, boolean supportFile) {
        DynamicObjectCollection tar_props = target_schema.getDynamicObjectCollection(PROP_ENTRYENTITY2);
        for (DynamicObject prop : tar_props) {
            String dt;
            String data_type = prop.getString(DATA_TYPE2);
            String data_schema = prop.getString(DATA_SCHEMA2);
            if (AutoMappingUtil.isAttachmentField(data_schema)) {
                if (!supportFile) continue;
                AutoMappingUtil.setAttachmentProp(src_columns, mapping_entries, prop, src_dt, target_schema);
                continue;
            }
            if (TYPE_ENTRIES.equals(data_type) || "SubHeadEntity".equals(data_type)) {
                entryList.add(prop);
                continue;
            }
            String prop_name = prop.getString(PROP_NAME);
            if (AutoMappingUtil.isPkFiled(prop, target_schema)) continue;
            DynamicObject item = mapping_entries.addNew();
            item.set(MAPPING_TAR_COLUMN, (Object)prop_name);
            String tar_desc = AutoMappingUtil.getDescription(prop);
            item.set(TAR_DESC, (Object)tar_desc);
            item.set(CANDIDATE_KEY, (Object)Boolean.FALSE);
            String srcDesc = src_columns.get(prop_name);
            if (src_columns.size() <= 0 || srcDesc == null || (dt = src_dt.get(prop_name)) == null || !dt.equals(data_type)) continue;
            item.set(MAPPING_SRC_COLUMN, (Object)prop_name);
            item.set(SRC_DESC, (Object)srcDesc);
        }
    }

    private static boolean isPkFiled(DynamicObject prop, DynamicObject target_schema) {
        return D.x((Object)prop.get("is_primary_key")) && "ENTITY".equals(target_schema.get("type"));
    }

    private static void setAttachmentProp(Map<String, String> src_columns, DynamicObjectCollection mapping_entries, DynamicObject prop, Map<String, String> src_dt, DynamicObject target_schema) {
        String dt;
        DynamicObject schema = AutoMappingUtil.getSchema(prop, target_schema.getLong(GROUP_ID));
        if (schema == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u76ee\u6807\u7cfb\u7edf\u6ca1\u6709\u7f16\u7801\u4e3a%s\u7684\u96c6\u6210\u5bf9\u8c61\uff0c\u8bf7\u624b\u5de5\u65b0\u589e\u6216\u5168\u91cf\u540c\u6b65\u96c6\u6210\u5bf9\u8c61\u3002", (String)"AutoMappingUtil_23", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), prop.getString(DATA_SCHEMA2)));
        }
        DynamicObject item = mapping_entries.addNew();
        String prop_name = prop.getString(PROP_NAME);
        item.set(MAPPING_TAR_COLUMN, (Object)(prop_name + ".id"));
        item.set(TAR_DESC, (Object)ResManager.loadKDString((String)"\u9644\u4ef6id - string", (String)"AutoMappingUtil_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        String src_desc = src_columns.get(FILE_LIST);
        if (src_desc != null && src_desc.contains(dt = src_dt.get(FILE_LIST))) {
            item.set(MAPPING_SRC_COLUMN, (Object)FILE_LIST);
            item.set(SRC_DESC, (Object)src_desc);
        }
    }

    public static DynamicObject getSchema(DynamicObject entryProp, long groupId) {
        String number = entryProp.getString(DATA_SCHEMA2);
        String name = entryProp.getString(PROP_NAME);
        QFilter filter = new QFilter(NUMBER2, "=", (Object)number).and(new QFilter(GROUP, "=", (Object)groupId));
        DynamicObject[] schemas = BusinessDataServiceHelper.load((String)ISC_METADATA_SCHEMA2, (String)"type,full_name", (QFilter[])new QFilter[]{filter}, null);
        if (schemas.length == 1) {
            return BusinessDataServiceHelper.loadSingle((Object)schemas[0].getPkValue(), (String)ISC_METADATA_SCHEMA2);
        }
        StringBuilder errorMsg = AutoMappingUtil.constructErrorMsg(entryProp, number, name);
        if (schemas.length != 0) {
            long id = MetaSchemaUtil.getHashId((MetaType)MetaType.valueOf((String)schemas[0].getString("type")), (long)groupId, (String)schemas[0].getString("full_name"));
            return BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_METADATA_SCHEMA2);
        }
        errorMsg.append(ResManager.loadKDString((String)"\u672a\u627e\u5230\uff01", (String)"AutoMappingUtil_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        throw new IscBizException(errorMsg.toString());
    }

    private static StringBuilder constructErrorMsg(DynamicObject entryProp, String number, String name) {
        DynamicObject parent = (DynamicObject)entryProp.getParent();
        String parentNumber = parent.getString(NUMBER2);
        String parentName = parent.getString("name");
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61\uff08\u7f16\u7801\uff1a%1$s\uff0c\u540d\u79f0\uff1a%2$s\uff09\u7684\u5206\u5f55\u5c5e\u6027\uff08%3$s\uff09\u5f15\u7528\u7684\u7f16\u7801\u662f\uff08%4$s\uff09\u7684\u5143\u6570\u636e", (String)"AutoMappingUtil_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), parentNumber, parentName, name, number));
        return errorMsg;
    }

    public static String getDescription(DynamicObject prop, String prefix) {
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix).append('.');
        }
        sb.append(prop.getString(PROP_LABEL)).append(" - ").append(prop.getString(DATA_TYPE2));
        if (prop.getBoolean("is_primary_key")) {
            sb.append(ResManager.loadKDString((String)" - \u4e3b\u952e", (String)"AutoMappingUtil_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else if (prop.getBoolean("required")) {
            sb.append(ResManager.loadKDString((String)" - \u5fc5\u586b", (String)"AutoMappingUtil_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        return sb.toString();
    }

    private static String getDescription(DynamicObject prop) {
        return AutoMappingUtil.getDescription(prop, null);
    }

    private static void initEntryProp(Map<String, Map<String, String>> src_entry_columns, DynamicObject target_schema, DynamicObjectCollection mapping_entries, List<DynamicObject> entryList, Map<String, Map<String, String>> src_entry_dt) {
        for (DynamicObject prop : entryList) {
            String prefix = prop.getString(PROP_NAME) + ".";
            String data_schema = prop.getString(DATA_SCHEMA2);
            DynamicObject entrySchema = AutoMappingUtil.getSchema(prop, target_schema.getLong(GROUP_ID));
            DynamicObjectCollection entryProps = entrySchema.getDynamicObjectCollection(PROP_ENTRYENTITY2);
            Map<String, String> refSrcEntryColumn = src_entry_columns.get(data_schema);
            if (refSrcEntryColumn == null) {
                refSrcEntryColumn = src_entry_columns.get(prop.getString(PROP_NAME));
            }
            for (DynamicObject entryProp : entryProps) {
                String data_type = entryProp.getString(DATA_TYPE2);
                if (TYPE_ENTRIES.equals(data_type)) continue;
                String entryPropName = entryProp.getString(PROP_NAME);
                if (AutoMappingUtil.isPkFiled(entryProp, target_schema)) continue;
                DynamicObject item = mapping_entries.addNew();
                String entryPropNameAndPrefix = prefix + entryPropName;
                item.set(MAPPING_TAR_COLUMN, (Object)entryPropNameAndPrefix);
                String tar_desc = AutoMappingUtil.getDescription(entryProp, prop.getString(PROP_LABEL));
                item.set(TAR_DESC, (Object)tar_desc);
                item.set(CANDIDATE_KEY, (Object)Boolean.FALSE);
                if (refSrcEntryColumn == null || !refSrcEntryColumn.containsKey(entryPropName)) continue;
                item.set(MAPPING_SRC_COLUMN, (Object)(refSrcEntryColumn.get("main_entry_prefix") + entryPropName));
                item.set(SRC_DESC, (Object)refSrcEntryColumn.get(entryPropName));
            }
        }
    }

    private static String getDescription(Map<?, ?> map) {
        StringBuilder sb = new StringBuilder();
        sb.append(map.get("full_name")).append(" - ").append(map.get(DATA_TYPE2));
        if (D.x(map.get("is_primary_key"))) {
            sb.append(ResManager.loadKDString((String)" - \u4e3b\u952e", (String)"AutoMappingUtil_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else if (D.x(map.get("required"))) {
            sb.append(ResManager.loadKDString((String)" - \u5fc5\u586b", (String)"AutoMappingUtil_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        return sb.toString();
    }

    public static void setMappingColumnValues(Map<?, ?> data, int index, IFormView view) {
        DynamicObject row = view.getModel().getEntryRowEntity("mapping_entries", index);
        if (data.get("$type").toString().equals("src")) {
            row.set(MAPPING_SRC_COLUMN, data.get(FULL_NUMBER2));
            row.set(SRC_DESC, (Object)AutoMappingUtil.getDescription(data));
        } else if (data.get("$type").toString().equals("tar")) {
            row.set(MAPPING_TAR_COLUMN, data.get(FULL_NUMBER2));
            row.set(TAR_DESC, (Object)AutoMappingUtil.getDescription(data));
        }
        view.updateView("mapping_entries");
    }

    public static void setReturnListValues(List<Map<String, Object>> data, IFormView view) {
        DynamicObjectCollection fieldEntries = view.getModel().getDataEntity(true).getDynamicObjectCollection("mapping_entries");
        for (Map<String, Object> item : data) {
            if (AutoMappingUtil.hasField(fieldEntries, item)) continue;
            DynamicObject entry = fieldEntries.addNew();
            entry.set(MAPPING_TAR_COLUMN, item.get(FULL_NUMBER2));
            entry.set(TAR_DESC, (Object)AutoMappingUtil.getDescription(item));
        }
        view.updateView("mapping_entries");
    }

    private static boolean hasField(DynamicObjectCollection entries, Map<String, Object> item) {
        return entries.stream().anyMatch(x -> x.getString(MAPPING_TAR_COLUMN).equals(item.get(FULL_NUMBER2)));
    }

    public static DynamicObject doCreateConvertRule(long srcId, long tarId, IFormView view) {
        EntryGrid mapping_entries = (EntryGrid)view.getControl("mapping_entries");
        int[] selectRows = mapping_entries.getSelectRows();
        if (selectRows.length != 1) {
            view.showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9 1 \u6761\u8bb0\u5f55!", (String)"AutoMappingUtil_14", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return null;
        }
        DynamicObject rule = null;
        DynamicObject entryRowEntity = view.getModel().getEntryRowEntity("mapping_entries", selectRows[0]);
        String tar_desc = entryRowEntity.getString(TAR_DESC);
        String src_desc = entryRowEntity.getString(SRC_DESC);
        if (AutoMappingUtil.isRefOrEnum(tar_desc) && AutoMappingUtil.isRefOrEnum(src_desc)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6e90\u5bf9\u8c61\u5b57\u6bb5\u6216\u76ee\u6807\u5bf9\u8c61\u5b57\u6bb5\u4e3aref\u6216enum\u7c7b\u578b\u4e14\u5b57\u6bb5\u4e0d\u4e3a\u7a7a\u624d\u80fd\u76f4\u63a5\u521b\u5efa\u503c\u8f6c\u6362\u89c4\u5219\uff01", (String)"AutoMappingUtil_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(10000));
            return null;
        }
        if (srcId > 0L && tarId > 0L) {
            if (srcId == tarId) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6e90\u5bf9\u8c61\u548c\u76ee\u6807\u5bf9\u8c61\u662f\u540c\u4e00\u4e2a\uff0c\u4e0d\u9700\u8981\u521b\u5efa\u8f6c\u6362\u89c4\u5219", (String)"AutoMappingUtil_16", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return null;
            }
            String mapping_tar_column = entryRowEntity.getString(MAPPING_TAR_COLUMN);
            String mapping_src_column = entryRowEntity.getString(MAPPING_SRC_COLUMN);
            if (StringUtils.isNotEmpty((String)mapping_src_column) && StringUtils.isNotEmpty((String)mapping_tar_column)) {
                DynamicObject src_column_schema = AutoMappingUtil.getColumnDataSchema(srcId, mapping_src_column);
                DynamicObject tar_column_schema = AutoMappingUtil.getColumnDataSchema(tarId, mapping_tar_column);
                if (src_column_schema != null && tar_column_schema != null) {
                    long src_data_schema_id = src_column_schema.getLong("id");
                    long tar_data_schema_id = tar_column_schema.getLong("id");
                    if (src_data_schema_id > 0L && tar_data_schema_id > 0L) {
                        rule = AutoMappingUtil.createBaseSchemaAndMappingRule(src_data_schema_id, tar_data_schema_id);
                    } else if (src_data_schema_id > 0L || tar_data_schema_id > 0L) {
                        rule = AutoMappingUtil.createOtherMappingRule(src_column_schema, tar_column_schema);
                    }
                    if (rule != null) {
                        entryRowEntity.set("value_conver_rule", (Object)rule);
                        DynamicObjectCollection mappingEntries = view.getModel().getDataEntity().getDynamicObjectCollection("mapping_entries");
                        mappingEntries.set(selectRows[0], (Object)entryRowEntity);
                        view.getModel().getDataEntity(true).set("mapping_entries", (Object)mappingEntries);
                    }
                }
            } else {
                if (StringUtils.isEmpty((String)mapping_src_column)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u6e90\u5bf9\u8c61\u5b57\u6bb5\u4e3a\u7a7a", (String)"AutoMappingUtil_17", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                    return null;
                }
                if (StringUtils.isEmpty((String)mapping_tar_column)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u5bf9\u8c61\u5b57\u6bb5\u4e3a\u7a7a", (String)"AutoMappingUtil_18", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                    return null;
                }
            }
        }
        return rule;
    }

    private static boolean isRefOrEnum(String desc) {
        return StringUtils.isEmpty((String)desc) || !desc.contains(TYPE_ENUM) && !desc.contains(TYPE_REF);
    }

    private static DynamicObject getColumnDataSchema(long schemaId, String columnName) {
        DynamicObject source_schema = BusinessDataServiceHelper.loadSingle((Object)schemaId, (String)ISC_METADATA_SCHEMA2);
        DynamicObjectCollection prop_entryentity = source_schema.getDynamicObjectCollection(PROP_ENTRYENTITY2);
        DynamicObject dynamicObject = null;
        String[] split = null;
        if (columnName.contains(".") && (split = columnName.split("\\.")).length == 2) {
            columnName = split[0];
        }
        for (DynamicObject prop : prop_entryentity) {
            if (!columnName.equals(prop.getString(PROP_NAME))) continue;
            String data_schema = prop.getString(DATA_SCHEMA2);
            long data_source_id = source_schema.getLong(GROUP_ID);
            String data_type = prop.getString(DATA_TYPE2);
            QFilter qFilter = new QFilter(GROUP, "=", (Object)data_source_id);
            if (TYPE_REF.equals(data_type) || TYPE_ENUM.equals(data_type) || TYPE_ENTRIES.equals(data_type)) {
                qFilter.and(NUMBER2, "=", (Object)data_schema);
                dynamicObject = BusinessDataServiceHelper.loadSingle((String)ISC_METADATA_SCHEMA2, (String)"id", (QFilter[])new QFilter[]{qFilter});
                if (dynamicObject == null) {
                    throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5[%1$s]\u6839\u636e\u6570\u636e\u6a21\u578b%2$s\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u96c6\u6210\u5bf9\u8c61", (String)"AutoMappingUtil_24", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), columnName, data_schema));
                }
                if (TYPE_ENTRIES.equals(data_type)) {
                    if (null != split && split.length == 2) {
                        return AutoMappingUtil.getColumnDataSchema(dynamicObject.getLong("id"), split[1]);
                    }
                    throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5[%s]\u540d\u79f0\u5f02\u5e38", (String)"AutoMappingUtil_25", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), columnName));
                }
                return dynamicObject;
            }
            DynamicObject basicSchema = BusinessDataServiceHelper.newDynamicObject((String)ISC_METADATA_SCHEMA2);
            basicSchema.set("type", (Object)data_type);
            basicSchema.set(GROUP, (Object)data_source_id);
            basicSchema.set(GROUP_ID, (Object)data_source_id);
            return basicSchema;
        }
        return null;
    }

    private static DynamicObject createBaseSchemaAndMappingRule(long src_data_schema_id, long tar_data_schema_id) {
        MapDataUtil.createBaseSchemaIfNotExists((long)src_data_schema_id);
        MapDataUtil.createBaseSchemaIfNotExists((long)tar_data_schema_id);
        QFilter qFilter = new QFilter(SOURCE_DATA_SCHEMA, "=", (Object)src_data_schema_id);
        qFilter.and(TARGET_DATA_SCHEMA, "=", (Object)tar_data_schema_id);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)ISC_VALUE_CONVER_RULE2, (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (obj == null) {
            return AutoMappingUtil.createMappingRule(src_data_schema_id, tar_data_schema_id);
        }
        return obj;
    }

    private static DynamicObject createOtherMappingRule(DynamicObject src_column_schema, DynamicObject tar_column_schema) {
        long src_schema_id = src_column_schema.getLong("id");
        long tar_schema_id = tar_column_schema.getLong("id");
        if (src_schema_id > 0L && tar_schema_id == 0L) {
            src_column_schema = BusinessDataServiceHelper.loadSingle((Object)src_schema_id, (String)ISC_METADATA_SCHEMA2);
            QFilter qFilter = new QFilter(SOURCE_DATA_SCHEMA, "=", (Object)src_schema_id);
            qFilter.and(TARGET_DATA_SOURCE, "=", (Object)tar_column_schema.getLong(GROUP_ID));
            qFilter.and(NUMBER2, "like", (Object)("%TO" + tar_column_schema.getString("type")));
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)ISC_VALUE_CONVER_RULE2, (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (obj == null) {
                return AutoMappingUtil.innerCreateRule(src_column_schema, tar_column_schema, src_schema_id, tar_schema_id);
            }
            return obj;
        }
        if (src_schema_id == 0L && tar_schema_id > 0L) {
            tar_column_schema = BusinessDataServiceHelper.loadSingle((Object)tar_schema_id, (String)ISC_METADATA_SCHEMA2);
            QFilter qFilter = new QFilter(TARGET_DATA_SCHEMA, "=", (Object)tar_schema_id);
            qFilter.and(SOURCE_DATA_SOURCE, "=", (Object)src_column_schema.getLong(GROUP_ID));
            qFilter.and(NUMBER2, "like", (Object)(src_column_schema.getString("type") + "TO%"));
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)ISC_VALUE_CONVER_RULE2, (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (obj == null) {
                return AutoMappingUtil.innerCreateRule(src_column_schema, tar_column_schema, src_schema_id, tar_schema_id);
            }
            return obj;
        }
        return null;
    }

    private static DynamicObject innerCreateRule(DynamicObject src_column_schema, DynamicObject tar_column_schema, long src_schema_id, long tar_schema_id) {
        DynamicObject newObject = BusinessDataServiceHelper.newDynamicObject((String)ISC_VALUE_CONVER_RULE2);
        String name = null;
        String number = null;
        if (src_schema_id > 0L) {
            newObject.set(SOURCE_DATA_SCHEMA, (Object)src_schema_id);
            name = src_column_schema.getString("name") + "-" + tar_column_schema.getString("type");
            number = Hash.mur32((Object[])new Object[]{name}) + "TO" + tar_column_schema.getString("type");
        }
        if (tar_schema_id > 0L) {
            newObject.set(TARGET_DATA_SCHEMA, (Object)tar_schema_id);
            name = src_column_schema.getString("type") + "-" + tar_column_schema.getString("name");
            number = src_column_schema.getString("type") + "TO" + Hash.mur32((Object[])new Object[]{name});
        }
        if (null != name && name.length() > 50) {
            name = name.substring(0, 50);
        }
        newObject.set(NUMBER2, number);
        newObject.set(SOURCE_DATA_SOURCE, src_column_schema.get(GROUP_ID));
        newObject.set(TARGET_DATA_SOURCE, tar_column_schema.get(GROUP_ID));
        if (TYPE_ENUM.equals(src_column_schema.getString("type")) || TYPE_ENUM.equals(tar_column_schema.getString("type"))) {
            newObject.set(RULE_TYPE, (Object)"tlb");
        } else {
            newObject.set(RULE_TYPE, (Object)"sql");
        }
        newObject.set("name", (Object)name);
        newObject.set("mapping_type", (Object)MappingType.UNKNOWN.getType());
        newObject.set("enable", (Object)"1");
        newObject.set("status", (Object)"C");
        newObject.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        newObject.set("modifytime", (Object)new Timestamp(System.currentTimeMillis()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newObject});
        return newObject;
    }

    private static DynamicObject createMappingRule(long src_data_schema_id, long tar_data_schema_id) {
        DynamicObject newObject = BusinessDataServiceHelper.newDynamicObject((String)ISC_VALUE_CONVER_RULE2);
        DynamicObject src_data_schema = BusinessDataServiceHelper.loadSingle((Object)src_data_schema_id, (String)ISC_METADATA_SCHEMA2);
        DynamicObject tar_data_schema = BusinessDataServiceHelper.loadSingle((Object)tar_data_schema_id, (String)ISC_METADATA_SCHEMA2);
        newObject.set(SOURCE_DATA_SCHEMA, (Object)src_data_schema_id);
        newObject.set(TARGET_DATA_SCHEMA, (Object)tar_data_schema_id);
        newObject.set(SOURCE_DATA_SOURCE, src_data_schema.get(GROUP_ID));
        newObject.set(TARGET_DATA_SOURCE, tar_data_schema.get(GROUP_ID));
        newObject.set(RULE_TYPE, (Object)"mapping");
        String name = src_data_schema.getString("name") + "-" + tar_data_schema.getString("name");
        name = name + "(" + src_data_schema.getDynamicObject(GROUP).getString("name") + "-" + tar_data_schema.getDynamicObject(GROUP).getString("name") + ")";
        if (name.length() > 50) {
            name = name.substring(0, 50);
        }
        newObject.set(NUMBER2, (Object)Hash.mur32((Object[])new Object[]{name}));
        newObject.set("name", (Object)name);
        MappingType mappingType = AutoMappingUtil.generateMappingType(src_data_schema, tar_data_schema);
        newObject.set("mapping_type", (Object)mappingType.getType());
        newObject.set("enable", (Object)"1");
        newObject.set("status", (Object)"C");
        newObject.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        newObject.set("modifytime", (Object)new Timestamp(System.currentTimeMillis()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newObject});
        return newObject;
    }

    private static MappingType generateMappingType(DynamicObject source_data_schema, DynamicObject target_data_schema) {
        String sourceType = source_data_schema.getString("type");
        String targetType = target_data_schema.getString("type");
        return MappingType.getType((String)(sourceType + "_" + targetType));
    }
}

