/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.cache.data.ConnectionConfig;
import kd.isc.iscb.platform.core.cache.data.DataSource;
import kd.isc.iscb.util.except.IscBizException;

public class DataSchemaUtil {
    private static final String PROP_NAME = "prop_name";
    private static final String DATA_TYPE2 = "data_type";
    private static final String PROP_ENTRYENTITY = "prop_entryentity";
    private static final String FIELD = "field";
    private static final String DESCRIPTION = "description";
    private static final String DATA_TYPE = "data_type";

    public static List<Map<String, Object>> getAllFields(long metaId) {
        ArrayList<Map<String, Object>> fields = new ArrayList<Map<String, Object>>();
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)metaId, (String)"isc_metadata_schema");
        long groupId = meta.getLong("group_id");
        DynamicObject config = ConnectionConfig.getConfig((long)DataSource.get((long)groupId).getDbLink());
        String connType = config.getString("database_type");
        DataSchemaUtil.recursiveAddField(fields, meta, groupId, "", connType);
        return fields;
    }

    private static void recursiveAddField(List<Map<String, Object>> fields, DynamicObject meta, long groupId, String parentPrefix, String connType) {
        if (meta != null) {
            DynamicObjectCollection props = meta.getDynamicObjectCollection(PROP_ENTRYENTITY);
            for (DynamicObject prop : props) {
                String dataType = prop.getString("data_type");
                if ("ENTRIES".equals(dataType)) {
                    DynamicObject schema = DataSchemaUtil.getSchema(prop, groupId, connType);
                    DataSchemaUtil.recursiveAddField(fields, schema, groupId, parentPrefix + prop.get(PROP_NAME) + ".", connType);
                    continue;
                }
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put(FIELD, parentPrefix + prop.get(PROP_NAME));
                item.put(DESCRIPTION, prop.get("prop_label"));
                item.put("data_type", prop.get("data_type"));
                fields.add(item);
            }
        }
    }

    private static DynamicObject getSchema(DynamicObject entryProp, long groupId, String connType) {
        String number = entryProp.getString("data_schema");
        if (DataSchemaUtil.isIerpAttachField(number, connType) || DataSchemaUtil.isEasAttachField(number, connType)) {
            return null;
        }
        QFilter filter = new QFilter("number", "=", (Object)number).and(new QFilter("group", "=", (Object)groupId));
        DynamicObject[] schemas = BusinessDataServiceHelper.load((String)"isc_metadata_schema", (String)"id", (QFilter[])new QFilter[]{filter}, null);
        if (schemas.length == 1) {
            return BusinessDataServiceHelper.loadSingle((Object)schemas[0].getPkValue(), (String)"isc_metadata_schema");
        }
        String name = entryProp.getString(PROP_NAME);
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u5c5e\u6027\uff08%1$s\uff09\u5f15\u7528\u7684\u7f16\u7801\u662f\uff08%2$s\uff09\u7684\u5143\u6570\u636e\u672a\u627e\u5230\u6216\u627e\u5230\u591a\u4e2a\uff01", (String)"DataSchemaUtil_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), name, number));
    }

    private static boolean isEasAttachField(String number, String connType) {
        return "$FILE_LIST".equals(number) && "eas".equals(connType);
    }

    private static boolean isIerpAttachField(String number, String connType) {
        return ("bos_attachment".equals(number) || "bd_attachment".equals(number)) && "self".equals(connType);
    }
}

