/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.util;

import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.util.dt.D;

public class OpenApiServiceUtil {
    public static final String API_NUMBER_PATTERN = "[^0-9a-zA-Z_-]";
    public static final String AUTHORIZE = "authorize";

    public static boolean isValid(String number) {
        if (number == null) {
            return false;
        }
        int length = number.length();
        for (int i = 0; i < length; ++i) {
            char c = number.charAt(i);
            if (OpenApiServiceUtil.isValid(c)) continue;
            return false;
        }
        return length > 0;
    }

    private static boolean isValid(char c) {
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        if (c >= '0' && c <= '9') {
            return true;
        }
        return c == '_' || c == '-';
    }

    public static boolean checkIllegalDbLink(DynamicObject object, IFormView view) {
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((Object)D.s((Object)object.get("group_id")), (String)"isc_data_source");
        if (dataSource.get("dblink") == null) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"%1$s \u7684\u6570\u636e\u6e90 %2$s \u6240\u5bf9\u5e94\u7684\u7cfb\u7edf\u8fde\u63a5\u4e0d\u5b58\u5728\uff0c\u8bf7\u524d\u5f80\u6570\u636e\u6e90\u7ba1\u7406\u914d\u7f6e\u76f8\u5e94\u7cfb\u7edf\u8fde\u63a5\u3002", (String)"OpenApiServiceUtil_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), object.getString("number"), dataSource.getString("number")));
            return true;
        }
        return false;
    }

    public static String formatUrl(String url) {
        String s = D.s((Object)url);
        if (s == null) {
            return "";
        }
        if (s.endsWith("/")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static boolean hasEnable(Object id, String entityName) {
        if (D.l((Object)id) == 0L) {
            return false;
        }
        QFilter[] qfs = new QFilter[]{new QFilter("id", "=", id), new QFilter("enable", "=", (Object)"1")};
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)entityName, (String)"id,enable", (QFilter[])qfs);
        return dynamicObjects != null && dynamicObjects.length != 0;
    }

    public static void authorize(AbstractFormPlugin form, DynamicObject api) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("type", api.getDynamicObjectType().getName());
        params.put("api", api.getPkValue());
        FormOpener.showForm(form, "isc_apic_permission", ResManager.loadKDString((String)"API\u6388\u6743", (String)"OpenApiServiceUtil_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
    }

    public static void showAuthList(AbstractFormPlugin form, String entityName) {
        long id = D.l((Object)form.getView().getModel().getValue("id"));
        QFilter qFilter = new QFilter("api_id", "=", (Object)id);
        qFilter.and("type", "=", (Object)entityName);
        FormOpener.showList(form, "isc_apic_permission", qFilter);
    }

    public static String getApiNumberPatternTips() {
        return ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u77ed\u6a2a\u7ebf\uff08-\uff09\u548c\u4e0b\u5212\u7ebf\uff08_\uff09", (String)"OpenApiServiceUtil_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
    }
}

