/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.param.AppParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.app.AppParameterServiceHelper;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class ScriptCommonUtil {
    private static Log logger = LogFactory.getLog(ScriptCommonUtil.class);

    public static String getEditor() {
        return "isc_script_editor_new";
    }

    public static void showEditor(AbstractFormPlugin form, String caption, Map<String, Object> params, String callback) {
        AppParam appParam = AppParameterServiceHelper.getAppParam();
        boolean isOpenNewSceneEditor = D.x((Object)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"open_scene_editorv2"));
        if (isOpenNewSceneEditor) {
            HashMap<String, Object> paramsCopy = new HashMap<String, Object>(params);
            paramsCopy.put("operate", "new_tab");
            if (!ScriptCommonUtil.openEditorTabIfExist(form, "isc_common_scriptv2", paramsCopy)) {
                ScriptCommonUtil.showModalEditor(form, caption, params, callback);
            }
        } else {
            FormOpener.showForm(form, "isc_script_editor_new", caption, params, callback);
        }
    }

    public static void showTabEditor(AbstractFormPlugin form, String caption, Map<String, Object> params, String callback) {
        FormOpener.showTabForm(form, "isc_common_scriptv2", caption, params, callback);
    }

    public static void showModalEditor(AbstractFormPlugin form, String caption, Map<String, Object> params, String callback) {
        params.put("caption", caption);
        params.put("actionId", callback);
        FormShowParameter p = new FormShowParameter();
        p.setFormId("isc_common_scriptv2");
        p.setCustomParams(params);
        p.setCaption(caption);
        if (callback != null) {
            p.setCloseCallBack(new CloseCallBack((IFormPlugin)form, callback));
        }
        p.setShowClose(true);
        p.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("1360px");
        styleCss.setHeight("700px");
        p.getOpenStyle().setInlineStyleCss(styleCss);
        form.getView().showForm(p);
    }

    public static boolean scripSizeLessThanThreshold(String script) {
        if (null == script) {
            return true;
        }
        int scriptLength = script.length();
        return scriptLength <= ScriptCommonUtil.getScriptLimitSize();
    }

    public static boolean openEditorTabIfExist(AbstractFormPlugin form, String entity, Map<String, Object> params) {
        try {
            IFormView appView;
            Control control;
            IFormView view = form.getView();
            IFormView mainView = view.getMainView();
            return mainView != null && !mainView.getPageId().equals(view.getPageId()) && (control = (appView = SessionManager.getCurrent().getViewNoPlugin(view.getFormShowParameter().getAppId() + mainView.getPageId())).getControl("_submaintab_")) instanceof Tab && ScriptCommonUtil.existEditorTabPage(entity, view, appView, (Tab)control, params);
        }
        catch (Exception e) {
            logger.warn("\u5224\u65ad\u662f\u5426\u5b58\u5728\u65b0\u9875\u7b7e\u65f6\u5931\u8d25,\u539f\u56e0\u662f\uff1a" + StringUtil.getCascadeMessage((Throwable)e), (Throwable)e);
            return false;
        }
    }

    public static boolean existEditorTabPage(String entity, IFormView view, IFormView appView, Tab control, Map<String, Object> params) {
        for (Object c : control.getItems()) {
            FormShowParameter formShowParameter;
            String formId;
            TabPage tabPage = (TabPage)c;
            String tabPageKey = tabPage.getKey();
            IFormView lv = appView.getViewNoPlugin(tabPageKey);
            if (lv == null || "appmiantab".equals(tabPageKey) || !entity.equals(formId = (formShowParameter = lv.getFormShowParameter()) instanceof ListShowParameter ? ((ListShowParameter)formShowParameter).getBillFormId() : formShowParameter.getFormId())) continue;
            boolean flag = true;
            if (params != null && !params.isEmpty()) {
                Map customParams = formShowParameter.getCustomParams();
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    String key = entry.getKey();
                    if ("script".equals(key) || "remark".equals(key) || "billStatus".equals(key) || Objects.equals(entry.getValue(), customParams.get(key))) continue;
                    flag = false;
                    break;
                }
            }
            if (!flag) continue;
            control.activeTab(tabPageKey);
            view.sendFormAction(appView);
            return true;
        }
        return false;
    }

    public static int getScriptLimitSize() {
        int limitSize;
        try {
            limitSize = D.i((Object)System.getProperty("ISC_SCRIPT_CONTENT_LIMIT_SIZE", "4096"));
        }
        catch (Throwable e) {
            logger.error("\u83b7\u53d6\u811a\u672c\u5185\u5bb9\u5927\u5c0f\u9650\u5236\u7684\u53c2\u6570\u5f02\u5e38\uff1a" + e);
            limitSize = 4096;
        }
        return limitSize;
    }

    public static String getScriptContentWarn(String env) {
        HashSet<String> useDefinedFunctionWarn = new HashSet<String>();
        useDefinedFunctionWarn.add("data_copy_query_script");
        useDefinedFunctionWarn.add("data_copy_source_script");
        useDefinedFunctionWarn.add("data_copy_mapping_script");
        useDefinedFunctionWarn.add("data_copy_target_script");
        useDefinedFunctionWarn.add("api_script");
        int limit = ScriptCommonUtil.getScriptLimitSize();
        if (useDefinedFunctionWarn.contains(env)) {
            return String.format(ResManager.loadKDString((String)"\u811a\u672c\u5df2\u8d85\u8fc7%s\u5b57\u8282\uff0c\u811a\u672c\u592a\u957f\u5bb9\u6613\u51fa\u9519\u3001\u4e0d\u6613\u7406\u89e3\u3001\u4e0d\u65b9\u4fbf\u7ef4\u62a4\uff0c\u5efa\u8bae\u4f7f\u7528\u81ea\u5b9a\u4e49\u51fd\u6570\u62c6\u5206\u811a\u672c\u3002\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u4fdd\u5b58\uff1f", (String)"ScriptCommonUtil_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), limit);
        }
        if ("sf_script_node".equals(env)) {
            return String.format(ResManager.loadKDString((String)"\u811a\u672c\u5df2\u8d85\u8fc7%s\u5b57\u8282\uff0c\u811a\u672c\u592a\u957f\u5bb9\u6613\u51fa\u9519\u3001\u4e0d\u6613\u7406\u89e3\u3001\u4e0d\u65b9\u4fbf\u7ef4\u62a4\uff0c\u5efa\u8bae\u4f7f\u7528\u591a\u4e2a\u811a\u672c\u8282\u70b9\u62c6\u5206\u811a\u672c\u3002\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u4fdd\u5b58\uff1f", (String)"ScriptCommonUtil_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), limit);
        }
        return String.format(ResManager.loadKDString((String)"\u811a\u672c\u5df2\u8d85\u8fc7%s\u5b57\u8282\uff0c\u811a\u672c\u592a\u957f\u5bb9\u6613\u51fa\u9519\u3001\u4e0d\u6613\u7406\u89e3\u3001\u4e0d\u65b9\u4fbf\u7ef4\u62a4\uff0c\u5efa\u8bae\u91c7\u53d6\u9002\u5f53\u63aa\u65bd\u7b80\u5316\u811a\u672c\u3002\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u4fdd\u5b58\uff1f", (String)"ScriptCommonUtil_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), limit);
    }
}

