/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.k3cloudsdk;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.K3SkyWebApiContext;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.script.Script;

public class CheckResult {
    private static final Log log = LogFactory.getLog(CheckResult.class);
    private String url;
    private Object[] parameters;
    private K3SkyWebApiContext ctx;
    public static final String pre_url = "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.";

    public CheckResult(K3SkyWebApiContext ctx, Object[] parameters, String action) {
        this.ctx = ctx;
        this.parameters = parameters;
        this.url = action.startsWith("Kingdee.BOS") ? action : pre_url + action;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object check(Object result) {
        Object checkResult = null;
        if (ObjectUtils.isEmpty((Object)result)) {
            return result;
        }
        if (result instanceof List) {
            Object re = ((List)((List)result).get(0)).get(0);
            if (!(re instanceof Map)) return result;
            return this.check((Map)re);
        }
        if (!(result instanceof Map)) return checkResult;
        return this.check((Map)result);
    }

    private Object check(Map<String, Object> responseResult) {
        Map result = (Map)responseResult.get("Result");
        Map responseStatus = (Map)result.get("ResponseStatus");
        Object retryResult = null;
        if (null != responseStatus && responseStatus.get("IsSuccess").equals(Boolean.FALSE)) {
            Map errors = (Map)((List)responseStatus.get("Errors")).get(0);
            String message = D.s(errors.get("Message"));
            if (null != message && (message.contains("\u4f1a\u8bdd\u4fe1\u606f\u5df2\u4e22\u5931") || message.contains("\u6703\u8a71\u4fe1\u606f\u5df2\u4e1f\u5931") || message.contains("Session information is lost"))) {
                retryResult = this.loginFailedRetryInvoke();
            } else if (null != message && message.contains("\u6b7b\u9501")) {
                retryResult = this.deadLockRetryInvoke();
            } else {
                throw new IscBizException(D.s((Object)errors));
            }
        }
        return retryResult == null ? responseResult : retryResult;
    }

    private Object deadLockRetryInvoke() {
        Object re;
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            log.warn("\u661f\u7a7a\u63a5\u53e3\u8fd4\u56de\u6b7b\u9501\u4fe1\u606f\uff0c\u6267\u884c\u7ebf\u7a0b\u7761\u77205S\u7136\u540e\u91cd\u8bd5\u8c03\u7528\u65f6\uff0c\u7ebf\u7a0b\u7761\u7720\u5931\u8d25\u3002");
        }
        Object response = null;
        try {
            response = Script.parseJson((String)this.ctx.getApi().execute(this.url, this.parameters));
        }
        catch (Exception e) {
            throw new IscBizException((Throwable)e);
        }
        if (response instanceof Map ? this.checkIsSuccess((Map)response) : response instanceof List && (re = ((List)((List)response).get(0)).get(0)) instanceof Map && this.checkIsSuccess((Map)re)) {
            return response;
        }
        return response;
    }

    private boolean checkIsSuccess(Map<String, Object> responseResult) {
        Map result = (Map)responseResult.get("Result");
        if (ObjectUtils.isEmpty((Object)result)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u661f\u7a7aURL:%1$s,\u8fd4\u56de\u7ed3\u679c\u4e2dResult\u53c2\u6570\u4e3a\uff1a%2$s", (String)"CheckResult_7", (String)"isc-iscb-connector-other", (Object[])new Object[0]), this.url, result));
        }
        Map responseStatus = (Map)result.get("ResponseStatus");
        if (ObjectUtils.isEmpty((Object)responseStatus)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u661f\u7a7aURL:%1$s,\u8fd4\u56de\u7ed3\u679c\u4e2dResponseStatus\u53c2\u6570\u4e3a\uff1a%2$s", (String)"CheckResult_8", (String)"isc-iscb-connector-other", (Object[])new Object[0]), this.url, responseStatus));
        }
        if (responseStatus.get("IsSuccess").equals(Boolean.FALSE)) {
            Object errors = responseStatus.get("Errors");
            throw new IscBizException(D.s(errors));
        }
        return true;
    }

    private Object loginFailedRetryInvoke() {
        Object result;
        int count = 0;
        while (true) {
            if ((result = this.tryInvoke()) instanceof Map) {
                if (this.checkError((Map)result)) {
                    return result;
                }
                count = this.checkMaxLimit(count);
                continue;
            }
            if (!(result instanceof List)) continue;
            Object re = ((List)((List)result).get(0)).get(0);
            if (!(re instanceof Map) || this.checkError((Map)re)) break;
            count = this.checkMaxLimit(count);
        }
        return result;
    }

    public int checkMaxLimit(int count) {
        if (++count >= 3) {
            throw new IscBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u8fc7\u7a0b\u4e2d\u53d1\u73b0\u661f\u7a7a\u670d\u52a1\u7684\u767b\u5f55\u64cd\u4f5c\u5b58\u5728\u5f02\u5e38\uff0c\u5df2\u91cd\u8bd5\u767b\u5f553\u6b21\u4ecd\u7136\u65e0\u6cd5\u767b\u5f55\u6210\u529f\uff0c\u8bf7\u68c0\u67e5\u661f\u7a7a\u670d\u52a1\u5668\u5f53\u524d\u72b6\u6001\u662f\u5426\u6b63\u5e38\u3002", (String)"CheckResult_9", (String)"isc-iscb-connector-other", (Object[])new Object[0]));
        }
        D.sleep((long)((long)(6 * count) * 1000L));
        return count;
    }

    private Object tryInvoke() {
        try {
            return Script.parseJson((String)this.ctx.getApi().execute(this.url, this.parameters));
        }
        catch (Exception e) {
            throw new IscBizException((Throwable)e);
        }
    }

    private void refreshCookie() {
    }

    public boolean checkError(Map<String, Object> responseResult) {
        Map result = (Map)responseResult.get("Result");
        Map responseStatus = (Map)result.get("ResponseStatus");
        if (null != responseStatus && responseStatus.get("IsSuccess").equals(Boolean.FALSE)) {
            Map errors = (Map)((List)responseStatus.get("Errors")).get(0);
            String message = D.s(errors.get("Message"));
            if (null != message && (message.contains("\u4f1a\u8bdd\u4fe1\u606f\u5df2\u4e22\u5931") || message.contains("\u6703\u8a71\u4fe1\u606f\u5df2\u4e1f\u5931") || message.contains("Session information is lost"))) {
                return false;
            }
            throw new IscBizException(D.s((Object)errors));
        }
        return true;
    }
}

