/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.k3cloudsdk;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.isc.iscb.platform.core.connector.AttachUtil;
import kd.isc.iscb.platform.core.connector.ConnectionFactory;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.IscK3CloudApi;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.K3SkyConnectionWrapper;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.K3SkyWebApiAction;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.K3SkyWebApiContext;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.QueryCloudData;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.attachment.K3SkyAttachmentInputStream;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.attachment.K3SkyAttachmentOutputStream;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.attachment.K3SkyAttachmentUtil;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.metadata.K3CloudEnumInfo;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.metadata.K3CloudMetaDataUtil;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.metadata.K3SkyEntityInfo;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.connector.Response;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.AbstractInputStream;
import kd.isc.iscb.util.io.AbstractOutputStream;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;

public final class K3CloudWebApiFactory
implements ConnectionFactory {
    public ConnectionWrapper create(DynamicObject cfg) {
        return new K3SkyConnectionWrapper(this, cfg);
    }

    public void test(ConnectionWrapper cn) {
        try (K3SkyWebApiContext k3CloudWebApiContext = new K3SkyWebApiContext(cn.getConfig());){
            IscK3CloudApi cloudApi = k3CloudWebApiContext.getApi();
            String data = "{\"FormId\":\"BD_Currency\",\"FieldKeys\":\"FCODE\",\"OrderString\":\"\",\"FilterString\":\" FNUMBER='PRE001' \",\"TopRowCount\":\"0\",\"StartRow\":\"0\",\"Limit\":\"0\"}";
            String returnInfo = cloudApi.executeBillQuery(data).toString();
            if (!returnInfo.contains("[CNY]") && !"[]".equals(returnInfo)) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4f7f\u7528\u914d\u7f6e\u4fe1\u606f\u8c03\u7528\u661f\u7a7a\u4f01\u4e1a\u7248\u7684\u5e01\u522b\u67e5\u8be2\u63a5\u53e3\u53d1\u751f\u9519\u8bef,\n\u8bf7\u6c42\u53c2\u6570\uff1a%1$s,\n\u539f\u59cb\u8fd4\u56de\u7ed3\u679c\u4e3a\uff1a%2$s", (String)"K3CloudWebApiFactory_5", (String)"isc-iscb-connector-other", (Object[])new Object[0]), data, returnInfo));
            }
        }
        catch (Exception e) {
            throw new KDBizException(StringUtil.getCascadeMessage((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, MetaType> getMetaList(ConnectionWrapper cn) {
        K3SkyWebApiContext k3CloudWebApiContext = new K3SkyWebApiContext(cn.getConfig());
        try {
            Map<String, MetaType> map = K3CloudMetaDataUtil.getMetaList(k3CloudWebApiContext);
            return map;
        }
        finally {
            k3CloudWebApiContext.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getEntityInfo(ConnectionWrapper cn, String name) {
        K3SkyWebApiContext k3CloudWebApiContext = new K3SkyWebApiContext(cn.getConfig());
        try {
            List<Map<String, Object>> list = K3SkyEntityInfo.getEntityInfo(k3CloudWebApiContext, name);
            return list;
        }
        finally {
            k3CloudWebApiContext.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getEnumInfo(ConnectionWrapper cn, String name) {
        K3SkyWebApiContext k3CloudWebApiContext = new K3SkyWebApiContext(cn.getConfig());
        try {
            Map<String, Object> map = K3CloudEnumInfo.getEnumInfo(k3CloudWebApiContext, name);
            return map;
        }
        finally {
            k3CloudWebApiContext.remove();
        }
    }

    public Map<String, Object> getServiceInfo(ConnectionWrapper cn, String service_name) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u661f\u7a7a\u8fde\u63a5\u5668\u4e0d\u652f\u6301\u83b7\u53d6API\u5143\u6570\u636e\u3002", (String)"K3CloudWebApiFactory_0", (String)"isc-iscb-connector-other", (Object[])new Object[0]));
    }

    public ObjectReader<Map<String, Object>> query(ConnectionWrapper cn, String entity, Map<String, Object> requires, List<Map<String, Object>> filter, List<Map<String, String>> orderBy) {
        K3SkyWebApiContext ctx = new K3SkyWebApiContext(cn.getConfig());
        try {
            K3CloudWebApiFactory.parseFilter(filter);
            ObjectReader<Map<String, Object>> objectReader = QueryCloudData.get(ctx, entity, requires, filter, orderBy);
            return objectReader;
        }
        catch (Exception e) {
            ConnectionWrapper.rewrite((Throwable)e, (ConnectionWrapper)cn);
            throw e;
        }
        finally {
            ctx.remove();
        }
    }

    private static void parseFilter(List<Map<String, Object>> filter) {
        for (Map<String, Object> map : filter) {
            String tempValue;
            String filterCompare = D.s((Object)map.get("filter_compare"));
            Object filter_value = map.get("filter_value");
            if (!"in".equalsIgnoreCase(filterCompare) && !"not in".equalsIgnoreCase(filterCompare) || !(filter_value instanceof String) || (tempValue = D.s((Object)filter_value)) == null || tempValue.startsWith("[") || tempValue.endsWith("]")) continue;
            String meg = String.format(ResManager.loadKDString((String)"\u6e90\u662f\u661f\u7a7a\u4f01\u4e1a\u7248,\u8fc7\u6ee4\u6761\u4ef6\u662fin\u548cnot in\u7684\u65f6\u5019,\u8fc7\u6ee4\u7684\u503c\u9700\u8981\u662f\u4ee5\u4e0b\u683c\u5f0f[123]\u3001[123,456]\u3001['abc']\u3001['abc','edf'],\u5f53\u524d\u8f93\u5165\u7684\u503c\u4e3a%s\u3002", (String)"K3CloudWebApiFactory_7", (String)"isc-iscb-connector-other", (Object[])new Object[0]), filter_value);
            throw new IscBizException(meg);
        }
    }

    public Response doBizAction(ConnectionWrapper cn, String entity, Map<String, Object> data, Map<String, List<String>> judgeFields, List<String> actions, String proxy_user) {
        try {
            return this.doBizAction(cn, entity, data, judgeFields, actions, Collections.emptyMap(), proxy_user);
        }
        catch (Exception e) {
            ConnectionWrapper.rewrite((Throwable)e, (ConnectionWrapper)cn);
            throw e;
        }
    }

    public Response doBizAction(ConnectionWrapper cn, String entity, Map<String, Object> data, Map<String, List<String>> judgeFields, List<String> actions, Map<String, Object> targetActionParams, String proxy_user) {
        K3SkyWebApiContext ctx = new K3SkyWebApiContext(cn.getConfig());
        try {
            Response response = K3SkyWebApiAction.doBizAction(ctx, entity, data, judgeFields, actions, targetActionParams, proxy_user);
            return response;
        }
        catch (Exception e) {
            ConnectionWrapper.rewrite((Throwable)e, (ConnectionWrapper)cn);
            throw e;
        }
        finally {
            ctx.remove();
        }
    }

    public Object callService(ConnectionWrapper cn, String service, Map<String, Object> params, String proxyUser) {
        K3SkyWebApiContext ctx = new K3SkyWebApiContext(cn.getConfig());
        try {
            List list = (List)params.get("#data");
            if (list == null) {
                throw new IscBizException(ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u8c03\u7528\u661f\u7a7aAPI\u7684\u811a\u672c\uff0cSDK\u65b9\u5f0f\u7684\u8fde\u63a5\u7c7b\u578b\u4e0d\u652f\u6301http\u51fd\u6570\u8c03\u7528\u3002", (String)"K3CloudWebApiFactory_6", (String)"isc-iscb-connector-other", (Object[])new Object[0]));
            }
            Object[] parameters = list.toArray();
            String action = service.contains(".") ? service.replace(".common.kdsvc", "") : "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService." + service;
            IscK3CloudApi api = ctx.getApi();
            if (D.x((Object)params.get("#needCheckAuthInfo"))) {
                api.CheckAuthInfo();
            }
            Object result = Script.parseJson((String)api.execute(action, parameters));
            HashMap<String, Object> res = new HashMap<String, Object>(1);
            res.put("result", result);
            HashMap<String, Object> hashMap = res;
            return hashMap;
        }
        catch (Exception e) {
            throw new IscBizException((Throwable)e);
        }
        finally {
            ctx.remove();
        }
    }

    public Response doDataAction(ConnectionWrapper cn, Map<String, Object> data, Table mainTable, Map<String, Pair<Table, String>> entryTables, Map<String, List<String>> judgeFields, List<String> actions) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u661f\u7a7a\u8fde\u63a5\u5668\u4e0d\u652f\u6301\u6570\u636e\u8868\u67e5\u8be2\u3002", (String)"K3CloudWebApiFactory_1", (String)"isc-iscb-connector-other", (Object[])new Object[0]));
    }

    public Response callDataHandler(ConnectionWrapper cn, String targetDataHandler, Map<String, Object> data, Map<String, List<String>> judgeFields, String proxy_user) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u661f\u7a7a\u8fde\u63a5\u5668\u4e0d\u652f\u6301\u8c03\u7528\u6570\u636e\u5904\u7406\u7c7b\u3002", (String)"K3CloudWebApiFactory_2", (String)"isc-iscb-connector-other", (Object[])new Object[0]));
    }

    public void detachEvents(ConnectionWrapper cn, String iscHub, EventBindingUtil.TriggerType type, long triggerId, String entity) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u661f\u7a7a\u8fde\u63a5\u5668\u4e0d\u652f\u6301\u89e3\u9664\u4e8b\u4ef6\u7ed1\u5b9a\u3002", (String)"K3CloudWebApiFactory_3", (String)"isc-iscb-connector-other", (Object[])new Object[0]));
    }

    public void attachEvents(ConnectionWrapper cn, String iscHub, EventBindingUtil.TriggerType type, long triggerId, String entity, String[] events, Map<String, Object> requires) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u661f\u7a7a\u4e0d\u652f\u6301\u4e8b\u4ef6\u89e6\u53d1\uff0c\u8bf7\u4f7f\u7528 \u5b9a\u65f6\u542f\u52a8 \u589e\u91cf\u96c6\u6210\uff0c\u6216\u661f\u7a7a\u5355\u636e\u4e8c\u5f00\u4e3b\u52a8\u8c03\u7528\u96c6\u6210\u4e91\u7684\u542f\u52a8\u65b9\u6848/\u96c6\u6210\u65b9\u6848\u8f6cAPI\u63a8\u9001\u6570\u636e\u3002", (String)"K3CloudWebApiFactory_4", (String)"isc-iscb-connector-other", (Object[])new Object[0]));
    }

    public boolean supportsRemoteDeploy() {
        return false;
    }

    public boolean hasMetaData(String metaFullname, String type, ConnectionWrapper cn) {
        switch (MetaType.valueOf((String)type)) {
            case ENTITY: {
                return true;
            }
            case ENUM: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractInputStream getAttachmentReader(ConnectionWrapper cn, Map<String, Object> fileInfo) {
        K3SkyWebApiContext ctx = new K3SkyWebApiContext(cn.getConfig());
        try {
            K3SkyAttachmentInputStream k3SkyAttachmentInputStream = new K3SkyAttachmentInputStream(ctx, fileInfo);
            return k3SkyAttachmentInputStream;
        }
        finally {
            ctx.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractOutputStream getAttachmentWriter(ConnectionWrapper cn, Map<String, Object> fileInfo) {
        K3SkyWebApiContext ctx = new K3SkyWebApiContext(cn.getConfig());
        try {
            K3SkyAttachmentOutputStream k3SkyAttachmentOutputStream = new K3SkyAttachmentOutputStream(ctx, fileInfo, AttachUtil.getBlockSize());
            return k3SkyAttachmentOutputStream;
        }
        finally {
            ctx.remove();
        }
    }

    public boolean supportsAttachment(ConnectionWrapper cn) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAttachmentChanged(ConnectionWrapper cn, Map<String, Object> fileInfo, String md5Code) {
        K3SkyWebApiContext ctx = new K3SkyWebApiContext(cn.getConfig());
        try {
            boolean bl = K3SkyAttachmentUtil.isAttachmentChanged(ctx, fileInfo, md5Code);
            return bl;
        }
        finally {
            ctx.remove();
        }
    }
}

