/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.k3cloudsdk;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.K3SkyError;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.K3SkyWebApiContext;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.QueryCloudData;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.attachment.K3SkyAttachmentUtil;
import kd.isc.iscb.util.io.ObjectReader;

public class K3SkyObjectReader
implements ObjectReader<Map<String, Object>> {
    private K3SkyWebApiContext ctx;
    private Map<String, Object> requires;
    private Iterator<Object> id;
    private String entity;
    private int count;

    public K3SkyObjectReader(K3SkyWebApiContext ctx, Map<String, Object> requires, List<Object> ids, String entity) {
        this.ctx = ctx;
        requires.put("id", 1);
        this.requires = requires;
        this.id = ids.iterator();
        this.entity = entity;
        this.count = ids.size();
    }

    public int getTotalCount() {
        return this.count;
    }

    public Map<String, Object> read() {
        try {
            if (this.id.hasNext()) {
                Object billId = this.id.next();
                Map<String, Object> billInfo = QueryCloudData.getBillInfo(this.ctx, billId, this.entity);
                DynamicObjectCollection entityMeta = QueryCloudData.getEntityMeta(this.ctx, this.entity);
                Map<String, Object> sourceBill = QueryCloudData.getSrcData(this.ctx, billInfo, entityMeta, this.requires);
                if (this.requires.containsKey("$supports_file_copy")) {
                    List<Map<String, Object>> attachmentList = K3SkyAttachmentUtil.getAttachmentList(this.ctx, billId, this.entity);
                    sourceBill.put("$file_list", attachmentList);
                }
                sourceBill.put("$keyMapping", Collections.emptyMap());
                return sourceBill;
            }
            return null;
        }
        catch (Exception e) {
            throw K3SkyError.K3CLOUD_READER_FAILURE.wrap((Throwable)e);
        }
    }

    public void close() {
    }
}

