/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.k3cloudsdk.attachment;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.k3cloud.attachment.K3AttachmentInfo;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.CheckResult;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.K3SkyWebApiContext;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.i.Hex;
import kd.isc.iscb.util.err.CommonError;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.script.Script;

public class K3SkyAttachmentUtil {
    private static final Log log = LogFactory.getLog(K3SkyAttachmentUtil.class);
    private static final String MD5 = "MD5";
    public static final String ENTITY_ISC_ATTACHMENT_TEMP = "isc_attachment_temp";

    public static List<Map<String, Object>> getAttachmentList(K3SkyWebApiContext ctx, Object billId, String formId) {
        String fieldKeys = "FFileId,FAttachmentName,FExtName,FAttachmentSize,FAttachmentDes,FCreateTime,FCreateMen";
        HashMap<String, String> param = new HashMap<String, String>(4);
        param.put("FormId", "BOS_Attachment");
        param.put("FieldKeys", fieldKeys);
        param.put("FilterString", "FInterID = '" + billId + "' and FBillType = '" + formId + "'");
        try {
            String data = Json.toString(param, (boolean)true);
            List response = ctx.getApi().executeBillQuery(data);
            CheckResult checkResult = new CheckResult(ctx, new Object[]{data}, "ExecuteBillQuery");
            List attachments = (List)checkResult.check(response);
            return K3SkyAttachmentUtil.getFileInfos(billId, attachments);
        }
        catch (Exception e) {
            throw new IscBizException((Throwable)e);
        }
    }

    public static List<Map<String, Object>> getFileInfos(Object billId, List<List<Object>> attachments) {
        if (ObjectUtils.isEmpty(attachments)) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> fileInfos = new ArrayList<Map<String, Object>>(attachments.size());
        for (List<Object> attachment : attachments) {
            Map<String, Object> fileInfo = K3SkyAttachmentUtil.getFileInfo(billId, attachment);
            fileInfos.add(fileInfo);
        }
        return fileInfos;
    }

    private static Map<String, Object> getFileInfo(Object billId, List<Object> attachment) {
        String fileType;
        int index;
        HashMap<String, Object> fileInfo = new HashMap<String, Object>(12);
        fileInfo.put("srcBillId", billId);
        fileInfo.put("srcAttachId", attachment.get(0));
        String fileName = D.s((Object)attachment.get(1));
        if (null != fileName && (index = fileName.lastIndexOf(".")) > 0) {
            fileName = fileName.substring(0, index);
        }
        if ((fileType = D.s((Object)attachment.get(2))) != null && fileType.startsWith(".")) {
            String[] type = fileType.split("\\.");
            fileType = type[1];
        }
        fileInfo.put("name", fileName);
        fileInfo.put("type", fileType);
        double kb = Double.parseDouble(D.s((Object)attachment.get(3)));
        fileInfo.put("bytes", kb * 1024.0);
        fileInfo.put("desc", attachment.get(4));
        fileInfo.put("srcAttachCreateTime", attachment.get(5));
        fileInfo.put("srcAttachCreator", attachment.get(6));
        return fileInfo;
    }

    public static Map<String, Object> retrieveAttachment(K3SkyWebApiContext ctx, String attachmentId, int startIndex) {
        Map response;
        HashMap<String, Object> fileId = new HashMap<String, Object>(2);
        fileId.put("FileId", attachmentId);
        fileId.put("StartIndex", startIndex);
        long begin = System.currentTimeMillis();
        try {
            response = (Map)Script.parseJson((String)ctx.getApi().attachmentDownLoad(Json.toString(fileId, (boolean)true)));
        }
        catch (Exception e) {
            throw new IscBizException((Throwable)e);
        }
        return K3SkyAttachmentUtil.parseResult(fileId, begin, response);
    }

    public static Map<String, Object> parseResult(Map<String, Object> param, long begin, Map<String, Object> response) {
        long end = System.currentTimeMillis();
        log.info("K3CloudAttachmentUtil\uff0c\u8c03\u7528\u661f\u7a7a\u63a5\u53e3:AttachmentDownLoad,\u5165\u53c2:{},\u8017\u65f6:{}ms.", param, (Object)(end - begin));
        Map result = (Map)response.get("Result");
        Map status = (Map)result.get("ResponseStatus");
        boolean isSuccess = D.x(status.get("IsSuccess"));
        if (isSuccess) {
            return result;
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u661f\u7a7a\u9644\u4ef6\u4e0b\u8f7d\u63a5\u53e3\u5931\u8d25\uff0c\u5165\u53c2\u662f\uff1a%1$s\uff0c\u8fd4\u56de\u7ed3\u679c\u662f\uff1a%2$s", (String)"K3SkyAttachmentUtil_7", (String)"isc-iscb-connector-other", (Object[])new Object[0]), D.s(param), result));
    }

    public static boolean isAttachmentChanged(K3SkyWebApiContext ctx, Map<String, Object> fileInfo, String md5Code) {
        String attachmentId = D.s((Object)fileInfo.get("checkFileId"));
        if (attachmentId == null || md5Code == null) {
            return true;
        }
        try {
            MessageDigest md5Instance = K3SkyAttachmentUtil.getMd5Instance();
            boolean last = false;
            int index = 0;
            while (!last) {
                Map<String, Object> result = K3SkyAttachmentUtil.retrieveAttachment(ctx, attachmentId, index);
                last = D.x((Object)result.get("IsLast"));
                index = D.i((Object)result.get("StartIndex"));
                String dataStr = D.s((Object)result.get("FilePart"));
                if (dataStr == null) continue;
                byte[] data = Base64.getDecoder().decode(dataStr);
                md5Instance.update(data);
            }
            String hashCode = Hex.encode((byte[])md5Instance.digest());
            return !md5Code.equals(hashCode);
        }
        catch (Exception e) {
            log.warn("\u5224\u65ad\u661f\u7a7a\u9644\u4ef6\u662f\u5426\u53d8\u5316\u65f6\u51fa\u9519\uff0c\u9519\u8bef\u539f\u56e0\uff1a" + e);
            return true;
        }
    }

    private static MessageDigest getMd5Instance() {
        try {
            return MessageDigest.getInstance(MD5);
        }
        catch (NoSuchAlgorithmException e) {
            throw CommonError.NO_SUCH_HASH_ALGO.create((Throwable)e, new String[]{MD5});
        }
    }

    public static void bindAttachment(K3SkyWebApiContext ctx, String formId, Object billId, Map<String, Object> data) {
        Object fileList = ((Map)data.get("Model")).get("$file_list");
        if (fileList instanceof List) {
            if (billId == null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u5355\u636e\uff1a\u3010%s\u3011\u9644\u4ef6\u65f6\uff0c\u5355\u636eid\u4e3a\u7a7a\u3002\u95ee\u9898\u6392\u67e5\uff1a", (String)"K3SkyAttachmentUtil_8", (String)"isc-iscb-connector-other", (Object[])new Object[0]), formId) + "\n" + ResManager.loadKDString((String)"1\u3001\u8bf7\u786e\u8ba4\u5355\u636e\u662f\u5426\u4fdd\u5b58/\u66f4\u65b0\u6210\u529f\u3002", (String)"K3SkyAttachmentUtil_9", (String)"isc-iscb-connector-other", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"2\u3001\u8c03\u7528\u661f\u7a7a\u8be5\u5355\u636e\u7684WEBAPI\u4fdd\u5b58\u63a5\u53e3\u65f6\u662f\u5426\u4f1a\u9ed8\u8ba4\u8fd4\u56deId\u4fe1\u606f\u3002", (String)"K3SkyAttachmentUtil_5", (String)"isc-iscb-connector-other", (Object[])new Object[0]));
            }
            if (((List)fileList).isEmpty()) {
                return;
            }
            K3SkyAttachmentUtil.bind(ctx, formId, billId, (List)fileList);
        }
    }

    private static void bind(K3SkyWebApiContext ctx, String formId, Object billId, List<Map<String, Object>> attachInfos) {
        Map response;
        List<Object> model = K3SkyAttachmentUtil.getModel(ctx, formId, billId, attachInfos);
        Map<String, Object> params = K3SkyAttachmentUtil.getBindParams(model);
        try {
            response = (Map)Script.parseJson((String)ctx.getApi().batchSave("BOS_Attachment", Json.toString(params, (boolean)true)));
        }
        catch (Exception e) {
            throw new IscBizException((Throwable)e);
        }
        K3SkyAttachmentUtil.parseBindResult(params, response);
    }

    public static void parseBindResult(Map<String, Object> params, Map<String, Object> response) {
        Map responseStatus;
        boolean success;
        Object result = response.get("Result");
        if (result instanceof Map && !(success = D.x((responseStatus = (Map)((Map)result).get("ResponseStatus")).get("IsSuccess")))) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u661f\u7a7a\u9644\u4ef6\u7ed1\u5b9a\u63a5\u53e3\u5931\u8d25\uff0c\u5165\u53c2\u662f%1$s\uff0c\u8fd4\u56de\u7ed3\u679c\u662f\uff1a%2$s", (String)"K3SkyAttachmentUtil_10", (String)"isc-iscb-connector-other", (Object[])new Object[0]), D.s(params), responseStatus));
        }
    }

    public static Map<String, Object> getBindParams(List<Object> model) {
        HashMap<String, Object> data = new HashMap<String, Object>(1);
        data.put("Model", model);
        return data;
    }

    private static List<Object> getModel(K3SkyWebApiContext ctx, String formId, Object billId, List<Map<String, Object>> attachInfos) {
        List<K3AttachmentInfo> attachments = K3SkyAttachmentUtil.getK3AttachmentInfos(ctx, formId, billId);
        ArrayList<K3AttachmentInfo> validList = new ArrayList<K3AttachmentInfo>(attachments.size());
        ArrayList<K3AttachmentInfo> invalidList = new ArrayList<K3AttachmentInfo>(attachments.size());
        K3SkyAttachmentUtil.initAttachInfoList(attachments, validList, invalidList);
        ArrayList<Object> models = new ArrayList<Object>(12);
        Collection<K3AttachmentInfo> remainShouldUnbindAttachments = K3SkyAttachmentUtil.bindAttachments(formId, billId, attachInfos, validList, models);
        invalidList.addAll(remainShouldUnbindAttachments);
        K3SkyAttachmentUtil.unBindAttachments(formId, invalidList, models);
        return models;
    }

    private static void initAttachInfoList(List<K3AttachmentInfo> attachments, List<K3AttachmentInfo> validList, List<K3AttachmentInfo> invalidList) {
        for (K3AttachmentInfo attachmentInfo : attachments) {
            String fileid = attachmentInfo.getFileid();
            if (fileid != null) {
                validList.add(attachmentInfo);
                continue;
            }
            invalidList.add(attachmentInfo);
        }
    }

    private static List<K3AttachmentInfo> getK3AttachmentInfos(K3SkyWebApiContext ctx, String formId, Object billId) {
        String fieldKeys = "FID,FFileId";
        HashMap<String, String> param = new HashMap<String, String>(4);
        param.put("FormId", "BOS_Attachment");
        param.put("FieldKeys", fieldKeys);
        param.put("FilterString", "FInterID = '" + billId + "' and FBillType = '" + formId + "'");
        try {
            String data = Json.toString(param, (boolean)true);
            List response = ctx.getApi().executeBillQuery(data);
            CheckResult checkResult = new CheckResult(ctx, new Object[]{data}, "ExecuteBillQuery");
            List check = (List)checkResult.check(response);
            ArrayList<K3AttachmentInfo> attachments = new ArrayList<K3AttachmentInfo>(check.size());
            for (List obj : check) {
                String fid = D.s(obj.get(0));
                String fileid = D.s(obj.get(1));
                attachments.add(new K3AttachmentInfo(fid, fileid));
            }
            return attachments;
        }
        catch (Exception e) {
            throw new IscBizException((Throwable)e);
        }
    }

    public static Collection<K3AttachmentInfo> bindAttachments(String formId, Object billId, List<Map<String, Object>> attachInfos, List<K3AttachmentInfo> attachmentInfos, List<Object> models) {
        Map<String, K3AttachmentInfo> fileIdToInfo = K3SkyAttachmentUtil.makeFileIdToInfoMap(attachmentInfos);
        HashSet<String> attachIdSet = new HashSet<String>(attachInfos.size());
        for (Map<String, Object> attachInfo : attachInfos) {
            String attachId = D.s((Object)attachInfo.get("attachId"));
            if (attachIdSet.contains(attachId)) continue;
            attachIdSet.add(attachId);
            HashMap<String, Object> model = new HashMap<String, Object>(12);
            models.add(model);
            K3AttachmentInfo info = fileIdToInfo.remove(attachId);
            if (info != null) {
                model.put("FID", info.getFid());
                model.put("FModifyTime", new Timestamp(System.currentTimeMillis()));
            } else {
                model.put("FCreateTime", new Timestamp(System.currentTimeMillis()));
            }
            DynamicObject attachmentTemp = BusinessDataServiceHelper.loadSingle((Object)K3SkyAttachmentUtil.getAttachTempId(attachId), (String)ENTITY_ISC_ATTACHMENT_TEMP);
            model.put("FFileId", attachId);
            model.put("FAttachmentName", attachmentTemp.getString("name"));
            model.put("FBillType", formId);
            model.put("FInterID", billId);
            model.put("FAttachmentSize", Double.parseDouble(attachmentTemp.getString("bytes")) / 1024.0);
            model.put("FExtName", "." + attachmentTemp.getString("type"));
            model.put("FEntrykey", " ");
            model.put("FEntryinterId", "-1");
            if (D.t((Object)attachmentTemp.get("usr_def_create_time")) != null) {
                model.put("FCreateTime", D.t((Object)attachmentTemp.get("usr_def_create_time")));
            }
            if (D.s((Object)attachmentTemp.get("usr_def_creator")) == null) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("FUserID", D.s((Object)attachmentTemp.get("usr_def_creator")));
            model.put("FCreateMen", map);
        }
        return fileIdToInfo.values();
    }

    private static Map<String, K3AttachmentInfo> makeFileIdToInfoMap(List<K3AttachmentInfo> attachmentInfos) {
        HashMap<String, K3AttachmentInfo> fileIdToInfo = new HashMap<String, K3AttachmentInfo>(attachmentInfos.size());
        for (K3AttachmentInfo attachmentInfo : attachmentInfos) {
            fileIdToInfo.put(attachmentInfo.getFileid(), attachmentInfo);
        }
        return fileIdToInfo;
    }

    public static long getAttachTempId(String attachId) {
        return Math.abs(Hash.mur64((byte[])attachId.getBytes(StandardCharsets.UTF_8)));
    }

    public static void unBindAttachments(String formId, List<K3AttachmentInfo> unbindList, List<Object> models) {
        for (K3AttachmentInfo info : unbindList) {
            HashMap<String, Object> model = new HashMap<String, Object>(12);
            models.add(model);
            model.put("FID", info.getFid());
            model.put("FFileId", " ");
            model.put("FAttachmentName", " ");
            model.put("FBillType", formId);
            model.put("FInterID", " ");
            model.put("FAttachmentSize", 0);
            model.put("FExtName", " ");
            model.put("FModifyTime", new Timestamp(System.currentTimeMillis()));
            model.put("FEntrykey", " ");
            model.put("FEntryinterId", "-1");
        }
    }
}

