/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.k3cloudsdk.metadata;

import com.kingdee.bos.webapi.sdk.K3CloudApi;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.IscK3CloudApi;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.K3SkyWebApiContext;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;

public class K3CloudMetaDataUtil {
    public static Map<String, MetaType> getMetaList(K3SkyWebApiContext ctx) {
        HashMap<String, MetaType> metas = new HashMap<String, MetaType>(16);
        K3CloudMetaDataUtil.getEntityList(ctx, metas);
        K3CloudMetaDataUtil.getEnumList(ctx, metas);
        return metas;
    }

    public static void getEnumList(K3SkyWebApiContext ctx, Map<String, MetaType> metas) {
        IscK3CloudApi cloudApi = ctx.getApi();
        int limit = 2000;
        int startRow = 0;
        int i = 0;
        K3CloudMetaDataUtil.getEnumList(metas, cloudApi, limit, startRow, i);
    }

    private static void getEnumList(Map<String, MetaType> metas, K3CloudApi cloudApi, int limit, int startRow, int i) {
        startRow += i * limit;
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        param.put("FormId", "BOS_EnumBill");
        param.put("FieldKeys", "fid");
        param.put("StartRow", startRow);
        List enumList = new ArrayList();
        try {
            enumList = cloudApi.executeBillQuery(Json.toString(param, (boolean)true));
        }
        catch (Exception e) {
            throw new IscBizException((Throwable)e);
        }
        if (enumList.isEmpty()) {
            throw new IscBizException("enumList size is :0");
        }
        for (List enmu : enumList) {
            metas.put(enmu.get(0).toString(), MetaType.ENUM);
        }
        if (enumList.size() < 2000) {
            return;
        }
        K3CloudMetaDataUtil.getEnumList(metas, cloudApi, limit, startRow, ++i);
    }

    public static void getEntityList(K3SkyWebApiContext ctx, Map<String, MetaType> metas) {
        IscK3CloudApi cloudApi = ctx.getApi();
        int limit = 2000;
        int i = 0;
        K3CloudMetaDataUtil.getEntityList(metas, cloudApi, limit, i);
    }

    private static void getEntityList(Map<String, MetaType> metas, K3CloudApi cloudApi, int limit, int i) {
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        param.put("FormId", "BOS_ObjectType");
        param.put("FieldKeys", "fid");
        param.put("FilterString", "FMODELTYPEID in (100,400) and Fdevtype !=2");
        param.put("StartRow", i * limit);
        List entityList = new ArrayList();
        try {
            entityList = cloudApi.executeBillQuery(Json.toString(param, (boolean)true));
        }
        catch (Exception e) {
            throw new IscBizException((Throwable)e);
        }
        for (List entity : entityList) {
            metas.put(entity.get(0).toString(), MetaType.ENTITY);
        }
        if (entityList.size() < 2000) {
            return;
        }
        K3CloudMetaDataUtil.getEntityList(metas, cloudApi, limit, ++i);
    }

    public static Object getRequestParams(Object paras) {
        HashMap<String, Object> params = new HashMap<String, Object>(6);
        UUID uuid = UUID.randomUUID();
        int hashCode = uuid.toString().hashCode();
        params.put("format", 1);
        params.put("useragent", "ApiClient");
        params.put("rid", hashCode);
        params.put("parameters", K3CloudMetaDataUtil.chinaToUnicode(Json.toString((Object)paras, (boolean)true)));
        params.put("timestamp", new Date().toString());
        params.put("v", "1.0");
        return params;
    }

    private static String chinaToUnicode(String str) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char chr1 = str.charAt(i);
            if (chr1 >= '\u4e00' && chr1 <= '\u29fa5') {
                result.append("\\u").append(Integer.toHexString(chr1));
                continue;
            }
            result.append(str.charAt(i));
        }
        return result.toString();
    }
}

