/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.k3cloudsdk.setter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.isc.iscb.platform.core.connector.k3cloud.setter.K3CloudSetter;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.CheckResult;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.K3SkyWebApiAction;
import kd.isc.iscb.platform.core.connector.k3cloudsdk.K3SkyWebApiContext;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;

public class K3SkyF7Setter
implements K3CloudSetter {
    private Map<Object, List<Object>> dataTypeMap;
    private K3SkyWebApiContext ctx;

    public K3SkyF7Setter(K3SkyWebApiContext ctx, Map<Object, List<Object>> dataTypeMap) {
        this.dataTypeMap = dataTypeMap;
        this.ctx = ctx;
    }

    public void setObjValue(Map<String, Object> modelDataMap, Map.Entry<String, Object> cloudDataMap) {
        HashMap<String, Object> cloumMap = new HashMap<String, Object>(16);
        String cloudDataMapKey = cloudDataMap.getKey();
        Object cloudDataMapValue = cloudDataMap.getValue();
        String entity = D.s((Object)this.dataTypeMap.get(cloudDataMapKey).get(1));
        String fieldKey = K3SkyWebApiAction.getPrimaryKeyBySchema(this.ctx, entity);
        if (cloudDataMapValue instanceof Map) {
            this.setRefFromMap(modelDataMap, cloumMap, cloudDataMapKey, (Map)cloudDataMapValue, entity, fieldKey);
        } else {
            modelDataMap.put(cloudDataMapKey, cloumMap);
            cloumMap.put(fieldKey, cloudDataMapValue);
        }
    }

    private void setRefFromMap(Map<String, Object> modelDataMap, Map<String, Object> cloumMap, String cloudDataMapKey, Map<String, Object> cloudDataMapValue, String entity, String fieldKey) {
        if (this.isEmpty(cloudDataMapValue)) {
            modelDataMap.put(cloudDataMapKey, null);
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>(cloudDataMapValue);
        Object fieldValue = data.remove(fieldKey);
        Object defaultValue = data.remove("$default");
        if (!ObjectUtils.isEmpty(fieldValue)) {
            modelDataMap.put(cloudDataMapKey, cloumMap);
            cloumMap.put(fieldKey, fieldValue);
        } else if (!data.isEmpty()) {
            Object id = this.queryIdByData(entity, data, fieldKey);
            modelDataMap.put(cloudDataMapKey, cloumMap);
            cloumMap.put(fieldKey, id);
        } else if (!ObjectUtils.isEmpty(defaultValue)) {
            modelDataMap.put(cloudDataMapKey, cloumMap);
            cloumMap.put(fieldKey, defaultValue);
        }
    }

    private boolean isEmpty(Map<String, Object> cloudDataMapValue) {
        boolean b = true;
        for (Object value : cloudDataMapValue.values()) {
            if (value == null || "".equals(value)) continue;
            b = false;
            break;
        }
        return b;
    }

    private Object queryIdByData(String entity, Map<String, Object> data, String fieldKey) {
        String url = this.ctx.getRemoteURL() + "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.ExecuteBillQuery.common.kdsvc";
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        param.put("FormId", entity);
        param.put("FieldKeys", fieldKey);
        param.put("FilterString", this.getFilter(data));
        List obj = new ArrayList();
        try {
            String dataStr = Json.toString(param, (boolean)true);
            obj = this.ctx.getApi().executeBillQuery(dataStr);
            CheckResult checkResult = new CheckResult(this.ctx, new Object[]{dataStr}, "ExecuteBillQuery");
            obj = (List)checkResult.check(obj);
        }
        catch (Exception e) {
            throw new IscBizException((Throwable)e);
        }
        if (ObjectUtils.isEmpty(obj)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\uff1a (%1$s) \u4e2d\u4e0d\u5b58\u5728\u6761\u4ef6\u4e3a (%2$s) \u7684\u6570\u636e", (String)"K3SkyF7Setter_3", (String)"isc-iscb-connector-other", (Object[])new Object[0]), entity, data));
        }
        return ((List)obj.get(0)).get(0);
    }

    private Object getFilter(Map<String, Object> data) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Object> m : data.entrySet()) {
            stringBuilder.append(m.getKey()).append(" = ").append('\'').append(K3SkyWebApiAction.getFieldValue(this.ctx, m.getValue())).append('\'').append(" and ");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 5);
    }
}

