/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core;

import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.platform.core.task.LightTask;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;

public class IscRuntimeInfo {
    private AtomicLong mq_pubished_count = new AtomicLong(0L);
    private AtomicLong mq_consumed_count = new AtomicLong(0L);
    private AtomicLong mq_published_bytes = new AtomicLong(0L);
    private AtomicLong mq_consumed_bytes = new AtomicLong(0L);
    private AtomicLong dcr_total_count = new AtomicLong(0L);
    private AtomicLong dcr_failed_count = new AtomicLong(0L);
    private AtomicLong dct_total_count = new AtomicLong(0L);
    private AtomicLong dct_failed_count = new AtomicLong(0L);
    private AtomicLong dcw_total_count = new AtomicLong(0L);
    private AtomicLong dcw_failed_count = new AtomicLong(0L);
    private AtomicLong sf_total_count = new AtomicLong(0L);
    private AtomicLong sf_failed_count = new AtomicLong(0L);
    private AtomicLong api_total_count = new AtomicLong(0L);
    private AtomicLong api_failed_count = new AtomicLong(0L);
    private AtomicBoolean changed = new AtomicBoolean(false);
    private AtomicLong df_stream_count = new AtomicLong(0L);
    private AtomicLong df_execute_total_count = new AtomicLong(0L);
    private AtomicLong df_execute_failed_count = new AtomicLong(0L);
    private AtomicLong df_fiber_count = new AtomicLong(0L);
    private AtomicLong df_fiber_complete_count = new AtomicLong(0L);
    private static final ReadLockFreeMap<String, IscRuntimeInfo> cache = new ReadLockFreeMap();
    private static Log logger = LogFactory.getLog(DataCopyTask.class);

    public void incDataFlowFiberCount() {
        this.df_fiber_count.incrementAndGet();
        this.changed.set(true);
    }

    public void incDataFlowFiberCompleteCount() {
        this.df_fiber_complete_count.incrementAndGet();
        this.changed.set(true);
    }

    public void incDataFlowStreamCount() {
        this.df_stream_count.incrementAndGet();
        this.changed.set(true);
    }

    public void incDataFlowExecuteTotalCount() {
        this.df_execute_total_count.incrementAndGet();
        this.changed.set(true);
    }

    public void incDataFlowExecuteFailedCount() {
        this.df_execute_failed_count.incrementAndGet();
        this.changed.set(true);
    }

    public long getDataFlowFiberCount() {
        return this.df_fiber_count.getAndSet(0L);
    }

    public long getDataFlowFiberCompleteCount() {
        return this.df_fiber_complete_count.getAndSet(0L);
    }

    public long getDataFlowStreamCount() {
        return this.df_stream_count.getAndSet(0L);
    }

    public long getDataFlowExecuteTotalCount() {
        return this.df_execute_total_count.getAndSet(0L);
    }

    public long getDataFlowExecuteFailedCount() {
        return this.df_execute_failed_count.getAndSet(0L);
    }

    public void incMqPublishedCount() {
        this.mq_pubished_count.incrementAndGet();
        this.changed.set(true);
    }

    public void incMqConsumedCount() {
        this.mq_consumed_count.incrementAndGet();
        this.changed.set(true);
    }

    public void addMqPublishedBytes(int bytes) {
        this.mq_published_bytes.addAndGet(bytes);
    }

    public void addMqConsumedBytes(int bytes) {
        this.mq_consumed_bytes.addAndGet(bytes);
    }

    public void incDataCopyReadTotalCount() {
        this.dcr_total_count.incrementAndGet();
        this.changed.set(true);
    }

    public void incDataCopyReadFailedCount() {
        this.dcr_failed_count.incrementAndGet();
    }

    public void incDataCopyTransferTotalCount() {
        this.dct_total_count.incrementAndGet();
        this.changed.set(true);
    }

    public void incDataCopyTransferFailedCount() {
        this.dct_failed_count.incrementAndGet();
    }

    public void incDataCopyWriteTotalCount() {
        this.dcw_total_count.incrementAndGet();
        this.changed.set(true);
    }

    public void incDataCopyWriteFailedCount() {
        this.dcw_failed_count.incrementAndGet();
    }

    public void incServiceFlowTotalCount() {
        this.sf_total_count.incrementAndGet();
        this.changed.set(true);
    }

    public void incServiceFlowFailedCount() {
        this.sf_failed_count.incrementAndGet();
    }

    public void incApiTotalCount() {
        this.api_total_count.incrementAndGet();
        this.changed.set(true);
    }

    public void incApiFailedCount() {
        this.api_failed_count.incrementAndGet();
    }

    private boolean isChanged() {
        return this.changed.getAndSet(false);
    }

    private long getMqPubishedCount() {
        return this.mq_pubished_count.getAndSet(0L);
    }

    private long getMqConsumedCount() {
        return this.mq_consumed_count.getAndSet(0L);
    }

    private long getMqPublishedBytes() {
        return this.mq_published_bytes.getAndSet(0L);
    }

    private long getMqConsumedBytes() {
        return this.mq_consumed_bytes.getAndSet(0L);
    }

    private long getDataCopyReadTotalCount() {
        return this.dcr_total_count.getAndSet(0L);
    }

    private long getDataCopyReadFailedCount() {
        return this.dcr_failed_count.getAndSet(0L);
    }

    private long getDataCopyTransferTotalCount() {
        return this.dct_total_count.getAndSet(0L);
    }

    private long getDataCopyTransferFailedCount() {
        return this.dct_failed_count.getAndSet(0L);
    }

    private long getDataCopyWriteTotalCount() {
        return this.dcw_total_count.getAndSet(0L);
    }

    private long getDataCopyWriteFailedCount() {
        return this.dcw_failed_count.getAndSet(0L);
    }

    private long getServiceFlowTotalCount() {
        return this.sf_total_count.getAndSet(0L);
    }

    private long getServiceFlowFailedCount() {
        return this.sf_failed_count.getAndSet(0L);
    }

    private long getApiTotalCount() {
        return this.api_total_count.getAndSet(0L);
    }

    private long getApiFailedCount() {
        return this.api_failed_count.getAndSet(0L);
    }

    public static IscRuntimeInfo get() {
        String account = RequestContext.get().getAccountId();
        IscRuntimeInfo info = (IscRuntimeInfo)cache.get((Object)account);
        if (info == null) {
            info = (IscRuntimeInfo)cache.putIfAbsent((Object)account, (Object)new IscRuntimeInfo());
            ScheduleManager.submit((Task)IscRuntimeInfo.createJob(info), 180);
        }
        return info;
    }

    private static LightTask createJob(final IscRuntimeInfo info) {
        return new LightTask(){
            private String id = UUID.randomUUID().toString();

            @Override
            public String getId() {
                return this.id;
            }

            @Override
            public void run() {
                if (info == IscRuntimeInfo.get()) {
                    try {
                        IscRuntimeInfo.saveRuntimeInfo(info);
                    }
                    catch (Exception e) {
                        logger.warn("\u4fdd\u5b58\u96c6\u6210\u4e91\u8fd0\u884c\u65f6\u7edf\u8ba1\u4fe1\u606f\u5931\u8d25", (Throwable)e);
                    }
                    finally {
                        ScheduleManager.submit((Task)this, 360);
                    }
                }
            }
        };
    }

    private static void saveRuntimeInfo(IscRuntimeInfo info) {
        if (info.isChanged()) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"isc_runtime_stat");
            obj.set("api_failed_count", (Object)info.getApiFailedCount());
            obj.set("api_total_count", (Object)info.getApiTotalCount());
            obj.set("dcr_failed_count", (Object)info.getDataCopyReadFailedCount());
            obj.set("dcr_total_count", (Object)info.getDataCopyReadTotalCount());
            obj.set("dct_failed_count", (Object)info.getDataCopyTransferFailedCount());
            obj.set("dct_total_count", (Object)info.getDataCopyTransferTotalCount());
            obj.set("dcw_failed_count", (Object)info.getDataCopyWriteFailedCount());
            obj.set("dcw_total_count", (Object)info.getDataCopyWriteTotalCount());
            obj.set("mq_consumed_bytes", (Object)info.getMqConsumedBytes());
            obj.set("mq_consumed_count", (Object)info.getMqConsumedCount());
            obj.set("mq_published_bytes", (Object)info.getMqPublishedBytes());
            obj.set("mq_pubished_count", (Object)info.getMqPubishedCount());
            obj.set("sf_failed_count", (Object)info.getServiceFlowFailedCount());
            obj.set("sf_total_count", (Object)info.getServiceFlowTotalCount());
            obj.set("df_fiber_count", (Object)info.getDataFlowFiberCount());
            obj.set("df_fiber_complete_count", (Object)info.getDataFlowFiberCompleteCount());
            obj.set("df_stream_count", (Object)info.getDataFlowStreamCount());
            obj.set("df_execute_total_count", (Object)info.getDataFlowExecuteTotalCount());
            obj.set("df_execute_failed_count", (Object)info.getDataFlowExecuteFailedCount());
            Calendar date = Calendar.getInstance();
            Timestamp now = new Timestamp(date.getTimeInMillis());
            obj.set("created_time", (Object)now);
            obj.set("period_hour", (Object)D.i((Object)new SimpleDateFormat("yyyyMMddHH").format(now)));
            obj.set("period_day", (Object)D.i((Object)new SimpleDateFormat("yyyyMMdd").format(now)));
            DecimalFormat f2 = new DecimalFormat("00");
            int year = date.get(1);
            obj.set("period_week", (Object)D.i((Object)(year + f2.format(date.get(3)))));
            obj.set("period_month", (Object)D.i((Object)(year + f2.format(date.get(2) + 1))));
            obj.set("period_quarter", (Object)D.i((Object)(year + f2.format(date.get(2) / 3 + 1))));
            obj.set("period_year", (Object)year);
            obj.set("server", (Object)StringUtil.trim((String)NetUtil.getServerId(), (int)100));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        }
    }

    public static void clear() {
        cache.clear();
    }
}

