/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api;

import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.api.ApiType;
import kd.isc.iscb.platform.core.fn.ext.Functions;
import kd.isc.iscb.platform.core.sf.res.DataSourceResource;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.core.NativeFunction;

public class ApiInfo {
    private final ApiType apiType;
    private final long callerId;
    private String callerNumber;
    private final long apiId;
    private Script script;

    public ApiInfo(String metaNumber, long apiId, long callerId, String script) {
        this.apiType = ApiType.getType(metaNumber);
        this.apiId = apiId;
        this.callerId = callerId;
        if (callerId > 0L) {
            DynamicObject caller = BusinessDataServiceHelper.loadSingle((Object)callerId, (String)"isc_apic_caller");
            this.callerNumber = caller.getString("number");
        }
        if (script != null) {
            this.script = Script.compile((String)script);
        }
    }

    public Script getScript() {
        return this.script;
    }

    public ApiType getApiType() {
        return this.apiType;
    }

    public long getCallerId() {
        return this.callerId;
    }

    public String getCallerNumber() {
        return this.callerNumber;
    }

    public long getApiId() {
        return this.apiId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object data) {
        DataSourceResource.createConnectionPool();
        try {
            HashMap<String, Object> ctx = new HashMap<String, Object>();
            NativeFunction func = this.apiType.generateFunc(this);
            ctx.put(func.name(), func);
            ctx.put("$data", data);
            Object object = this.script.eval(ctx);
            return object;
        }
        finally {
            DataSourceResource.disposeConnectionPool();
        }
    }

    static {
        Functions.init();
    }
}

