/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.api.ApiInfo;
import kd.isc.iscb.platform.core.api.ExternalApiFunc;
import kd.isc.iscb.platform.core.api.ScriptApiFunc;
import kd.isc.iscb.platform.core.api.webapi.WebApi;
import kd.isc.iscb.platform.core.sf.Resource;
import kd.isc.iscb.platform.core.sf.parser.ResourceCategory;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.script.core.NativeFunction;

public enum ApiType {
    EXTERNAL("isc_apic_for_external_api"){

        @Override
        public NativeFunction generateFunc(ApiInfo apiInfo) {
            return new ExternalApiFunc(apiInfo.getApiId(), apiInfo.getCallerNumber());
        }
    }
    ,
    INTERNAL("isc_apic_script"){

        @Override
        public NativeFunction generateFunc(ApiInfo apiInfo) {
            return new ScriptApiFunc(apiInfo.getApiId(), apiInfo.getCallerNumber());
        }
    }
    ,
    WEBAPI("isc_apic_webapi"){

        @Override
        public NativeFunction generateFunc(ApiInfo apiInfo) {
            long apiId = apiInfo.getApiId();
            WebApi webApi = WebApi.get(apiId);
            DynamicObject cfg = webApi.getCfg();
            String name = cfg.getString("number");
            String title = cfg.getString("name");
            Resource resource = ResourceCategory.ISC_APIC_WEBAPI.create(apiId, name, title);
            NativeFunction function = (NativeFunction)resource.eval(null);
            return function;
        }
    };

    private final String metaNumber;

    private ApiType(String metaNumber) {
        this.metaNumber = metaNumber;
    }

    public String getMetaNumber() {
        return this.metaNumber;
    }

    public static ApiType getType(String metaNumber) {
        for (ApiType apiType : ApiType.values()) {
            if (!apiType.getMetaNumber().equals(metaNumber)) continue;
            return apiType;
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u5143\u6570\u636e\u7f16\u7801[%s]\u627e\u4e0d\u5230\u5bf9\u5e94\u7684API\u5904\u7406\u7c7b", (String)"ApiType_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), metaNumber));
    }

    public abstract NativeFunction generateFunc(ApiInfo var1);
}

