/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.api.IntegrateObjectApiDispatcher;
import kd.isc.iscb.platform.core.apic.IscApiParam;
import kd.isc.iscb.platform.core.cache.data.DataCopySchema;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.ApiToXmlPropStruct;
import kd.isc.iscb.platform.core.connector.apic.doc.schema.AbstractDocGenerator;
import kd.isc.iscb.platform.core.connector.apic.doc.schema.DcType;
import kd.isc.iscb.platform.core.connector.apic.doc.schema.ExecuteApiDocGenerator;
import kd.isc.iscb.platform.core.connector.apic.doc.schema.PullApiDocGenerator;
import kd.isc.iscb.platform.core.connector.apic.doc.schema.PushApiDocGenerator;
import kd.isc.iscb.platform.core.connector.apic.doc.schema.TransferApiDocGenerator;
import kd.isc.iscb.platform.core.connector.apic.doc.trigger.AbstractTriggerDocGenerator;
import kd.isc.iscb.platform.core.connector.apic.doc.trigger.TriggerExecuteApiDocGenerator;
import kd.isc.iscb.platform.core.connector.apic.doc.trigger.TriggerPushApiDocGenerator;
import kd.isc.iscb.platform.core.util.ApiToXmlUtil;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;

public class CheckApiParamUtil {
    public static final String INPUT_FIELD = "input_field";
    public static final String INPUT_DATA_TYPE = "input_data_type";
    public static final String INPUT_IS_REQUIRED = "input_is_required";
    public static final String INPUT_DESCRIPTION = "input_description";
    public static final String INPUTS = "inputs";
    public static final String CHECK_PARAM_TYPE = "check_param_type";

    public static boolean notCheck(DynamicObject api, Map<String, Object> data) {
        if (api == null || data == null || data.isEmpty()) {
            return true;
        }
        if (api.getDataEntityType().getProperties().containsKey((Object)CHECK_PARAM_TYPE)) {
            return !api.getBoolean(CHECK_PARAM_TYPE);
        }
        return true;
    }

    public static void checkTriggerInput(DynamicObject api, Map<String, Object> data) {
        String field;
        AbstractTriggerDocGenerator generator;
        DynamicObjectCollection params;
        String type;
        if (CheckApiParamUtil.notCheck(api, data)) {
            return;
        }
        DynamicObject schema = DataCopySchema.get(D.l((Object)api.get("data_copy_id")));
        ArrayList<Map<String, Object>> batch = new ArrayList<Map<String, Object>>();
        switch (type = api.getString("execution_type")) {
            case "PUSH": {
                batch.addAll(CollectionUtils.toList(data.get("data")));
                params = schema.getDynamicObjectCollection("mapping_entries");
                generator = new TriggerPushApiDocGenerator(null, api, null);
                field = "mapping_src_column";
                break;
            }
            case "EXECUTE": {
                batch.add(data);
                params = schema.getDynamicObjectCollection("param_entries");
                generator = new TriggerExecuteApiDocGenerator(null, api, null);
                field = "params_name";
                break;
            }
            default: {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"%s \u4e0d\u652f\u6301\u7684\u7c7b\u578b\u3002", (String)"CheckApiParamUtil_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), type));
            }
        }
        ArrayList<DynamicObject> supplier = new ArrayList<DynamicObject>();
        Map<String, ApiToXmlPropStruct> apiStruct = generator.setApiStruct(params, true, supplier);
        DynamicObject srcMeta = MetaDataSchema.get(D.l((Object)schema.getDynamicObject("source_schema").getPkValue()));
        Map<String, Object> requires = ApiToXmlUtil.existPuts(srcMeta, field, supplier);
        List<IscApiParam.Field> fields = CheckApiParamUtil.getFieldsFromPropStruct(null, requires, apiStruct, srcMeta);
        CheckApiParamUtil.checkParam(batch, fields);
    }

    public static void checkMetaInput(DynamicObject api, Map<String, Object> data) {
        List<Map<String, Object>> batch;
        if (CheckApiParamUtil.notCheck(api, data)) {
            return;
        }
        if (IntegrateObjectApiDispatcher.isBatch(api, data)) {
            batch = (List)data.get("data");
        } else {
            batch = new ArrayList();
            batch.add(data);
        }
        DynamicObjectCollection collection = api.getDynamicObjectCollection(INPUTS);
        List<IscApiParam.Field> fields = CheckApiParamUtil.getFields(collection, INPUT_FIELD, INPUT_DATA_TYPE, INPUT_DESCRIPTION, INPUT_IS_REQUIRED, null, null);
        CheckApiParamUtil.checkParam(batch, fields);
    }

    public static void checkDcInput(DynamicObject api, Map<String, Object> data) {
        AbstractDocGenerator generator;
        String field;
        String entriesName;
        if (CheckApiParamUtil.notCheck(api, data)) {
            return;
        }
        ArrayList<Map<String, Object>> batch = new ArrayList<Map<String, Object>>();
        ArrayList<DynamicObject> supplier = new ArrayList<DynamicObject>();
        DcType type = DcType.valueOf(api.getString("type"));
        switch (type) {
            case PULL: {
                batch.add(data);
                entriesName = "param_entries";
                field = "params_name";
                generator = new PullApiDocGenerator(null, api, null);
                break;
            }
            case EXECUTE: {
                batch.add(data);
                entriesName = "param_entries";
                field = "params_name";
                generator = new ExecuteApiDocGenerator(null, api, null);
                break;
            }
            case PUSH: {
                batch.addAll(CollectionUtils.toList(data.get("data")));
                entriesName = "mapping_entries";
                field = "mapping_src_column";
                generator = new PushApiDocGenerator(null, api, null);
                break;
            }
            case TRANSFER: {
                batch.addAll(CollectionUtils.toList(data.get("data")));
                entriesName = "mapping_entries";
                field = "mapping_src_column";
                generator = new TransferApiDocGenerator(null, api, null);
                break;
            }
            default: {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"%s \u4e0d\u652f\u6301\u7684\u7c7b\u578b\u3002", (String)"CheckApiParamUtil_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), new Object[]{type}));
            }
        }
        DynamicObject opObj = DataCopySchema.get(D.l((Object)api.get("schema_id")));
        Map<String, ApiToXmlPropStruct> apiStruct = generator.setApiStruct(opObj.getDynamicObjectCollection(entriesName), true, supplier);
        DynamicObject srcMeta = MetaDataSchema.get(D.l((Object)opObj.getDynamicObject("source_schema").getPkValue()));
        Map<String, Object> requires = ApiToXmlUtil.existPuts(srcMeta, field, supplier);
        List<IscApiParam.Field> fields = CheckApiParamUtil.getFieldsFromPropStruct(null, requires, apiStruct, srcMeta);
        CheckApiParamUtil.checkParam(batch, fields);
    }

    public static void checkMsInput(DynamicObject api, Map<String, Object> data) {
        if (CheckApiParamUtil.notCheck(api, data)) {
            return;
        }
        DynamicObjectCollection inputs = api.getDynamicObjectCollection(INPUTS);
        if (CollectionUtils.isEmpty(inputs)) {
            return;
        }
        ArrayList<IscApiParam.Field> fields = new ArrayList<IscApiParam.Field>(inputs.size());
        for (DynamicObject input : inputs) {
            String dateType = input.getString(INPUT_DATA_TYPE);
            boolean isArray = "ENTRIES".equalsIgnoreCase(dateType) || "ARRAY".equalsIgnoreCase(dateType);
            fields.add(new IscApiParam.Field(input.getString(INPUT_FIELD), dateType, input.getString(INPUT_DESCRIPTION), isArray, false, null));
        }
        CheckApiParamUtil.checkParam(Collections.singletonList(data), fields);
    }

    public static String translateType(String type) {
        switch (type) {
            case "List(nclob)": 
            case "nclob": 
            case "string": {
                return "string";
            }
            case "int": 
            case "List(int)": {
                return "int";
            }
            case "decimal": 
            case "List(decimal)": {
                return "decimal";
            }
            case "List(datetime)": 
            case "datetime": {
                return "datetime";
            }
            case "List(date)": 
            case "date": {
                return "date";
            }
            case "List(time)": 
            case "time": {
                return "time";
            }
            case "bigint": 
            case "List(bigint)": 
            case "long": {
                return "long";
            }
            case "bit": 
            case "List(bit)": 
            case "boolean": {
                return "boolean";
            }
            case "ENUM": {
                return "ENUM";
            }
        }
        return type;
    }

    private static List<IscApiParam.Field> getFields(DynamicObjectCollection params, String nameProperty, String dataTypeProperty, String titleProperty, String requiredProperty, String isArrayProperty, String defaultValueProperty) {
        if (CollectionUtils.isEmpty(params)) {
            return Collections.emptyList();
        }
        ArrayList<IscApiParam.Field> fields = new ArrayList<IscApiParam.Field>(params.size());
        for (DynamicObject p : params) {
            fields.add(CheckApiParamUtil.getField(p, nameProperty, dataTypeProperty, titleProperty, requiredProperty, isArrayProperty, defaultValueProperty));
        }
        return fields;
    }

    private static IscApiParam.Field getField(DynamicObject entity, String nameProperty, String dataTypeProperty, String titleProperty, String requiredProperty, String isArrayProperty, String defaultValueProperty) {
        boolean isArray;
        String name = StringUtil.isEmpty((String)nameProperty) ? null : entity.getString(nameProperty);
        String dataType = StringUtil.isEmpty((String)dataTypeProperty) ? null : entity.getString(dataTypeProperty);
        String title = StringUtil.isEmpty((String)titleProperty) ? null : entity.getString(titleProperty);
        boolean required = !StringUtil.isEmpty((String)requiredProperty) && entity.getBoolean(requiredProperty);
        boolean bl = isArray = !StringUtil.isEmpty((String)isArrayProperty) && entity.getBoolean(isArrayProperty);
        if (ApiToXmlUtil.isEntries(dataType)) {
            dataType = "STRUCT";
            isArray = true;
        }
        String defaultValue = StringUtil.isEmpty((String)defaultValueProperty) ? null : entity.getString(defaultValueProperty);
        return new IscApiParam.Field(name, dataType, title, isArray, required, defaultValue);
    }

    private static void checkParam(List<Map<String, Object>> batch, List<IscApiParam.Field> fields) {
        fields = fields.stream().sorted(Comparator.comparing(IscApiParam.Field::getName)).collect(Collectors.toList());
        IscApiParam apiParam = new IscApiParam(fields);
        for (Map<String, Object> map : batch) {
            if (map == null || map.isEmpty()) continue;
            apiParam.narrow(map);
        }
    }

    private static List<IscApiParam.Field> getFieldsFromPropStruct(String str, Map<String, Object> requires, Map<String, ApiToXmlPropStruct> apiStruct, DynamicObject srcMeta) {
        ArrayList<IscApiParam.Field> fieldList = new ArrayList<IscApiParam.Field>();
        for (Map.Entry<String, Object> entry : requires.entrySet()) {
            IscApiParam.Field field;
            ApiToXmlPropStruct propStruct;
            String s = str == null ? entry.getKey() : str + '.' + entry.getKey();
            ApiToXmlPropStruct apiToXmlPropStruct = propStruct = apiStruct.get(s) == null ? new ApiToXmlPropStruct(s, null, null) : apiStruct.get(s);
            if (entry.getValue() instanceof Integer && ApiToXmlUtil.isRef(propStruct.getDataType())) {
                apiStruct.get(s).setDesc();
            }
            boolean isArray = false;
            boolean required = false;
            String dataType = propStruct.getDataType();
            if (entry.getValue() instanceof Map) {
                if (StringUtil.isEmpty((String)propStruct.getDataType())) {
                    dataType = "STRUCT";
                    String type = ApiToXmlUtil.getProperty(srcMeta, propStruct.getName(), "data_type");
                    if (ApiToXmlUtil.isEntries(type)) {
                        isArray = true;
                    }
                }
                field = new IscApiParam.Field(propStruct.getName(), dataType, propStruct.getDesc(), isArray, required, null);
                fieldList.add(field);
                fieldList.addAll(CheckApiParamUtil.getFieldsFromPropStruct(s, (Map)entry.getValue(), apiStruct, srcMeta));
                continue;
            }
            field = new IscApiParam.Field(propStruct.getName(), dataType, propStruct.getDesc(), isArray, required, null);
            fieldList.add(field);
        }
        return fieldList;
    }
}

