/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.isc.iscb.platform.core.api.CheckApiParamUtil;
import kd.isc.iscb.platform.core.api.IscApiResult;
import kd.isc.iscb.platform.core.apic.IscApicUtil;
import kd.isc.iscb.platform.core.cache.data.MicroServiceApi;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.platform.core.trace.TraceType;
import kd.isc.iscb.platform.core.trace.TraceUtil;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.trace.TraceTask;

public class MicroServiceApiDispatcher {
    private static final String ISC_APIC_MSERVICE = "isc_apic_mservice";

    public static ApiResult execute(String apiNumber, String caller, Map<String, Object> data) {
        MicroServiceApi cachedApi = MicroServiceApi.getSchema(apiNumber);
        try {
            Object result = MicroServiceApiDispatcher.execute(cachedApi, data, caller);
            return ApiResult.success((Object)result);
        }
        catch (Exception e) {
            return IscApiResult.ex(e);
        }
    }

    public static Object execute(MicroServiceApi cachedApi, Object[] args, String caller) {
        Map<String, Object> params = MicroServiceApiDispatcher.prepareParams(cachedApi.getInputs(), args);
        return MicroServiceApiDispatcher.execute(cachedApi, params, caller);
    }

    public static Object execute(final MicroServiceApi cachedApi, final Map<String, Object> data, final String caller) {
        final DynamicObject api = cachedApi.getCfg();
        DynamicObject log = IscApicUtil.invokeBegin(api, ISC_APIC_MSERVICE, caller, data);
        try {
            Object result = log == null ? TraceStack.run(TraceType.EXE_APIF, MicroServiceApiDispatcher.getNumber(cachedApi), api.getLong("id"), new TraceTask(){

                public Object invoke() {
                    return MicroServiceApiDispatcher.invokeApi(caller, api, cachedApi, data);
                }
            }) : TraceStack.run(TraceType.EXE_APIL, log, new TraceTask(){

                public Object invoke() {
                    return MicroServiceApiDispatcher.invokeApi(caller, api, cachedApi, data);
                }
            });
            IscApicUtil.invokeEnd(log, result, api);
            return result;
        }
        catch (Exception e) {
            IscApicUtil.invokeEnd(log, e, api);
            throw e;
        }
    }

    private static String getNumber(MicroServiceApi api) {
        return "isc_apic_mservice/" + api.getServiceName() + "." + api.getMethod() + "@" + api.getAppId();
    }

    private static Object invokeApi(String caller, DynamicObject api, MicroServiceApi cachedApi, Map<String, Object> data) {
        TraceUtil.checkDisableTrace(api);
        MicroServiceApiDispatcher.checkApiEnable(api);
        IscApicUtil.checkCaller(api, ISC_APIC_MSERVICE, caller);
        CheckApiParamUtil.checkMsInput(api, data);
        Object[] params = MicroServiceApiDispatcher.getParams(cachedApi.getInputs(), data);
        Object result = MicroServiceApiDispatcher.invoke(cachedApi, params);
        return result;
    }

    private static Map<String, Object> prepareParams(DynamicObjectCollection inputs, Object[] args) {
        if (inputs.size() != args.length) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u63d0\u4f9b\u7684\u5fae\u670d\u52a1\u53c2\u6570\u4e2a\u6570\u4e0e\u5b9a\u4e49\u4e0d\u7b26\uff0c\u8981\u6c42%1$s\u4e2a\uff0c\u5b9e\u9645\u63d0\u4f9b%2$s\u4e2a\uff01", (String)"MicroServiceApiDispatcher_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), inputs.size(), args.length));
        }
        HashMap<String, Object> params = new HashMap<String, Object>(inputs.size());
        for (int i = 0; i < inputs.size(); ++i) {
            DynamicObject input = (DynamicObject)inputs.get(i);
            String key = input.getString("input_field");
            params.put(key, args[i]);
        }
        return params;
    }

    private static Object[] getParams(DynamicObjectCollection inputs, Map<String, Object> data) {
        Object[] values = new Object[inputs.size()];
        for (int i = 0; i < inputs.size(); ++i) {
            DynamicObject object = (DynamicObject)inputs.get(i);
            String field = D.s((Object)object.getString("input_field"));
            values[i] = MicroServiceApiDispatcher.castParams(data.get(field), D.s((Object)object.getString("input_data_type")));
        }
        return values;
    }

    public static Object castParams(Object value, String dataType) {
        if (value == null) {
            return null;
        }
        switch (dataType) {
            case "string": {
                return value.toString();
            }
            case "boolean": {
                return D.x((Object)value);
            }
            case "decimal": 
            case "bigdecimal": {
                return D.n((Object)value);
            }
            case "integer": 
            case "int": {
                return D.i((Object)value);
            }
            case "long": {
                return D.l((Object)value);
            }
            case "datetime": {
                return D.t((Object)value);
            }
            case "double": {
                return Double.parseDouble(value.toString());
            }
            case "STRUCT": {
                return MicroServiceApiDispatcher.castMap(value);
            }
            case "ENTRIES": {
                return CollectionUtils.toList(value);
            }
            case "ARRAY": {
                return MicroServiceApiDispatcher.castArray(value);
            }
            case "Set": {
                return CollectionUtils.toSet(value);
            }
        }
        return value;
    }

    private static Object castMap(Object value) {
        if (value instanceof Map) {
            return value;
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b\u5e94\u4e3aMap:{}\uff0c\u5b9e\u9645\u4e3a\uff1a%s", (String)"MicroServiceApiDispatcher_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]), value));
    }

    private static Object castArray(Object value) {
        if (value instanceof List) {
            return ((List)value).toArray();
        }
        if (value instanceof Object[]) {
            return value;
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b\u5e94\u4e3a\u6570\u7ec4\uff0c\u5b9e\u9645\u4e3a\uff1a%s", (String)"MicroServiceApiDispatcher_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), value));
    }

    private static Object invoke(MicroServiceApi cachedApi, Object[] params) {
        String type = cachedApi.getServiceType();
        if ("bos".equals(type)) {
            return DispatchServiceHelper.invokeBOSService((String)cachedApi.getAppId(), (String)cachedApi.getServiceName(), (String)cachedApi.getMethod(), (Object[])params);
        }
        if ("biz".equals(type)) {
            return DispatchServiceHelper.invokeBizService((String)cachedApi.getCloudId(), (String)cachedApi.getAppId(), (String)cachedApi.getServiceName(), (String)cachedApi.getMethod(), (Object[])params);
        }
        if ("isv".equals(type)) {
            return DispatchServiceHelper.invokeService((String)cachedApi.getCloudId(), (String)cachedApi.getAppId(), (String)cachedApi.getServiceName(), (String)cachedApi.getMethod(), (Object[])params);
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5fae\u670d\u52a1\u7c7b\u578b\uff1a%s", (String)"MicroServiceApiDispatcher_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), type));
    }

    private static void checkApiEnable(DynamicObject api) {
        if (!api.getBoolean("enable")) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u5fae\u670d\u52a1API\uff1a%s\u5df2\u7981\u7528\uff0c\u7981\u6b62\u8bbf\u95ee\u3002", (String)"MicroServiceApiDispatcher_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), api.getString("number")));
        }
    }
}

