/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.openapi.v2;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.IDService;
import kd.bos.orm.query.QFilter;
import kd.isc.iscb.platform.core.api.ApiUtil;
import kd.isc.iscb.platform.core.api.openapi.OpenApiConstFields;
import kd.isc.iscb.platform.core.api.openapi.v2.OpenApiField;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.Const;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class IscApiUtil
implements OpenApiConstFields,
Const {
    public static void addInput(DynamicObjectCollection inputEntries, MetaDataSchema metaData, Map<String, Object> srcFields) {
        long id = IscApiUtil.getId();
        int level = 1;
        OpenApiField dataField = new OpenApiField("data", "STRUCT");
        IscApiUtil.addInputField(inputEntries, 0L, id, level, dataField);
        IscApiUtil.addMeta2Input(inputEntries, metaData, srcFields, id, level + 1);
    }

    public static void addMeta2Input(DynamicObjectCollection inputEntries, MetaDataSchema metaData, Map<String, Object> srcFields, long id, int level) {
        IscApiUtil.addInputEntry(inputEntries, metaData, srcFields, id, level);
    }

    private static void addInputEntry(DynamicObjectCollection inputEntries, MetaDataSchema metaData, Object srcFields, long parentId, int level) {
        if (srcFields instanceof Map) {
            Map src = (Map)srcFields;
            for (Map.Entry srcField : src.entrySet()) {
                String fieldName = (String)srcField.getKey();
                OpenApiField openApiField = new OpenApiField(fieldName, metaData);
                long id = IscApiUtil.getId();
                IscApiUtil.addInputField(inputEntries, parentId, id, level, openApiField);
                MetaDataSchema refMetaData = IscApiUtil.getRefMetaData(metaData, fieldName);
                IscApiUtil.addInputEntry(inputEntries, refMetaData, srcField.getValue(), id, level + 1);
            }
        }
    }

    public static void addInputField(DynamicObjectCollection inputEntries, long parentId, long id, int level, OpenApiField field) {
        DynamicObject inputEntry = inputEntries.addNew();
        inputEntry.set("id", (Object)id);
        inputEntry.set("paramname", (Object)field.name);
        inputEntry.set("bodyparamdes", (Object)field.title);
        Object example = field.example;
        inputEntry.set("example", (Object)("-".equals(example) ? "-" : JSON.toJSONString((Object)example)));
        inputEntry.set("paramtype", (Object)field.type);
        inputEntry.set("is_req_mul_value", (Object)field.isArray);
        inputEntry.set("must", (Object)(field.required ? "1" : "0"));
        inputEntry.set("pid", (Object)parentId);
        inputEntry.set("body_level", (Object)D.s((Object)level));
    }

    private static MetaDataSchema getRefMetaData(MetaDataSchema metaData, String fieldName) {
        DynamicObject group;
        long groupId;
        if (metaData == null || metaData.getDataSchema(fieldName).isEmpty()) {
            return null;
        }
        String dataSchema = metaData.getDataSchema(fieldName);
        QFilter filter = new QFilter("number", "=", (Object)dataSchema).and("group", "=", (Object)(groupId = (group = metaData.getConfig().getDynamicObject("group")).getLong("id")));
        MetaDataSchema meta = MetaDataSchema.getOneSchemaByFilter(filter);
        if (meta == null) {
            String number = group.getString("number");
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5728\u7f16\u7801\u4e3a(%1$s)\u7684\u6570\u636e\u6e90\u4e2d\u6ca1\u6709\u627e\u5230\u7f16\u7801\u4e3a(%2$s)\u7684\u96c6\u6210\u5bf9\u8c61\uff0c\u8bf7\u786e\u8ba4\uff1a", (String)"IscApiUtil_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), number, dataSchema) + "\r\n" + ResManager.loadKDString((String)"1\u3001\u96c6\u6210\u5bf9\u8c61\u4e0d\u5b58\u5728\uff0c\u5219\u5168\u91cf\u540c\u6b65\u8be5\u6570\u636e\u6e90\u7684\u96c6\u6210\u5bf9\u8c61\uff1b", (String)"IscApiUtil_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"2\u3001\u96c6\u6210\u5bf9\u8c61\u5b58\u5728\uff0c\u5219\u91cd\u65b0\u4fdd\u5b58\u4e00\u4e0b\u8be5\u96c6\u6210\u5bf9\u8c61\u3002", (String)"IscApiUtil_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        return meta;
    }

    public static void addParam2Input(DynamicObjectCollection inputEntries, DynamicObjectCollection params) {
        for (DynamicObject param : params) {
            OpenApiField field = new OpenApiField(param, "params_name", "params_label", "params_data_type");
            IscApiUtil.addInputField(inputEntries, 0L, IscApiUtil.getId(), 1, field);
        }
    }

    public static void addMeta2Output(DynamicObjectCollection outputEntries, MetaDataSchema metaData, Object tarFields) {
        IscApiUtil.addOutputEntry(outputEntries, metaData, tarFields, 0L, 1);
    }

    private static void addOutputEntry(DynamicObjectCollection outputEntries, MetaDataSchema metaData, Object tarFields, long parentId, int level) {
        if (tarFields instanceof Map) {
            Map fields = (Map)tarFields;
            for (Map.Entry tarField : fields.entrySet()) {
                String fieldName = (String)tarField.getKey();
                OpenApiField field = new OpenApiField(fieldName, metaData);
                long id = IscApiUtil.getId();
                IscApiUtil.addOutputField(outputEntries, parentId, id, level, field);
                MetaDataSchema refMetaData = IscApiUtil.getRefMetaData(metaData, fieldName);
                IscApiUtil.addOutputEntry(outputEntries, refMetaData, tarField.getValue(), id, level + 1);
            }
        }
    }

    public static void addOutputField(DynamicObjectCollection outputEntries, long parentId, long id, int level, OpenApiField field) {
        DynamicObject outputEntry = outputEntries.addNew();
        outputEntry.set("id", (Object)id);
        outputEntry.set("respparamname", (Object)field.name);
        outputEntry.set("respdes", (Object)field.title);
        outputEntry.set("respparamtype", (Object)field.type);
        Object example = field.example;
        outputEntry.set("respexample", (Object)("-".equals(example) ? "-" : JSON.toJSONString((Object)example)));
        outputEntry.set("is_resp_mul_value", (Object)field.isArray);
        outputEntry.set("pid", (Object)parentId);
        outputEntry.set("resp_level", (Object)level);
    }

    public static Map<String, Object> getInputFields(DynamicObject dataCopy) {
        TreeMap<String, Object> inputs = new TreeMap<String, Object>();
        DynamicObjectCollection mappingEntries = dataCopy.getDynamicObjectCollection("mapping_entries");
        for (DynamicObject mappingEntry : mappingEntries) {
            String src = D.s((Object)mappingEntry.get("mapping_src_column"));
            if (src == null) continue;
            if (src.indexOf(46) < 0) {
                inputs.putIfAbsent(src, 1);
                continue;
            }
            String[] names = src.split("\\.");
            IscApiUtil.addEntryProperty(inputs, names);
        }
        return inputs;
    }

    public static void addEntryProperty(Map<String, Object> requires, String[] path) {
        Map entry = requires;
        int j = path.length - 1;
        for (int i = 0; i < j; ++i) {
            String name = path[i];
            HashMap tmp = entry.get(name);
            if (!(tmp instanceof Map)) {
                tmp = new HashMap();
                entry.put(name, tmp);
            }
            entry = tmp;
        }
        if (!(entry.get(path[path.length - 1]) instanceof Map)) {
            entry.put(path[path.length - 1], 1);
        }
    }

    public static Map<String, Object> getOutputFields(DynamicObject dataCopy) {
        TreeMap<String, Object> outputs = new TreeMap<String, Object>();
        DynamicObjectCollection mappingEntries = dataCopy.getDynamicObjectCollection("mapping_entries");
        for (DynamicObject obj : mappingEntries) {
            String tar = D.s((Object)obj.get("mapping_tar_column"));
            String src = D.s((Object)obj.get("mapping_src_column"));
            String fixedValue = D.s((Object)obj.get("fixed_value"));
            if (tar == null || src == null && fixedValue == null) continue;
            if (tar.indexOf(46) < 0) {
                outputs.put(tar, 1);
                continue;
            }
            String[] names = tar.split("\\.");
            IscApiUtil.addEntryProperty(outputs, names);
        }
        return outputs;
    }

    public static long getId() {
        return IDService.get().genLongId();
    }

    public static void setOutputByVersion(Map<String, Object> output, DynamicObject api) {
        if (ApiUtil.isVersion2Api(api)) {
            output.put("status", Boolean.TRUE);
            output.put("errorCode", null);
            output.put("message", null);
        } else {
            output.put("success", Boolean.TRUE);
            output.put("errorCode", "success");
        }
    }

    public static void setErrorByVersion(Map<String, Object> error, DynamicObject api) {
        if (ApiUtil.isVersion2Api(api)) {
            error.put("status", Boolean.FALSE);
        } else {
            error.put("success", Boolean.FALSE);
        }
    }
}

