/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.openapi.v2;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.openapi.common.constant.DataType;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.platform.core.cache.data.type.EntryType;
import kd.isc.iscb.platform.core.cache.data.type.Field;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.ListType;

public class OpenApiField {
    String name;
    String title;
    boolean required;
    String type;
    Object example;
    boolean isArray;
    private static final Map<String, DataType> META_AND_OPENAPI_TYPE_MAPPING = new HashMap<String, DataType>(12);
    private static final Map<String, DataType> STRUCT_AND_OPENAPI_TYPE_MAPPING;

    public OpenApiField(String fieldName, MetaDataSchema metaData) {
        if (metaData == null || metaData.getField(fieldName) == null) {
            this.name = fieldName;
            this.title = fieldName;
            this.required = false;
            DataType any = DataType.ANY;
            this.type = any.type();
            this.example = any.defaultValue();
            this.isArray = false;
        } else {
            Field field = metaData.getField(fieldName);
            this.name = field.getName();
            this.title = field.getTitle();
            this.required = field.isRequired();
            kd.isc.iscb.util.dt.DataType dataType = field.getDataType();
            this.isArray = dataType instanceof EntryType || dataType instanceof ListType;
            DataType openApiType = OpenApiField.metaTypeToOpenApiType(dataType);
            this.type = openApiType.type();
            this.example = openApiType.defaultValue();
        }
    }

    public OpenApiField(DynamicObject param, String name, String title, String type) {
        this.name = param.getString(name);
        this.title = param.getString(title);
        this.required = false;
        String paramType = param.getString(type);
        this.isArray = "ENTRIES".equals(paramType);
        DataType openApiType = OpenApiField.structTypeToOpenApiType(paramType);
        this.type = openApiType.type();
        this.example = openApiType.defaultValue();
    }

    public OpenApiField(String name, String title, String example) {
        this.name = name;
        this.title = title;
        this.required = false;
        this.isArray = false;
        this.type = "String";
        this.example = example;
    }

    public OpenApiField(Map<String, Object> varDefine, String type) {
        this.name = D.s((Object)varDefine.get("name"));
        this.title = D.s((Object)varDefine.get("title"));
        this.required = false;
        this.isArray = D.x((Object)varDefine.get("is_array"));
        DataType openApiFieldType = OpenApiField.structTypeToOpenApiType(type);
        this.type = openApiFieldType.type();
        this.example = openApiFieldType.defaultValue();
    }

    public OpenApiField(String name, String type) {
        this.name = name;
        this.title = name;
        this.required = false;
        DataType openApiFieldType = OpenApiField.structTypeToOpenApiType(type);
        this.type = openApiFieldType.type();
        this.example = openApiFieldType.defaultValue();
        this.isArray = false;
    }

    private static DataType metaTypeToOpenApiType(kd.isc.iscb.util.dt.DataType iscDataType) {
        String name = iscDataType.getClass().getName();
        DataType openApiType = META_AND_OPENAPI_TYPE_MAPPING.get(name);
        if (openApiType == null) {
            return DataType.ANY;
        }
        return openApiType;
    }

    public static DataType structTypeToOpenApiType(String typeName) {
        DataType dataType = STRUCT_AND_OPENAPI_TYPE_MAPPING.get(typeName);
        if (dataType == null) {
            return DataType.ANY;
        }
        return dataType;
    }

    static {
        META_AND_OPENAPI_TYPE_MAPPING.put("kd.isc.iscb.platform.core.cache.data.type.EntryType", DataType.STRUCT);
        META_AND_OPENAPI_TYPE_MAPPING.put("kd.isc.iscb.util.dt.i.DateTimeType", DataType.DATE_TIME);
        META_AND_OPENAPI_TYPE_MAPPING.put("kd.isc.iscb.util.dt.i.DateType", DataType.DATE);
        META_AND_OPENAPI_TYPE_MAPPING.put("kd.isc.iscb.util.dt.i.StringType", DataType.STRING);
        META_AND_OPENAPI_TYPE_MAPPING.put("kd.isc.iscb.util.dt.i.DecimalType", DataType.DECIMAL);
        META_AND_OPENAPI_TYPE_MAPPING.put("kd.isc.iscb.util.dt.i.BooleanType", DataType.BOOLEAN);
        META_AND_OPENAPI_TYPE_MAPPING.put("kd.isc.iscb.util.dt.i.LongType", DataType.LONG);
        META_AND_OPENAPI_TYPE_MAPPING.put("kd.isc.iscb.util.dt.i.IntegerType", DataType.INTEGER);
        STRUCT_AND_OPENAPI_TYPE_MAPPING = new HashMap<String, DataType>(36);
        STRUCT_AND_OPENAPI_TYPE_MAPPING.put("int", DataType.INTEGER);
        STRUCT_AND_OPENAPI_TYPE_MAPPING.put("integer", DataType.INTEGER);
        STRUCT_AND_OPENAPI_TYPE_MAPPING.put("INTEGER", DataType.INTEGER);
        STRUCT_AND_OPENAPI_TYPE_MAPPING.put("long", DataType.LONG);
        STRUCT_AND_OPENAPI_TYPE_MAPPING.put("LONG", DataType.LONG);
        STRUCT_AND_OPENAPI_TYPE_MAPPING.put("decimal", DataType.DECIMAL);
        STRUCT_AND_OPENAPI_TYPE_MAPPING.put("DECIMAL", DataType.DECIMAL);
        STRUCT_AND_OPENAPI_TYPE_MAPPING.put("double", DataType.DECIMAL);
        STRUCT_AND_OPENAPI_TYPE_MAPPING.put("datetime", DataType.DATE_TIME);
        STRUCT_AND_OPENAPI_TYPE_MAPPING.put("DATETIME", DataType.DATE_TIME);
        STRUCT_AND_OPENAPI_TYPE_MAPPING.put("date", DataType.DATE);
        STRUCT_AND_OPENAPI_TYPE_MAPPING.put("DATE", DataType.DATE);
        STRUCT_AND_OPENAPI_TYPE_MAPPING.put("time", DataType.DATE_TIME);
        STRUCT_AND_OPENAPI_TYPE_MAPPING.put("TIME", DataType.DATE_TIME);
        STRUCT_AND_OPENAPI_TYPE_MAPPING.put("string", DataType.STRING);
        STRUCT_AND_OPENAPI_TYPE_MAPPING.put("STRING", DataType.STRING);
        STRUCT_AND_OPENAPI_TYPE_MAPPING.put("boolean", DataType.BOOLEAN);
        STRUCT_AND_OPENAPI_TYPE_MAPPING.put("BOOLEAN", DataType.BOOLEAN);
        STRUCT_AND_OPENAPI_TYPE_MAPPING.put("STRUCT", DataType.STRUCT);
        STRUCT_AND_OPENAPI_TYPE_MAPPING.put("ENTRIES", DataType.STRUCT);
        STRUCT_AND_OPENAPI_TYPE_MAPPING.put("ARRAY", DataType.STRUCT);
        STRUCT_AND_OPENAPI_TYPE_MAPPING.put("variant", DataType.ANY);
        STRUCT_AND_OPENAPI_TYPE_MAPPING.put("unknown", DataType.ANY);
    }
}

