/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.openapi.v2;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.openapi.common.constant.DataType;
import kd.isc.iscb.platform.core.api.openapi.v2.IscApiUtil;
import kd.isc.iscb.platform.core.api.openapi.v2.OpenApiField;
import kd.isc.iscb.platform.core.api.openapi.v2.OpenApiVersion2Builder;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.platform.core.connector.apic.doc.JsonSampleUtil;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.Flow;
import kd.isc.iscb.util.flow.core.Variable;

public class OpenApiFormIscFlowApi
extends OpenApiVersion2Builder {
    private Flow flow;

    @Override
    protected DynamicObjectCollection makeBodyEntries(DynamicObject svc, DynamicObject api) {
        this.checkApiParam(api);
        DynamicObjectCollection bodyEntries = svc.getDynamicObjectCollection("bodyentryentity");
        bodyEntries.clear();
        this.addInputParam(bodyEntries);
        return bodyEntries;
    }

    private void checkApiParam(DynamicObject api) {
        DynamicObject serviceFlow = api.getDynamicObject("service_flow");
        if (serviceFlow == null) {
            String number = api.getString("number");
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u53d1\u5e03\u7f16\u7801\u4e3a\uff08%s\uff09\u7684\u96c6\u6210\u5bf9\u8c61\u8f6cAPI\u5230\u5f00\u653e\u5e73\u53f0\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u96c6\u6210\u5bf9\u8c61\u8f6cAPI\u6ca1\u6709\u5173\u8054\u3010\u96c6\u6210\u5bf9\u8c61\u3011\u3002", (String)"OpenApiFormIscFlowApi_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), number));
        }
        long flowId = ServiceFlowParser.findReleasedFlowId(api.getLong("service_flow_id"));
        this.flow = ServiceFlowParser.getFlow(flowId);
    }

    private void addInputParam(DynamicObjectCollection inputEntries) {
        List inputVariables = this.flow.getInputVariables();
        for (Variable variable : inputVariables) {
            this.parseInputVariable(inputEntries, variable);
        }
    }

    private void parseInputVariable(DynamicObjectCollection inputEntries, Variable variable) {
        Map varDefine = (Map)variable.getAttribute("define");
        String category = D.s(varDefine.get("category"));
        int level = 1;
        if ("isc_metadata_schema".equalsIgnoreCase(category)) {
            this.addSchema2Input(inputEntries, varDefine, level);
        } else if ("isc_type_simple_value".equalsIgnoreCase(category)) {
            OpenApiField openApiField = new OpenApiField(varDefine, D.s(varDefine.get("type")));
            IscApiUtil.addInputField(inputEntries, 0L, IscApiUtil.getId(), level, openApiField);
        } else {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u53d8\u91cf\u7c7b\u522b\uff1a%1$s(%2$s)", (String)"OpenApiFormIscFlowApi_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), category, variable.getName()));
        }
    }

    private void addSchema2Input(DynamicObjectCollection inputEntries, Map<String, Object> varDefine, int level) {
        long id = IscApiUtil.getId();
        OpenApiField openApiField = new OpenApiField(varDefine, "STRUCT");
        IscApiUtil.addInputField(inputEntries, 0L, id, level, openApiField);
        DynamicObject metaSchema = MetaDataSchema.get(D.l((Object)varDefine.get("type")));
        DynamicObjectCollection propList = metaSchema.getDynamicObjectCollection("prop_entryentity");
        this.addProp2Input(inputEntries, metaSchema, propList, id, level + 1);
    }

    private void addProp2Input(DynamicObjectCollection inputEntries, DynamicObject metaSchema, DynamicObjectCollection propList, long parentId, int level) {
        for (DynamicObject prop : propList) {
            long id = IscApiUtil.getId();
            OpenApiField openApiField = new OpenApiField(prop, "prop_name", "prop_label", "data_type");
            IscApiUtil.addInputField(inputEntries, parentId, id, level, openApiField);
            if (!this.isEntries(prop.getString("data_type"))) continue;
            DynamicObject entries = JsonSampleUtil.findMetaByDataSchema(metaSchema, prop.getString("data_schema"));
            DynamicObjectCollection entryList = entries.getDynamicObjectCollection("prop_entryentity");
            this.addProp2Input(inputEntries, metaSchema, entryList, id, level + 1);
        }
    }

    private boolean isEntries(String type) {
        return type != null && type.startsWith("ENTRIES");
    }

    @Override
    protected DynamicObjectCollection makeRespEntries(DynamicObject svc, DynamicObject api) {
        DynamicObjectCollection outputEntries = svc.getDynamicObjectCollection("respentryentity");
        outputEntries.clear();
        this.addOutputParam(outputEntries);
        return outputEntries;
    }

    private void addOutputParam(DynamicObjectCollection outputEntries) {
        int level = 1;
        this.addBaseInfo(outputEntries, "id", "long", ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8bid", (String)"OpenApiFormIscFlowApi_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), IscApiUtil.getId(), level);
        long id = IscApiUtil.getId();
        this.addBaseInfo(outputEntries, "output", "STRUCT", ResManager.loadKDString((String)"\u8f93\u51fa\u53c2\u6570", (String)"OpenApiFormIscFlowApi_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), id, level);
        List outputVariables = this.flow.getOutputVariables();
        for (Variable variable : outputVariables) {
            this.parseOutputVariable(outputEntries, level, id, variable);
        }
    }

    private void parseOutputVariable(DynamicObjectCollection outputEntries, int level, long id, Variable variable) {
        Map varDefine = (Map)variable.getAttribute("define");
        String category = D.s(varDefine.get("category"));
        if ("isc_metadata_schema".equalsIgnoreCase(category)) {
            this.addSchema2Output(outputEntries, level, id, varDefine);
        } else if ("isc_type_simple_value".equalsIgnoreCase(category)) {
            OpenApiField openApiField = new OpenApiField(varDefine, D.s(varDefine.get("type")));
            IscApiUtil.addOutputField(outputEntries, id, IscApiUtil.getId(), level + 1, openApiField);
        } else {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u53d8\u91cf\u7c7b\u522b\uff1a%1$s(%2$s)", (String)"OpenApiFormIscFlowApi_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), category, variable.getName()));
        }
    }

    private void addSchema2Output(DynamicObjectCollection outputEntries, int level, long parentId, Map<String, Object> varDefine) {
        long id = IscApiUtil.getId();
        OpenApiField openApiField = new OpenApiField(varDefine, "STRUCT");
        IscApiUtil.addOutputField(outputEntries, parentId, id, level + 1, openApiField);
        DynamicObject metaSchema = MetaDataSchema.get(D.l((Object)varDefine.get("type")));
        DynamicObjectCollection propList = metaSchema.getDynamicObjectCollection("prop_entryentity");
        this.addProp2Output(outputEntries, metaSchema, propList, id, level + 2);
    }

    private void addProp2Output(DynamicObjectCollection inputEntries, DynamicObject metaSchema, DynamicObjectCollection propList, long parentId, int level) {
        for (DynamicObject prop : propList) {
            long id = IscApiUtil.getId();
            OpenApiField openApiField = new OpenApiField(prop, "prop_name", "prop_label", "data_type");
            IscApiUtil.addOutputField(inputEntries, parentId, id, level, openApiField);
            if (!this.isEntries(prop.getString("data_type"))) continue;
            DynamicObject entries = JsonSampleUtil.findMetaByDataSchema(metaSchema, prop.getString("data_schema"));
            DynamicObjectCollection entryList = entries.getDynamicObjectCollection("prop_entryentity");
            this.addProp2Output(inputEntries, metaSchema, entryList, id, level + 1);
        }
    }

    private void addBaseInfo(DynamicObjectCollection outputEntries, String name, String type, String title, long id, int level) {
        DynamicObject outputEntry = outputEntries.addNew();
        outputEntry.set("id", (Object)id);
        outputEntry.set("respparamname", (Object)name);
        outputEntry.set("respdes", (Object)title);
        DataType openApiType = OpenApiField.structTypeToOpenApiType(type);
        Object object = openApiType.defaultValue();
        outputEntry.set("respparamtype", (Object)openApiType.type());
        outputEntry.set("respexample", (Object)("-".equals(object) ? "-" : JSON.toJSONString((Object)object)));
        outputEntry.set("is_resp_mul_value", (Object)Boolean.FALSE);
        outputEntry.set("pid", (Object)0);
        outputEntry.set("resp_level", (Object)level);
    }
}

