/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api.openapi.v2;

import com.alibaba.fastjson.JSON;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.id.IDService;
import kd.bos.openapi.common.constant.DataType;
import kd.isc.iscb.platform.core.api.openapi.v2.OpenApiVersion2Builder;
import kd.isc.iscb.platform.core.api.parsers.model.IscFieldType;
import kd.isc.iscb.platform.core.apic.IscApiParam;
import kd.isc.iscb.platform.core.apic.IscApicUtil;
import kd.isc.iscb.util.dt.D;

public class OpenApiFromIscScriptApi
extends OpenApiVersion2Builder {
    @Override
    protected DynamicObjectCollection makeBodyEntries(DynamicObject svc, DynamicObject api) {
        DynamicObjectCollection bodyEntries = svc.getDynamicObjectCollection("bodyentryentity");
        bodyEntries.clear();
        IscApiParam inputSchema = IscApicUtil.getInputSchema(api);
        this.addBodyEntry(0L, bodyEntries, inputSchema, 1);
        return bodyEntries;
    }

    private void addBodyEntry(long parentId, DynamicObjectCollection bodyEntries, IscApiParam inputSchema, int level) {
        if (inputSchema != null) {
            List<IscApiParam.Field> fields = inputSchema.getFields();
            for (IscApiParam.Field field : fields) {
                DynamicObject bodyEntry = bodyEntries.addNew();
                long id = IDService.get().genLongId();
                bodyEntry.set("id", (Object)id);
                bodyEntry.set("paramname", (Object)field.getName());
                bodyEntry.set("bodyparamdes", (Object)field.getTitle());
                DataType openApiFieldType = IscFieldType.getIscTypeByTypeName(field.getDataType()).getOpenApiFieldType();
                Object object = openApiFieldType.defaultValue();
                bodyEntry.set("example", (Object)("-".equals(object) ? "-" : JSON.toJSONString((Object)object)));
                bodyEntry.set("paramtype", (Object)openApiFieldType.type());
                bodyEntry.set("is_req_mul_value", (Object)field.isArray());
                bodyEntry.set("must", (Object)(field.isRequired() ? "1" : "0"));
                bodyEntry.set("pid", (Object)parentId);
                bodyEntry.set("body_level", (Object)D.s((Object)level));
                this.addBodyEntry(id, bodyEntries, field.getSchema(), level + 1);
            }
        }
    }

    @Override
    protected DynamicObjectCollection makeRespEntries(DynamicObject svc, DynamicObject api) {
        DynamicObjectCollection respEntries = svc.getDynamicObjectCollection("respentryentity");
        respEntries.clear();
        IscApiParam outputSchema = IscApicUtil.getOutputSchema(api);
        this.addRespEntry(0L, respEntries, outputSchema, 1);
        return respEntries;
    }

    private void addRespEntry(long parentId, DynamicObjectCollection respEntries, IscApiParam outputSchema, int level) {
        if (outputSchema != null) {
            List<IscApiParam.Field> fields = outputSchema.getFields();
            for (IscApiParam.Field field : fields) {
                DynamicObject respEntry = respEntries.addNew();
                long id = IDService.get().genLongId();
                respEntry.set("id", (Object)id);
                respEntry.set("respparamname", (Object)field.getName());
                respEntry.set("respdes", (Object)field.getTitle());
                IscFieldType outputDataType = IscFieldType.getIscTypeByTypeName(field.getDataType());
                DataType openApiType = outputDataType.getOpenApiFieldType();
                Object object = openApiType.defaultValue();
                respEntry.set("respparamtype", (Object)openApiType.type());
                respEntry.set("respexample", (Object)("-".equals(object) ? "-" : JSON.toJSONString((Object)object)));
                respEntry.set("is_resp_mul_value", (Object)field.isArray());
                respEntry.set("pid", (Object)parentId);
                respEntry.set("resp_level", (Object)D.s((Object)level));
                this.addRespEntry(id, respEntries, field.getSchema(), level + 1);
            }
        }
    }
}

